/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.inmemory;

import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.query.inmemory.InMemoryExpressionEvaluator;
import org.datanucleus.query.inmemory.InvocationEvaluator;
import org.datanucleus.query.inmemory.VariableNotSetException;

public class MapContainsEntryMethod
implements InvocationEvaluator {
    @Override
    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        Object currentValForKey;
        String method = expr.getOperation();
        if (invokedValue == null) {
            return Boolean.FALSE;
        }
        if (!(invokedValue instanceof Map)) {
            throw new NucleusException(eval.getLocaliser().msg("021011", (Object)method, (Object)invokedValue.getClass().getName()));
        }
        Expression keyParam = expr.getArguments().get(0);
        Expression valParam = expr.getArguments().get(1);
        Object keyValue = null;
        if (keyParam instanceof Literal) {
            keyValue = ((Literal)keyParam).getLiteral();
        } else if (keyParam instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)keyParam;
            keyValue = eval.getValueForPrimaryExpression(primExpr);
        } else if (keyParam instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)keyParam;
            keyValue = QueryUtils.getValueForParameterExpression(eval.getParameterValues(), paramExpr);
        } else if (keyParam instanceof VariableExpression) {
            VariableExpression varExpr = (VariableExpression)keyParam;
            try {
                keyValue = eval.getValueForVariableExpression(varExpr);
            }
            catch (VariableNotSetException vnse) {
                throw new VariableNotSetException(varExpr, ((Map)invokedValue).values().toArray());
            }
        } else {
            throw new NucleusException("Dont currently support use of containsEntry(" + keyParam.getClass().getName() + ",?)");
        }
        Object valValue = null;
        if (valParam instanceof Literal) {
            valValue = ((Literal)valParam).getLiteral();
        } else if (keyParam instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)valParam;
            valValue = eval.getValueForPrimaryExpression(primExpr);
        } else if (keyParam instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)valParam;
            valValue = QueryUtils.getValueForParameterExpression(eval.getParameterValues(), paramExpr);
        } else if (keyParam instanceof VariableExpression) {
            VariableExpression varExpr = (VariableExpression)valParam;
            try {
                valValue = eval.getValueForVariableExpression(varExpr);
            }
            catch (VariableNotSetException vnse) {
                throw new VariableNotSetException(varExpr, ((Map)invokedValue).values().toArray());
            }
        } else {
            throw new NucleusException("Dont currently support use of containsEntry(?," + valParam.getClass().getName() + ")");
        }
        Map invokedMap = (Map)invokedValue;
        if (invokedMap.containsKey(keyValue) && (currentValForKey = invokedMap.get(keyValue)).equals(valValue)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

