/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.identity;

import java.io.Serializable;
import org.datanucleus.ClassConstants;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.util.Localiser;

public class DatastoreIdImplXcalia
implements Serializable,
DatastoreId,
Comparable {
    protected static final transient Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected static final transient String STRING_DELIMITER = ":";
    public final Object keyAsObject;
    public final String targetClassName;
    public final String toString;
    public final int hashCode;

    public DatastoreIdImplXcalia() {
        this.keyAsObject = null;
        this.targetClassName = null;
        this.toString = null;
        this.hashCode = -1;
    }

    public DatastoreIdImplXcalia(String pcClass, Object object) {
        this.targetClassName = pcClass;
        this.keyAsObject = object;
        StringBuilder s = new StringBuilder();
        s.append(this.targetClassName);
        s.append(STRING_DELIMITER);
        s.append(this.keyAsObject.toString());
        this.toString = s.toString();
        this.hashCode = this.toString.hashCode();
    }

    public DatastoreIdImplXcalia(String str) throws IllegalArgumentException {
        if (str.length() < 2) {
            throw new IllegalArgumentException(LOCALISER.msg("038000", (Object)str));
        }
        int separatorPosition = str.indexOf(STRING_DELIMITER);
        this.targetClassName = str.substring(0, separatorPosition);
        String oidStr = str.substring(separatorPosition + 1);
        Object oidValue = null;
        try {
            oidValue = Long.valueOf(oidStr);
        }
        catch (NumberFormatException nfe) {
            oidValue = oidStr;
        }
        this.keyAsObject = oidValue;
        this.toString = str;
        this.hashCode = this.toString.hashCode();
    }

    @Override
    public Object getKeyAsObject() {
        return this.keyAsObject;
    }

    @Override
    public String getTargetClassName() {
        return this.targetClassName;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().getName().equals(DatastoreIdImplXcalia.class.getName())) {
            return false;
        }
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        return ((DatastoreId)obj).toString().equals(this.toString);
    }

    public int compareTo(Object o) {
        if (o instanceof DatastoreIdImplXcalia) {
            DatastoreIdImplXcalia c = (DatastoreIdImplXcalia)o;
            return this.toString.compareTo(c.toString);
        }
        if (o == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + o.getClass().getName());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        return this.toString;
    }
}

