/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.identity;

import java.io.Serializable;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.util.Localiser;

public class DatastoreIdImpl
implements Serializable,
DatastoreId,
Comparable {
    protected static final transient Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected static final transient String STRING_DELIMITER = "[OID]";
    public final Object keyAsObject;
    public final String targetClassName;
    public final String toString;
    public final int hashCode;

    public DatastoreIdImpl() {
        this.keyAsObject = null;
        this.targetClassName = null;
        this.toString = null;
        this.hashCode = -1;
    }

    public DatastoreIdImpl(String pcClass, Object object) {
        this.targetClassName = pcClass;
        this.keyAsObject = object;
        StringBuilder s = new StringBuilder();
        s.append(this.keyAsObject.toString());
        s.append(STRING_DELIMITER);
        s.append(this.targetClassName);
        this.toString = s.toString();
        this.hashCode = this.toString.hashCode();
    }

    public DatastoreIdImpl(String str) throws IllegalArgumentException {
        if (str.length() < 2) {
            throw new IllegalArgumentException(LOCALISER.msg("038000", (Object)str));
        }
        if (str.indexOf(STRING_DELIMITER) < 0) {
            throw new IllegalArgumentException(LOCALISER.msg("038000", (Object)str));
        }
        int start = 0;
        int end = str.indexOf(STRING_DELIMITER, start);
        String oidStr = str.substring(start, end);
        Object oidValue = null;
        try {
            oidValue = Long.valueOf(oidStr);
        }
        catch (NumberFormatException nfe) {
            oidValue = oidStr;
        }
        this.keyAsObject = oidValue;
        start = end + STRING_DELIMITER.length();
        this.targetClassName = str.substring(start, str.length());
        this.toString = str;
        this.hashCode = this.toString.hashCode();
    }

    @Override
    public Object getKeyAsObject() {
        return this.keyAsObject;
    }

    @Override
    public String getTargetClassName() {
        return this.targetClassName;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().getName().equals(ClassNameConstants.IDENTITY_OID_IMPL)) {
            return false;
        }
        if (this.hashCode() != obj.hashCode()) {
            return false;
        }
        return ((DatastoreId)obj).toString().equals(this.toString);
    }

    public int compareTo(Object o) {
        if (o instanceof DatastoreIdImpl) {
            DatastoreIdImpl c = (DatastoreIdImpl)o;
            return this.toString.compareTo(c.toString);
        }
        if (o == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + o.getClass().getName());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        return this.toString;
    }
}

