/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ImplementationCreator;
import org.datanucleus.enhancer.ClassEnhancer;
import org.datanucleus.enhancer.EnhancerClassLoader;
import org.datanucleus.enhancer.ImplementationGenerator;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;

public class ImplementationCreatorImpl
implements Serializable,
ImplementationCreator {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassEnhancer.class.getClassLoader());
    protected final MetaDataManager metaDataMgr;
    protected final EnhancerClassLoader loader;

    public ImplementationCreatorImpl(MetaDataManager mmgr) {
        this.metaDataMgr = mmgr;
        this.loader = new EnhancerClassLoader();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public Object newInstance(Class cls, ClassLoaderResolver clr) {
        try {
            if (Persistable.class.isAssignableFrom(cls)) {
                if (Modifier.isAbstract(cls.getModifiers())) {
                    ClassMetaData cmd = (ClassMetaData)this.metaDataMgr.getMetaDataForClass(cls, clr);
                    if (cmd == null) {
                        throw new NucleusException("Could not find metadata for class " + cls.getName()).setFatal();
                    }
                    Persistable obj = this.newInstance(cmd, clr);
                    if (!this.metaDataMgr.hasMetaDataForClass(obj.getClass().getName())) {
                        this.metaDataMgr.registerImplementationOfAbstractClass(cmd, obj.getClass(), clr);
                    }
                    return obj;
                }
                return cls.newInstance();
            }
            InterfaceMetaData imd = this.metaDataMgr.getMetaDataForInterface(cls, clr);
            if (imd == null) {
                throw new NucleusException("Could not find metadata for class/interface " + cls.getName()).setFatal();
            }
            Persistable obj = this.newInstance(imd, clr);
            if (!this.metaDataMgr.hasMetaDataForClass(obj.getClass().getName())) {
                this.metaDataMgr.registerPersistentInterface(imd, obj.getClass(), clr);
            }
            return obj;
        }
        catch (ClassNotFoundException e) {
            throw new NucleusUserException(e.toString(), e);
        }
        catch (InstantiationException e) {
            throw new NucleusUserException(e.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new NucleusUserException(e.toString(), e);
        }
    }

    protected Persistable newInstance(InterfaceMetaData imd, ClassLoaderResolver clr) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class cls = clr.classForName(imd.getFullClassName());
        Method[] methods = cls.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            if (methodName.startsWith("dn")) continue;
            String propertyName = methodName;
            if (methodName.startsWith("set")) {
                propertyName = ClassUtils.getFieldNameForJavaBeanSetter(methodName);
            } else if (methodName.startsWith("get")) {
                propertyName = ClassUtils.getFieldNameForJavaBeanGetter(methodName);
            }
            if (imd.getMetaDataForMember(propertyName) != null) continue;
            throw new NucleusUserException(LOCALISER.msg("ImplementationCreator.InterfaceMethodUndefined", (Object)imd.getFullClassName(), (Object)methodName));
        }
        String implClassName = imd.getName() + "Impl";
        String implFullClassName = imd.getPackageName() + '.' + implClassName;
        try {
            this.loader.loadClass(implFullClassName);
        }
        catch (ClassNotFoundException e) {
            ImplementationGenerator gen = this.getGenerator(imd, implClassName);
            gen.enhance(clr);
            this.loader.defineClass(implFullClassName, gen.getBytes(), clr);
        }
        Object instance = this.loader.loadClass(implFullClassName).newInstance();
        if (instance instanceof Persistable) {
            return (Persistable)instance;
        }
        Class<?>[] interfaces = instance.getClass().getInterfaces();
        StringBuilder implementedInterfacesMsg = new StringBuilder("[");
        String classLoaderPCMsg = "";
        for (int i = 0; i < interfaces.length; ++i) {
            implementedInterfacesMsg.append(interfaces[i].getName());
            if (i < interfaces.length - 1) {
                implementedInterfacesMsg.append(",");
            }
            if (!interfaces[i].getName().equals(Persistable.class.getName())) continue;
            classLoaderPCMsg = LOCALISER.msg("ImplementationCreator.DifferentClassLoader", interfaces[i].getClassLoader(), (Object)Persistable.class.getClassLoader());
        }
        implementedInterfacesMsg.append("]");
        throw new NucleusException(LOCALISER.msg("ImplementationCreator.NotPCProblem", (Object)implFullClassName, (Object)classLoaderPCMsg, (Object)implementedInterfacesMsg.toString()));
    }

    protected Persistable newInstance(ClassMetaData cmd, ClassLoaderResolver clr) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class cls = clr.classForName(cmd.getFullClassName());
        Method[] methods = cls.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            if (!Modifier.isAbstract(methods[i].getModifiers()) || methodName.startsWith("dn")) continue;
            String propertyName = methodName;
            if (methodName.startsWith("set")) {
                propertyName = ClassUtils.getFieldNameForJavaBeanSetter(methodName);
            } else if (methodName.startsWith("get")) {
                propertyName = ClassUtils.getFieldNameForJavaBeanGetter(methodName);
            }
            if (cmd.getMetaDataForMember(propertyName) != null) continue;
            throw new NucleusUserException(LOCALISER.msg("ImplementationCreator.AbstractClassMethodUndefined", (Object)cmd.getFullClassName(), (Object)methodName));
        }
        String implClassName = cmd.getName() + "Impl";
        String implFullClassName = cmd.getPackageName() + '.' + implClassName;
        try {
            this.loader.loadClass(implFullClassName);
        }
        catch (ClassNotFoundException e) {
            ImplementationGenerator gen = this.getGenerator(cmd, implClassName);
            gen.enhance(clr);
            this.loader.defineClass(implFullClassName, gen.getBytes(), clr);
        }
        Object instance = this.loader.loadClass(implFullClassName).newInstance();
        if (instance instanceof Persistable) {
            return (Persistable)instance;
        }
        Class<?>[] interfaces = instance.getClass().getInterfaces();
        StringBuilder implementedInterfacesMsg = new StringBuilder("[");
        String classLoaderPCMsg = "";
        for (int i = 0; i < interfaces.length; ++i) {
            implementedInterfacesMsg.append(interfaces[i].getName());
            if (i < interfaces.length - 1) {
                implementedInterfacesMsg.append(",");
            }
            if (!interfaces[i].getName().equals(Persistable.class.getName())) continue;
            classLoaderPCMsg = LOCALISER.msg("ImplementationCreator.DifferentClassLoader", interfaces[i].getClassLoader(), (Object)Persistable.class.getClassLoader());
        }
        implementedInterfacesMsg.append("]");
        throw new NucleusException(LOCALISER.msg("ImplementationCreator.NotPCProblem", (Object)implFullClassName, (Object)classLoaderPCMsg, (Object)implementedInterfacesMsg.toString()));
    }

    protected ImplementationGenerator getGenerator(AbstractClassMetaData acmd, String implClassName) {
        if (acmd instanceof InterfaceMetaData) {
            return new ImplementationGenerator((InterfaceMetaData)acmd, implClassName, this.metaDataMgr);
        }
        if (acmd instanceof ClassMetaData) {
            return new ImplementationGenerator((ClassMetaData)acmd, implClassName, this.metaDataMgr);
        }
        return null;
    }
}

