/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.simple;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassConstants;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.store.types.SCOCollection;
import org.datanucleus.store.types.SCOCollectionIterator;
import org.datanucleus.store.types.SCOMtoN;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class Collection
extends AbstractCollection
implements SCOCollection,
SCOMtoN,
Cloneable,
Serializable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected transient ObjectProvider ownerOP;
    protected transient AbstractMemberMetaData ownerMmd;
    protected java.util.Collection delegate;

    public Collection(ObjectProvider ownerOP, AbstractMemberMetaData mmd) {
        this.ownerOP = ownerOP;
        this.ownerMmd = mmd;
    }

    public void initialise(Object o, boolean forInsert, boolean forUpdate) {
        java.util.Collection c = (java.util.Collection)o;
        this.delegate = c != null ? new HashSet(c) : new HashSet();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023003", (Object)this.ownerOP.getObjectAsPrintable(), (Object)this.ownerMmd.getName(), (Object)("" + this.size()), (Object)SCOUtils.getSCOWrapperOptionsMessage(true, false, true, false)));
        }
    }

    public void initialise() {
        this.delegate = new HashSet();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023003", (Object)this.ownerOP.getObjectAsPrintable(), (Object)this.ownerMmd.getName(), (Object)("" + this.size()), (Object)SCOUtils.getSCOWrapperOptionsMessage(true, false, true, false)));
        }
    }

    public Object getValue() {
        return this.delegate;
    }

    public void load() {
    }

    public boolean isLoaded() {
        return true;
    }

    public void updateEmbeddedElement(Object element, int fieldNumber, Object value) {
        this.makeDirty();
    }

    public String getFieldName() {
        return this.ownerMmd.getName();
    }

    public Object getOwner() {
        return this.ownerOP != null ? this.ownerOP.getObject() : null;
    }

    public synchronized void unsetOwner() {
        if (this.ownerOP != null) {
            this.ownerOP = null;
            this.ownerMmd = null;
        }
    }

    public void makeDirty() {
        if (this.ownerOP != null) {
            this.ownerOP.makeDirty(this.ownerMmd.getAbsoluteFieldNumber());
        }
    }

    public Object detachCopy(FetchPlanState state) {
        HashSet detached = new HashSet();
        SCOUtils.detachCopyForCollection(this.ownerOP, this.toArray(), state, detached);
        return detached;
    }

    public void attachCopy(Object value) {
        java.util.Collection c = (java.util.Collection)value;
        boolean elementsWithoutIdentity = SCOUtils.collectionHasElementsWithoutIdentity(this.ownerMmd);
        SCOUtils.attachCopyElements(this.ownerOP, this, c, elementsWithoutIdentity);
    }

    public Object clone() {
        return ((HashSet)this.delegate).clone();
    }

    public synchronized boolean contains(Object element) {
        return this.delegate.contains(element);
    }

    public synchronized boolean containsAll(java.util.Collection c) {
        return this.delegate.containsAll(c);
    }

    public synchronized boolean equals(Object o) {
        return ((Object)this.delegate).equals(o);
    }

    public synchronized int hashCode() {
        return ((Object)this.delegate).hashCode();
    }

    public synchronized boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public synchronized Iterator iterator() {
        return new SCOCollectionIterator(this, this.ownerOP, this.delegate, null, true);
    }

    public synchronized int size() {
        return this.delegate.size();
    }

    public synchronized Object[] toArray() {
        return this.delegate.toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        return this.delegate.toArray(a);
    }

    public synchronized boolean add(Object element) {
        boolean success = this.delegate.add(element);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP).relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    public synchronized boolean addAll(java.util.Collection c) {
        boolean success = this.delegate.addAll(c);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP).relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), iter.next());
            }
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    public synchronized void clear() {
        Iterator iter;
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            iter = this.delegate.iterator();
            RelationshipManager relMgr = this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP);
            while (iter.hasNext()) {
                relMgr.relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), iter.next());
            }
        }
        if (this.ownerOP != null && !this.delegate.isEmpty() && SCOUtils.hasDependentElement(this.ownerMmd)) {
            iter = this.delegate.iterator();
            while (iter.hasNext()) {
                this.ownerOP.getExecutionContext().deleteObjectInternal(iter.next());
            }
        }
        this.delegate.clear();
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    public synchronized boolean remove(Object element) {
        return this.remove(element, true);
    }

    public synchronized boolean remove(Object element, boolean allowCascadeDelete) {
        boolean success = this.delegate.remove(element);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP).relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        if (this.ownerOP != null && allowCascadeDelete && SCOUtils.hasDependentElement(this.ownerMmd)) {
            this.ownerOP.getExecutionContext().deleteObjectInternal(element);
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    public synchronized boolean removeAll(java.util.Collection elements) {
        Iterator iter;
        boolean success = this.delegate.removeAll(elements);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            iter = elements.iterator();
            RelationshipManager relMgr = this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP);
            while (iter.hasNext()) {
                relMgr.relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), iter.next());
            }
        }
        if (this.ownerOP != null && elements != null && !elements.isEmpty() && SCOUtils.hasDependentElement(this.ownerMmd)) {
            iter = elements.iterator();
            while (iter.hasNext()) {
                this.ownerOP.getExecutionContext().deleteObjectInternal(iter.next());
            }
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    public synchronized boolean retainAll(java.util.Collection c) {
        boolean success = this.delegate.retainAll(c);
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new HashSet(this.delegate);
    }
}

