/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.backed;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.flush.CollectionAddOperation;
import org.datanucleus.flush.CollectionClearOperation;
import org.datanucleus.flush.CollectionRemoveOperation;
import org.datanucleus.flush.ListAddAtOperation;
import org.datanucleus.flush.ListRemoveAtOperation;
import org.datanucleus.flush.ListSetOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.BackedSCOStoreManager;
import org.datanucleus.store.scostore.ListStore;
import org.datanucleus.store.scostore.Store;
import org.datanucleus.store.types.SCOListIterator;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.backed.BackedSCO;
import org.datanucleus.util.NucleusLogger;

public class ArrayList
extends org.datanucleus.store.types.simple.ArrayList
implements BackedSCO {
    protected transient ListStore backingStore;
    protected transient boolean allowNulls = false;
    protected transient boolean useCache = true;
    protected transient boolean isCacheLoaded = false;
    protected transient boolean queued = false;

    public ArrayList(ObjectProvider op, AbstractMemberMetaData mmd) {
        super(op, mmd);
        this.delegate = new java.util.ArrayList();
        ExecutionContext ec = op.getExecutionContext();
        this.allowNulls = SCOUtils.allowNullsInContainer(this.allowNulls, mmd);
        this.queued = ec.isDelayDatastoreOperationsEnabled();
        this.useCache = SCOUtils.useContainerCache(op, mmd);
        if (!SCOUtils.collectionHasSerialisedElements(mmd) && mmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            this.backingStore = (ListStore)((BackedSCOStoreManager)((Object)ec.getStoreManager())).getBackingStoreForField(clr, mmd, java.util.ArrayList.class);
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(SCOUtils.getContainerInfoMessage(op, this.ownerMmd.getName(), this, this.useCache, this.queued, this.allowNulls, SCOUtils.useCachedLazyLoading(op, this.ownerMmd)));
        }
    }

    public void initialise(Object o, boolean forInsert, boolean forUpdate) {
        Collection c = (Collection)o;
        if (c != null) {
            if (SCOUtils.collectionHasSerialisedElements(this.ownerMmd) && this.ownerMmd.getCollection().elementIsPersistent()) {
                ExecutionContext ec = this.ownerOP.getExecutionContext();
                for (Object pc : c) {
                    ObjectProvider objOP = ec.findObjectProvider(pc);
                    if (objOP != null) continue;
                    objOP = ec.newObjectProviderForEmbedded(pc, false, this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber());
                }
            }
            if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
                this.isCacheLoaded = true;
            }
            if (forInsert) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023007", (Object)this.ownerOP.getObjectAsPrintable(), (Object)this.ownerMmd.getName(), (Object)("" + c.size())));
                }
                if (this.useCache) {
                    this.loadFromStore();
                }
                if (this.backingStore != null) {
                    if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                        for (Object element : c) {
                            this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionAddOperation(this.ownerOP, this.backingStore, element));
                        }
                    } else {
                        try {
                            this.backingStore.addAll(this.ownerOP, c, this.useCache ? this.delegate.size() : -1);
                        }
                        catch (NucleusDataStoreException dse) {
                            NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"addAll", (Object)this.ownerMmd.getName(), (Object)dse));
                        }
                    }
                }
                this.makeDirty();
                this.delegate.addAll(c);
            } else if (forUpdate) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023008", (Object)this.ownerOP.getObjectAsPrintable(), (Object)this.ownerMmd.getName(), (Object)("" + c.size())));
                }
                if (this.backingStore != null) {
                    if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                        this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionClearOperation(this.ownerOP, this.backingStore));
                    } else {
                        this.backingStore.clear(this.ownerOP);
                    }
                }
                if (this.useCache) {
                    this.loadFromStore();
                }
                if (this.backingStore != null) {
                    if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                        for (Object element : c) {
                            this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionAddOperation(this.ownerOP, this.backingStore, element));
                        }
                    } else {
                        try {
                            this.backingStore.addAll(this.ownerOP, c, this.useCache ? this.delegate.size() : -1);
                        }
                        catch (NucleusDataStoreException dse) {
                            NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"addAll", (Object)this.ownerMmd.getName(), (Object)dse));
                        }
                    }
                }
                this.delegate.addAll(c);
                this.makeDirty();
            } else {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023007", (Object)this.ownerOP.getObjectAsPrintable(), (Object)this.ownerMmd.getName(), (Object)("" + c.size())));
                }
                this.delegate.clear();
                this.delegate.addAll(c);
            }
        }
    }

    public void initialise() {
        if (this.useCache && !SCOUtils.useCachedLazyLoading(this.ownerOP, this.ownerMmd)) {
            this.loadFromStore();
        }
    }

    public Object getValue() {
        this.loadFromStore();
        return super.getValue();
    }

    public void load() {
        if (this.useCache) {
            this.loadFromStore();
        }
    }

    public boolean isLoaded() {
        return this.useCache ? this.isCacheLoaded : false;
    }

    protected void loadFromStore() {
        if (this.backingStore != null && !this.isCacheLoaded) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023006", (Object)this.ownerOP.getObjectAsPrintable(), (Object)this.ownerMmd.getName()));
            }
            this.delegate.clear();
            Iterator iter = this.backingStore.iterator(this.ownerOP);
            while (iter.hasNext()) {
                this.delegate.add(iter.next());
            }
            this.isCacheLoaded = true;
        }
    }

    public Store getBackingStore() {
        return this.backingStore;
    }

    public void updateEmbeddedElement(Object element, int fieldNumber, Object value) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedElement(this.ownerOP, element, fieldNumber, value);
        }
    }

    public synchronized void unsetOwner() {
        super.unsetOwner();
        if (this.backingStore != null) {
            this.backingStore = null;
        }
    }

    public Object clone() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return this.delegate.clone();
    }

    public boolean contains(Object element) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.contains(element);
        }
        if (this.backingStore != null) {
            return this.backingStore.contains(this.ownerOP, element);
        }
        return this.delegate.contains(element);
    }

    public synchronized boolean containsAll(Collection c) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            HashSet h = new HashSet(c);
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                h.remove(iter.next());
            }
            return h.isEmpty();
        }
        return this.delegate.containsAll(c);
    }

    public synchronized boolean equals(Object o) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l = (List)o;
        if (l.size() != this.size()) {
            return false;
        }
        Object[] elements = this.toArray();
        Object[] otherElements = l.toArray();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i].equals(otherElements[i])) continue;
            return false;
        }
        return true;
    }

    public Object get(int index) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.get(this.ownerOP, index);
        }
        return this.delegate.get(index);
    }

    public int indexOf(Object element) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.indexOf(this.ownerOP, element);
        }
        return this.delegate.indexOf(element);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return new SCOListIterator(this, this.ownerOP, this.delegate, this.backingStore, this.useCache, -1);
    }

    public ListIterator listIterator() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return new SCOListIterator(this, this.ownerOP, this.delegate, this.backingStore, this.useCache, -1);
    }

    public ListIterator listIterator(int index) {
        if (this.useCache) {
            this.loadFromStore();
        }
        return new SCOListIterator(this, this.ownerOP, this.delegate, this.backingStore, this.useCache, index);
    }

    public int lastIndexOf(Object element) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.lastIndexOf(this.ownerOP, element);
        }
        return this.delegate.lastIndexOf(element);
    }

    public int size() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.size();
        }
        if (this.backingStore != null) {
            return this.backingStore.size(this.ownerOP);
        }
        return this.delegate.size();
    }

    public synchronized List subList(int from, int to) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.subList(this.ownerOP, from, to);
        }
        return this.delegate.subList(from, to);
    }

    public synchronized Object[] toArray() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerOP);
        }
        return this.delegate.toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerOP, a);
        }
        return this.delegate.toArray(a);
    }

    public void add(int index, Object element) {
        if (!this.allowNulls && element == null) {
            throw new NullPointerException("Nulls not allowed for collection at field " + this.ownerMmd.getName() + " but element is null");
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new ListAddAtOperation(this.ownerOP, this.backingStore, index, element));
            } else {
                try {
                    this.backingStore.add(this.ownerOP, element, index, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"add", (Object)this.ownerMmd.getName(), (Object)dse));
                }
            }
        }
        this.makeDirty();
        this.delegate.add(index, element);
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    public boolean add(Object element) {
        if (!this.allowNulls && element == null) {
            throw new NullPointerException("Nulls not allowed for collection at field " + this.ownerMmd.getName() + " but element is null");
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionAddOperation(this.ownerOP, this.backingStore, element));
            } else {
                try {
                    this.backingStore.add(this.ownerOP, element, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"add", (Object)this.ownerMmd.getName(), (Object)dse));
                    backingSuccess = false;
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.add(element);
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public boolean addAll(Collection elements) {
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                for (Object element : elements) {
                    this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionAddOperation(this.ownerOP, this.backingStore, element));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.addAll(this.ownerOP, elements, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"addAll", (Object)this.ownerMmd.getName(), (Object)dse));
                    backingSuccess = false;
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.addAll(elements);
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public boolean addAll(int index, Collection elements) {
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                int pos = index;
                for (Object element : elements) {
                    this.ownerOP.getExecutionContext().addOperationToQueue(new ListAddAtOperation(this.ownerOP, this.backingStore, pos++, element));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.addAll(this.ownerOP, elements, index, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"addAll", (Object)this.ownerMmd.getName(), (Object)dse));
                    backingSuccess = false;
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.addAll(index, elements);
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public synchronized void clear() {
        this.makeDirty();
        this.delegate.clear();
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionClearOperation(this.ownerOP, this.backingStore));
            } else {
                this.backingStore.clear(this.ownerOP);
            }
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    public synchronized boolean remove(Object element) {
        return this.remove(element, true);
    }

    public boolean remove(Object element, boolean allowCascadeDelete) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int size = this.useCache ? this.delegate.size() : -1;
        boolean contained = this.delegate.contains(element);
        boolean delegateSuccess = this.delegate.remove(element);
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                backingSuccess = contained;
                if (backingSuccess) {
                    this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation(this.ownerOP, this.backingStore, element, allowCascadeDelete));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.remove(this.ownerOP, element, size, allowCascadeDelete);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"remove", (Object)this.ownerMmd.getName(), (Object)dse));
                    backingSuccess = false;
                }
            }
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    public synchronized Object remove(int index) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int size = this.useCache ? this.delegate.size() : -1;
        Object delegateObject = this.useCache ? (Object)this.delegate.remove(index) : null;
        Object backingObject = null;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                backingObject = delegateObject;
                this.ownerOP.getExecutionContext().addOperationToQueue(new ListRemoveAtOperation(this.ownerOP, this.backingStore, index));
            } else {
                try {
                    backingObject = this.backingStore.remove(this.ownerOP, index, size);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"remove", (Object)this.ownerMmd.getName(), (Object)dse));
                    backingObject = null;
                }
            }
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return this.backingStore != null ? backingObject : delegateObject;
    }

    public boolean removeAll(Collection elements) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int size = this.useCache ? this.delegate.size() : -1;
        HashSet contained = null;
        if (this.backingStore != null && SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
            contained = new HashSet();
            for (Object elem : elements) {
                if (!this.contains(elem)) continue;
                contained.add(elem);
            }
        }
        boolean delegateSuccess = this.delegate.removeAll(elements);
        if (this.backingStore != null) {
            boolean backingSuccess = true;
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                backingSuccess = false;
                for (Object element : contained) {
                    backingSuccess = true;
                    this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation(this.ownerOP, this.backingStore, element, true));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.removeAll(this.ownerOP, elements, size);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"removeAll", (Object)this.ownerMmd.getName(), (Object)dse));
                    backingSuccess = false;
                }
            }
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
            return backingSuccess;
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return delegateSuccess;
    }

    public synchronized boolean retainAll(Collection c) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (c.contains(element)) continue;
            iter.remove();
            modified = true;
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return modified;
    }

    public Object set(int index, Object element, boolean allowDependentField) {
        if (!this.allowNulls && element == null) {
            throw new NullPointerException("Nulls not allowed for collection at field " + this.ownerMmd.getName() + " but element is null");
        }
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        Object delegateReturn = this.delegate.set(index, element);
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new ListSetOperation(this.ownerOP, this.backingStore, index, element, allowDependentField));
            } else {
                this.backingStore.set(this.ownerOP, index, element, allowDependentField);
            }
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return delegateReturn;
    }

    public Object set(int index, Object element) {
        return this.set(index, element, true);
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.useCache) {
            this.loadFromStore();
            return new java.util.ArrayList(this.delegate);
        }
        return new java.util.ArrayList(this.delegate);
    }
}

