/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ContainerComponent;
import org.datanucleus.metadata.ContainerMetaData;
import org.datanucleus.metadata.InvalidMemberMetaDataException;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ArrayMetaData
extends ContainerMetaData {
    protected ContainerComponent element = new ContainerComponent();
    protected boolean mayContainPersistableElements;

    public ArrayMetaData(ArrayMetaData arrmd) {
        super(arrmd);
        this.element.embedded = arrmd.element.embedded;
        this.element.serialized = arrmd.element.serialized;
        this.element.dependent = arrmd.element.dependent;
        this.element.type = arrmd.element.type;
        this.element.classMetaData = arrmd.element.classMetaData;
    }

    public ArrayMetaData() {
    }

    public void populate(ClassLoaderResolver clr, ClassLoader primary, MetaDataManager mmgr) {
        String arrayComponentType;
        Class<?> component_type;
        AbstractMemberMetaData mmd = (AbstractMemberMetaData)this.parent;
        if (!StringUtils.isWhitespace(this.element.type) && this.element.type.indexOf(44) > 0) {
            throw new InvalidMemberMetaDataException(LOCALISER, "044140", mmd.getClassName(), mmd.getName());
        }
        ApiAdapter api = mmgr.getApiAdapter();
        this.element.populate(((AbstractMemberMetaData)this.parent).getAbstractClassMetaData().getPackageName(), clr, primary, mmgr);
        Class field_type = this.getMemberMetaData().getType();
        if (!field_type.isArray()) {
            throw new InvalidMemberMetaDataException(LOCALISER, "044141", mmd.getClassName(), this.getFieldName());
        }
        if (this.element.embedded == null) {
            component_type = field_type.getComponentType();
            this.element.embedded = mmgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(component_type) ? Boolean.TRUE : (api.isPersistable(component_type) || Object.class.isAssignableFrom(component_type) || component_type.isInterface() ? Boolean.FALSE : Boolean.TRUE);
        }
        if (Boolean.FALSE.equals(this.element.embedded) && !api.isPersistable(component_type = field_type.getComponentType()) && !component_type.isInterface() && component_type != Object.class) {
            this.element.embedded = Boolean.TRUE;
        }
        if (!(mmgr.isEnhancing() || this.getMemberMetaData().isSerialized() || this.getMemberMetaData().getJoinMetaData() != null || api.isPersistable(this.getMemberMetaData().getType().getComponentType()) || !mmgr.supportsORM() || (arrayComponentType = this.getMemberMetaData().getType().getComponentType().getName()).equals(ClassNameConstants.BOOLEAN) || arrayComponentType.equals(ClassNameConstants.BYTE) || arrayComponentType.equals(ClassNameConstants.CHAR) || arrayComponentType.equals(ClassNameConstants.DOUBLE) || arrayComponentType.equals(ClassNameConstants.FLOAT) || arrayComponentType.equals(ClassNameConstants.INT) || arrayComponentType.equals(ClassNameConstants.LONG) || arrayComponentType.equals(ClassNameConstants.SHORT) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_BOOLEAN) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_BYTE) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_CHARACTER) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_DOUBLE) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_FLOAT) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_INTEGER) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_LONG) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_SHORT) || arrayComponentType.equals(ClassNameConstants.JAVA_MATH_BIGDECIMAL) || arrayComponentType.equals(ClassNameConstants.JAVA_MATH_BIGINTEGER))) {
            String msg = LOCALISER.msg("044142", (Object)mmd.getClassName(), (Object)this.getFieldName(), (Object)this.getMemberMetaData().getType().getComponentType().getName());
            NucleusLogger.METADATA.warn(msg);
        }
        if (this.element.type != null) {
            Class elementCls = clr.classForName(this.element.type, primary);
            if (api.isPersistable(elementCls)) {
                this.mayContainPersistableElements = true;
            }
            this.element.classMetaData = mmgr.getMetaDataForClassInternal(elementCls, clr);
        } else {
            this.element.type = field_type.getComponentType().getName();
            this.element.classMetaData = mmgr.getMetaDataForClassInternal(field_type.getComponentType(), clr);
        }
        if (this.element.classMetaData != null) {
            this.mayContainPersistableElements = true;
        }
        super.populate(clr, primary, mmgr);
        this.setPopulated();
    }

    public String getElementType() {
        return this.element.type;
    }

    public boolean elementIsPersistent() {
        return this.element.classMetaData != null;
    }

    public AbstractClassMetaData getElementClassMetaData(final ClassLoaderResolver clr, final MetaDataManager mmgr) {
        if (this.element.classMetaData != null && !this.element.classMetaData.isInitialised()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ArrayMetaData.this.element.classMetaData.initialise(clr, mmgr);
                    return null;
                }
            });
        }
        return this.element.classMetaData;
    }

    public boolean mayContainPersistableElements() {
        return this.mayContainPersistableElements;
    }

    public boolean isEmbeddedElement() {
        if (this.element.embedded == null) {
            return false;
        }
        return this.element.embedded;
    }

    public boolean isSerializedElement() {
        if (this.element.serialized == null) {
            return false;
        }
        return this.element.serialized;
    }

    public boolean isDependentElement() {
        if (this.element.dependent == null) {
            return false;
        }
        return this.element.dependent;
    }

    public ArrayMetaData setElementType(String type) {
        if (StringUtils.isWhitespace(type)) {
            this.element.type = null;
        } else {
            this.element.setType(type);
        }
        return this;
    }

    public ArrayMetaData setEmbeddedElement(boolean embedded) {
        this.element.setEmbedded(embedded);
        return this;
    }

    public ArrayMetaData setSerializedElement(boolean serialized) {
        this.element.setSerialized(serialized);
        return this;
    }

    public ArrayMetaData setDependentElement(boolean dependent) {
        this.element.setDependent(dependent);
        return this;
    }

    void getReferencedClassMetaData(List orderedCMDs, Set referencedCMDs, ClassLoaderResolver clr, MetaDataManager mmgr) {
        AbstractClassMetaData element_cmd = mmgr.getMetaDataForClass(this.getMemberMetaData().getType().getComponentType(), clr);
        if (element_cmd != null) {
            element_cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, clr, mmgr);
        }
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<array");
        if (this.element.type != null) {
            sb.append(" element-type=\"").append(this.element.type).append("\"");
        }
        if (this.element.embedded != null) {
            sb.append(" embedded-element=\"").append(this.element.embedded).append("\"");
        }
        if (this.element.serialized != null) {
            sb.append(" serialized-element=\"").append(this.element.serialized).append("\"");
        }
        if (this.element.dependent != null) {
            sb.append(" dependent-element=\"").append(this.element.dependent).append("\"");
        }
        if (this.getNoOfExtensions() > 0) {
            sb.append(">\n");
            sb.append(super.toString(prefix + indent, indent));
            sb.append(prefix).append("</array>\n");
        } else {
            sb.append(prefix).append("/>\n");
        }
        return sb.toString();
    }
}

