/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.converters.TypeConverter;

public class TypeConverterMapping
extends SingleFieldMapping {
    TypeConverter converter;

    public void initialize(AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        if (fmd.getTypeConverterName() == null) {
            throw new NucleusException("Attempt to create TypeConverterMapping when no type converter defined for member " + fmd.getFullFieldName());
        }
        this.converter = container.getStoreManager().getNucleusContext().getTypeManager().getTypeConverterForName(fmd.getTypeConverterName());
        super.initialize(fmd, container, clr);
    }

    public String getJavaTypeForDatastoreMapping(int index) {
        return TypeManager.getDatastoreTypeForTypeConverter(this.converter, this.getJavaType()).getName();
    }

    public Class getJavaType() {
        return this.mmd.getType();
    }

    public void setBoolean(ExecutionContext ec, Object preparedStatement, int[] exprIndex, boolean value) {
        if (exprIndex == null) {
            return;
        }
        this.getDatastoreMapping(0).setBoolean(preparedStatement, exprIndex[0], (Boolean)this.converter.toDatastoreType(value));
    }

    public boolean getBoolean(ExecutionContext ec, Object resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return false;
        }
        Boolean datastoreValue = this.getDatastoreMapping(0).getBoolean(resultSet, exprIndex[0]);
        return datastoreValue != null ? (Boolean)this.converter.toMemberType(datastoreValue) : null;
    }

    public void setByte(ExecutionContext ec, Object preparedStatement, int[] exprIndex, byte value) {
        if (exprIndex == null) {
            return;
        }
        this.getDatastoreMapping(0).setByte(preparedStatement, exprIndex[0], (Byte)this.converter.toDatastoreType(value));
    }

    public byte getByte(ExecutionContext ec, Object resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return 0;
        }
        Byte datastoreValue = this.getDatastoreMapping(0).getByte(resultSet, exprIndex[0]);
        return datastoreValue != null ? (Byte)this.converter.toMemberType(datastoreValue) : null;
    }

    public void setChar(ExecutionContext ec, Object preparedStatement, int[] exprIndex, char value) {
        if (exprIndex == null) {
            return;
        }
        this.getDatastoreMapping(0).setChar(preparedStatement, exprIndex[0], ((Character)this.converter.toDatastoreType(Character.valueOf(value))).charValue());
    }

    public char getChar(ExecutionContext ec, Object resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return '\u0000';
        }
        Character datastoreValue = Character.valueOf(this.getDatastoreMapping(0).getChar(resultSet, exprIndex[0]));
        return (datastoreValue != null ? (Character)this.converter.toMemberType(datastoreValue) : null).charValue();
    }

    public void setDouble(ExecutionContext ec, Object preparedStatement, int[] exprIndex, double value) {
        if (exprIndex == null) {
            return;
        }
        this.getDatastoreMapping(0).setDouble(preparedStatement, exprIndex[0], (Double)this.converter.toDatastoreType(value));
    }

    public double getDouble(ExecutionContext ec, Object resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return 0.0;
        }
        Double datastoreValue = this.getDatastoreMapping(0).getDouble(resultSet, exprIndex[0]);
        return datastoreValue != null ? (Double)this.converter.toMemberType(datastoreValue) : null;
    }

    public void setFloat(ExecutionContext ec, Object preparedStatement, int[] exprIndex, float value) {
        if (exprIndex == null) {
            return;
        }
        this.getDatastoreMapping(0).setFloat(preparedStatement, exprIndex[0], ((Float)this.converter.toDatastoreType(Float.valueOf(value))).floatValue());
    }

    public float getFloat(ExecutionContext ec, Object resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return 0.0f;
        }
        Float datastoreValue = Float.valueOf(this.getDatastoreMapping(0).getFloat(resultSet, exprIndex[0]));
        return (datastoreValue != null ? (Float)this.converter.toMemberType(datastoreValue) : null).floatValue();
    }

    public void setInt(ExecutionContext ec, Object preparedStatement, int[] exprIndex, int value) {
        if (exprIndex == null) {
            return;
        }
        this.getDatastoreMapping(0).setInt(preparedStatement, exprIndex[0], (Integer)this.converter.toDatastoreType(value));
    }

    public int getInt(ExecutionContext ec, Object resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return 0;
        }
        Integer datastoreValue = this.getDatastoreMapping(0).getInt(resultSet, exprIndex[0]);
        return datastoreValue != null ? (Integer)this.converter.toMemberType(datastoreValue) : null;
    }

    public void setLong(ExecutionContext ec, Object preparedStatement, int[] exprIndex, long value) {
        if (exprIndex == null) {
            return;
        }
        this.getDatastoreMapping(0).setLong(preparedStatement, exprIndex[0], (Long)this.converter.toDatastoreType(value));
    }

    public long getLong(ExecutionContext ec, Object resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return 0L;
        }
        Long datastoreValue = this.getDatastoreMapping(0).getLong(resultSet, exprIndex[0]);
        return datastoreValue != null ? (Long)this.converter.toMemberType(datastoreValue) : null;
    }

    public void setShort(ExecutionContext ec, Object preparedStatement, int[] exprIndex, short value) {
        if (exprIndex == null) {
            return;
        }
        this.getDatastoreMapping(0).setShort(preparedStatement, exprIndex[0], (Short)this.converter.toDatastoreType(value));
    }

    public short getShort(ExecutionContext ec, Object resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return 0;
        }
        Short datastoreValue = this.getDatastoreMapping(0).getShort(resultSet, exprIndex[0]);
        return datastoreValue != null ? (Short)this.converter.toMemberType(datastoreValue) : null;
    }

    public void setString(ExecutionContext ec, Object preparedStatement, int[] exprIndex, String value) {
        if (exprIndex == null) {
            return;
        }
        this.getDatastoreMapping(0).setString(preparedStatement, exprIndex[0], (String)this.converter.toDatastoreType(value));
    }

    public String getString(ExecutionContext ec, Object resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return null;
        }
        String datastoreValue = this.getDatastoreMapping(0).getString(resultSet, exprIndex[0]);
        return datastoreValue != null ? (String)this.converter.toMemberType(datastoreValue) : null;
    }

    public void setObject(ExecutionContext ec, Object preparedStatement, int[] exprIndex, Object value) {
        if (exprIndex == null) {
            return;
        }
        this.getDatastoreMapping(0).setObject(preparedStatement, exprIndex[0], this.converter.toDatastoreType(value));
    }

    public Object getObject(ExecutionContext ec, Object resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return null;
        }
        Object datastoreValue = this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]);
        return datastoreValue != null ? this.converter.toMemberType(datastoreValue) : null;
    }
}

