/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlanForClass;
import org.datanucleus.Transaction;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.IdentityReference;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ActivityState;
import org.datanucleus.state.CallbackHandler;
import org.datanucleus.state.JDOStateManager;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.ObjectReferencingStoreManager;
import org.datanucleus.store.fieldmanager.AbstractFetchDepthFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.fieldmanager.SingleTypeFieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOContainer;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractStateManager
implements StateManager,
ObjectProvider {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected static final SingleTypeFieldManager HOLLOWFIELDMANAGER = new SingleTypeFieldManager();
    protected static final int FLAG_STORING_PC = 65536;
    protected static final int FLAG_NEED_INHERITANCE_VALIDATION = 32768;
    protected static final int FLAG_POSTINSERT_UPDATE = 16384;
    protected static final int FLAG_LOADINGFPFIELDS = 8192;
    protected static final int FLAG_POSTLOAD_PENDING = 4096;
    protected static final int FLAG_CHANGING_STATE = 2048;
    protected static final int FLAG_FLUSHED_NEW = 1024;
    protected static final int FLAG_BECOMING_DELETED = 512;
    protected static final int FLAG_UPDATING_EMBEDDING_FIELDS_WITH_OWNER = 256;
    protected static final int FLAG_RETRIEVING_DETACHED_STATE = 128;
    protected static final int FLAG_RESETTING_DETACHED_STATE = 64;
    protected static final int FLAG_ATTACHING = 32;
    protected static final int FLAG_DETACHING = 16;
    protected static final int FLAG_MAKING_TRANSIENT = 8;
    protected static final int FLAG_FLUSHING = 4;
    protected static final int FLAG_DISCONNECTING = 2;
    protected int flags;
    protected byte jdoDfgFlags;
    protected ExecutionContext myEC;
    protected PersistenceCapable myPC;
    protected AbstractClassMetaData cmd;
    protected Object myInternalID;
    protected Object myID;
    protected LifeCycleState myLC;
    protected Object myVersion;
    protected Object transactionalVersion;
    protected FetchPlanForClass myFP;
    protected boolean dirty = false;
    protected boolean[] dirtyFields;
    protected boolean[] loadedFields;
    protected boolean restoreValues = false;
    protected FieldManager currFM = null;
    protected Lock lock = new ReentrantLock();
    protected short lockMode = 0;
    protected byte savedFlags;
    protected PersistenceCapable savedImage = null;
    protected boolean[] savedLoadedFields = null;
    protected Map associatedValuesMap = null;
    protected ActivityState activity = ActivityState.NONE;

    public AbstractStateManager(ExecutionContext ec, AbstractClassMetaData cmd) {
        this.myEC = ec;
        this.cmd = cmd;
        int fieldCount = cmd.getMemberCount();
        this.dirtyFields = new boolean[fieldCount];
        this.loadedFields = new boolean[fieldCount];
        this.myFP = this.myEC.getFetchPlan().manageFetchPlanForClass(cmd);
    }

    public String getObjectAsPrintable() {
        return StringUtils.toJVMIDString(this.myPC);
    }

    public Object getObject() {
        return this.myPC;
    }

    public Object getInternalObjectId() {
        if (this.myID != null) {
            return this.myID;
        }
        if (this.myInternalID == null) {
            this.myInternalID = new IdentityReference(this);
            return this.myInternalID;
        }
        return this.myInternalID;
    }

    public String toString() {
        return "StateManager[pc=" + StringUtils.toJVMIDString(this.myPC) + ", lifecycle=" + this.myLC + "]";
    }

    public AbstractClassMetaData getClassMetaData() {
        return this.cmd;
    }

    public ExecutionContext getExecutionContext() {
        return this.myEC;
    }

    public LifeCycleState getLifecycleState() {
        return this.myLC;
    }

    public boolean isRestoreValues() {
        return this.restoreValues;
    }

    protected void setRestoreValues(boolean restore_values) {
        this.restoreValues = restore_values;
    }

    public void saveFields() {
        this.savedImage = this.myPC.jdoNewInstance((StateManager)this);
        this.savedImage.jdoCopyFields((Object)this.myPC, this.cmd.getAllMemberPositions());
        this.savedFlags = this.jdoDfgFlags;
        this.savedLoadedFields = (boolean[])this.loadedFields.clone();
    }

    public void clearSavedFields() {
        this.savedImage = null;
        this.savedFlags = 0;
        this.savedLoadedFields = null;
    }

    public void restoreFields() {
        if (this.savedImage != null) {
            this.loadedFields = this.savedLoadedFields;
            this.jdoDfgFlags = this.savedFlags;
            this.myPC.jdoReplaceFlags();
            this.myPC.jdoCopyFields((Object)this.savedImage, this.cmd.getAllMemberPositions());
            this.clearDirtyFlags();
            this.clearSavedFields();
        }
    }

    public void setAssociatedValue(Object key, Object value) {
        if (this.associatedValuesMap == null) {
            this.associatedValuesMap = new HashMap(1);
        }
        this.associatedValuesMap.put(key, value);
    }

    public Object getAssociatedValue(Object key) {
        if (this.associatedValuesMap == null) {
            return null;
        }
        return this.associatedValuesMap.get(key);
    }

    public boolean containsAssociatedValue(Object key) {
        return this.associatedValuesMap != null && this.associatedValuesMap.containsKey(key);
    }

    public void enlistInTransaction() {
        if (!this.myEC.getTransaction().isActive()) {
            return;
        }
        this.myEC.enlistInTransaction(this);
        if (this.jdoDfgFlags == 1 && this.areFieldsLoaded(this.cmd.getDFGMemberPositions())) {
            this.jdoDfgFlags = (byte)-1;
            this.myPC.jdoReplaceFlags();
        }
    }

    public void evictFromTransaction() {
        this.myEC.evictFromTransaction(this);
        this.jdoDfgFlags = 1;
        this.myPC.jdoReplaceFlags();
    }

    protected void replaceStateManager(final PersistenceCapable pc, final StateManager sm) {
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    pc.jdoReplaceStateManager(sm);
                    return null;
                }
            });
        }
        catch (SecurityException e) {
            throw new JDOFatalUserException(LOCALISER.msg("026000"), (Throwable)e);
        }
    }

    public StateManager replacingStateManager(PersistenceCapable pc, StateManager sm) {
        if (this.myLC == null) {
            throw new JDOFatalInternalException("Null LifeCycleState");
        }
        if (this.myLC.stateType() == 11) {
            return sm;
        }
        if (pc == this.myPC) {
            if (sm == null) {
                return null;
            }
            if (sm == this) {
                return this;
            }
            if (this.myEC == ((AbstractStateManager)sm).getExecutionContext()) {
                ((JDOStateManager)sm).disconnect();
                return this;
            }
            throw new JDOUserException(LOCALISER.msg("026003"));
        }
        if (pc == this.savedImage) {
            return null;
        }
        return sm;
    }

    public void replaceManagedPC(Object pc) {
        if (pc == null) {
            return;
        }
        this.replaceStateManager((PersistenceCapable)pc, this);
        this.replaceStateManager(this.myPC, null);
        this.myPC = (PersistenceCapable)pc;
        this.myEC.putObjectIntoLevel1Cache(this);
    }

    public PersistenceManager getPersistenceManager(PersistenceCapable pc) {
        if (this.myPC != null && this.disconnectClone(pc)) {
            return null;
        }
        if (this.myEC == null) {
            return null;
        }
        this.myEC.hereIsObjectProvider(this, this.myPC);
        return (PersistenceManager)this.myEC.getOwner();
    }

    protected CallbackHandler getCallbackHandler() {
        return this.myEC.getCallbackHandler();
    }

    public boolean isFlushedToDatastore() {
        return !this.dirty;
    }

    public boolean isDirty(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isDirty();
    }

    public boolean isTransactional(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isTransactional();
    }

    public boolean isPersistent(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isPersistent();
    }

    public boolean isNew(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isNew();
    }

    public boolean isDeleted(PersistenceCapable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isDeleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict() {
        if (this.myLC != this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(2) && this.myLC != this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(9)) {
            return;
        }
        this.preStateChange();
        try {
            try {
                this.getCallbackHandler().preClear(this.myPC);
                this.getCallbackHandler().postClear(this.myPC);
            }
            finally {
                this.myLC = this.myLC.transitionEvict(this);
            }
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionRefresh(this);
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieve(boolean fgOnly) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionRetrieve((ObjectProvider)this, fgOnly);
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePersistentTransactionalTransient() {
        this.preStateChange();
        try {
            if (this.myLC.isTransactional && !this.myLC.isPersistent) {
                this.makePersistent();
                this.myLC = this.myLC.transitionMakePersistent(this);
            }
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeNontransactional() {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionMakeNontransactional(this);
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transitionReadField(boolean isLoaded) {
        try {
            if (this.myEC.getMultithreaded()) {
                this.myEC.getLock().lock();
                this.lock.lock();
            }
            if (this.myLC == null) {
                return;
            }
            this.preStateChange();
            try {
                this.myLC = this.myLC.transitionReadField(this, isLoaded);
            }
            finally {
                this.postStateChange();
            }
        }
        finally {
            if (this.myEC.getMultithreaded()) {
                this.lock.unlock();
                this.myEC.getLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transitionWriteField() {
        try {
            if (this.myEC.getMultithreaded()) {
                this.myEC.getLock().lock();
                this.lock.lock();
            }
            this.preStateChange();
            try {
                this.myLC = this.myLC.transitionWriteField(this);
            }
            finally {
                this.postStateChange();
            }
        }
        finally {
            if (this.myEC.getMultithreaded()) {
                this.lock.unlock();
                this.myEC.getLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preBegin(Transaction tx) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionBegin(this, tx);
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCommit(Transaction tx) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionCommit(this, tx);
            if (this.transactionalVersion != this.myVersion) {
                this.myVersion = this.transactionalVersion;
            }
            this.lockMode = 0;
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRollback(Transaction tx) {
        this.preStateChange();
        try {
            this.myEC.clearDirty(this);
            this.myLC = this.myLC.transitionRollback(this, tx);
            if (this.transactionalVersion != this.myVersion) {
                this.transactionalVersion = this.myVersion;
            }
            this.lockMode = 0;
        }
        finally {
            this.postStateChange();
        }
    }

    protected abstract void preStateChange();

    protected abstract void postStateChange();

    public Object getVersion(PersistenceCapable pc) {
        if (pc == this.myPC) {
            return this.transactionalVersion;
        }
        return null;
    }

    public Object getVersion() {
        return this.getVersion(this.myPC);
    }

    public void setTransactionalVersion(Object version) {
        this.transactionalVersion = version;
    }

    public Object getTransactionalVersion(Object pc) {
        return this.transactionalVersion;
    }

    public Object getTransactionalVersion() {
        return this.getTransactionalVersion(this.myPC);
    }

    public void setVersion(Object version) {
        this.myVersion = version;
        this.transactionalVersion = version;
    }

    protected boolean areFieldsLoaded(int[] fieldNumbers) {
        for (int i = 0; i < fieldNumbers.length; ++i) {
            if (this.loadedFields[fieldNumbers[i]]) continue;
            return false;
        }
        return true;
    }

    public boolean[] getDirtyFields() {
        boolean[] copy = new boolean[this.dirtyFields.length];
        System.arraycopy(this.dirtyFields, 0, copy, 0, this.dirtyFields.length);
        return copy;
    }

    public int[] getDirtyFieldNumbers() {
        return ClassUtils.getFlagsSetTo(this.dirtyFields, true);
    }

    public boolean[] getLoadedFields() {
        return (boolean[])this.loadedFields.clone();
    }

    public int[] getLoadedFieldNumbers() {
        return ClassUtils.getFlagsSetTo(this.loadedFields, true);
    }

    public boolean getAllFieldsLoaded() {
        for (int i = 0; i < this.loadedFields.length; ++i) {
            if (this.loadedFields[i]) continue;
            return false;
        }
        return true;
    }

    public String[] getDirtyFieldNames() {
        int[] dirtyFieldNumbers = ClassUtils.getFlagsSetTo(this.dirtyFields, true);
        if (dirtyFieldNumbers != null && dirtyFieldNumbers.length > 0) {
            String[] dirtyFieldNames = new String[dirtyFieldNumbers.length];
            for (int i = 0; i < dirtyFieldNumbers.length; ++i) {
                dirtyFieldNames[i] = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(dirtyFieldNumbers[i]).getName();
            }
            return dirtyFieldNames;
        }
        return null;
    }

    public String[] getLoadedFieldNames() {
        int[] loadedFieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, true);
        if (loadedFieldNumbers != null && loadedFieldNumbers.length > 0) {
            String[] loadedFieldNames = new String[loadedFieldNumbers.length];
            for (int i = 0; i < loadedFieldNumbers.length; ++i) {
                loadedFieldNames[i] = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(loadedFieldNumbers[i]).getName();
            }
            return loadedFieldNames;
        }
        return null;
    }

    public boolean isFieldLoaded(int fieldNumber) {
        return this.loadedFields[fieldNumber];
    }

    protected void clearDirtyFlags() {
        this.dirty = false;
        ClassUtils.clearFlags(this.dirtyFields);
    }

    protected void clearDirtyFlags(int[] fieldNumbers) {
        this.dirty = false;
        ClassUtils.clearFlags(this.dirtyFields, fieldNumbers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFields() {
        try {
            this.getCallbackHandler().preClear(this.myPC);
        }
        finally {
            this.clearFieldsByNumbers(this.cmd.getAllMemberPositions());
            this.clearDirtyFlags();
            if (this.myEC.getStoreManager() instanceof ObjectReferencingStoreManager) {
                ((ObjectReferencingStoreManager)((Object)this.myEC.getStoreManager())).notifyObjectIsOutdated(this);
            }
            this.jdoDfgFlags = 1;
            this.myPC.jdoReplaceFlags();
            this.getCallbackHandler().postClear(this.myPC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearNonPrimaryKeyFields() {
        try {
            this.getCallbackHandler().preClear(this.myPC);
        }
        finally {
            int[] nonpkFields = this.cmd.getNonPKMemberPositions();
            this.clearFieldsByNumbers(nonpkFields);
            this.clearDirtyFlags(nonpkFields);
            if (this.myEC.getStoreManager() instanceof ObjectReferencingStoreManager) {
                ((ObjectReferencingStoreManager)((Object)this.myEC.getStoreManager())).notifyObjectIsOutdated(this);
            }
            this.jdoDfgFlags = 1;
            this.myPC.jdoReplaceFlags();
            this.getCallbackHandler().postClear(this.myPC);
        }
    }

    public void clearLoadedFlags() {
        if (this.myEC.getStoreManager() instanceof ObjectReferencingStoreManager) {
            ((ObjectReferencingStoreManager)((Object)this.myEC.getStoreManager())).notifyObjectIsOutdated(this);
        }
        this.jdoDfgFlags = 1;
        this.myPC.jdoReplaceFlags();
        ClassUtils.clearFlags(this.loadedFields);
    }

    protected void clearFieldsByNumbers(int[] fieldNumbers) {
        this.replaceFields(fieldNumbers, HOLLOWFIELDMANAGER);
        for (int i = 0; i < fieldNumbers.length; ++i) {
            this.loadedFields[fieldNumbers[i]] = false;
            this.dirtyFields[fieldNumbers[i]] = false;
        }
    }

    public byte replacingFlags(PersistenceCapable pc) {
        if (pc != this.myPC) {
            return 0;
        }
        return this.jdoDfgFlags;
    }

    public void providedBooleanField(PersistenceCapable pc, int fieldNumber, boolean currentValue) {
        this.currFM.storeBooleanField(fieldNumber, currentValue);
    }

    public void providedByteField(PersistenceCapable pc, int fieldNumber, byte currentValue) {
        this.currFM.storeByteField(fieldNumber, currentValue);
    }

    public void providedCharField(PersistenceCapable pc, int fieldNumber, char currentValue) {
        this.currFM.storeCharField(fieldNumber, currentValue);
    }

    public void providedDoubleField(PersistenceCapable pc, int fieldNumber, double currentValue) {
        this.currFM.storeDoubleField(fieldNumber, currentValue);
    }

    public void providedFloatField(PersistenceCapable pc, int fieldNumber, float currentValue) {
        this.currFM.storeFloatField(fieldNumber, currentValue);
    }

    public void providedIntField(PersistenceCapable pc, int fieldNumber, int currentValue) {
        this.currFM.storeIntField(fieldNumber, currentValue);
    }

    public void providedLongField(PersistenceCapable pc, int fieldNumber, long currentValue) {
        this.currFM.storeLongField(fieldNumber, currentValue);
    }

    public void providedShortField(PersistenceCapable pc, int fieldNumber, short currentValue) {
        this.currFM.storeShortField(fieldNumber, currentValue);
    }

    public void providedStringField(PersistenceCapable pc, int fieldNumber, String currentValue) {
        this.currFM.storeStringField(fieldNumber, currentValue);
    }

    public void providedObjectField(PersistenceCapable pc, int fieldNumber, Object currentValue) {
        this.currFM.storeObjectField(fieldNumber, currentValue);
    }

    public Object provideField(int fieldNumber) {
        return this.provideField(this.myPC, fieldNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object provideField(PersistenceCapable pc, int fieldNumber) {
        Object obj;
        try {
            if (this.myEC.getMultithreaded()) {
                this.myEC.getLock().lock();
                this.lock.lock();
            }
            FieldManager prevFM = this.currFM;
            this.currFM = new SingleValueFieldManager();
            try {
                pc.jdoProvideField(fieldNumber);
                obj = this.currFM.fetchObjectField(fieldNumber);
            }
            finally {
                this.currFM = prevFM;
            }
        }
        finally {
            if (this.myEC.getMultithreaded()) {
                this.lock.unlock();
                this.myEC.getLock().unlock();
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provideFields(int[] fieldNumbers, FieldManager fm) {
        try {
            if (this.myEC.getMultithreaded()) {
                this.myEC.getLock().lock();
                this.lock.lock();
            }
            FieldManager prevFM = this.currFM;
            this.currFM = fm;
            try {
                this.myPC.jdoProvideFields(fieldNumbers);
            }
            finally {
                this.currFM = prevFM;
            }
        }
        finally {
            if (this.myEC.getMultithreaded()) {
                this.lock.unlock();
                this.myEC.getLock().unlock();
            }
        }
    }

    protected abstract void loadUnloadedFieldsInFetchPlanAndVersion();

    protected abstract void replaceField(PersistenceCapable var1, int var2, Object var3, boolean var4);

    public void setBooleanField(PersistenceCapable pc, int fieldNumber, boolean currentValue, boolean newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, fieldNumber, newValue ? Boolean.TRUE : Boolean.FALSE, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[fieldNumber] || currentValue != newValue) {
                String key;
                if (this.cmd.getIdentityType() == IdentityType.NONDURABLE && !this.containsAssociatedValue(key = "FIELD_VALUE.ORIGINAL." + fieldNumber)) {
                    this.setAssociatedValue(key, currentValue);
                }
                this.updateField(pc, fieldNumber, newValue ? Boolean.TRUE : Boolean.FALSE);
                if (!this.myEC.getTransaction().isActive()) {
                    this.myEC.processNontransactionalUpdate();
                }
            }
        } else {
            this.replaceField(pc, fieldNumber, newValue ? Boolean.TRUE : Boolean.FALSE, true);
        }
    }

    public void setByteField(PersistenceCapable pc, int fieldNumber, byte currentValue, byte newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, fieldNumber, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[fieldNumber] || currentValue != newValue) {
                String key;
                if (this.cmd.getIdentityType() == IdentityType.NONDURABLE && !this.containsAssociatedValue(key = "FIELD_VALUE.ORIGINAL." + fieldNumber)) {
                    this.setAssociatedValue(key, currentValue);
                }
                this.updateField(pc, fieldNumber, newValue);
                if (!this.myEC.getTransaction().isActive()) {
                    this.myEC.processNontransactionalUpdate();
                }
            }
        } else {
            this.replaceField(pc, fieldNumber, newValue, true);
        }
    }

    public void setCharField(PersistenceCapable pc, int fieldNumber, char currentValue, char newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, fieldNumber, Character.valueOf(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[fieldNumber] || currentValue != newValue) {
                String key;
                if (this.cmd.getIdentityType() == IdentityType.NONDURABLE && !this.containsAssociatedValue(key = "FIELD_VALUE.ORIGINAL." + fieldNumber)) {
                    this.setAssociatedValue(key, Character.valueOf(currentValue));
                }
                this.updateField(pc, fieldNumber, Character.valueOf(newValue));
                if (!this.myEC.getTransaction().isActive()) {
                    this.myEC.processNontransactionalUpdate();
                }
            }
        } else {
            this.replaceField(pc, fieldNumber, Character.valueOf(newValue), true);
        }
    }

    public void setDoubleField(PersistenceCapable pc, int fieldNumber, double currentValue, double newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, fieldNumber, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[fieldNumber] || currentValue != newValue) {
                String key;
                if (this.cmd.getIdentityType() == IdentityType.NONDURABLE && !this.containsAssociatedValue(key = "FIELD_VALUE.ORIGINAL." + fieldNumber)) {
                    this.setAssociatedValue(key, currentValue);
                }
                this.updateField(pc, fieldNumber, newValue);
                if (!this.myEC.getTransaction().isActive()) {
                    this.myEC.processNontransactionalUpdate();
                }
            }
        } else {
            this.replaceField(pc, fieldNumber, newValue, true);
        }
    }

    public void setFloatField(PersistenceCapable pc, int fieldNumber, float currentValue, float newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, fieldNumber, Float.valueOf(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[fieldNumber] || currentValue != newValue) {
                String key;
                if (this.cmd.getIdentityType() == IdentityType.NONDURABLE && !this.containsAssociatedValue(key = "FIELD_VALUE.ORIGINAL." + fieldNumber)) {
                    this.setAssociatedValue(key, Float.valueOf(currentValue));
                }
                this.updateField(pc, fieldNumber, Float.valueOf(newValue));
                if (!this.myEC.getTransaction().isActive()) {
                    this.myEC.processNontransactionalUpdate();
                }
            }
        } else {
            this.replaceField(pc, fieldNumber, Float.valueOf(newValue), true);
        }
    }

    public void setIntField(PersistenceCapable pc, int fieldNumber, int currentValue, int newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, fieldNumber, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[fieldNumber] || currentValue != newValue) {
                String key;
                if (this.cmd.getIdentityType() == IdentityType.NONDURABLE && !this.containsAssociatedValue(key = "FIELD_VALUE.ORIGINAL." + fieldNumber)) {
                    this.setAssociatedValue(key, currentValue);
                }
                this.updateField(pc, fieldNumber, newValue);
                if (!this.myEC.getTransaction().isActive()) {
                    this.myEC.processNontransactionalUpdate();
                }
            }
        } else {
            this.replaceField(pc, fieldNumber, newValue, true);
        }
    }

    public void setLongField(PersistenceCapable pc, int fieldNumber, long currentValue, long newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, fieldNumber, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[fieldNumber] || currentValue != newValue) {
                String key;
                if (this.cmd.getIdentityType() == IdentityType.NONDURABLE && !this.containsAssociatedValue(key = "FIELD_VALUE.ORIGINAL." + fieldNumber)) {
                    this.setAssociatedValue(key, currentValue);
                }
                this.updateField(pc, fieldNumber, newValue);
                if (!this.myEC.getTransaction().isActive()) {
                    this.myEC.processNontransactionalUpdate();
                }
            }
        } else {
            this.replaceField(pc, fieldNumber, newValue, true);
        }
    }

    public void setShortField(PersistenceCapable pc, int fieldNumber, short currentValue, short newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, fieldNumber, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[fieldNumber] || currentValue != newValue) {
                String key;
                if (this.cmd.getIdentityType() == IdentityType.NONDURABLE && !this.containsAssociatedValue(key = "FIELD_VALUE.ORIGINAL." + fieldNumber)) {
                    this.setAssociatedValue(key, currentValue);
                }
                this.updateField(pc, fieldNumber, newValue);
                if (!this.myEC.getTransaction().isActive()) {
                    this.myEC.processNontransactionalUpdate();
                }
            }
        } else {
            this.replaceField(pc, fieldNumber, newValue, true);
        }
    }

    public void setStringField(PersistenceCapable pc, int fieldNumber, String currentValue, String newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, fieldNumber, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[fieldNumber] || !(currentValue != null ? currentValue.equals(newValue) : newValue == null)) {
                String key;
                if (this.cmd.getIdentityType() == IdentityType.NONDURABLE && !this.containsAssociatedValue(key = "FIELD_VALUE.ORIGINAL." + fieldNumber)) {
                    this.setAssociatedValue(key, currentValue);
                }
                this.updateField(pc, fieldNumber, newValue);
                if (!this.myEC.getTransaction().isActive()) {
                    this.myEC.processNontransactionalUpdate();
                }
            }
        } else {
            this.replaceField(pc, fieldNumber, newValue, true);
        }
    }

    public void setObjectField(PersistenceCapable pc, int fieldNumber, Object currentValue, Object newValue) {
        JDOStateManager currentSM;
        if (currentValue != null && currentValue != newValue && currentValue instanceof PersistenceCapable && (currentSM = (JDOStateManager)this.myEC.findObjectProvider(currentValue)) != null && currentSM.isEmbedded()) {
            currentSM.removeEmbeddedOwner((JDOStateManager)this, fieldNumber);
        }
        if (pc != this.myPC) {
            this.replaceField(pc, fieldNumber, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            boolean loadedOldValue = false;
            Object oldValue = currentValue;
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            ClassLoaderResolver clr = this.myEC.getClassLoaderResolver();
            RelationType relationType = mmd.getRelationType(clr);
            this.myEC.removeObjectFromLevel2Cache(this.myID);
            if (!this.loadedFields[fieldNumber] && currentValue == null) {
                if (this.myEC.getManageRelations() && (relationType == RelationType.ONE_TO_ONE_BI || relationType == RelationType.MANY_TO_ONE_BI)) {
                    this.loadField(fieldNumber);
                    loadedOldValue = true;
                    oldValue = this.provideField(fieldNumber);
                }
                if (relationType != RelationType.NONE && newValue == null && (mmd.isDependent() || mmd.isCascadeRemoveOrphans())) {
                    this.loadField(fieldNumber);
                    loadedOldValue = true;
                    oldValue = this.provideField(fieldNumber);
                }
            }
            boolean equal = false;
            if (oldValue == null && newValue == null) {
                equal = true;
            } else if (oldValue != null && newValue != null) {
                if (oldValue instanceof PersistenceCapable) {
                    if (oldValue == newValue) {
                        equal = true;
                    }
                } else if (oldValue.equals(newValue)) {
                    equal = true;
                }
            }
            boolean needsSCOUpdating = false;
            if (!this.loadedFields[fieldNumber] || !equal || mmd.hasArray()) {
                SCO sco;
                Object owner;
                String key;
                if (this.cmd.getIdentityType() == IdentityType.NONDURABLE && relationType == RelationType.NONE && !this.containsAssociatedValue(key = "FIELD_VALUE.ORIGINAL." + fieldNumber)) {
                    this.setAssociatedValue(key, oldValue);
                }
                if (oldValue instanceof SCO) {
                    if (oldValue instanceof SCOContainer) {
                        ((SCOContainer)oldValue).load();
                    }
                    ((SCO)oldValue).unsetOwner();
                }
                if (newValue instanceof SCO && (owner = (sco = (SCO)newValue).getOwner()) != null) {
                    throw new JDOUserException(LOCALISER.msg("026007", (Object)sco.getFieldName(), owner));
                }
                this.updateField(pc, fieldNumber, newValue);
                if (this.cmd.getSCOMutableMemberFlags()[fieldNumber] && !(newValue instanceof SCO)) {
                    needsSCOUpdating = true;
                }
            } else if (loadedOldValue) {
                this.updateField(pc, fieldNumber, newValue);
            }
            if (!equal && RelationType.isBidirectional(relationType) && this.myEC.getManageRelations()) {
                this.myEC.getRelationshipManager(this).relationChange(fieldNumber, oldValue, newValue);
            }
            if (needsSCOUpdating) {
                newValue = this.wrapSCOField(fieldNumber, newValue, false, true, true);
            }
            if (oldValue != null && newValue == null && oldValue instanceof PersistenceCapable && (mmd.isDependent() || mmd.isCascadeRemoveOrphans()) && this.myEC.getApiAdapter().isPersistent(oldValue)) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026026", oldValue, (Object)mmd.getFullFieldName()));
                this.myEC.deleteObjectInternal(oldValue);
            }
            if (!this.myEC.getTransaction().isActive()) {
                this.myEC.processNontransactionalUpdate();
            }
        } else {
            this.replaceField(pc, fieldNumber, newValue, true);
        }
    }

    protected void updateField(PersistenceCapable pc, int fieldNumber, Object value) {
        boolean wasDirty = this.dirty;
        if (this.activity != ActivityState.INSERTING && this.activity != ActivityState.INSERTING_CALLBACKS) {
            if (!wasDirty) {
                this.getCallbackHandler().preDirty(this.myPC);
            }
            this.transitionWriteField();
            this.dirty = true;
            this.dirtyFields[fieldNumber] = true;
            this.loadedFields[fieldNumber] = true;
        }
        this.replaceField(pc, fieldNumber, value, true);
        if (this.dirty && !wasDirty) {
            this.getCallbackHandler().postDirty(this.myPC);
        }
        if (this.activity == ActivityState.NONE && (this.flags & 4) == 0 && (!this.myLC.isTransactional() || this.myLC.isPersistent())) {
            this.myEC.markDirty(this, true);
        }
    }

    public boolean replacingBooleanField(PersistenceCapable pc, int fieldNumber) {
        boolean value = this.currFM.fetchBooleanField(fieldNumber);
        this.loadedFields[fieldNumber] = true;
        return value;
    }

    public byte replacingByteField(PersistenceCapable obj, int fieldNumber) {
        byte value = this.currFM.fetchByteField(fieldNumber);
        this.loadedFields[fieldNumber] = true;
        return value;
    }

    public char replacingCharField(PersistenceCapable obj, int fieldNumber) {
        char value = this.currFM.fetchCharField(fieldNumber);
        this.loadedFields[fieldNumber] = true;
        return value;
    }

    public double replacingDoubleField(PersistenceCapable obj, int fieldNumber) {
        double value = this.currFM.fetchDoubleField(fieldNumber);
        this.loadedFields[fieldNumber] = true;
        return value;
    }

    public float replacingFloatField(PersistenceCapable obj, int fieldNumber) {
        float value = this.currFM.fetchFloatField(fieldNumber);
        this.loadedFields[fieldNumber] = true;
        return value;
    }

    public int replacingIntField(PersistenceCapable obj, int fieldNumber) {
        int value = this.currFM.fetchIntField(fieldNumber);
        this.loadedFields[fieldNumber] = true;
        return value;
    }

    public long replacingLongField(PersistenceCapable obj, int fieldNumber) {
        long value = this.currFM.fetchLongField(fieldNumber);
        this.loadedFields[fieldNumber] = true;
        return value;
    }

    public short replacingShortField(PersistenceCapable obj, int fieldNumber) {
        short value = this.currFM.fetchShortField(fieldNumber);
        this.loadedFields[fieldNumber] = true;
        return value;
    }

    public String replacingStringField(PersistenceCapable obj, int fieldNumber) {
        String value = this.currFM.fetchStringField(fieldNumber);
        this.loadedFields[fieldNumber] = true;
        return value;
    }

    public Object replacingObjectField(PersistenceCapable obj, int fieldNumber) {
        try {
            Object value = this.currFM.fetchObjectField(fieldNumber);
            this.loadedFields[fieldNumber] = true;
            return value;
        }
        catch (AbstractFetchDepthFieldManager.EndOfFetchPlanGraphException eodge) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceField(PersistenceCapable pc, int fieldNumber, Object value) {
        try {
            if (this.myEC.getMultithreaded()) {
                this.myEC.getLock().lock();
                this.lock.lock();
            }
            FieldManager prevFM = this.currFM;
            this.currFM = new SingleValueFieldManager();
            try {
                this.currFM.storeObjectField(fieldNumber, value);
                pc.jdoReplaceField(fieldNumber);
            }
            finally {
                this.currFM = prevFM;
            }
        }
        finally {
            if (this.myEC.getMultithreaded()) {
                this.lock.unlock();
                this.myEC.getLock().unlock();
            }
        }
    }

    public void lock(short lockMode) {
        this.lockMode = lockMode;
    }

    public void unlock() {
        this.lockMode = 0;
    }

    public short getLockMode() {
        return this.lockMode;
    }

    public boolean isDetaching() {
        return (this.flags & 0x10) != 0;
    }

    protected boolean disconnectClone(PersistenceCapable pc) {
        if ((this.flags & 0x10) != 0) {
            return false;
        }
        if (pc != this.myPC) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026001", (Object)StringUtils.toJVMIDString(pc), (Object)this));
            }
            pc.jdoReplaceFlags();
            this.replaceStateManager(pc, null);
            return true;
        }
        return false;
    }

    public void retrieveDetachState(ObjectProvider op) {
        if (op.getObject() instanceof Detachable) {
            ((JDOStateManager)op).flags |= 0x80;
            ((Detachable)op.getObject()).jdoReplaceDetachedState();
            ((JDOStateManager)op).flags &= 0xFFFFFF7F;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDetachState() {
        if (this.getObject() instanceof Detachable) {
            this.flags |= 0x40;
            try {
                ((Detachable)this.getObject()).jdoReplaceDetachedState();
            }
            finally {
                this.flags &= 0xFFFFFFBF;
            }
        }
    }

    public Object[] replacingDetachedState(Detachable pc, Object[] currentState) {
        if ((this.flags & 0x40) != 0) {
            return null;
        }
        if ((this.flags & 0x80) != 0) {
            BitSet jdoLoadedFields = (BitSet)currentState[2];
            for (int i = 0; i < this.loadedFields.length; ++i) {
                this.loadedFields[i] = jdoLoadedFields.get(i);
            }
            BitSet jdoModifiedFields = (BitSet)currentState[3];
            for (int i = 0; i < this.dirtyFields.length; ++i) {
                this.dirtyFields[i] = jdoModifiedFields.get(i);
            }
            this.setVersion(currentState[1]);
            return currentState;
        }
        Object[] state = new Object[4];
        state[0] = this.myID;
        state[1] = this.getVersion(this.myPC);
        BitSet loadedState = new BitSet();
        for (int i = 0; i < this.loadedFields.length; ++i) {
            if (this.loadedFields[i]) {
                loadedState.set(i);
                continue;
            }
            loadedState.clear(i);
        }
        state[2] = loadedState;
        BitSet modifiedState = new BitSet();
        for (int i = 0; i < this.dirtyFields.length; ++i) {
            if (this.dirtyFields[i]) {
                modifiedState.set(i);
                continue;
            }
            modifiedState.clear(i);
        }
        state[3] = modifiedState;
        return state;
    }

    public boolean getBooleanField(PersistenceCapable pc, int fieldNumber, boolean currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public byte getByteField(PersistenceCapable pc, int fieldNumber, byte currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public char getCharField(PersistenceCapable pc, int fieldNumber, char currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public double getDoubleField(PersistenceCapable pc, int fieldNumber, double currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public float getFloatField(PersistenceCapable pc, int fieldNumber, float currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public int getIntField(PersistenceCapable pc, int fieldNumber, int currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public long getLongField(PersistenceCapable pc, int fieldNumber, long currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public short getShortField(PersistenceCapable pc, int fieldNumber, short currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public String getStringField(PersistenceCapable pc, int fieldNumber, String currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }

    public Object getObjectField(PersistenceCapable pc, int fieldNumber, Object currentValue) {
        throw new NucleusException(LOCALISER.msg("026006"));
    }
}

