/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer.jdo;

import org.datanucleus.ClassConstants;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.util.Localiser;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class JDOUtils {
    protected static Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    public static final String ACN_boolean = ClassNameConstants.BOOLEAN;
    public static final String ACN_byte = ClassNameConstants.BYTE;
    public static final String ACN_char = ClassNameConstants.CHAR;
    public static final String ACN_double = ClassNameConstants.DOUBLE;
    public static final String ACN_float = ClassNameConstants.FLOAT;
    public static final String ACN_int = ClassNameConstants.INT;
    public static final String ACN_long = ClassNameConstants.LONG;
    public static final String ACN_short = ClassNameConstants.SHORT;
    public static final String ACN_Boolean = ClassNameConstants.JAVA_LANG_BOOLEAN.replace('.', '/');
    public static final String ACN_Byte = ClassNameConstants.JAVA_LANG_BYTE.replace('.', '/');
    public static final String ACN_Character = ClassNameConstants.JAVA_LANG_CHARACTER.replace('.', '/');
    public static final String ACN_Double = ClassNameConstants.JAVA_LANG_DOUBLE.replace('.', '/');
    public static final String ACN_Float = ClassNameConstants.JAVA_LANG_FLOAT.replace('.', '/');
    public static final String ACN_Integer = ClassNameConstants.JAVA_LANG_INTEGER.replace('.', '/');
    public static final String ACN_Long = ClassNameConstants.JAVA_LANG_LONG.replace('.', '/');
    public static final String ACN_Short = ClassNameConstants.JAVA_LANG_SHORT.replace('.', '/');
    public static final String ACN_String = ClassNameConstants.JAVA_LANG_STRING.replace('.', '/');
    public static final String ACN_Object = Object.class.getName().replace('.', '/');
    public static final String CD_String = Type.getDescriptor(String.class);
    public static final String CD_Object = Type.getDescriptor(Object.class);

    private JDOUtils() {
    }

    public static void addBIPUSHToMethod(MethodVisitor visitor, int i) {
        if (i < 6) {
            switch (i) {
                case 0: {
                    visitor.visitInsn(3);
                    break;
                }
                case 1: {
                    visitor.visitInsn(4);
                    break;
                }
                case 2: {
                    visitor.visitInsn(5);
                    break;
                }
                case 3: {
                    visitor.visitInsn(6);
                    break;
                }
                case 4: {
                    visitor.visitInsn(7);
                    break;
                }
                case 5: {
                    visitor.visitInsn(8);
                }
            }
        } else if (i < 127) {
            visitor.visitIntInsn(16, i);
        } else if (i < Short.MAX_VALUE) {
            visitor.visitIntInsn(17, i);
        }
    }

    public static void addReturnForType(MethodVisitor visitor, Class type) {
        if (type == Integer.TYPE || type == Boolean.TYPE || type == Byte.TYPE || type == Character.TYPE || type == Short.TYPE) {
            visitor.visitInsn(172);
        } else if (type == Double.TYPE) {
            visitor.visitInsn(175);
        } else if (type == Float.TYPE) {
            visitor.visitInsn(174);
        } else if (type == Long.TYPE) {
            visitor.visitInsn(173);
        } else {
            visitor.visitInsn(176);
        }
    }

    public static void addLoadForType(MethodVisitor visitor, Class type, int number) {
        if (type == Integer.TYPE || type == Boolean.TYPE || type == Byte.TYPE || type == Character.TYPE || type == Short.TYPE) {
            visitor.visitVarInsn(21, number);
        } else if (type == Double.TYPE) {
            visitor.visitVarInsn(24, number);
        } else if (type == Float.TYPE) {
            visitor.visitVarInsn(23, number);
        } else if (type == Long.TYPE) {
            visitor.visitVarInsn(22, number);
        } else {
            visitor.visitVarInsn(25, number);
        }
    }

    public static String getTypeNameForJDOMethod(Class cls) {
        if (cls == null) {
            return null;
        }
        if (cls == Boolean.TYPE) {
            return "Boolean";
        }
        if (cls == Byte.TYPE) {
            return "Byte";
        }
        if (cls == Character.TYPE) {
            return "Char";
        }
        if (cls == Double.TYPE) {
            return "Double";
        }
        if (cls == Float.TYPE) {
            return "Float";
        }
        if (cls == Integer.TYPE) {
            return "Int";
        }
        if (cls == Long.TYPE) {
            return "Long";
        }
        if (cls == Short.TYPE) {
            return "Short";
        }
        if (cls == String.class) {
            return "String";
        }
        return "Object";
    }

    public static String getTypeDescriptorForType(String clsName) {
        if (clsName == null) {
            return null;
        }
        if (clsName.equals(Boolean.TYPE.getName())) {
            return Type.BOOLEAN_TYPE.getDescriptor();
        }
        if (clsName.equals(Byte.TYPE.getName())) {
            return Type.BYTE_TYPE.getDescriptor();
        }
        if (clsName.equals(Character.TYPE.getName())) {
            return Type.CHAR_TYPE.getDescriptor();
        }
        if (clsName.equals(Double.TYPE.getName())) {
            return Type.DOUBLE_TYPE.getDescriptor();
        }
        if (clsName.equals(Float.TYPE.getName())) {
            return Type.FLOAT_TYPE.getDescriptor();
        }
        if (clsName.equals(Integer.TYPE.getName())) {
            return Type.INT_TYPE.getDescriptor();
        }
        if (clsName.equals(Long.TYPE.getName())) {
            return Type.LONG_TYPE.getDescriptor();
        }
        if (clsName.equals(Short.TYPE.getName())) {
            return Type.SHORT_TYPE.getDescriptor();
        }
        if (clsName.equals(String.class.getName())) {
            return CD_String;
        }
        return "L" + clsName.replace('.', '/') + ";";
    }

    public static String getTypeDescriptorForJDOMethod(Class cls) {
        if (cls == null) {
            return null;
        }
        if (cls == Boolean.TYPE) {
            return Type.BOOLEAN_TYPE.getDescriptor();
        }
        if (cls == Byte.TYPE) {
            return Type.BYTE_TYPE.getDescriptor();
        }
        if (cls == Character.TYPE) {
            return Type.CHAR_TYPE.getDescriptor();
        }
        if (cls == Double.TYPE) {
            return Type.DOUBLE_TYPE.getDescriptor();
        }
        if (cls == Float.TYPE) {
            return Type.FLOAT_TYPE.getDescriptor();
        }
        if (cls == Integer.TYPE) {
            return Type.INT_TYPE.getDescriptor();
        }
        if (cls == Long.TYPE) {
            return Type.LONG_TYPE.getDescriptor();
        }
        if (cls == Short.TYPE) {
            return Type.SHORT_TYPE.getDescriptor();
        }
        if (cls == String.class) {
            return CD_String;
        }
        return CD_Object;
    }

    public static String getASMClassNameForSingleFieldIdentityConstructor(Class fieldType) {
        if (fieldType == null) {
            return null;
        }
        if (fieldType == Byte.TYPE || fieldType == Byte.class) {
            return ACN_Byte;
        }
        if (fieldType == Character.TYPE || fieldType == Character.class) {
            return ACN_Character;
        }
        if (fieldType == Integer.TYPE || fieldType == Integer.class) {
            return ACN_Integer;
        }
        if (fieldType == Long.TYPE || fieldType == Long.class) {
            return ACN_Long;
        }
        if (fieldType == Short.TYPE || fieldType == Short.class) {
            return ACN_Short;
        }
        if (fieldType == String.class) {
            return ACN_String;
        }
        return ACN_Object;
    }
}

