/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchGroup;
import org.datanucleus.FetchGroupManager;
import org.datanucleus.FetchPlan;
import org.datanucleus.ImplementationCreator;
import org.datanucleus.JTAJCATransactionImpl;
import org.datanucleus.JTATransactionImpl;
import org.datanucleus.NucleusContext;
import org.datanucleus.NullCallbackHandler;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.Transaction;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.TransactionImpl;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.L2CachePopulateFieldManager;
import org.datanucleus.cache.Level1Cache;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.exceptions.ClassNotDetachableException;
import org.datanucleus.exceptions.ClassNotPersistableException;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.CommitStateTransitionException;
import org.datanucleus.exceptions.NoPersistenceInformationException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusFatalUserException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.ObjectDetachedException;
import org.datanucleus.exceptions.RollbackStateTransitionException;
import org.datanucleus.exceptions.TransactionActiveOnCloseException;
import org.datanucleus.exceptions.TransactionNotActiveException;
import org.datanucleus.identity.DatastoreUniqueOID;
import org.datanucleus.identity.IdentityKeyTranslator;
import org.datanucleus.identity.IdentityReference;
import org.datanucleus.identity.IdentityStringTranslator;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.identity.SCOID;
import org.datanucleus.management.ManagerStatistics;
import org.datanucleus.management.jmx.ManagementManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.TransactionType;
import org.datanucleus.properties.BasePropertyStore;
import org.datanucleus.state.CallbackHandler;
import org.datanucleus.state.DetachState;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.JDOStateManagerFactory;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.state.LockManager;
import org.datanucleus.state.LockManagerImpl;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.state.RelationshipManagerImpl;
import org.datanucleus.store.Extent;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.PersistenceBatchType;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.WeakValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionContextImpl
implements ExecutionContext,
TransactionEventListener {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    NucleusContext nucCtx;
    private Object owner;
    private boolean closed;
    private FetchPlan fetchPlan;
    private ClassLoaderResolver clr = null;
    private CallbackHandler callbacks;
    protected Level1Cache cache;
    private Object objectLookingForOP = null;
    private ObjectProvider foundOP = null;
    private Transaction tx;
    private Map<Object, ObjectProvider> enlistedOPCache = new WeakValueMap();
    private List<ObjectProvider> dirtyOPs = new ArrayList<ObjectProvider>();
    private List<ObjectProvider> indirectDirtyOPs = new ArrayList<ObjectProvider>();
    private Set<ObjectProvider> nontxProcessedOPs = null;
    private Set txCachedIds = null;
    private BasePropertyStore properties = new BasePropertyStore();
    private int flushing = 0;
    private boolean runningDetachAllOnTxnEnd = false;
    private FetchGroupManager fetchGrpMgr;
    private LockManager lockMgr = null;
    protected Lock lock;
    private boolean runningManageRelations = false;
    Map<ObjectProvider, RelationshipManager> managedRelationDetails = null;
    private boolean runningPBRAtCommit = false;
    private Set txKnownPersistedIds = null;
    private Set txKnownDeletedIds = null;
    private Set txFlushedNewIds = null;
    private Set txEnlistedIds = null;
    ManagerStatistics statistics = null;
    JDOStateManagerFactory smFactory = JDOStateManagerFactory.getInstance();
    private ThreadLocal contextInfoThreadLocal = new ThreadLocal(){

        protected Object initialValue() {
            return new ThreadContextInfo();
        }
    };
    private ObjectProvider[] detachAllOnTxnEndOPs = null;

    protected ThreadContextInfo acquireThreadContextInfo() {
        ThreadContextInfo threadInfo = (ThreadContextInfo)this.contextInfoThreadLocal.get();
        ++threadInfo.referenceCounter;
        return threadInfo;
    }

    protected ThreadContextInfo getThreadContextInfo() {
        return (ThreadContextInfo)this.contextInfoThreadLocal.get();
    }

    protected void releaseThreadContextInfo() {
        ThreadContextInfo threadInfo = (ThreadContextInfo)this.contextInfoThreadLocal.get();
        if (--threadInfo.referenceCounter <= 0) {
            threadInfo.referenceCounter = 0;
            if (threadInfo.attachedOwnerByObject != null) {
                threadInfo.attachedOwnerByObject.clear();
            }
            threadInfo.attachedOwnerByObject = null;
            if (threadInfo.attachedPCById != null) {
                threadInfo.attachedPCById.clear();
            }
            threadInfo.attachedPCById = null;
            this.contextInfoThreadLocal.remove();
        }
    }

    public ExecutionContextImpl(NucleusContext ctx, Object owner, String userName, String password) {
        if (ctx.getPersistenceConfiguration().getBooleanProperty("datanucleus.Multithreaded")) {
            this.lock = new ReentrantLock();
        }
        this.owner = owner;
        this.nucCtx = ctx;
        this.closed = false;
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        this.clr = ctx.getClassLoaderResolver(contextLoader);
        try {
            ImplementationCreator ic = ctx.getImplementationCreator();
            if (ic != null) {
                this.clr.setRuntimeClassLoader(ic.getClassLoader());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        PersistenceConfiguration config = ctx.getPersistenceConfiguration();
        for (Map.Entry<String, Object> entry : config.getManagerOverrideableProperties().entrySet()) {
            this.properties.setProperty(entry.getKey().toLowerCase(Locale.ENGLISH), entry.getValue());
        }
        if (this.getReachabilityAtCommit()) {
            this.txKnownPersistedIds = new HashSet();
            this.txKnownDeletedIds = new HashSet();
            this.txFlushedNewIds = new HashSet();
            this.txEnlistedIds = new HashSet();
        }
        this.fetchPlan = new FetchPlan(this, this.clr).setMaxFetchDepth(config.getIntProperty("datanucleus.maxFetchDepth"));
        this.initialiseLevel1Cache();
        this.tx = TransactionType.JTA.toString().equalsIgnoreCase(config.getStringProperty("datanucleus.TransactionType")) ? (this.getNucleusContext().isJcaMode() ? new JTAJCATransactionImpl(this) : new JTATransactionImpl(this)) : new TransactionImpl(this);
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010000", this, (Object)ctx.getStoreManager(), (Object)this.tx));
        }
        if (this.nucCtx.statisticsEnabled()) {
            String name = null;
            if (this.nucCtx.getJMXManager() != null) {
                ManagementManager mgmtMgr = this.nucCtx.getJMXManager();
                name = mgmtMgr.getDomainName() + ":InstanceName=" + mgmtMgr.getInstanceName() + ",Type=" + ManagerStatistics.class.getName() + ",Name=Manager" + NucleusContext.random.nextLong();
            }
            this.statistics = new ManagerStatistics(name, this.nucCtx.getStatistics());
            if (this.nucCtx.getJMXManager() != null) {
                this.nucCtx.getJMXManager().registerMBean(this.statistics, name);
            }
        }
        if (this.nucCtx.hasLevel2Cache()) {
            this.txCachedIds = new HashSet();
        }
    }

    @Override
    public void transactionStarted() {
        this.getStoreManager().transactionStarted(this);
        this.postBegin();
    }

    @Override
    public void transactionPreFlush() {
    }

    @Override
    public void transactionFlushed() {
    }

    @Override
    public void transactionPreCommit() {
        this.preCommit();
    }

    @Override
    public void transactionCommitted() {
        this.getStoreManager().transactionCommitted(this);
        this.postCommit();
    }

    @Override
    public void transactionPreRollBack() {
        this.preRollback();
    }

    @Override
    public void transactionRolledBack() {
        this.getStoreManager().transactionRolledBack(this);
        this.postRollback();
    }

    @Override
    public void transactionEnded() {
    }

    @Override
    public ManagerStatistics getStatistics() {
        return this.statistics;
    }

    protected void initialiseLevel1Cache() {
        String level1Type = this.nucCtx.getPersistenceConfiguration().getStringProperty("datanucleus.cache.level1.type");
        if (level1Type != null && level1Type.equalsIgnoreCase("none")) {
            return;
        }
        String level1ClassName = this.getNucleusContext().getPluginManager().getAttributeValueForExtension("org.datanucleus.cache_level1", "name", level1Type, "class-name");
        if (level1ClassName == null) {
            throw new NucleusUserException(LOCALISER.msg("003001", (Object)level1Type)).setFatal();
        }
        try {
            this.cache = (Level1Cache)this.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.cache_level1", "name", level1Type, "class-name", null, null);
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003003", (Object)level1Type));
            }
        }
        catch (Exception e) {
            throw new NucleusUserException(LOCALISER.msg("003002", (Object)level1Type, (Object)level1ClassName), e).setFatal();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public ClassLoaderResolver getClassLoaderResolver() {
        return this.clr;
    }

    @Override
    public StoreManager getStoreManager() {
        return this.getNucleusContext().getStoreManager();
    }

    @Override
    public ApiAdapter getApiAdapter() {
        return this.getNucleusContext().getApiAdapter();
    }

    @Override
    public TypeManager getTypeManager() {
        return this.getNucleusContext().getTypeManager();
    }

    @Override
    public LockManager getLockManager() {
        if (this.lockMgr == null) {
            this.lockMgr = new LockManagerImpl();
        }
        return this.lockMgr;
    }

    @Override
    public FetchPlan getFetchPlan() {
        this.assertIsOpen();
        return this.fetchPlan;
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    @Override
    public NucleusContext getNucleusContext() {
        return this.nucCtx;
    }

    @Override
    public MetaDataManager getMetaDataManager() {
        return this.getNucleusContext().getMetaDataManager();
    }

    @Override
    public void setProperties(Map props) {
        if (props == null) {
            return;
        }
        for (Map.Entry entry : props.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            this.setProperty((String)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setProperty(String name, Object value) {
        if (this.properties.hasProperty(name.toLowerCase(Locale.ENGLISH))) {
            String intName = this.getNucleusContext().getPersistenceConfiguration().getInternalNameForProperty(name);
            this.properties.setProperty(intName.toLowerCase(Locale.ENGLISH), value);
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties.getProperties();
    }

    @Override
    public Boolean getBooleanProperty(String name) {
        if (this.properties.hasProperty(name.toLowerCase(Locale.ENGLISH))) {
            this.assertIsOpen();
            String intName = this.getNucleusContext().getPersistenceConfiguration().getInternalNameForProperty(name);
            return this.properties.getBooleanProperty(intName);
        }
        return null;
    }

    @Override
    public Integer getIntProperty(String name) {
        if (this.properties.hasProperty(name.toLowerCase(Locale.ENGLISH))) {
            this.assertIsOpen();
            String intName = this.getNucleusContext().getPersistenceConfiguration().getInternalNameForProperty(name);
            return this.properties.getIntProperty(intName);
        }
        return null;
    }

    @Override
    public Object getProperty(String name) {
        if (this.properties.hasProperty(name.toLowerCase(Locale.ENGLISH))) {
            this.assertIsOpen();
            String intName = this.getNucleusContext().getPersistenceConfiguration().getInternalNameForProperty(name);
            return this.properties.getProperty(intName.toLowerCase(Locale.ENGLISH));
        }
        return null;
    }

    @Override
    public Set<String> getSupportedProperties() {
        return this.properties.getPropertyNames();
    }

    @Override
    public Integer getDatastoreReadTimeoutMillis() {
        return this.properties.getIntProperty("datanucleus.datastoreReadTimeout".toLowerCase(Locale.ENGLISH));
    }

    @Override
    public Integer getDatastoreWriteTimeoutMillis() {
        return this.properties.getIntProperty("datanucleus.datastoreWriteTimeout".toLowerCase(Locale.ENGLISH));
    }

    @Override
    public boolean getMultithreaded() {
        return false;
    }

    protected boolean getDetachOnClose() {
        return this.properties.getBooleanProperty("datanucleus.DetachOnClose".toLowerCase(Locale.ENGLISH));
    }

    protected boolean getDetachAllOnCommit() {
        return this.properties.getBooleanProperty("datanucleus.DetachAllOnCommit".toLowerCase(Locale.ENGLISH));
    }

    protected boolean getDetachAllOnRollback() {
        return this.properties.getBooleanProperty("datanucleus.DetachAllOnRollback".toLowerCase(Locale.ENGLISH));
    }

    protected boolean getReachabilityAtCommit() {
        return this.properties.getBooleanProperty("datanucleus.persistenceByReachabilityAtCommit".toLowerCase(Locale.ENGLISH));
    }

    public boolean getCopyOnAttach() {
        return this.properties.getBooleanProperty("datanucleus.CopyOnAttach".toLowerCase(Locale.ENGLISH));
    }

    @Override
    public boolean getIgnoreCache() {
        return this.properties.getBooleanProperty("datanucleus.IgnoreCache".toLowerCase(Locale.ENGLISH));
    }

    @Override
    public boolean isDelayDatastoreOperationsEnabled() {
        if (this.isFlushing() || this.tx.isCommitting()) {
            return false;
        }
        String flushModeString = (String)this.getProperty("datanucleus.flush.mode");
        if (flushModeString != null) {
            return !flushModeString.equalsIgnoreCase("AUTO");
        }
        if (this.tx.isActive()) {
            return this.tx.getOptimistic();
        }
        return !this.isNonTxAtomic();
    }

    @Override
    public boolean isInserting(Object pc) {
        ObjectProvider op = this.findObjectProvider(pc);
        if (op == null) {
            return false;
        }
        return op.isInserting();
    }

    @Override
    public Transaction getTransaction() {
        this.assertIsOpen();
        return this.tx;
    }

    @Override
    public void enlistInTransaction(ObjectProvider op) {
        this.assertActiveTransaction();
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015017", (Object)StringUtils.toJVMIDString(op.getObject()), (Object)op.getInternalObjectId().toString()));
        }
        if (this.getReachabilityAtCommit() && this.tx.isActive()) {
            if (this.getApiAdapter().isNew(op.getObject())) {
                this.txFlushedNewIds.add(op.getInternalObjectId());
            } else if (this.getApiAdapter().isPersistent(op.getObject()) && !this.getApiAdapter().isDeleted(op.getObject()) && !this.txFlushedNewIds.contains(op.getInternalObjectId())) {
                this.txKnownPersistedIds.add(op.getInternalObjectId());
            }
            if (!this.runningPBRAtCommit) {
                this.txEnlistedIds.add(op.getInternalObjectId());
            }
        }
        this.enlistedOPCache.put(op.getInternalObjectId(), op);
    }

    @Override
    public void evictFromTransaction(ObjectProvider op) {
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015019", (Object)StringUtils.toJVMIDString(op.getObject()), (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), op.getInternalObjectId())));
        }
        if (this.enlistedOPCache.remove(op.getInternalObjectId()) == null && NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("010023", (Object)StringUtils.toJVMIDString(op.getObject()), (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), op.getInternalObjectId())));
        }
    }

    @Override
    public boolean isEnlistedInTransaction(Object id) {
        if (!this.getReachabilityAtCommit() || !this.tx.isActive()) {
            return false;
        }
        if (id == null) {
            return false;
        }
        return this.txEnlistedIds.contains(id);
    }

    @Override
    public Object getAttachedObjectForId(Object id) {
        ObjectProvider op = this.enlistedOPCache.get(id);
        if (op != null) {
            return op.getObject();
        }
        if (this.cache != null && (op = (ObjectProvider)this.cache.get(id)) != null) {
            return op.getObject();
        }
        return null;
    }

    @Override
    public void addObjectProvider(ObjectProvider op) {
        this.putObjectIntoLevel1Cache(op);
    }

    @Override
    public void removeObjectProvider(ObjectProvider op) {
        this.removeObjectFromLevel1Cache(op.getInternalObjectId());
        this.enlistedOPCache.remove(op.getInternalObjectId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectProvider findObjectProvider(Object pc) {
        ObjectProvider op = null;
        Object previousLookingFor = this.objectLookingForOP;
        ObjectProvider previousFound = this.foundOP;
        try {
            this.objectLookingForOP = pc;
            this.foundOP = null;
            ExecutionContext ec = this.getApiAdapter().getExecutionContext(pc);
            if (ec != null && this != ec) {
                throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(pc)));
            }
            op = this.foundOP;
            Object var7_6 = null;
            this.objectLookingForOP = previousLookingFor;
            this.foundOP = previousFound;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.objectLookingForOP = previousLookingFor;
            this.foundOP = previousFound;
            throw throwable;
        }
        return op;
    }

    @Override
    public ObjectProvider findObjectProvider(Object pc, boolean persist) {
        ObjectProvider op = this.findObjectProvider(pc);
        if (op == null && persist) {
            int objectType = 0;
            Object object2 = this.persistObjectInternal(pc, null, null, -1, objectType);
            op = this.findObjectProvider(object2);
        } else if (op == null) {
            return null;
        }
        return op;
    }

    @Override
    public ObjectProvider findObjectProviderForEmbedded(Object value, ObjectProvider owner, AbstractMemberMetaData mmd) {
        ObjectProvider embeddedSM = this.findObjectProvider(value);
        if (embeddedSM == null) {
            embeddedSM = this.newObjectProviderForEmbedded(value, false, owner, owner.getClassMetaData().getMetaDataForMember(mmd.getName()).getAbsoluteFieldNumber());
        }
        if (embeddedSM.getEmbeddedOwners() == null || embeddedSM.getEmbeddedOwners().length == 0) {
            int absoluteFieldNumber = owner.getClassMetaData().getMetaDataForMember(mmd.getName()).getAbsoluteFieldNumber();
            embeddedSM.addEmbeddedOwner(owner, absoluteFieldNumber);
            embeddedSM.setPcObjectType((short)1);
        }
        return embeddedSM;
    }

    @Override
    public ObjectProvider newObjectProviderForHollow(Class pcClass, Object id) {
        return this.smFactory.newForHollow(this, pcClass, id);
    }

    @Override
    public ObjectProvider newObjectProviderForHollowPreConstructed(Object id, Object pc) {
        return this.smFactory.newForHollowPreConstructed(this, id, pc);
    }

    @Override
    public ObjectProvider newObjectProviderForHollowPopulated(Class pcClass, Object id, FieldValues fv) {
        return this.smFactory.newForHollow(this, pcClass, id, fv);
    }

    @Override
    public ObjectProvider newObjectProviderForPersistentClean(Object id, Object pc) {
        return this.smFactory.newForPersistentClean(this, id, pc);
    }

    @Override
    public ObjectProvider newObjectProviderForHollowPopulatedAppId(Class pcClass, FieldValues fv) {
        return this.smFactory.newForHollowPopulatedAppId(this, pcClass, fv);
    }

    @Override
    public ObjectProvider newObjectProviderForEmbedded(Object pc, boolean copyPc, ObjectProvider ownerOP, int ownerFieldNumber) {
        return this.smFactory.newForEmbedded(this, pc, copyPc, ownerOP, ownerFieldNumber);
    }

    @Override
    public ObjectProvider newObjectProviderForEmbedded(AbstractClassMetaData cmd, ObjectProvider ownerOP, int ownerFieldNumber) {
        return this.smFactory.newForEmbedded(this, cmd, ownerOP, ownerFieldNumber);
    }

    @Override
    public ObjectProvider newObjectProviderForPersistentNew(Object pc, FieldValues preInsertChanges) {
        return this.smFactory.newForPersistentNew(this, pc, preInsertChanges);
    }

    @Override
    public ObjectProvider newObjectProviderForTransactionalTransient(Object pc) {
        return this.smFactory.newForTransactionalTransient(this, pc);
    }

    @Override
    public ObjectProvider newObjectProviderForDetached(Object pc, Object id, Object version) {
        return this.smFactory.newForDetached(this, pc, id, version);
    }

    @Override
    public ObjectProvider newObjectProviderForPNewToBeDeleted(Object pc) {
        return this.smFactory.newForPNewToBeDeleted(this, pc);
    }

    protected ObjectProvider newObjectProviderForCachedPC(Object id, CachedPC cachedPC) {
        return this.smFactory.newForCachedPC(this, id, cachedPC);
    }

    @Override
    public void hereIsObjectProvider(ObjectProvider op, Object pc) {
        if (this.objectLookingForOP == pc) {
            this.foundOP = op;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            throw new NucleusUserException(LOCALISER.msg("010002"));
        }
        if (this.tx.isActive()) {
            throw new TransactionActiveOnCloseException(this);
        }
        if (!this.dirtyOPs.isEmpty() && this.tx.getNontransactionalWrite()) {
            if (this.isNonTxAtomic()) {
                this.processNontransactionalUpdate();
            } else {
                try {
                    this.tx.begin();
                    this.tx.commit();
                    Object var2_1 = null;
                    if (this.tx.isActive()) {
                        this.tx.rollback();
                    }
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    if (this.tx.isActive()) {
                        this.tx.rollback();
                    }
                    throw throwable;
                }
            }
        }
        if (this.getDetachOnClose()) {
            this.performDetachOnClose();
        }
        ExecutionContext.LifecycleListener[] listener = this.nucCtx.getExecutionContextListeners();
        for (int i = 0; i < listener.length; ++i) {
            listener[i].preClose(this);
        }
        this.disconnectObjectProvidersFromCache();
        this.disconnectLifecycleListener();
        this.fetchPlan.clearGroups().addGroup("default");
        if (this.statistics != null) {
            if (this.nucCtx.getJMXManager() != null) {
                this.nucCtx.getJMXManager().deregisterMBean(this.statistics.getRegisteredName());
            }
            this.statistics = null;
        }
        this.closed = true;
        this.tx = null;
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010001", this));
        }
    }

    protected void disconnectObjectProvidersFromCache() {
        if (this.cache != null) {
            HashSet cachedOPsClone = new HashSet(this.cache.values());
            for (ObjectProvider op : cachedOPsClone) {
                if (op == null) continue;
                op.disconnect();
            }
            this.cache.clear();
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003011"));
            }
        }
    }

    private boolean isNonTxAtomic() {
        return this.getNucleusContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.nontx.atomic");
    }

    @Override
    public void processNontransactionalUpdate() {
        if (this.tx.isActive() || !this.tx.getNontransactionalWrite() || !this.isNonTxAtomic()) {
            return;
        }
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        if (threadInfo.nontxPersistDelete) {
            return;
        }
        this.processNontransactionalAtomicChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processNontransactionalAtomicChanges() {
        if (this.tx.isActive() || !this.tx.getNontransactionalWrite()) {
            return;
        }
        if (!this.isNonTxAtomic()) {
            return;
        }
        if (!this.dirtyOPs.isEmpty()) {
            for (ObjectProvider op : this.dirtyOPs) {
                this.enlistedOPCache.put(op.getInternalObjectId(), op);
            }
            this.flushInternal(true);
            if (this.nucCtx.hasLevel2Cache()) {
                this.performLevel2CacheUpdateAtCommit();
            }
            if (this.getDetachAllOnCommit()) {
                this.performDetachAllOnTxnEndPreparation();
                this.performDetachAllOnTxnEnd();
            }
            ArrayList<RuntimeException> failures = null;
            try {
                ApiAdapter api = this.getApiAdapter();
                ObjectProvider[] ops = this.enlistedOPCache.values().toArray(new ObjectProvider[this.enlistedOPCache.size()]);
                for (int i = 0; i < ops.length; ++i) {
                    try {
                        if (ops[i] != null && ops[i].getObject() != null && api.isPersistent(ops[i].getObject()) && api.isDirty(ops[i].getObject())) {
                            ops[i].postCommit(this.getTransaction());
                            continue;
                        }
                        NucleusLogger.PERSISTENCE.debug(">> Atomic nontransactional processing : Not performing postCommit on " + ops[i]);
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (failures == null) {
                            failures = new ArrayList<RuntimeException>();
                        }
                        failures.add(e);
                    }
                }
                Object var7_6 = null;
                this.resetTransactionalVariables();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.resetTransactionalVariables();
                throw throwable;
            }
            if (failures != null && !failures.isEmpty()) {
                throw new CommitStateTransitionException(failures.toArray(new Exception[failures.size()]));
            }
        }
        if (this.nontxProcessedOPs != null && !this.nontxProcessedOPs.isEmpty()) {
            for (ObjectProvider op : this.nontxProcessedOPs) {
                if (op == null || op.getLifecycleState() == null || !op.getLifecycleState().isDeleted()) continue;
                this.removeObjectFromLevel1Cache(op.getInternalObjectId());
                this.removeObjectFromLevel2Cache(op.getInternalObjectId());
            }
            this.nontxProcessedOPs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evictObject(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            ObjectProvider op = this.findObjectProvider(obj);
            if (op == null) {
                throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(obj)));
            }
            op.evict();
            Object var4_3 = null;
            this.clr.unsetPrimary();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evictObjects(Class cls, boolean subclasses) {
        if (this.cache != null) {
            try {
                if (this.getMultithreaded()) {
                    this.lock.lock();
                }
                ArrayList opsToEvict = new ArrayList();
                opsToEvict.addAll(this.cache.values());
                for (ObjectProvider op : opsToEvict) {
                    Object pc = op.getObject();
                    boolean evict = false;
                    if (!subclasses && pc.getClass() == cls) {
                        evict = true;
                    } else if (subclasses && cls.isAssignableFrom(pc.getClass())) {
                        evict = true;
                    }
                    if (!evict) continue;
                    op.evict();
                    this.removeObjectFromLevel1Cache(this.getApiAdapter().getIdForObject(pc));
                }
                Object var9_8 = null;
                if (this.getMultithreaded()) {
                    this.lock.unlock();
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (this.getMultithreaded()) {
                    this.lock.unlock();
                }
                throw throwable;
            }
        }
    }

    @Override
    public void evictAllObjects() {
        if (this.cache != null) {
            ArrayList opsToEvict = new ArrayList();
            opsToEvict.addAll(this.cache.values());
            for (ObjectProvider op : opsToEvict) {
                Object pc = op.getObject();
                op.evict();
                this.removeObjectFromLevel1Cache(this.getApiAdapter().getIdForObject(pc));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshObject(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            ObjectProvider op = this.findObjectProvider(obj);
            if (op == null) {
                throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(obj)));
            }
            if (this.getApiAdapter().isPersistent(obj) && op.isWaitingToBeFlushedToDatastore()) {
                Object var4_3 = null;
                this.clr.unsetPrimary();
                return;
            }
            op.refresh();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
        Object var4_4 = null;
        this.clr.unsetPrimary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshAllObjects() {
        HashSet<ObjectProvider> toRefresh = new HashSet<ObjectProvider>();
        toRefresh.addAll(this.enlistedOPCache.values());
        toRefresh.addAll(this.dirtyOPs);
        toRefresh.addAll(this.indirectDirtyOPs);
        if (!this.tx.isActive() && this.cache != null) {
            toRefresh.addAll(this.cache.values());
        }
        try {
            if (this.getMultithreaded()) {
                this.lock.lock();
            }
            ArrayList<RuntimeException> failures = null;
            for (ObjectProvider op : toRefresh) {
                try {
                    op.refresh();
                }
                catch (RuntimeException e) {
                    if (failures == null) {
                        failures = new ArrayList<RuntimeException>();
                    }
                    failures.add(e);
                }
            }
            if (failures != null && !failures.isEmpty()) {
                throw new NucleusUserException(LOCALISER.msg("010037"), failures.toArray(new Exception[failures.size()]));
            }
            Object var7_6 = null;
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retrieveObject(Object obj, boolean fgOnly) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            ObjectProvider op = this.findObjectProvider(obj);
            if (op == null) {
                throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(obj)));
            }
            op.retrieve(fgOnly);
            Object var5_4 = null;
            this.clr.unsetPrimary();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object persistObject(Object obj, boolean merging) {
        Object object;
        block13: {
            if (obj == null) {
                return null;
            }
            ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
            try {
                if (merging && this.nucCtx.getPersistenceConfiguration().getBooleanProperty("datanucleus.allowAttachOfTransient", false)) {
                    threadInfo.merging = true;
                }
                if (threadInfo.attachedOwnerByObject == null) {
                    threadInfo.attachedOwnerByObject = new HashMap<Object, ObjectProvider>();
                }
                if (threadInfo.attachedPCById == null) {
                    threadInfo.attachedPCById = new HashMap();
                }
                if (this.tx.isActive()) {
                    Object object2 = this.persistObjectWork(obj);
                    Object var12_6 = null;
                    this.releaseThreadContextInfo();
                    return object2;
                }
                threadInfo.nontxPersistDelete = true;
                boolean success = true;
                HashSet cachedIds = this.cache != null ? new HashSet(this.cache.keySet()) : null;
                try {
                    object = this.persistObjectWork(obj);
                    Object var10_12 = null;
                }
                catch (RuntimeException re) {
                    try {
                        success = false;
                        if (this.cache == null) throw re;
                        Iterator cacheIter = this.cache.keySet().iterator();
                        while (cacheIter.hasNext()) {
                            Object id = cacheIter.next();
                            if (cachedIds.contains(id)) continue;
                            cacheIter.remove();
                        }
                        throw re;
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        threadInfo.nontxPersistDelete = false;
                        if (!success) throw throwable;
                        this.processNontransactionalAtomicChanges();
                        throw throwable;
                    }
                }
                threadInfo.nontxPersistDelete = false;
                if (!success) break block13;
                this.processNontransactionalAtomicChanges();
            }
            catch (Throwable throwable) {
                Object var12_8 = null;
                this.releaseThreadContextInfo();
                throw throwable;
            }
        }
        Object var12_7 = null;
        this.releaseThreadContextInfo();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] persistObjects(Object[] objs) {
        if (objs == null) {
            return null;
        }
        Object[] persistedObjs = new Object[objs.length];
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        try {
            if (threadInfo.attachedOwnerByObject == null) {
                threadInfo.attachedOwnerByObject = new HashMap<Object, ObjectProvider>();
            }
            if (threadInfo.attachedPCById == null) {
                threadInfo.attachedPCById = new HashMap();
            }
            if (!this.tx.isActive()) {
                threadInfo.nontxPersistDelete = true;
            }
            try {
                this.getStoreManager().getPersistenceHandler().batchStart(this, PersistenceBatchType.PERSIST);
                ArrayList<RuntimeException> failures = null;
                for (int i = 0; i < objs.length; ++i) {
                    try {
                        if (objs[i] == null) continue;
                        persistedObjs[i] = this.persistObjectWork(objs[i]);
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (failures == null) {
                            failures = new ArrayList<RuntimeException>();
                        }
                        failures.add(e);
                    }
                }
                if (failures != null && !failures.isEmpty()) {
                    RuntimeException e = (RuntimeException)failures.get(0);
                    if (e instanceof NucleusException && ((NucleusException)e).isFatal()) {
                        throw new NucleusFatalUserException(LOCALISER.msg("010039"), failures.toArray(new Exception[failures.size()]));
                    }
                    throw new NucleusUserException(LOCALISER.msg("010039"), failures.toArray(new Exception[failures.size()]));
                }
                Object var8_8 = null;
                this.getStoreManager().getPersistenceHandler().batchEnd(this, PersistenceBatchType.PERSIST);
                if (!this.tx.isActive()) {
                    threadInfo.nontxPersistDelete = false;
                    this.processNontransactionalAtomicChanges();
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.getStoreManager().getPersistenceHandler().batchEnd(this, PersistenceBatchType.PERSIST);
                if (!this.tx.isActive()) {
                    threadInfo.nontxPersistDelete = false;
                    this.processNontransactionalAtomicChanges();
                }
                throw throwable;
            }
            Object var10_11 = null;
            this.releaseThreadContextInfo();
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.releaseThreadContextInfo();
            throw throwable;
        }
        return persistedObjs;
    }

    private Object persistObjectWork(Object obj) {
        boolean detached = this.getApiAdapter().isDetached(obj);
        Object persistedPc = this.persistObjectInternal(obj, null, null, -1, 0);
        ObjectProvider op = this.findObjectProvider(persistedPc);
        if (op != null) {
            if (this.indirectDirtyOPs.contains(op)) {
                this.dirtyOPs.add(op);
                this.indirectDirtyOPs.remove(op);
            } else if (!this.dirtyOPs.contains(op)) {
                this.dirtyOPs.add(op);
                if (this.txCachedIds != null) {
                    this.txCachedIds.add(op.getInternalObjectId());
                }
            }
            if (this.getReachabilityAtCommit() && this.tx.isActive() && (detached || this.getApiAdapter().isNew(persistedPc))) {
                this.txKnownPersistedIds.add(op.getInternalObjectId());
            }
        }
        return persistedPc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object persistObjectInternal(Object obj, FieldValues preInsertChanges, ObjectProvider ownerOP, int ownerFieldNum, int objectType) {
        if (obj == null) {
            return null;
        }
        ApiAdapter api = this.getApiAdapter();
        Object id = null;
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            ExecutionContext ec = api.getExecutionContext(obj);
            if (ec != null && ec != this) {
                throw new NucleusUserException(LOCALISER.msg("010007", obj));
            }
            Object persistedPc = obj;
            if (api.isDetached(obj)) {
                this.assertDetachable(obj);
                if (this.getCopyOnAttach()) {
                    persistedPc = this.attachObjectCopy(ownerOP, obj, api.getIdForObject(obj) == null);
                } else {
                    this.attachObject(ownerOP, obj, api.getIdForObject(obj) == null);
                    persistedPc = obj;
                }
            } else if (api.isTransactional(obj) && !api.isPersistent(obj)) {
                ObjectProvider op;
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010015", (Object)StringUtils.toJVMIDString(obj)));
                }
                if ((op = this.findObjectProvider(obj)) == null) {
                    throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(obj)));
                }
                op.makePersistentTransactionalTransient();
            } else if (!api.isPersistent(obj)) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010015", (Object)StringUtils.toJVMIDString(obj)));
                }
                boolean merged = false;
                ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
                try {
                    block35: {
                        try {
                            AbstractClassMetaData cmd;
                            if (!threadInfo.merging || (cmd = this.getMetaDataManager().getMetaDataForClass(obj.getClass(), this.clr)).getIdentityType() != IdentityType.APPLICATION) break block35;
                            Object transientId = api.getNewApplicationIdentityObjectId(obj, cmd);
                            Object existingObj = this.findObject(transientId, true, true, cmd.getFullClassName());
                            ObjectProvider existingOP = this.findObjectProvider(existingObj);
                            existingOP.attach(obj);
                            id = transientId;
                            merged = true;
                            persistedPc = existingObj;
                        }
                        catch (NucleusObjectNotFoundException onfe) {
                            Object var17_22 = null;
                            this.releaseThreadContextInfo();
                        }
                    }
                    Object var17_21 = null;
                    this.releaseThreadContextInfo();
                }
                catch (Throwable throwable) {
                    Object var17_23 = null;
                    this.releaseThreadContextInfo();
                    throw throwable;
                }
                if (!merged) {
                    ObjectProvider op = this.findObjectProvider(obj);
                    if (op == null) {
                        if ((objectType == 2 || objectType == 3 || objectType == 4 || objectType == 1) && ownerOP != null) {
                            op = this.newObjectProviderForEmbedded(obj, false, ownerOP, ownerFieldNum);
                            op.setPcObjectType((short)objectType);
                            op.makePersistent();
                            id = op.getInternalObjectId();
                        } else {
                            op = this.newObjectProviderForPersistentNew(obj, preInsertChanges);
                            op.makePersistent();
                            id = op.getInternalObjectId();
                        }
                    } else if (op.getReferencedPC() == null) {
                        op.makePersistent();
                        id = op.getInternalObjectId();
                    } else {
                        persistedPc = op.getReferencedPC();
                    }
                }
            } else if (api.isPersistent(obj) && api.getIdForObject(obj) == null) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010015", (Object)StringUtils.toJVMIDString(obj)));
                }
                ObjectProvider op = this.findObjectProvider(obj);
                op.makePersistent();
                id = op.getInternalObjectId();
            } else if (api.isDeleted(obj)) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010015", (Object)StringUtils.toJVMIDString(obj)));
                }
                ObjectProvider op = this.findObjectProvider(obj);
                op.makePersistent();
                id = op.getInternalObjectId();
            } else if (api.isPersistent(obj) && api.isTransactional(obj) && api.isDirty(obj) && this.isDelayDatastoreOperationsEnabled()) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010015", (Object)StringUtils.toJVMIDString(obj)));
                }
                ObjectProvider op = this.findObjectProvider(obj);
                op.makePersistent();
                id = op.getInternalObjectId();
            }
            if (id != null && this.txCachedIds != null) {
                this.txCachedIds.add(id);
            }
            Object object = persistedPc;
            Object var19_25 = null;
            this.clr.unsetPrimary();
            return object;
        }
        catch (Throwable throwable) {
            Object var19_26 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    @Override
    public Object persistObjectInternal(Object pc, ObjectProvider ownerOP, int ownerFieldNum, int objectType) {
        if (ownerOP != null) {
            ObjectProvider op = this.findObjectProvider(ownerOP.getObject());
            return this.persistObjectInternal(pc, null, op, ownerFieldNum, objectType);
        }
        return this.persistObjectInternal(pc, null, null, ownerFieldNum, objectType);
    }

    @Override
    public Object persistObjectInternal(Object pc, FieldValues preInsertChanges, int objectType) {
        return this.persistObjectInternal(pc, preInsertChanges, null, -1, objectType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObjects(Object[] objs) {
        if (objs == null) {
            return;
        }
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        try {
            if (!this.tx.isActive()) {
                threadInfo.nontxPersistDelete = true;
            }
            this.getStoreManager().getPersistenceHandler().batchStart(this, PersistenceBatchType.DELETE);
            ArrayList<RuntimeException> failures = null;
            for (int i = 0; i < objs.length; ++i) {
                try {
                    if (objs[i] == null) continue;
                    this.deleteObjectWork(objs[i]);
                    continue;
                }
                catch (RuntimeException e) {
                    if (failures == null) {
                        failures = new ArrayList<RuntimeException>();
                    }
                    failures.add(e);
                }
            }
            if (failures != null && !failures.isEmpty()) {
                RuntimeException e = (RuntimeException)failures.get(0);
                if (e instanceof NucleusException && ((NucleusException)e).isFatal()) {
                    throw new NucleusFatalUserException(LOCALISER.msg("010040"), failures.toArray(new Exception[failures.size()]));
                }
                throw new NucleusUserException(LOCALISER.msg("010040"), failures.toArray(new Exception[failures.size()]));
            }
            Object var7_7 = null;
            this.getStoreManager().getPersistenceHandler().batchEnd(this, PersistenceBatchType.DELETE);
            if (!this.tx.isActive()) {
                threadInfo.nontxPersistDelete = false;
                this.processNontransactionalAtomicChanges();
            }
            this.releaseThreadContextInfo();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.getStoreManager().getPersistenceHandler().batchEnd(this, PersistenceBatchType.DELETE);
            if (!this.tx.isActive()) {
                threadInfo.nontxPersistDelete = false;
                this.processNontransactionalAtomicChanges();
            }
            this.releaseThreadContextInfo();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObject(Object obj) {
        if (obj == null) {
            return;
        }
        ThreadContextInfo threadInfo = this.acquireThreadContextInfo();
        try {
            if (!this.tx.isActive()) {
                threadInfo.nontxPersistDelete = true;
            }
            this.deleteObjectWork(obj);
            Object var4_3 = null;
            if (!this.tx.isActive()) {
                threadInfo.nontxPersistDelete = false;
                this.processNontransactionalAtomicChanges();
            }
            this.releaseThreadContextInfo();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!this.tx.isActive()) {
                threadInfo.nontxPersistDelete = false;
                this.processNontransactionalAtomicChanges();
            }
            this.releaseThreadContextInfo();
            throw throwable;
        }
    }

    void deleteObjectWork(Object obj) {
        ObjectProvider op = this.findObjectProvider(obj);
        if (op == null && this.getApiAdapter().isDetached(obj)) {
            Object attachedObj = this.findObject(this.getApiAdapter().getIdForObject(obj), true, false, obj.getClass().getName());
            op = this.findObjectProvider(attachedObj);
        }
        if (op != null) {
            if (this.indirectDirtyOPs.contains(op)) {
                this.indirectDirtyOPs.remove(op);
                this.dirtyOPs.add(op);
            } else if (!this.dirtyOPs.contains(op)) {
                this.dirtyOPs.add(op);
                if (this.txCachedIds != null) {
                    this.txCachedIds.add(op.getInternalObjectId());
                }
            }
        }
        this.deleteObjectInternal(obj);
        if (this.getReachabilityAtCommit() && this.tx.isActive() && op != null && this.getApiAdapter().isDeleted(obj)) {
            this.txKnownDeletedIds.add(op.getInternalObjectId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObjectInternal(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            ObjectProvider op;
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            Object pc = obj;
            if (this.getApiAdapter().isDetached(obj)) {
                pc = this.findObject(this.getApiAdapter().getIdForObject(obj), true, true, null);
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010019", (Object)StringUtils.toJVMIDString(pc)));
            }
            if (this.getApiAdapter().getName().equals("JDO")) {
                if (!this.getApiAdapter().isPersistent(pc) && !this.getApiAdapter().isTransactional(pc)) {
                    throw new NucleusUserException(LOCALISER.msg("010020"));
                }
                if (!this.getApiAdapter().isPersistent(pc) && this.getApiAdapter().isTransactional(pc)) {
                    throw new NucleusUserException(LOCALISER.msg("010021", this.getApiAdapter().getIdForObject(obj)));
                }
            }
            if ((op = this.findObjectProvider(pc)) == null) {
                if (!this.getApiAdapter().allowDeleteOfNonPersistentObject()) {
                    throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(pc)));
                }
                op = this.newObjectProviderForPNewToBeDeleted(pc);
            }
            if (this.txCachedIds != null) {
                this.txCachedIds.add(op.getInternalObjectId());
            }
            op.deletePersistent();
            Object var5_4 = null;
            this.clr.unsetPrimary();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeObjectTransient(Object obj, FetchPlanState state) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010022", (Object)StringUtils.toJVMIDString(obj)));
            }
            if (this.getApiAdapter().isPersistent(obj)) {
                ObjectProvider op = this.findObjectProvider(obj);
                op.makeTransient(state);
            }
            Object var5_4 = null;
            this.clr.unsetPrimary();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeObjectTransactional(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            ObjectProvider op;
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            this.assertNotDetached(obj);
            if (this.getApiAdapter().isPersistent(obj)) {
                this.assertActiveTransaction();
            }
            if ((op = this.findObjectProvider(obj)) == null) {
                op = this.newObjectProviderForTransactionalTransient(obj);
            }
            op.makeTransactional();
            Object var4_3 = null;
            this.clr.unsetPrimary();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeObjectNontransactional(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            this.clr.setPrimary(obj.getClass().getClassLoader());
            this.assertClassPersistable(obj.getClass());
            if (!this.getApiAdapter().isPersistent(obj) && this.getApiAdapter().isTransactional(obj) && this.getApiAdapter().isDirty(obj)) {
                throw new NucleusUserException(LOCALISER.msg("010024"));
            }
            ObjectProvider op = this.findObjectProvider(obj);
            op.makeNontransactional();
            Object var4_3 = null;
            this.clr.unsetPrimary();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    @Override
    public void attachObject(ObjectProvider ownerOP, Object pc, boolean sco) {
        ApiAdapter api;
        Object id;
        this.assertClassPersistable(pc.getClass());
        Map<Object, ObjectProvider> attachedOwnerByObject = this.getThreadContextInfo().attachedOwnerByObject;
        if (attachedOwnerByObject != null) {
            attachedOwnerByObject.put(pc, ownerOP);
        }
        if ((id = (api = this.getApiAdapter()).getIdForObject(pc)) != null && this.isInserting(pc)) {
            return;
        }
        if (id == null && !sco) {
            this.persistObjectInternal(pc, null, null, -1, 0);
            return;
        }
        if (api.isDetached(pc)) {
            ObjectProvider l1CachedOP;
            if (this.cache != null && (l1CachedOP = (ObjectProvider)this.cache.get(id)) != null && l1CachedOP.getObject() != pc) {
                throw new NucleusUserException(LOCALISER.msg("010017", (Object)StringUtils.toJVMIDString(pc)));
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010016", (Object)StringUtils.toJVMIDString(pc)));
            }
        } else {
            return;
        }
        ObjectProvider op = this.newObjectProviderForDetached(pc, id, api.getVersionForObject(pc));
        op.attach(sco);
    }

    @Override
    public Object attachObjectCopy(ObjectProvider ownerOP, Object pc, boolean sco) {
        ApiAdapter api;
        Object id;
        this.assertClassPersistable(pc.getClass());
        this.assertDetachable(pc);
        Map<Object, ObjectProvider> attachedOwnerByObject = this.getThreadContextInfo().attachedOwnerByObject;
        if (attachedOwnerByObject != null) {
            attachedOwnerByObject.put(pc, ownerOP);
        }
        if ((id = (api = this.getApiAdapter()).getIdForObject(pc)) != null && this.isInserting(pc)) {
            return pc;
        }
        if (id == null && !sco) {
            return this.persistObjectInternal(pc, null, null, -1, 0);
        }
        if (api.isPersistent(pc)) {
            return pc;
        }
        Object pcTarget = null;
        if (sco) {
            boolean detached = this.getApiAdapter().isDetached(pc);
            ObjectProvider targetOP = this.newObjectProviderForEmbedded(pc, true, null, -1);
            pcTarget = targetOP.getObject();
            if (detached) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010018", (Object)StringUtils.toJVMIDString(pc), (Object)StringUtils.toJVMIDString(pcTarget)));
                }
                targetOP.attachCopy(pc, sco);
            }
        } else {
            boolean detached = this.getApiAdapter().isDetached(pc);
            pcTarget = this.findObject(id, false, false, pc.getClass().getName());
            if (detached) {
                Object obj = null;
                Map attachedPCById = this.getThreadContextInfo().attachedPCById;
                if (attachedPCById != null) {
                    obj = attachedPCById.get(this.getApiAdapter().getIdForObject(pc));
                }
                if (obj != null) {
                    pcTarget = obj;
                } else {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010018", (Object)StringUtils.toJVMIDString(pc), (Object)StringUtils.toJVMIDString(pcTarget)));
                    }
                    pcTarget = this.findObjectProvider(pcTarget).attachCopy(pc, sco);
                    if (attachedPCById != null) {
                        attachedPCById.put(this.getApiAdapter().getIdForObject(pc), pcTarget);
                    }
                }
            }
        }
        return pcTarget;
    }

    @Override
    public void detachObject(Object obj, FetchPlanState state) {
        ObjectProvider op;
        if (this.getApiAdapter().isDetached(obj)) {
            return;
        }
        if (!this.getApiAdapter().isPersistent(obj) && this.tx.isActive()) {
            this.persistObjectInternal(obj, null, null, -1, 0);
        }
        if ((op = this.findObjectProvider(obj)) == null) {
            throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(obj)));
        }
        op.detach(state);
        if (this.dirtyOPs.contains(op) || this.indirectDirtyOPs.contains(op)) {
            NucleusLogger.GENERAL.info(LOCALISER.msg("010047", (Object)StringUtils.toJVMIDString(obj)));
            this.clearDirty(op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object detachObjectCopy(Object pc, FetchPlanState state) {
        Object thePC = pc;
        try {
            ObjectProvider op;
            this.clr.setPrimary(pc.getClass().getClassLoader());
            if (!this.getApiAdapter().isPersistent(pc) && !this.getApiAdapter().isDetached(pc)) {
                if (this.tx.isActive()) {
                    thePC = this.persistObjectInternal(pc, null, null, -1, 0);
                } else {
                    throw new NucleusUserException(LOCALISER.msg("010014"));
                }
            }
            if (this.getApiAdapter().isDetached(thePC)) {
                thePC = this.findObject(this.getApiAdapter().getIdForObject(thePC), false, true, null);
            }
            if ((op = this.findObjectProvider(thePC)) == null) {
                throw new NucleusUserException(LOCALISER.msg("010007", this.getApiAdapter().getIdForObject(thePC)));
            }
            Object object = op.detachCopy(state);
            Object var7_6 = null;
            this.clr.unsetPrimary();
            return object;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    @Override
    public void detachAll() {
        HashSet<ObjectProvider> opsToDetach = new HashSet<ObjectProvider>();
        opsToDetach.addAll(this.enlistedOPCache.values());
        if (this.cache != null) {
            opsToDetach.addAll(this.cache.values());
        }
        FetchPlanState fps = new FetchPlanState();
        Iterator iter = opsToDetach.iterator();
        while (iter.hasNext()) {
            ((ObjectProvider)iter.next()).detach(fps);
        }
    }

    @Override
    public Object newInstance(Class cls) {
        if (this.getApiAdapter().isPersistable(cls) && !Modifier.isAbstract(cls.getModifiers())) {
            try {
                return cls.newInstance();
            }
            catch (IllegalAccessException iae) {
                throw new NucleusUserException(iae.toString(), iae);
            }
            catch (InstantiationException ie) {
                throw new NucleusUserException(ie.toString(), ie);
            }
        }
        this.assertHasImplementationCreator();
        return this.getNucleusContext().getImplementationCreator().newInstance(cls, this.clr);
    }

    @Override
    public boolean exists(Object obj) {
        if (obj == null) {
            return false;
        }
        Object id = this.getApiAdapter().getIdForObject(obj);
        if (id == null) {
            return false;
        }
        try {
            this.findObject(id, true, false, obj.getClass().getName());
        }
        catch (NucleusObjectNotFoundException onfe) {
            return false;
        }
        return true;
    }

    @Override
    public Set getManagedObjects() {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet<Object> objs = new HashSet<Object>();
        for (ObjectProvider op : this.enlistedOPCache.values()) {
            objs.add(op.getObject());
        }
        return objs;
    }

    @Override
    public Set getManagedObjects(Class[] classes) {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet<Object> objs = new HashSet<Object>();
        block0: for (ObjectProvider op : this.enlistedOPCache.values()) {
            for (int i = 0; i < classes.length; ++i) {
                if (classes[i] != op.getObject().getClass()) continue;
                objs.add(op.getObject());
                continue block0;
            }
        }
        return objs;
    }

    @Override
    public Set getManagedObjects(String[] states) {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet<Object> objs = new HashSet<Object>();
        block0: for (ObjectProvider op : this.enlistedOPCache.values()) {
            for (int i = 0; i < states.length; ++i) {
                if (!this.getApiAdapter().getObjectState(op.getObject()).equals(states[i])) continue;
                objs.add(op.getObject());
                continue block0;
            }
        }
        return objs;
    }

    @Override
    public Set getManagedObjects(String[] states, Class[] classes) {
        if (!this.tx.isActive()) {
            return null;
        }
        HashSet<Object> objs = new HashSet<Object>();
        block0: for (ObjectProvider op : this.enlistedOPCache.values()) {
            boolean matches = false;
            for (int i = 0; i < states.length; ++i) {
                if (this.getApiAdapter().getObjectState(op.getObject()).equals(states[i])) {
                    int j = 0;
                    while (i < classes.length) {
                        if (classes[j] == op.getObject().getClass()) {
                            matches = true;
                            objs.add(op.getObject());
                            break;
                        }
                        ++i;
                    }
                }
                if (matches) continue block0;
            }
        }
        return objs;
    }

    @Override
    public Object findObject(Object id, FieldValues fv, Class cls, boolean ignoreCache, boolean checkInheritance) {
        this.assertIsOpen();
        boolean createdHollow = false;
        Object pc = null;
        ObjectProvider op = null;
        if (!ignoreCache) {
            pc = this.getObjectFromCache(id);
        }
        if (pc == null) {
            pc = this.getStoreManager().getPersistenceHandler().findObject(this, id);
        }
        if (pc == null) {
            String className;
            String string = className = cls != null ? cls.getName() : null;
            if (cls == null && (className = this.getStoreManager().getClassNameForObjectID(id, this.clr, this)) == null) {
                throw new NucleusObjectNotFoundException(LOCALISER.msg("010026"), id);
            }
            if (!(id instanceof SCOID)) {
                ClassDetailsForId details = this.getClassDetailsForId(id, className, checkInheritance);
                if (details.className != null && cls != null && !cls.getName().equals(details.className)) {
                    cls = this.clr.classForName(details.className);
                }
                className = details.className;
                id = details.id;
                if (details.pc != null) {
                    pc = details.pc;
                    op = this.findObjectProvider(pc);
                }
            }
            if (pc == null) {
                if (cls == null) {
                    try {
                        cls = this.clr.classForName(className, id.getClass().getClassLoader());
                    }
                    catch (ClassNotResolvedException e) {
                        String msg = LOCALISER.msg("010027", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id));
                        NucleusLogger.PERSISTENCE.warn(msg);
                        throw new NucleusUserException(msg, e);
                    }
                }
                createdHollow = true;
                op = this.newObjectProviderForHollowPopulated(cls, id, fv);
                pc = op.getObject();
                this.putObjectIntoLevel1Cache(op);
                this.putObjectIntoLevel2Cache(op, false);
            }
        }
        if (pc != null && fv != null && !createdHollow) {
            if (op == null) {
                op = this.findObjectProvider(pc);
            }
            if (op != null) {
                fv.fetchNonLoadedFields(op);
            }
        }
        return pc;
    }

    @Override
    public Object[] findObjects(Object[] identities, boolean validate) {
        Map pcsById;
        if (identities == null) {
            return null;
        }
        if (identities.length == 1) {
            return new Object[]{this.findObject(identities[0], validate, validate, null)};
        }
        for (int i = 0; i < identities.length; ++i) {
            if (identities[i] != null) continue;
            throw new NucleusUserException(LOCALISER.msg("010044"));
        }
        Object[] ids = new Object[identities.length];
        for (int i = 0; i < identities.length; ++i) {
            if (this.getNucleusContext().getIdentityStringTranslator() != null && identities[i] instanceof String) {
                IdentityStringTranslator translator = this.getNucleusContext().getIdentityStringTranslator();
                ids[i] = translator.getIdentity(this, (String)identities[i]);
                continue;
            }
            ids[i] = identities[i];
        }
        HashMap<Object, Object> pcById = new HashMap<Object, Object>(identities.length);
        ArrayList<Object> idsToFind = new ArrayList<Object>();
        ApiAdapter api = this.getApiAdapter();
        for (int i = 0; i < ids.length; ++i) {
            Object pc = this.getObjectFromLevel1Cache(ids[i]);
            if (pc != null) {
                if (ids[i] instanceof SCOID && api.isPersistent(pc) && !api.isNew(pc) && !api.isDeleted(pc) && !api.isTransactional(pc)) {
                    throw new NucleusUserException(LOCALISER.msg("010005"));
                }
                pcById.put(ids[i], pc);
                continue;
            }
            idsToFind.add(ids[i]);
        }
        if (!idsToFind.isEmpty() && this.nucCtx.hasLevel2Cache() && !(pcsById = this.getObjectsFromLevel2Cache(idsToFind)).isEmpty()) {
            for (Map.Entry entry : pcsById.entrySet()) {
                pcById.put(entry.getKey(), entry.getValue());
                idsToFind.remove(entry.getKey());
            }
        }
        boolean performValidationWhenCached = this.nucCtx.getPersistenceConfiguration().getBooleanProperty("datanucleus.findObject.validateWhenCached");
        ArrayList<ObjectProvider> opsToValidate = new ArrayList<ObjectProvider>();
        if (validate && performValidationWhenCached) {
            Collection pcValues = pcById.values();
            for (Object pc : pcValues) {
                if (api.isTransactional(pc)) continue;
                ObjectProvider op = this.findObjectProvider(pc);
                opsToValidate.add(op);
            }
        }
        Object[] foundPcs = null;
        if (!idsToFind.isEmpty()) {
            foundPcs = this.getStoreManager().getPersistenceHandler().findObjects(this, idsToFind.toArray());
        }
        int foundPcIdx = 0;
        for (Object id : idsToFind) {
            Object idOrig = id;
            Object pc = foundPcs[foundPcIdx++];
            ObjectProvider op = null;
            if (pc != null) {
                op = this.findObjectProvider(pc);
                this.putObjectIntoLevel1Cache(op);
            } else {
                ClassDetailsForId details = this.getClassDetailsForId(id, null, validate);
                String className = details.className;
                id = details.id;
                if (details.pc != null) {
                    pc = details.pc;
                    op = this.findObjectProvider(pc);
                    if (performValidationWhenCached && validate && !api.isTransactional(pc)) {
                        opsToValidate.add(op);
                    }
                } else {
                    try {
                        Class pcClass = this.clr.classForName(className, id instanceof OID ? null : id.getClass().getClassLoader());
                        if (Modifier.isAbstract(pcClass.getModifiers())) {
                            throw new NucleusObjectNotFoundException(LOCALISER.msg("010027", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id), (Object)className));
                        }
                        op = this.newObjectProviderForHollow(pcClass, id);
                        pc = op.getObject();
                        if (!validate) {
                            op.markForInheritanceValidation();
                        }
                        this.putObjectIntoLevel1Cache(op);
                    }
                    catch (ClassNotResolvedException e) {
                        NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("010027", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id)));
                        throw new NucleusUserException(LOCALISER.msg("010027", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id)), e);
                    }
                    if (validate) {
                        opsToValidate.add(op);
                    }
                }
            }
            pcById.put(idOrig, pc);
        }
        if (!opsToValidate.isEmpty()) {
            try {
                this.getStoreManager().getPersistenceHandler().locateObjects(opsToValidate.toArray(new ObjectProvider[opsToValidate.size()]));
            }
            catch (NucleusObjectNotFoundException nonfe) {
                NucleusObjectNotFoundException[] nonfes = (NucleusObjectNotFoundException[])nonfe.getNestedExceptions();
                if (nonfes != null) {
                    for (int i = 0; i < nonfes.length; ++i) {
                        Object missingId = nonfes[i].getFailedObject();
                        this.removeObjectFromLevel1Cache(missingId);
                    }
                }
                throw nonfe;
            }
        }
        Object[] objs = new Object[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            Object id = ids[i];
            objs[i] = pcById.get(id);
        }
        return objs;
    }

    private ClassDetailsForId getClassDetailsForId(Object id, String objectClassName, boolean checkInheritance) {
        ApiAdapter api = this.getApiAdapter();
        String className = null;
        String originalClassName = null;
        boolean checkedClassName = false;
        if (id instanceof SCOID) {
            throw new NucleusUserException(LOCALISER.msg("010006"));
        }
        if (id instanceof DatastoreUniqueOID) {
            throw new NucleusObjectNotFoundException(LOCALISER.msg("010026"), id);
        }
        if (api.isDatastoreIdentity(id) || api.isSingleFieldIdentity(id)) {
            originalClassName = this.getStoreManager().manageClassForIdentity(id, this.clr);
        } else if (objectClassName != null) {
            originalClassName = objectClassName;
        } else {
            originalClassName = this.getStoreManager().getClassNameForObjectID(id, this.clr, this);
            checkedClassName = true;
        }
        Object pc = null;
        if (checkInheritance) {
            String[] subclasses;
            String string = className = checkedClassName ? originalClassName : this.getStoreManager().getClassNameForObjectID(id, this.clr, this);
            if (className == null) {
                throw new NucleusObjectNotFoundException(LOCALISER.msg("010026"), id);
            }
            if (!checkedClassName && (api.isDatastoreIdentity(id) || api.isSingleFieldIdentity(id)) && (subclasses = this.getMetaDataManager().getSubclassesForClass(className, true)) != null) {
                for (int i = 0; i < subclasses.length; ++i) {
                    Object oid = null;
                    if (api.isDatastoreIdentity(id)) {
                        oid = OIDFactory.getInstance(this.nucCtx, subclasses[i], ((OID)id).getKeyValue());
                    } else if (api.isSingleFieldIdentity(id)) {
                        oid = api.getNewSingleFieldIdentity(id.getClass(), this.getClassLoaderResolver().classForName(subclasses[i]), api.getTargetKeyForSingleFieldIdentity(id));
                    }
                    pc = this.getObjectFromCache(oid);
                    if (pc == null) continue;
                    className = subclasses[i];
                    break;
                }
            }
            if (pc == null && originalClassName != null && !originalClassName.equals(className)) {
                if (api.isDatastoreIdentity(id)) {
                    id = OIDFactory.getInstance(this.getNucleusContext(), className, ((OID)id).getKeyValue());
                    pc = this.getObjectFromCache(id);
                } else if (api.isSingleFieldIdentity(id)) {
                    id = api.getNewSingleFieldIdentity(id.getClass(), this.clr.classForName(className), api.getTargetKeyForSingleFieldIdentity(id));
                    pc = this.getObjectFromCache(id);
                }
            }
        } else {
            className = originalClassName;
        }
        return new ClassDetailsForId(id, className, pc);
    }

    @Override
    public Object findObject(Object id, boolean validate, boolean checkInheritance, String objectClassName) {
        if (id == null) {
            throw new NucleusUserException(LOCALISER.msg("010044"));
        }
        IdentityStringTranslator translator = this.getNucleusContext().getIdentityStringTranslator();
        if (translator != null && id instanceof String) {
            id = translator.getIdentity(this, (String)id);
        }
        ApiAdapter api = this.getApiAdapter();
        boolean fromCache = false;
        Object pc = this.getObjectFromCache(id);
        ObjectProvider op = null;
        if (pc != null) {
            fromCache = true;
            if (id instanceof SCOID && api.isPersistent(pc) && !api.isNew(pc) && !api.isDeleted(pc) && !api.isTransactional(pc)) {
                throw new NucleusUserException(LOCALISER.msg("010005"));
            }
            if (api.isTransactional(pc)) {
                return pc;
            }
            op = this.findObjectProvider(pc);
        } else {
            pc = this.getStoreManager().getPersistenceHandler().findObject(this, id);
            if (pc != null) {
                op = this.findObjectProvider(pc);
                this.putObjectIntoLevel1Cache(op);
                this.putObjectIntoLevel2Cache(op, false);
            } else {
                ClassDetailsForId details = this.getClassDetailsForId(id, objectClassName, checkInheritance);
                String className = details.className;
                id = details.id;
                if (details.pc != null) {
                    pc = details.pc;
                    op = this.findObjectProvider(pc);
                    fromCache = true;
                } else {
                    try {
                        Class pcClass = this.clr.classForName(className, id instanceof OID ? null : id.getClass().getClassLoader());
                        if (Modifier.isAbstract(pcClass.getModifiers())) {
                            throw new NucleusObjectNotFoundException(LOCALISER.msg("010027", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id), (Object)className));
                        }
                        op = this.newObjectProviderForHollow(pcClass, id);
                        pc = op.getObject();
                        if (!checkInheritance && !validate) {
                            op.markForInheritanceValidation();
                        }
                        this.putObjectIntoLevel1Cache(op);
                    }
                    catch (ClassNotResolvedException e) {
                        NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("010027", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id)));
                        throw new NucleusUserException(LOCALISER.msg("010027", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id)), e);
                    }
                }
            }
        }
        boolean performValidationWhenCached = this.nucCtx.getPersistenceConfiguration().getBooleanProperty("datanucleus.findObject.validateWhenCached");
        if (validate && (!fromCache || performValidationWhenCached)) {
            if (op != null && !fromCache) {
                this.putObjectIntoLevel1Cache(op);
            }
            try {
                op.validate();
                if (op.getObject() != pc) {
                    fromCache = false;
                    pc = op.getObject();
                    this.putObjectIntoLevel1Cache(op);
                }
            }
            catch (NucleusObjectNotFoundException onfe) {
                this.removeObjectFromLevel1Cache(op.getInternalObjectId());
                throw onfe;
            }
        }
        if (!fromCache) {
            this.putObjectIntoLevel2Cache(op, false);
        }
        return pc;
    }

    @Override
    public Object newObjectId(Class pcClass, Object key) {
        IdentityKeyTranslator translator;
        if (pcClass == null) {
            throw new NucleusUserException(LOCALISER.msg("010028"));
        }
        this.assertClassPersistable(pcClass);
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(pcClass, this.clr);
        if (cmd == null) {
            throw new NoPersistenceInformationException(pcClass.getName());
        }
        if (!this.getStoreManager().managesClass(cmd.getFullClassName())) {
            this.getStoreManager().addClass(cmd.getFullClassName(), this.clr);
        }
        if ((translator = this.getNucleusContext().getIdentityKeyTranslator()) != null) {
            key = translator.getKey(this, pcClass, key);
        }
        Object id = null;
        if (cmd.usesSingleFieldIdentityClass()) {
            Class idType = this.clr.classForName(cmd.getObjectidClass());
            id = this.getApiAdapter().getNewSingleFieldIdentity(idType, pcClass, key);
        } else if (key instanceof String) {
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                if (Modifier.isAbstract(pcClass.getModifiers()) && cmd.getObjectidClass() != null) {
                    try {
                        Constructor c = this.clr.classForName(cmd.getObjectidClass()).getDeclaredConstructor(String.class);
                        id = c.newInstance((String)key);
                    }
                    catch (Exception e) {
                        String msg = LOCALISER.msg("010030", (Object)cmd.getObjectidClass(), (Object)cmd.getFullClassName());
                        NucleusLogger.PERSISTENCE.error(msg);
                        NucleusLogger.PERSISTENCE.error(e);
                        throw new NucleusUserException(msg);
                    }
                } else {
                    this.clr.classForName(pcClass.getName(), true);
                    id = this.getApiAdapter().getNewApplicationIdentityObjectId(pcClass, key);
                }
            } else {
                id = OIDFactory.getInstance(this.getNucleusContext(), (String)key);
            }
        } else {
            throw new NucleusUserException(LOCALISER.msg("010029", (Object)pcClass.getName(), (Object)key.getClass().getName()));
        }
        return id;
    }

    @Override
    public Object newObjectId(String className, Object pc) {
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, this.clr);
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            Object nextIdentifier = this.getStoreManager().getStrategyValue(this, cmd, -1);
            return OIDFactory.getInstance(this.getNucleusContext(), cmd.getFullClassName(), nextIdentifier);
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            return this.getApiAdapter().getNewApplicationIdentityObjectId(pc, cmd);
        }
        return new SCOID(className);
    }

    @Override
    public void clearDirty(ObjectProvider op) {
        this.dirtyOPs.remove(op);
        this.indirectDirtyOPs.remove(op);
    }

    @Override
    public void clearDirty() {
        this.dirtyOPs.clear();
        this.indirectDirtyOPs.clear();
    }

    @Override
    public void markDirty(ObjectProvider op, boolean directUpdate) {
        if (this.tx.isCommitting() && !this.tx.isActive()) {
            throw new NucleusException("Cannot change objects when transaction is no longer active.");
        }
        boolean isInDirty = this.dirtyOPs.contains(op);
        boolean isInIndirectDirty = this.indirectDirtyOPs.contains(op);
        if (!(this.isDelayDatastoreOperationsEnabled() || isInDirty || isInIndirectDirty || this.dirtyOPs.size() < this.getNucleusContext().getPersistenceConfiguration().getIntProperty("datanucleus.datastoreTransactionFlushLimit"))) {
            this.flushInternal(false);
        }
        if (directUpdate) {
            if (isInIndirectDirty) {
                this.indirectDirtyOPs.remove(op);
                this.dirtyOPs.add(op);
            } else if (!isInDirty) {
                this.dirtyOPs.add(op);
                if (this.txCachedIds != null) {
                    this.txCachedIds.add(op.getInternalObjectId());
                }
            }
        } else if (!isInDirty && !isInIndirectDirty) {
            this.indirectDirtyOPs.add(op);
            if (this.txCachedIds != null) {
                this.txCachedIds.add(op.getInternalObjectId());
            }
        }
    }

    @Override
    public boolean getManageRelations() {
        return this.properties.getBooleanProperty("datanucleus.manageRelationships");
    }

    public boolean getManageRelationsChecks() {
        return this.properties.getBooleanProperty("datanucleus.manageRelationshipsChecks");
    }

    @Override
    public RelationshipManager getRelationshipManager(ObjectProvider op) {
        RelationshipManager relMgr;
        if (!this.getManageRelations()) {
            return null;
        }
        if (this.managedRelationDetails == null) {
            this.managedRelationDetails = new ConcurrentHashMap<ObjectProvider, RelationshipManager>();
        }
        if ((relMgr = this.managedRelationDetails.get(op)) == null) {
            relMgr = new RelationshipManagerImpl(op);
            this.managedRelationDetails.put(op, relMgr);
        }
        return relMgr;
    }

    @Override
    public boolean isManagingRelations() {
        return this.runningManageRelations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performManagedRelationships() {
        if (this.getManageRelations() && this.managedRelationDetails != null && !this.managedRelationDetails.isEmpty()) {
            try {
                RelationshipManager relMgr;
                LifeCycleState lc;
                this.runningManageRelations = true;
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013000"));
                }
                if (this.getManageRelationsChecks()) {
                    for (ObjectProvider op : this.managedRelationDetails.keySet()) {
                        lc = op.getLifecycleState();
                        if (lc == null || lc.isDeleted()) continue;
                        relMgr = this.managedRelationDetails.get(op);
                        relMgr.checkConsistency();
                    }
                }
                for (ObjectProvider op : this.managedRelationDetails.keySet()) {
                    lc = op.getLifecycleState();
                    if (lc == null || lc.isDeleted()) continue;
                    relMgr = this.managedRelationDetails.get(op);
                    relMgr.process();
                    relMgr.clearFields();
                }
                this.managedRelationDetails.clear();
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("013001"));
                }
                Object var6_5 = null;
                this.runningManageRelations = false;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.runningManageRelations = false;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ObjectProvider> getObjectsToBeFlushed() {
        ArrayList<ObjectProvider> ops = new ArrayList<ObjectProvider>();
        try {
            if (this.getMultithreaded()) {
                this.lock.lock();
            }
            ops.addAll(this.dirtyOPs);
            ops.addAll(this.indirectDirtyOPs);
            Object var3_2 = null;
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
            throw throwable;
        }
        return ops;
    }

    @Override
    public boolean isFlushing() {
        return this.flushing > 0;
    }

    @Override
    public void flush() {
        if (this.tx.isActive()) {
            this.performManagedRelationships();
            this.flushInternal(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushInternal(boolean flushToDatastore) {
        if (!flushToDatastore && this.dirtyOPs.size() == 0 && this.indirectDirtyOPs.size() == 0) {
            return;
        }
        if (!this.tx.isActive()) {
            if (this.nontxProcessedOPs == null) {
                this.nontxProcessedOPs = new HashSet<ObjectProvider>();
            }
            this.nontxProcessedOPs.addAll(this.dirtyOPs);
            this.nontxProcessedOPs.addAll(this.indirectDirtyOPs);
        }
        ++this.flushing;
        try {
            if (flushToDatastore) {
                this.tx.preFlush();
            }
            List<NucleusOptimisticException> optimisticFailures = null;
            Boolean optimisedFlag = this.getNucleusContext().getPersistenceConfiguration().getBooleanObjectProperty("datanucleus.flush.optimised");
            optimisticFailures = optimisedFlag != null ? (optimisedFlag != false ? this.flushInternalNonReferential() : this.flushInternalWithOrdering()) : (!this.getStoreManager().getPersistenceHandler().useReferentialIntegrity() ? this.flushInternalNonReferential() : this.flushInternalWithOrdering());
            if (flushToDatastore) {
                this.tx.flush();
            }
            if (optimisticFailures != null) {
                throw new NucleusOptimisticException(LOCALISER.msg("010031"), optimisticFailures.toArray(new Throwable[optimisticFailures.size()]));
            }
            Object var5_4 = null;
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010004"));
            }
            --this.flushing;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010004"));
            }
            --this.flushing;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<NucleusOptimisticException> flushInternalWithOrdering() {
        int i;
        Object[] toFlushIndirect;
        Object[] toFlushDirect;
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010003", this.dirtyOPs.size() + this.indirectDirtyOPs.size()));
        }
        ArrayList<NucleusOptimisticException> optimisticFailures = null;
        try {
            if (this.getMultithreaded()) {
                this.lock.lock();
            }
            toFlushDirect = this.dirtyOPs.toArray();
            this.dirtyOPs.clear();
            toFlushIndirect = this.indirectDirtyOPs.toArray();
            this.indirectDirtyOPs.clear();
            Object var5_4 = null;
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
            throw throwable;
        }
        HashSet classesToFlush = null;
        if (this.getNucleusContext().getStoreManager().getQueryManager().getQueryResultsCache() != null) {
            classesToFlush = new HashSet();
        }
        for (i = 0; i < toFlushDirect.length; ++i) {
            ObjectProvider objectProvider = (ObjectProvider)toFlushDirect[i];
            try {
                objectProvider.flush();
                if (classesToFlush == null) continue;
                classesToFlush.add(objectProvider.getObject().getClass());
                continue;
            }
            catch (NucleusOptimisticException oe) {
                if (optimisticFailures == null) {
                    optimisticFailures = new ArrayList<NucleusOptimisticException>();
                }
                optimisticFailures.add(oe);
            }
        }
        for (i = 0; i < toFlushIndirect.length; ++i) {
            ObjectProvider objectProvider = (ObjectProvider)toFlushIndirect[i];
            try {
                objectProvider.flush();
                if (classesToFlush == null) continue;
                classesToFlush.add(objectProvider.getObject().getClass());
                continue;
            }
            catch (NucleusOptimisticException oe) {
                if (optimisticFailures == null) {
                    optimisticFailures = new ArrayList();
                }
                optimisticFailures.add(oe);
            }
        }
        if (classesToFlush != null) {
            for (Class clazz : classesToFlush) {
                this.getNucleusContext().getStoreManager().getQueryManager().evictQueryResultsForType(clazz);
            }
        }
        return optimisticFailures;
    }

    protected List<NucleusOptimisticException> flushInternalNonReferential() {
        ArrayList<NucleusOptimisticException> optimisticFailures = null;
        StorePersistenceHandler persistenceHandler = this.getStoreManager().getPersistenceHandler();
        HashSet<ObjectProvider> opsToFlush = new HashSet<ObjectProvider>();
        opsToFlush.addAll(this.dirtyOPs);
        this.dirtyOPs.clear();
        opsToFlush.addAll(this.indirectDirtyOPs);
        this.indirectDirtyOPs.clear();
        HashSet classesToFlush = null;
        if (this.getNucleusContext().getStoreManager().getQueryManager().getQueryResultsCache() != null) {
            classesToFlush = new HashSet();
        }
        HashSet<ObjectProvider> opsToDelete = new HashSet<ObjectProvider>();
        HashSet<ObjectProvider> opsToInsert = new HashSet<ObjectProvider>();
        Iterator opIter = opsToFlush.iterator();
        while (opIter.hasNext()) {
            ObjectProvider op = (ObjectProvider)opIter.next();
            if (op.isEmbedded()) {
                op.markAsFlushed();
                opIter.remove();
                continue;
            }
            if (classesToFlush != null) {
                classesToFlush.add(op.getObject().getClass());
            }
            if (op.getLifecycleState().isNew() && !op.isFlushedToDatastore() && !op.isFlushedNew()) {
                opsToInsert.add(op);
                opIter.remove();
                continue;
            }
            if (!op.getLifecycleState().isDeleted() || op.isFlushedToDatastore()) continue;
            if (!op.getLifecycleState().isNew()) {
                opsToDelete.add(op);
                opIter.remove();
                continue;
            }
            if (!op.getLifecycleState().isNew() || !op.isFlushedNew()) continue;
            opsToDelete.add(op);
            opIter.remove();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010046", opsToDelete.size(), (Object)opsToInsert.size(), (Object)opsToFlush.size()));
        }
        if (!opsToDelete.isEmpty()) {
            for (ObjectProvider objectProvider : opsToDelete) {
                objectProvider.setFlushing(true);
                this.getCallbackHandler().preDelete(objectProvider.getObject());
            }
            try {
                persistenceHandler.deleteObjects(opsToDelete.toArray(new ObjectProvider[opsToDelete.size()]));
            }
            catch (NucleusOptimisticException noe) {
                if (optimisticFailures == null) {
                    optimisticFailures = new ArrayList<NucleusOptimisticException>();
                }
                optimisticFailures.add(noe);
            }
            for (ObjectProvider objectProvider : opsToDelete) {
                this.getCallbackHandler().postDelete(objectProvider.getObject());
                objectProvider.setFlushedNew(false);
                objectProvider.markAsFlushed();
                objectProvider.setFlushing(false);
            }
        }
        if (!opsToInsert.isEmpty()) {
            for (ObjectProvider objectProvider : opsToInsert) {
                objectProvider.setFlushing(true);
                this.getCallbackHandler().preStore(objectProvider.getObject());
            }
            persistenceHandler.insertObjects(opsToInsert.toArray(new ObjectProvider[opsToInsert.size()]));
            for (ObjectProvider objectProvider : opsToInsert) {
                this.getCallbackHandler().postStore(objectProvider.getObject());
                objectProvider.setFlushedNew(true);
                objectProvider.markAsFlushed();
                objectProvider.setFlushing(false);
                this.putObjectIntoLevel1Cache(objectProvider);
            }
        }
        if (!opsToFlush.isEmpty()) {
            for (ObjectProvider objectProvider : opsToFlush) {
                try {
                    objectProvider.flush();
                }
                catch (NucleusOptimisticException oe) {
                    if (optimisticFailures == null) {
                        optimisticFailures = new ArrayList();
                    }
                    optimisticFailures.add(oe);
                }
            }
        }
        if (classesToFlush != null) {
            for (Class clazz : classesToFlush) {
                this.getNucleusContext().getStoreManager().getQueryManager().evictQueryResultsForType(clazz);
            }
        }
        return optimisticFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postBegin() {
        try {
            int i;
            if (this.getMultithreaded()) {
                this.lock.lock();
            }
            ObjectProvider[] ops = this.dirtyOPs.toArray(new ObjectProvider[this.dirtyOPs.size()]);
            for (i = 0; i < ops.length; ++i) {
                ops[i].preBegin(this.tx);
            }
            ops = this.indirectDirtyOPs.toArray(new ObjectProvider[this.indirectDirtyOPs.size()]);
            for (i = 0; i < ops.length; ++i) {
                ops[i].preBegin(this.tx);
            }
            Object var4_3 = null;
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCommit() {
        try {
            if (this.getMultithreaded()) {
                this.lock.lock();
            }
            this.flush();
            if (this.getReachabilityAtCommit()) {
                try {
                    try {
                        this.runningPBRAtCommit = true;
                        this.performReachabilityAtCommit();
                    }
                    catch (Throwable t) {
                        NucleusLogger.PERSISTENCE.error(t);
                        if (t instanceof NucleusException) {
                            throw (NucleusException)t;
                        }
                        throw new NucleusException("Unexpected error during precommit", t);
                    }
                    Object var3_1 = null;
                    this.runningPBRAtCommit = false;
                }
                catch (Throwable throwable) {
                    Object var3_2 = null;
                    this.runningPBRAtCommit = false;
                    throw throwable;
                }
            }
            if (this.nucCtx.hasLevel2Cache()) {
                this.performLevel2CacheUpdateAtCommit();
            }
            if (this.getDetachAllOnCommit()) {
                this.performDetachAllOnTxnEndPreparation();
            }
            Object var5_5 = null;
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
            throw throwable;
        }
    }

    @Override
    public boolean isObjectModifiedInTransaction(Object id) {
        if (this.txCachedIds != null) {
            return this.txCachedIds.contains(id);
        }
        return false;
    }

    private void performLevel2CacheUpdateAtCommit() {
        if (this.txCachedIds == null) {
            return;
        }
        HashSet<ObjectProvider> opsToCache = null;
        HashSet<Object> idsToRemove = null;
        for (Object id : this.txCachedIds) {
            ObjectProvider op = this.enlistedOPCache.get(id);
            if (op == null) {
                if (NucleusLogger.CACHE.isDebugEnabled() && this.nucCtx.getLevel2Cache().containsOid(id)) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("004014", id));
                }
                if (idsToRemove == null) {
                    idsToRemove = new HashSet<Object>();
                }
                idsToRemove.add(id);
                continue;
            }
            Object obj = op.getObject();
            Object objID = this.getApiAdapter().getIdForObject(obj);
            if (objID == null) continue;
            if (this.getApiAdapter().isDeleted(obj)) {
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("004007", (Object)StringUtils.toJVMIDString(obj), op.getInternalObjectId()));
                }
                if (idsToRemove == null) {
                    idsToRemove = new HashSet();
                }
                idsToRemove.add(objID);
                continue;
            }
            if (this.getApiAdapter().isDetached(obj) || !this.nucCtx.isClassCacheable(op.getClassMetaData())) continue;
            if (opsToCache == null) {
                opsToCache = new HashSet<ObjectProvider>();
            }
            opsToCache.add(op);
        }
        if (idsToRemove != null && !idsToRemove.isEmpty()) {
            this.nucCtx.getLevel2Cache().evictAll(idsToRemove);
        }
        if (opsToCache != null && !opsToCache.isEmpty()) {
            this.putObjectsIntoLevel2Cache((Set<ObjectProvider>)opsToCache);
        }
        this.txCachedIds.clear();
    }

    private void performReachabilityAtCommit() {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010032"));
        }
        if (this.txKnownPersistedIds.size() > 0 && this.txFlushedNewIds.size() > 0) {
            HashSet currentReachables = new HashSet();
            Object[] ids = this.txKnownPersistedIds.toArray();
            HashSet<Object> objectNotFound = new HashSet<Object>();
            for (int i = 0; i < ids.length; ++i) {
                if (this.txKnownDeletedIds.contains(ids[i])) continue;
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug("Performing reachability algorithm on object with id \"" + ids[i] + "\"");
                }
                try {
                    ObjectProvider op = this.findObjectProvider(this.findObject(ids[i], true, true, null));
                    op.runReachability(currentReachables);
                    continue;
                }
                catch (NucleusObjectNotFoundException ex) {
                    objectNotFound.add(ids[i]);
                }
            }
            this.txFlushedNewIds.removeAll(currentReachables);
            Object[] nonReachableIds = this.txFlushedNewIds.toArray();
            if (nonReachableIds != null && nonReachableIds.length > 0) {
                ObjectProvider op;
                int i;
                for (i = 0; i < nonReachableIds.length; ++i) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010033", nonReachableIds[i]));
                    }
                    try {
                        if (objectNotFound.contains(nonReachableIds[i])) continue;
                        op = this.findObjectProvider(this.findObject(nonReachableIds[i], true, true, null));
                        op.nullifyFields();
                        continue;
                    }
                    catch (NucleusObjectNotFoundException ex) {
                        // empty catch block
                    }
                }
                for (i = 0; i < nonReachableIds.length; ++i) {
                    try {
                        if (objectNotFound.contains(nonReachableIds[i])) continue;
                        op = this.findObjectProvider(this.findObject(nonReachableIds[i], true, true, null));
                        op.deletePersistent();
                        continue;
                    }
                    catch (NucleusObjectNotFoundException ex) {
                        // empty catch block
                    }
                }
            }
            this.flushInternal(true);
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010034"));
        }
    }

    private void performDetachAllOnTxnEndPreparation() {
        ArrayList<ObjectProvider> ops = new ArrayList<ObjectProvider>();
        Collection roots = this.fetchPlan.getDetachmentRoots();
        Class[] rootClasses = this.fetchPlan.getDetachmentRootClasses();
        if (roots != null && roots.size() > 0) {
            for (Object obj : roots) {
                ops.add(this.findObjectProvider(obj));
            }
        } else if (rootClasses != null && rootClasses.length > 0) {
            ObjectProvider[] txOPs = this.enlistedOPCache.values().toArray(new ObjectProvider[this.enlistedOPCache.size()]);
            block3: for (int i = 0; i < txOPs.length; ++i) {
                for (int j = 0; j < rootClasses.length; ++j) {
                    if (txOPs[i].getObject().getClass() != rootClasses[j]) continue;
                    ops.add(txOPs[i]);
                    continue block3;
                }
            }
        } else if (this.cache != null) {
            ops.addAll(this.cache.values());
        }
        Iterator opsIter = ops.iterator();
        while (opsIter.hasNext()) {
            ObjectProvider op = (ObjectProvider)opsIter.next();
            Object pc = op.getObject();
            if (pc == null || this.getApiAdapter().isDetached(pc) || this.getApiAdapter().isDeleted(pc)) continue;
            FetchPlanState state = new FetchPlanState();
            try {
                op.loadFieldsInFetchPlan(state);
            }
            catch (NucleusObjectNotFoundException onfe) {
                NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("010013", (Object)StringUtils.toJVMIDString(pc), op.getInternalObjectId()));
                opsIter.remove();
            }
        }
        this.detachAllOnTxnEndOPs = ops.toArray(new ObjectProvider[ops.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDetachAllOnTxnEnd() {
        try {
            this.runningDetachAllOnTxnEnd = true;
            if (this.detachAllOnTxnEndOPs != null) {
                ObjectProvider[] opsToDetach = this.detachAllOnTxnEndOPs;
                DetachState state = new DetachState(this.getApiAdapter());
                for (int i = 0; i < opsToDetach.length; ++i) {
                    Object pc = opsToDetach[i].getObject();
                    if (pc == null) continue;
                    opsToDetach[i].detach(state);
                }
            }
            Object var6_5 = null;
            this.detachAllOnTxnEndOPs = null;
            this.runningDetachAllOnTxnEnd = false;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.detachAllOnTxnEndOPs = null;
            this.runningDetachAllOnTxnEnd = false;
            throw throwable;
        }
    }

    @Override
    public boolean isRunningDetachAllOnCommit() {
        return this.runningDetachAllOnTxnEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDetachOnClose() {
        if (this.cache != null && this.cache.size() > 0) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010011"));
            ArrayList<ObjectProvider> toDetach = new ArrayList<ObjectProvider>();
            toDetach.addAll(this.cache.values());
            if (this.tx.getNontransactionalRead()) {
                this.performDetachOnCloseWork(toDetach);
            } else {
                try {
                    this.tx.begin();
                    this.performDetachOnCloseWork(toDetach);
                    this.tx.commit();
                    Object var3_2 = null;
                    if (this.tx.isActive()) {
                        this.tx.rollback();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (this.tx.isActive()) {
                        this.tx.rollback();
                    }
                    throw throwable;
                }
            }
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("010012"));
        }
    }

    private void performDetachOnCloseWork(List<ObjectProvider> smsToDetach) {
        for (ObjectProvider op : smsToDetach) {
            if (op == null || op.getObject() == null || op.getExecutionContext().getApiAdapter().isDeleted(op.getObject()) || op.getExternalObjectId() == null) continue;
            try {
                op.detach(new DetachState(this.getApiAdapter()));
            }
            catch (NucleusObjectNotFoundException onfe) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCommit() {
        try {
            if (this.getMultithreaded()) {
                this.lock.lock();
            }
            if (this.getDetachAllOnCommit()) {
                this.performDetachAllOnTxnEnd();
            }
            ArrayList<RuntimeException> failures = null;
            try {
                ApiAdapter api = this.getApiAdapter();
                ObjectProvider[] ops = this.enlistedOPCache.values().toArray(new ObjectProvider[this.enlistedOPCache.size()]);
                for (int i = 0; i < ops.length; ++i) {
                    try {
                        if (ops[i] == null || ops[i].getObject() == null || !api.isPersistent(ops[i].getObject()) && !api.isTransactional(ops[i].getObject())) continue;
                        ops[i].postCommit(this.getTransaction());
                        if (!this.getDetachAllOnCommit() || !api.isDetachable(ops[i].getObject())) continue;
                        this.removeObjectProvider(ops[i]);
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (failures == null) {
                            failures = new ArrayList<RuntimeException>();
                        }
                        failures.add(e);
                    }
                }
                Object var7_6 = null;
                this.resetTransactionalVariables();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.resetTransactionalVariables();
                throw throwable;
            }
            if (failures != null && !failures.isEmpty()) {
                throw new CommitStateTransitionException(failures.toArray(new Exception[failures.size()]));
            }
            Object var9_9 = null;
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRollback() {
        try {
            if (this.getMultithreaded()) {
                this.lock.lock();
            }
            ArrayList<RuntimeException> failures = null;
            try {
                Collection<ObjectProvider> ops = this.enlistedOPCache.values();
                for (ObjectProvider op : ops) {
                    try {
                        op.preRollback(this.getTransaction());
                    }
                    catch (RuntimeException e) {
                        if (failures == null) {
                            failures = new ArrayList<RuntimeException>();
                        }
                        failures.add(e);
                    }
                }
                this.clearDirty();
                Object var7_6 = null;
                this.resetTransactionalVariables();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.resetTransactionalVariables();
                throw throwable;
            }
            if (failures != null && !failures.isEmpty()) {
                throw new RollbackStateTransitionException(failures.toArray(new Exception[failures.size()]));
            }
            if (this.getDetachAllOnRollback()) {
                this.performDetachAllOnTxnEndPreparation();
            }
            Object var9_9 = null;
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRollback() {
        try {
            if (this.getMultithreaded()) {
                this.lock.lock();
            }
            if (this.getDetachAllOnRollback()) {
                this.performDetachAllOnTxnEnd();
            }
            Object var2_1 = null;
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.getMultithreaded()) {
                this.lock.unlock();
            }
            throw throwable;
        }
    }

    private void resetTransactionalVariables() {
        if (this.getReachabilityAtCommit()) {
            this.txEnlistedIds.clear();
            this.txKnownPersistedIds.clear();
            this.txKnownDeletedIds.clear();
            this.txFlushedNewIds.clear();
        }
        this.enlistedOPCache.clear();
        this.dirtyOPs.clear();
        this.indirectDirtyOPs.clear();
        this.fetchPlan.resetDetachmentRoots();
        if (this.getManageRelations() && this.managedRelationDetails != null) {
            this.managedRelationDetails.clear();
        }
        if (this.txCachedIds != null) {
            this.txCachedIds.clear();
        }
    }

    @Override
    public void putObjectIntoLevel1Cache(ObjectProvider op) {
        if (this.cache != null) {
            Object id = op.getInternalObjectId();
            if (id == null || op.getObject() == null) {
                NucleusLogger.CACHE.warn(LOCALISER.msg("003006"));
                return;
            }
            ObjectProvider oldOP = this.cache.put(id, op);
            if (NucleusLogger.CACHE.isDebugEnabled() && oldOP == null) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003004", (Object)StringUtils.toJVMIDString(op.getObject()), (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id), (Object)StringUtils.booleanArrayToString(op.getLoadedFields())));
            }
        }
    }

    protected void putObjectIntoLevel2Cache(ObjectProvider op, boolean updateIfPresent) {
        if (op.getInternalObjectId() == null || !this.nucCtx.isClassCacheable(op.getClassMetaData())) {
            return;
        }
        if (this.txCachedIds != null && !this.txCachedIds.contains(op.getInternalObjectId())) {
            this.putObjectIntoLevel2CacheInternal(op, updateIfPresent);
        }
    }

    protected CachedPC getL2CacheableObject(ObjectProvider op) {
        int[] loadedFieldNumbers = op.getLoadedFieldNumbers();
        if (loadedFieldNumbers == null || loadedFieldNumbers.length == 0) {
            return null;
        }
        CachedPC cachedPC = new CachedPC(op.getObject().getClass(), op.getLoadedFields(), op.getTransactionalVersion());
        op.provideFields(loadedFieldNumbers, new L2CachePopulateFieldManager(op, cachedPC));
        return cachedPC;
    }

    protected void putObjectsIntoLevel2Cache(Set<ObjectProvider> ops) {
        int batchSize = this.nucCtx.getPersistenceConfiguration().getIntProperty("datanucleus.cache.level2.batchSize");
        Level2Cache l2Cache = this.nucCtx.getLevel2Cache();
        HashMap<Object, CachedPC> dataToUpdate = new HashMap<Object, CachedPC>();
        for (ObjectProvider op : ops) {
            Object id = op.getInternalObjectId();
            CachedPC cachedPC = this.getL2CacheableObject(op);
            if (cachedPC == null || id == null || id instanceof IdentityReference) continue;
            dataToUpdate.put(id, cachedPC);
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                String fieldNames = StringUtils.objectArrayToString(cachedPC.getFieldNumbers());
                if (fieldNames == null || fieldNames.equals("null")) {
                    fieldNames = "";
                }
                if (l2Cache.containsOid(id)) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("004013", (Object)StringUtils.toJVMIDString(op.getObject()), id, (Object)fieldNames, cachedPC.getVersion()));
                } else {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("004003", (Object)StringUtils.toJVMIDString(op.getObject()), id, (Object)fieldNames, cachedPC.getVersion()));
                }
            }
            if (dataToUpdate.size() != batchSize) continue;
            l2Cache.putAll(dataToUpdate);
            dataToUpdate.clear();
        }
        if (!dataToUpdate.isEmpty()) {
            l2Cache.putAll(dataToUpdate);
            dataToUpdate.clear();
        }
    }

    protected void putObjectIntoLevel2CacheInternal(ObjectProvider op, boolean updateIfPresent) {
        Object id = op.getInternalObjectId();
        if (id == null || id instanceof IdentityReference) {
            return;
        }
        Level2Cache l2Cache = this.nucCtx.getLevel2Cache();
        if (!updateIfPresent && l2Cache.containsOid(id)) {
            return;
        }
        CachedPC cachedPC = this.getL2CacheableObject(op);
        if (cachedPC != null) {
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                String fieldNames = StringUtils.objectArrayToString(cachedPC.getFieldNumbers());
                if (fieldNames == null || fieldNames.equals("null")) {
                    fieldNames = "";
                }
                if (l2Cache.containsOid(id)) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("004013", (Object)StringUtils.toJVMIDString(op.getObject()), id, (Object)fieldNames, cachedPC.getVersion()));
                } else {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("004003", (Object)StringUtils.toJVMIDString(op.getObject()), id, (Object)fieldNames, cachedPC.getVersion()));
                }
            }
            l2Cache.put(id, cachedPC);
        }
    }

    @Override
    public void removeObjectFromLevel1Cache(Object id) {
        if (id != null && this.cache != null) {
            Object pcRemoved;
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003009", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id), (Object)String.valueOf(this.cache.size())));
            }
            if ((pcRemoved = this.cache.remove(id)) == null && NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003010", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id)));
            }
        }
    }

    @Override
    public void removeObjectFromLevel2Cache(Object id) {
        Level2Cache l2Cache;
        if (id != null && (l2Cache = this.nucCtx.getLevel2Cache()).containsOid(id)) {
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("004016", id));
            }
            l2Cache.evict(id);
        }
    }

    @Override
    public boolean hasIdentityInCache(Object id) {
        Level2Cache l2Cache;
        if (this.cache != null && this.cache.containsKey(id)) {
            return true;
        }
        return this.nucCtx.hasLevel2Cache() && (l2Cache = this.nucCtx.getLevel2Cache()).containsOid(id);
    }

    @Override
    public Object getObjectFromCache(Object id) {
        Object pc = this.getObjectFromLevel1Cache(id);
        if (pc != null) {
            return pc;
        }
        return this.getObjectFromLevel2Cache(id);
    }

    public Object getObjectFromLevel1Cache(Object id) {
        Object pc = null;
        ObjectProvider op = null;
        if (this.cache != null) {
            op = (ObjectProvider)this.cache.get(id);
            if (op != null) {
                pc = op.getObject();
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("003008", (Object)StringUtils.toJVMIDString(pc), (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id), (Object)StringUtils.booleanArrayToString(op.getLoadedFields()), (Object)("" + this.cache.size())));
                }
                op.resetDetachState();
                return pc;
            }
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("003007", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id), (Object)("" + this.cache.size())));
            }
        }
        return null;
    }

    public Object getObjectFromLevel2Cache(Object id) {
        Object pc = null;
        if (this.nucCtx.hasLevel2Cache()) {
            Level2Cache l2Cache = this.nucCtx.getLevel2Cache();
            CachedPC cachedPC = l2Cache.get(id);
            if (cachedPC != null) {
                ObjectProvider op = this.newObjectProviderForCachedPC(id, cachedPC);
                pc = op.getObject();
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("004006", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id), (Object)StringUtils.objectArrayToString(cachedPC.getFieldNumbers()), cachedPC.getVersion(), (Object)StringUtils.toJVMIDString(pc)));
                }
                if (this.tx.isActive() && this.tx.getOptimistic()) {
                    op.makeNontransactional();
                } else if (!this.tx.isActive() && this.getApiAdapter().isTransactional(pc)) {
                    op.makeNontransactional();
                }
                return pc;
            }
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(LOCALISER.msg("004005", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id)));
            }
        }
        return null;
    }

    protected Map getObjectsFromLevel2Cache(Collection ids) {
        if (this.nucCtx.hasLevel2Cache()) {
            Level2Cache l2Cache = this.nucCtx.getLevel2Cache();
            Map<Object, CachedPC> cachedPCs = l2Cache.getAll(ids);
            HashMap<Object, Object> pcsById = new HashMap<Object, Object>(cachedPCs.size());
            for (Map.Entry<Object, CachedPC> entry : cachedPCs.entrySet()) {
                Object id = entry.getKey();
                CachedPC cachedPC = entry.getValue();
                if (cachedPC != null) {
                    ObjectProvider op = this.newObjectProviderForCachedPC(id, cachedPC);
                    Object pc = op.getObject();
                    if (NucleusLogger.CACHE.isDebugEnabled()) {
                        NucleusLogger.CACHE.debug(LOCALISER.msg("004006", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id), (Object)StringUtils.objectArrayToString(cachedPC.getFieldNumbers()), cachedPC.getVersion(), (Object)StringUtils.toJVMIDString(pc)));
                    }
                    if (this.tx.isActive() && this.tx.getOptimistic()) {
                        op.makeNontransactional();
                    } else if (!this.tx.isActive() && this.getApiAdapter().isTransactional(pc)) {
                        op.makeNontransactional();
                    }
                    pcsById.put(id, pc);
                    continue;
                }
                if (!NucleusLogger.CACHE.isDebugEnabled()) continue;
                NucleusLogger.CACHE.debug(LOCALISER.msg("004005", (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), id)));
            }
            return pcsById;
        }
        return null;
    }

    @Override
    public void replaceObjectId(Object pc, Object oldID, Object newID) {
        if (pc == null || this.getApiAdapter().getIdForObject(pc) == null) {
            NucleusLogger.CACHE.warn(LOCALISER.msg("003006"));
            return;
        }
        ObjectProvider op = this.findObjectProvider(pc);
        if (this.cache != null) {
            Object o = this.cache.get(oldID);
            if (o != null) {
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(LOCALISER.msg("003012", (Object)StringUtils.toJVMIDString(pc), (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), oldID), (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), newID)));
                }
                this.cache.remove(oldID);
            }
            if (op != null) {
                this.putObjectIntoLevel1Cache(op);
            }
        }
        if (this.enlistedOPCache.get(oldID) != null && op != null) {
            this.enlistedOPCache.remove(oldID);
            this.enlistedOPCache.put(newID, op);
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015018", (Object)StringUtils.toJVMIDString(pc), (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), oldID), (Object)IdentityUtils.getIdentityAsString(this.getApiAdapter(), newID)));
            }
        }
        if (this.txCachedIds != null && this.txCachedIds.contains(oldID)) {
            this.txCachedIds.remove(oldID);
            this.txCachedIds.add(newID);
        }
        if (this.getReachabilityAtCommit() && this.tx.isActive()) {
            if (this.txEnlistedIds.remove(oldID)) {
                this.txEnlistedIds.add(newID);
            }
            if (this.txFlushedNewIds.remove(oldID)) {
                this.txFlushedNewIds.add(newID);
            }
            if (this.txKnownPersistedIds.remove(oldID)) {
                this.txKnownPersistedIds.add(newID);
            }
            if (this.txKnownDeletedIds.remove(oldID)) {
                this.txKnownDeletedIds.add(newID);
            }
        }
    }

    @Override
    public boolean getSerializeReadForClass(String className) {
        AbstractClassMetaData cmd;
        if (this.tx.isActive() && this.tx.getSerializeRead() != null) {
            return this.tx.getSerializeRead();
        }
        if (this.getProperty("datanucleus.SerializeRead") != null) {
            return this.properties.getBooleanProperty("datanucleus.SerializeRead");
        }
        if (className != null && (cmd = this.getMetaDataManager().getMetaDataForClass(className, this.clr)) != null) {
            return cmd.isSerializeRead();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Extent getExtent(Class pcClass, boolean subclasses) {
        try {
            this.clr.setPrimary(pcClass.getClassLoader());
            this.assertClassPersistable(pcClass);
            Extent extent = this.getStoreManager().getExtent(this, pcClass, subclasses);
            Object var5_4 = null;
            this.clr.unsetPrimary();
            return extent;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.clr.unsetPrimary();
            throw throwable;
        }
    }

    @Override
    public Query newQuery() {
        return this.getStoreManager().getQueryManager().newQuery("JDOQL", this, null);
    }

    public void removeAllInstanceLifecycleListeners() {
        if (this.callbacks != null) {
            this.callbacks.close();
        }
    }

    @Override
    public CallbackHandler getCallbackHandler() {
        if (this.callbacks != null) {
            return this.callbacks;
        }
        if (!this.getNucleusContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.allowCallbacks")) {
            this.callbacks = new NullCallbackHandler();
            return this.callbacks;
        }
        String callbackHandlerClassName = this.getNucleusContext().getPluginManager().getAttributeValueForExtension("org.datanucleus.callbackhandler", "name", this.getNucleusContext().getApiName(), "class-name");
        if (callbackHandlerClassName != null) {
            try {
                this.callbacks = (CallbackHandler)this.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.callbackhandler", "name", this.getNucleusContext().getApiName(), "class-name", new Class[]{ClassConstants.NUCLEUS_CONTEXT}, new Object[]{this.getNucleusContext()});
                return this.callbacks;
            }
            catch (Exception e) {
                NucleusLogger.PERSISTENCE.error(LOCALISER.msg("025000", (Object)callbackHandlerClassName, (Object)e));
            }
        }
        return null;
    }

    @Override
    public void addListener(Object listener, Class[] classes) {
        if (listener == null) {
            return;
        }
        this.getCallbackHandler().addListener(listener, classes);
    }

    @Override
    public void removeListener(Object listener) {
        if (listener != null) {
            this.getCallbackHandler().removeListener(listener);
        }
    }

    @Override
    public void disconnectLifecycleListener() {
        if (this.callbacks != null) {
            this.callbacks.close();
        }
    }

    protected void assertIsOpen() {
        if (this.isClosed()) {
            throw new NucleusUserException(LOCALISER.msg("010002")).setFatal();
        }
    }

    @Override
    public void assertClassPersistable(Class cls) {
        if (cls != null && !this.getNucleusContext().getApiAdapter().isPersistable(cls) && !cls.isInterface()) {
            throw new ClassNotPersistableException(cls.getName());
        }
        if (!this.hasPersistenceInformationForClass(cls)) {
            throw new NoPersistenceInformationException(cls.getName());
        }
    }

    protected void assertDetachable(Object object) {
        if (object != null && !this.getApiAdapter().isDetachable(object)) {
            throw new ClassNotDetachableException(object.getClass().getName());
        }
    }

    protected void assertNotDetached(Object object) {
        if (object != null && this.getApiAdapter().isDetached(object)) {
            throw new ObjectDetachedException(object.getClass().getName());
        }
    }

    protected void assertActiveTransaction() {
        if (!this.tx.isActive()) {
            throw new TransactionNotActiveException();
        }
    }

    protected void assertHasImplementationCreator() {
        if (this.getNucleusContext().getImplementationCreator() == null) {
            throw new NucleusUserException(LOCALISER.msg("010035"));
        }
    }

    @Override
    public boolean hasPersistenceInformationForClass(Class cls) {
        if (cls == null) {
            return false;
        }
        if (this.getMetaDataManager().getMetaDataForClass(cls, this.clr) != null) {
            return true;
        }
        if (cls.isInterface()) {
            try {
                this.newInstance(cls);
            }
            catch (RuntimeException ex) {
                NucleusLogger.PERSISTENCE.warn(ex);
            }
            return this.getMetaDataManager().getMetaDataForClass(cls, this.clr) != null;
        }
        return false;
    }

    protected FetchGroupManager getFetchGroupManager() {
        if (this.fetchGrpMgr == null) {
            this.fetchGrpMgr = new FetchGroupManager(this.getNucleusContext());
        }
        return this.fetchGrpMgr;
    }

    @Override
    public void addInternalFetchGroup(FetchGroup grp) {
        this.getFetchGroupManager().addFetchGroup(grp);
    }

    protected void removeInternalFetchGroup(FetchGroup grp) {
        this.getFetchGroupManager().removeFetchGroup(grp);
    }

    @Override
    public FetchGroup getInternalFetchGroup(Class cls, String name) {
        if (!cls.isInterface() && !this.getNucleusContext().getApiAdapter().isPersistable(cls)) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        if (cls.isInterface() && !this.getNucleusContext().getMetaDataManager().isPersistentInterface(cls.getName())) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        return this.getFetchGroupManager().getFetchGroup(cls, name);
    }

    @Override
    public Set getFetchGroupsWithName(String name) {
        return this.getFetchGroupManager().getFetchGroupsWithName(name);
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }

    private static class ClassDetailsForId {
        Object id;
        String className;
        Object pc;

        public ClassDetailsForId(Object id, String className, Object pc) {
            this.id = id;
            this.className = className;
            this.pc = pc;
        }
    }

    static class ThreadContextInfo {
        int referenceCounter = 0;
        Map<Object, ObjectProvider> attachedOwnerByObject = null;
        Map attachedPCById = null;
        boolean merging = false;
        boolean nontxPersistDelete = false;

        ThreadContextInfo() {
        }
    }
}

