/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.JDOClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.InvalidMemberMetaDataException;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PersistenceFileMetaData;
import org.datanucleus.metadata.Relation;
import org.datanucleus.metadata.xml.MetaDataParser;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataUtils {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    private static MetaDataUtils instance;

    public static synchronized MetaDataUtils getInstance() {
        if (instance == null) {
            instance = new MetaDataUtils();
        }
        return instance;
    }

    protected MetaDataUtils() {
    }

    public boolean arrayStorableAsByteArrayInSingleColumn(AbstractMemberMetaData fmd) {
        if (fmd == null || !fmd.hasArray()) {
            return false;
        }
        String arrayComponentType = fmd.getType().getComponentType().getName();
        return arrayComponentType.equals(ClassNameConstants.BOOLEAN) || arrayComponentType.equals(ClassNameConstants.BYTE) || arrayComponentType.equals(ClassNameConstants.CHAR) || arrayComponentType.equals(ClassNameConstants.DOUBLE) || arrayComponentType.equals(ClassNameConstants.FLOAT) || arrayComponentType.equals(ClassNameConstants.INT) || arrayComponentType.equals(ClassNameConstants.LONG) || arrayComponentType.equals(ClassNameConstants.SHORT) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_BOOLEAN) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_BYTE) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_CHARACTER) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_DOUBLE) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_FLOAT) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_INTEGER) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_LONG) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_SHORT) || arrayComponentType.equals(ClassNameConstants.JAVA_MATH_BIGDECIMAL) || arrayComponentType.equals(ClassNameConstants.JAVA_MATH_BIGINTEGER);
    }

    public boolean storesPersistable(AbstractMemberMetaData fmd, ExecutionContext ec) {
        if (fmd == null) {
            return false;
        }
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        MetaDataManager mmgr = ec.getMetaDataManager();
        if (fmd.hasCollection()) {
            if (fmd.getCollection().elementIsPersistent()) {
                return true;
            }
            String elementType = fmd.getCollection().getElementType();
            Class elementCls = clr.classForName(elementType);
            if (mmgr.getMetaDataForImplementationOfReference(elementCls, null, clr) != null) {
                return true;
            }
            if (elementCls != null && ClassUtils.isReferenceType(elementCls)) {
                try {
                    String[] impls = this.getImplementationNamesForReferenceField(fmd, 3, clr, mmgr);
                    if (impls != null) {
                        elementCls = clr.classForName(impls[0]);
                        if (ec.getApiAdapter().isPersistable(elementCls)) {
                            return true;
                        }
                    }
                }
                catch (NucleusUserException nue) {}
            }
        } else if (fmd.hasMap()) {
            String[] impls;
            if (fmd.getMap().keyIsPersistent()) {
                return true;
            }
            String keyType = fmd.getMap().getKeyType();
            Class keyCls = clr.classForName(keyType);
            if (mmgr.getMetaDataForImplementationOfReference(keyCls, null, clr) != null) {
                return true;
            }
            if (keyCls != null && ClassUtils.isReferenceType(keyCls)) {
                try {
                    impls = this.getImplementationNamesForReferenceField(fmd, 5, clr, mmgr);
                    if (impls != null) {
                        keyCls = clr.classForName(impls[0]);
                        if (ec.getApiAdapter().isPersistable(keyCls)) {
                            return true;
                        }
                    }
                }
                catch (NucleusUserException nue) {
                    // empty catch block
                }
            }
            if (fmd.getMap().valueIsPersistent()) {
                return true;
            }
            String valueType = fmd.getMap().getValueType();
            Class valueCls = clr.classForName(valueType);
            if (mmgr.getMetaDataForImplementationOfReference(valueCls, null, clr) != null) {
                return true;
            }
            if (valueCls != null && ClassUtils.isReferenceType(valueCls)) {
                try {
                    impls = this.getImplementationNamesForReferenceField(fmd, 6, clr, mmgr);
                    if (impls != null) {
                        valueCls = clr.classForName(impls[0]);
                        if (ec.getApiAdapter().isPersistable(valueCls)) {
                            return true;
                        }
                    }
                }
                catch (NucleusUserException nue) {}
            }
        } else if (fmd.hasArray()) {
            if (mmgr.getApiAdapter().isPersistable(fmd.getType().getComponentType())) {
                return true;
            }
            String elementType = fmd.getArray().getElementType();
            Class elementCls = clr.classForName(elementType);
            if (mmgr.getApiAdapter().isPersistable(elementCls)) {
                return true;
            }
            if (mmgr.getMetaDataForImplementationOfReference(elementCls, null, clr) != null) {
                return true;
            }
            if (elementCls != null && ClassUtils.isReferenceType(elementCls)) {
                try {
                    String[] impls = this.getImplementationNamesForReferenceField(fmd, 4, clr, mmgr);
                    if (impls != null) {
                        elementCls = clr.classForName(impls[0]);
                        if (ec.getApiAdapter().isPersistable(elementCls)) {
                            return true;
                        }
                    }
                }
                catch (NucleusUserException nue) {}
            }
        } else {
            if (ClassUtils.isReferenceType(fmd.getType()) && mmgr.getMetaDataForImplementationOfReference(fmd.getType(), null, clr) != null) {
                return true;
            }
            if (mmgr.getMetaDataForClass(fmd.getType(), clr) != null) {
                return true;
            }
        }
        return false;
    }

    public boolean storesFCO(AbstractMemberMetaData fmd, ExecutionContext ec) {
        if (fmd == null) {
            return false;
        }
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        MetaDataManager mgr = ec.getMetaDataManager();
        if (fmd.isSerialized() || fmd.isEmbedded()) {
            return false;
        }
        if (fmd.hasCollection() && !fmd.getCollection().isSerializedElement() && !fmd.getCollection().isEmbeddedElement()) {
            if (fmd.getCollection().elementIsPersistent()) {
                return true;
            }
            String elementType = fmd.getCollection().getElementType();
            Class elementCls = clr.classForName(elementType);
            if (elementCls != null && ClassUtils.isReferenceType(elementCls) && mgr.getMetaDataForImplementationOfReference(elementCls, null, clr) != null) {
                return true;
            }
        } else if (fmd.hasMap()) {
            if (fmd.getMap().keyIsPersistent() && !fmd.getMap().isEmbeddedKey() && !fmd.getMap().isSerializedKey()) {
                return true;
            }
            String keyType = fmd.getMap().getKeyType();
            Class keyCls = clr.classForName(keyType);
            if (keyCls != null && ClassUtils.isReferenceType(keyCls) && mgr.getMetaDataForImplementationOfReference(keyCls, null, clr) != null) {
                return true;
            }
            if (fmd.getMap().valueIsPersistent() && !fmd.getMap().isEmbeddedValue() && !fmd.getMap().isSerializedValue()) {
                return true;
            }
            String valueType = fmd.getMap().getValueType();
            Class valueCls = clr.classForName(valueType);
            if (valueCls != null && ClassUtils.isReferenceType(valueCls) && mgr.getMetaDataForImplementationOfReference(valueCls, null, clr) != null) {
                return true;
            }
        } else if (fmd.hasArray() && !fmd.getArray().isSerializedElement() && !fmd.getArray().isEmbeddedElement()) {
            if (mgr.getApiAdapter().isPersistable(fmd.getType().getComponentType())) {
                return true;
            }
        } else {
            if (ClassUtils.isReferenceType(fmd.getType()) && mgr.getMetaDataForImplementationOfReference(fmd.getType(), null, clr) != null) {
                return true;
            }
            if (mgr.getMetaDataForClass(fmd.getType(), clr) != null) {
                return true;
            }
        }
        return false;
    }

    public String[] getValuesForCommaSeparatedAttribute(String attr) {
        if (attr == null || attr.length() == 0) {
            return null;
        }
        String[] values = StringUtils.split(attr, ",");
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = values[i].trim();
            }
        }
        return values;
    }

    public String[] getImplementationNamesForReferenceField(AbstractMemberMetaData fmd, int fieldRole, ClassLoaderResolver clr, MetaDataManager mmgr) {
        Class implCls;
        String[] implTypes = null;
        if (4 == fieldRole) {
            String implTypeStr = fmd.getArray().getElementType();
            if (implTypeStr != null) {
                implTypes = this.getValuesForCommaSeparatedAttribute(implTypeStr);
            }
        } else {
            implTypes = fmd.getFieldTypes();
        }
        if (implTypes != null && implTypes.length == 1 && (implCls = clr.classForName(implTypes[0].trim())).isInterface()) {
            implTypes = mmgr.getClassesImplementingInterface(implTypes[0], clr);
        }
        if (implTypes == null) {
            implTypes = 3 == fieldRole ? fmd.getValuesForExtension("implementation-classes") : (4 == fieldRole ? fmd.getValuesForExtension("implementation-classes") : (5 == fieldRole ? fmd.getValuesForExtension("key-implementation-classes") : (6 == fieldRole ? fmd.getValuesForExtension("value-implementation-classes") : fmd.getValuesForExtension("implementation-classes"))));
        }
        if (implTypes == null) {
            String type = null;
            type = fmd.hasCollection() && fieldRole == 3 ? fmd.getCollection().getElementType() : (fmd.hasMap() && fieldRole == 5 ? fmd.getMap().getKeyType() : (fmd.hasMap() && fieldRole == 6 ? fmd.getMap().getValueType() : (fmd.hasArray() && fieldRole == 4 ? fmd.getType().getComponentType().getName() : fmd.getTypeName())));
            if (!type.equals(ClassNameConstants.Object)) {
                implTypes = mmgr.getClassesImplementingInterface(type, clr);
            }
            if (implTypes == null) {
                throw new InvalidMemberMetaDataException(LOCALISER, "044161", fmd.getClassName(), fmd.getName(), (Object)type);
            }
        }
        int noOfDups = 0;
        block0: for (int i = 0; i < implTypes.length; ++i) {
            for (int j = 0; j < i; ++j) {
                if (!implTypes[j].equals(implTypes[i])) continue;
                ++noOfDups;
                continue block0;
            }
        }
        String[] impls = new String[implTypes.length - noOfDups];
        int n = 0;
        for (int i = 0; i < implTypes.length; ++i) {
            boolean dup = false;
            for (int j = 0; j < i; ++j) {
                if (!implTypes[j].equals(implTypes[i])) continue;
                dup = true;
                break;
            }
            if (dup) continue;
            impls[n++] = implTypes[i];
        }
        return impls;
    }

    public static boolean getBooleanForString(String str, boolean dflt) {
        if (StringUtils.isWhitespace(str)) {
            return dflt;
        }
        return Boolean.parseBoolean(str);
    }

    public static String getClassNameFromDiscriminatorValue(String discrimValue, DiscriminatorMetaData dismd, ExecutionContext ec) {
        if (discrimValue == null) {
            return null;
        }
        String rowClassName = null;
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractClassMetaData baseCmd = (AbstractClassMetaData)((InheritanceMetaData)dismd.getParent()).getParent();
        if (dismd.getStrategy() == DiscriminatorStrategy.CLASS_NAME) {
            rowClassName = discrimValue;
        } else if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
            String className2 = baseCmd.getFullClassName();
            if (dismd.getValue().equals(discrimValue)) {
                rowClassName = className2;
            } else {
                for (String className2 : ec.getStoreManager().getSubClassesForClass(baseCmd.getFullClassName(), true, clr)) {
                    AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(className2, clr);
                    if (!discrimValue.equals(cmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue())) continue;
                    rowClassName = className2;
                    break;
                }
            }
        }
        return rowClassName;
    }

    public static String getValueForExtensionRecursively(MetaData metadata, String key) {
        if (metadata == null) {
            return null;
        }
        String value = metadata.getValueForExtension(key);
        if (value == null) {
            value = MetaDataUtils.getValueForExtensionRecursively(metadata.getParent(), key);
        }
        return value;
    }

    public static String[] getValuesForExtensionRecursively(MetaData metadata, String key) {
        if (metadata == null) {
            return null;
        }
        String[] values = metadata.getValuesForExtension(key);
        if (values == null) {
            values = MetaDataUtils.getValuesForExtensionRecursively(metadata.getParent(), key);
        }
        return values;
    }

    public static boolean isJdbcTypeNumeric(String jdbcType) {
        if (jdbcType == null) {
            return false;
        }
        return jdbcType.equalsIgnoreCase("INTEGER") || jdbcType.equalsIgnoreCase("SMALLINT") || jdbcType.equalsIgnoreCase("TINYINT") || jdbcType.equalsIgnoreCase("NUMERIC") || jdbcType.equalsIgnoreCase("BIGINT");
    }

    public static boolean isJdbcTypeString(String jdbcType) {
        if (jdbcType == null) {
            return false;
        }
        return jdbcType.equalsIgnoreCase("VARCHAR") || jdbcType.equalsIgnoreCase("CHAR") || jdbcType.equalsIgnoreCase("LONGVARCHAR");
    }

    public static List<AbstractClassMetaData> getMetaDataForCandidates(Class cls, boolean subclasses, ExecutionContext ec) {
        ArrayList<AbstractClassMetaData> cmds;
        block5: {
            String[] subclassNames;
            ClassLoaderResolver clr;
            block4: {
                clr = ec.getClassLoaderResolver();
                cmds = new ArrayList<AbstractClassMetaData>();
                if (!cls.isInterface()) break block4;
                InterfaceMetaData icmd = ec.getMetaDataManager().getMetaDataForInterface(cls, clr);
                if (icmd == null) {
                    throw new NucleusUserException("Attempting to query an interface yet it is not declared 'persistent'. Define the interface in metadata as being persistent to perform this operation, and make sure any implementations use the same identity and identity member(s)");
                }
                String[] impls = ec.getMetaDataManager().getClassesImplementingInterface(cls.getName(), clr);
                for (int i = 0; i < impls.length; ++i) {
                    String[] subclassNames2;
                    AbstractClassMetaData implCmd = ec.getMetaDataManager().getMetaDataForClass(impls[i], clr);
                    cmds.add(implCmd);
                    if (!subclasses || (subclassNames2 = ec.getMetaDataManager().getSubclassesForClass(implCmd.getFullClassName(), true)) == null || subclassNames2.length <= 0) continue;
                    for (int j = 0; j < subclassNames2.length; ++j) {
                        AbstractClassMetaData subcmd = ec.getMetaDataManager().getMetaDataForClass(subclassNames2[j], clr);
                        cmds.add(subcmd);
                    }
                }
                break block5;
            }
            AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(cls, clr);
            cmds.add(cmd);
            if (!subclasses || (subclassNames = ec.getMetaDataManager().getSubclassesForClass(cls.getName(), true)) == null || subclassNames.length <= 0) break block5;
            for (int j = 0; j < subclassNames.length; ++j) {
                AbstractClassMetaData subcmd = ec.getMetaDataManager().getMetaDataForClass(subclassNames[j], clr);
                cmds.add(subcmd);
            }
        }
        return cmds;
    }

    public static FileMetaData[] getFileMetaDataForInputFiles(MetaDataManager metaDataMgr, ClassLoaderResolver clr, String[] inputFiles) {
        FileMetaData[] filemds = null;
        String msg = null;
        try {
            int i;
            HashSet<String> metadataFiles = new HashSet<String>();
            HashSet<String> classNames = new HashSet<String>();
            for (int i2 = 0; i2 < inputFiles.length; ++i2) {
                if (inputFiles[i2].endsWith(".class")) {
                    URL classFileURL = null;
                    try {
                        classFileURL = new URL("file:" + inputFiles[i2]);
                    }
                    catch (Exception e) {
                        msg = LOCALISER.msg(false, "014013", (Object)inputFiles[i2]);
                        NucleusLogger.METADATA.error(msg);
                        throw new NucleusUserException(msg);
                    }
                    String className = null;
                    try {
                        className = ClassUtils.getClassNameForFileURL(classFileURL);
                        classNames.add(className);
                    }
                    catch (Throwable e) {
                        className = ClassUtils.getClassNameForFileName(inputFiles[i2], clr);
                        if (className != null) {
                            classNames.add(className);
                            continue;
                        }
                        NucleusLogger.METADATA.info("File \"" + inputFiles[i2] + "\" could not be resolved to a class name, so ignoring." + " Specify it as a class explicitly using persistence.xml to overcome this", e);
                    }
                    continue;
                }
                metadataFiles.add(inputFiles[i2]);
            }
            FileMetaData[] filemds1 = metaDataMgr.loadMetadataFiles(metadataFiles.toArray(new String[metadataFiles.size()]), null);
            FileMetaData[] filemds2 = metaDataMgr.loadClasses(classNames.toArray(new String[classNames.size()]), null);
            filemds = new FileMetaData[filemds1.length + filemds2.length];
            int pos = 0;
            for (i = 0; i < filemds1.length; ++i) {
                filemds[pos++] = filemds1[i];
            }
            for (i = 0; i < filemds2.length; ++i) {
                filemds[pos++] = filemds2[i];
            }
        }
        catch (Exception e) {
            msg = LOCALISER.msg(false, "014014", (Object)e.getMessage());
            NucleusLogger.METADATA.error(msg, e);
            throw new NucleusUserException(msg, e);
        }
        return filemds;
    }

    public static PersistenceFileMetaData[] parsePersistenceFiles(PluginManager pluginMgr, String persistenceFilename, boolean validate, NucleusContext nucCtx) {
        if (persistenceFilename != null) {
            try {
                URL fileURL = new URL(persistenceFilename);
                MetaDataParser parser = new MetaDataParser(null, pluginMgr, validate);
                MetaData permd = parser.parseMetaDataURL(fileURL, "persistence");
                return new PersistenceFileMetaData[]{(PersistenceFileMetaData)permd};
            }
            catch (MalformedURLException mue) {
                NucleusLogger.METADATA.error("Error reading user-specified persistence.xml file " + persistenceFilename, mue);
                return null;
            }
        }
        LinkedHashSet<MetaData> metadata = new LinkedHashSet<MetaData>();
        ClassLoaderResolver clr = nucCtx != null ? nucCtx.getClassLoaderResolver(null) : new JDOClassLoaderResolver();
        try {
            Enumeration<URL> files = clr.getResources("META-INF/persistence.xml", Thread.currentThread().getContextClassLoader());
            if (!files.hasMoreElements()) {
                return null;
            }
            MetaDataParser parser = null;
            while (files.hasMoreElements()) {
                URL fileURL = files.nextElement();
                if (parser == null) {
                    parser = new MetaDataParser(null, pluginMgr, validate);
                }
                MetaData permd = parser.parseMetaDataURL(fileURL, "persistence");
                metadata.add(permd);
            }
        }
        catch (IOException ioe) {
            NucleusLogger.METADATA.warn(StringUtils.getStringFromStackTrace(ioe));
        }
        return metadata.toArray(new PersistenceFileMetaData[metadata.size()]);
    }

    public static boolean persistColumnAsNumeric(ColumnMetaData colmd) {
        String jdbc;
        boolean useLong = false;
        String string = jdbc = colmd != null ? colmd.getJdbcType() : null;
        if (jdbc != null && (jdbc.equalsIgnoreCase("int") || jdbc.equalsIgnoreCase("integer"))) {
            useLong = true;
        }
        return useLong;
    }

    public static Class getTypeOfDatastoreIdentity(IdentityMetaData idmd) {
        if (idmd == null) {
            return Long.TYPE;
        }
        if (idmd.getValueStrategy() == IdentityStrategy.UUIDHEX || idmd.getValueStrategy() == IdentityStrategy.UUIDSTRING) {
            return String.class;
        }
        return Long.TYPE;
    }

    public static boolean isMemberEmbedded(AbstractMemberMetaData mmd, int relationType, ClassLoaderResolver clr, MetaDataManager mmgr) {
        boolean embedded = false;
        if (mmd.isEmbedded()) {
            embedded = true;
        } else if (mmd.getEmbeddedMetaData() != null) {
            embedded = true;
        } else if (Relation.isRelationMultiValued(relationType)) {
            if (mmd.hasCollection() && mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null) {
                embedded = true;
            } else if (mmd.hasArray() && mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null) {
                embedded = true;
            } else if (mmd.hasMap() && (mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getEmbeddedMetaData() != null || mmd.getValueMetaData() != null && mmd.getValueMetaData().getEmbeddedMetaData() != null)) {
                embedded = true;
            }
        } else if (Relation.isRelationSingleValued(relationType)) {
            AbstractClassMetaData mmdCmd = mmgr.getMetaDataForClass(mmd.getType(), clr);
            if (mmdCmd != null && mmdCmd.isEmbeddedOnly()) {
                embedded = true;
            }
        } else if (Relation.isRelationMultiValued(relationType)) {
            // empty if block
        }
        return embedded;
    }
}

