/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.jdo.JDOUserException;
import org.datanucleus.ClassConstants;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.util.Localiser;

public abstract class AbstractQueryResult
extends AbstractList
implements QueryResult,
Serializable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected boolean closed = false;
    protected Query query;
    protected List<ManagedConnectionResourceListener> connectionListeners = null;
    String api = "JDO";
    protected int size = -1;
    protected String resultSizeMethod = "last";
    protected boolean loadResultsAtCommit = true;

    public AbstractQueryResult(Query query) {
        this.query = query;
        if (query != null) {
            this.api = query.getExecutionContext().getApiAdapter().getName();
            this.resultSizeMethod = query.getStringExtensionProperty("datanucleus.query.resultSizeMethod", "last");
            this.loadResultsAtCommit = query.getBooleanExtensionProperty("datanucleus.query.loadResultsAtCommit", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (this.query == null) {
            return;
        }
        try {
            this.closingConnection();
            this.closeResults();
        }
        finally {
            this.query = null;
        }
    }

    protected abstract void closingConnection();

    protected abstract void closeResults();

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closeResults();
        this.query = null;
        this.closed = true;
        if (this.connectionListeners != null) {
            Iterator<ManagedConnectionResourceListener> iter = this.connectionListeners.iterator();
            while (iter.hasNext()) {
                iter.next().resourcePostClose();
            }
            this.connectionListeners.clear();
            this.connectionListeners = null;
        }
    }

    public void addConnectionListener(ManagedConnectionResourceListener listener) {
        if (this.connectionListeners == null) {
            this.connectionListeners = new ArrayList<ManagedConnectionResourceListener>();
        }
        this.connectionListeners.add(listener);
    }

    protected boolean isOpen() {
        return !this.closed;
    }

    protected void assertIsOpen() {
        if (!this.isOpen()) {
            String msg = LOCALISER.msg("052600");
            if (this.api.equalsIgnoreCase("JDO")) {
                throw new JDOUserException(msg);
            }
            throw new NucleusUserException(msg);
        }
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException(LOCALISER.msg("052603"));
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException(LOCALISER.msg("052603"));
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException(LOCALISER.msg("052603"));
    }

    public void clear() {
        throw new UnsupportedOperationException(LOCALISER.msg("052603"));
    }

    public boolean contains(Object o) {
        throw new UnsupportedOperationException(LOCALISER.msg("052604"));
    }

    public boolean containsAll(Collection c) {
        throw new UnsupportedOperationException(LOCALISER.msg("052604"));
    }

    public abstract boolean equals(Object var1);

    public abstract Object get(int var1);

    public int hashCode() {
        if (this.query != null) {
            return this.query.hashCode();
        }
        return super.hashCode();
    }

    public int indexOf(Object o) {
        throw new UnsupportedOperationException(LOCALISER.msg("052604"));
    }

    public boolean isEmpty() {
        return this.size() < 1;
    }

    public abstract Iterator iterator();

    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException(LOCALISER.msg("052604"));
    }

    public abstract ListIterator listIterator();

    public Object remove(int index) {
        throw new UnsupportedOperationException(LOCALISER.msg("052603"));
    }

    public Object set(int index, Object element) {
        throw new UnsupportedOperationException(LOCALISER.msg("052603"));
    }

    public int size() {
        this.assertIsOpen();
        if (this.size < 0) {
            this.size = this.getSizeUsingMethod();
        }
        return this.size;
    }

    public List subList(int fromIndex, int toIndex) {
        int subListLength = toIndex - fromIndex;
        ArrayList<Object> subList = new ArrayList<Object>(subListLength);
        for (int i = fromIndex; i < toIndex; ++i) {
            subList.add(this.get(i));
        }
        return subList;
    }

    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public Object[] toArray(Object[] a) {
        int theSize = this.size();
        if (a.length >= theSize) {
            for (int i = 0; i < a.length; ++i) {
                a[i] = i < theSize ? this.get(i) : null;
            }
            return a;
        }
        return this.toArray();
    }

    protected int getSizeUsingMethod() {
        if (this.resultSizeMethod.equalsIgnoreCase("COUNT")) {
            if (this.query != null && this.query.getCompilation() != null) {
                ExecutionContext ec = this.query.getExecutionContext();
                if (this.query.getCompilation().getQueryLanguage().equalsIgnoreCase("JDOQL")) {
                    long rangeEnd;
                    long rangeStart;
                    Query countQuery = this.query.getStoreManager().getQueryManager().newQuery("JDOQL", ec, this.query);
                    if (this.query.getResultDistinct()) {
                        countQuery.setResult("COUNT(DISTINCT this)");
                    } else {
                        countQuery.setResult("count(this)");
                    }
                    countQuery.setOrdering(null);
                    countQuery.setRange(null);
                    Map queryParams = this.query.getInputParameters();
                    long count = queryParams != null ? ((Long)countQuery.executeWithMap(queryParams)).longValue() : ((Long)countQuery.execute()).longValue();
                    if (this.query.getRange() != null && (count -= (rangeStart = this.query.getRangeFromIncl())) > (rangeEnd = this.query.getRangeToExcl()) - rangeStart) {
                        count = rangeEnd - rangeStart;
                    }
                    countQuery.closeAll();
                    return (int)count;
                }
                if (this.query.getCompilation().getQueryLanguage().equalsIgnoreCase("JPQL")) {
                    long rangeEnd;
                    long rangeStart;
                    Query countQuery = this.query.getStoreManager().getQueryManager().newQuery("JPQL", ec, this.query);
                    countQuery.setResult("count(" + this.query.getCompilation().getCandidateAlias() + ")");
                    countQuery.setOrdering(null);
                    countQuery.setRange(null);
                    Map queryParams = this.query.getInputParameters();
                    long count = queryParams != null ? ((Long)countQuery.executeWithMap(queryParams)).longValue() : ((Long)countQuery.execute()).longValue();
                    if (this.query.getRange() != null && (count -= (rangeStart = this.query.getRangeFromIncl())) > (rangeEnd = this.query.getRangeToExcl()) - rangeStart) {
                        count = rangeEnd - rangeStart;
                    }
                    countQuery.closeAll();
                    return (int)count;
                }
            }
            throw new NucleusUserException("datanucleus.query.resultSizeMethod of \"COUNT\" is only valid for use with JDOQL or JPQL currently");
        }
        throw new NucleusUserException("DataNucleus doesnt currently support any method \"" + this.resultSizeMethod + "\" for determining the size of the query results");
    }
}

