/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.state.ActivityState;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.BackedSCOStoreManager;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.exceptions.NoTableManagedException;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.MappedStoreData;
import org.datanucleus.store.mapped.MappedTypeManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.mapping.ArrayMapping;
import org.datanucleus.store.mapped.mapping.CollectionMapping;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MapMapping;
import org.datanucleus.store.mapped.mapping.MappingManager;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.scostore.ArrayStore;
import org.datanucleus.store.scostore.CollectionStore;
import org.datanucleus.store.scostore.ListStore;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.store.scostore.PersistableRelationStore;
import org.datanucleus.store.scostore.SetStore;
import org.datanucleus.store.scostore.Store;
import org.datanucleus.store.types.sco.IncompatibleFieldTypeException;
import org.datanucleus.store.types.sco.SCOUtils;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MappedStoreManager
extends AbstractStoreManager
implements BackedSCOStoreManager {
    protected DatastoreAdapter dba;
    protected IdentifierFactory identifierFactory;
    protected String catalogName = null;
    protected String schemaName = null;
    protected Map<DatastoreIdentifier, DatastoreContainerObject> datastoreContainerByIdentifier = new ConcurrentHashMap<DatastoreIdentifier, DatastoreContainerObject>();
    protected MappedTypeManager mappedTypeMgr = null;
    protected MappingManager mappingManager;
    protected Map<ObjectProvider, DatastoreClass> insertedDatastoreClassByStateManager = new ConcurrentHashMap<ObjectProvider, DatastoreClass>();
    protected ReadWriteLock schemaLock = new ReentrantReadWriteLock();

    protected MappedStoreManager(String key, ClassLoaderResolver clr, NucleusContext nucleusContext, Map<String, Object> props) {
        super(key, clr, nucleusContext, props);
        this.mappedTypeMgr = new MappedTypeManager(nucleusContext);
    }

    @Override
    public void close() {
        this.dba = null;
        super.close();
    }

    protected void initialiseIdentifierFactory(NucleusContext nucleusContext) {
        if (this.dba == null) {
            throw new NucleusException("DatastoreAdapter not yet created so cannot create IdentifierFactory!");
        }
        String idFactoryName = this.getStringProperty("datanucleus.identifierFactory");
        String idFactoryClassName = nucleusContext.getPluginManager().getAttributeValueForExtension("org.datanucleus.store_identifierfactory", "name", idFactoryName, "class-name");
        if (idFactoryClassName == null) {
            throw new NucleusUserException(LOCALISER.msg("039003", (Object)idFactoryName)).setFatal();
        }
        try {
            String val;
            HashMap<String, String> props = new HashMap<String, String>();
            if (this.catalogName != null) {
                props.put("DefaultCatalog", this.catalogName);
            }
            if (this.schemaName != null) {
                props.put("DefaultSchema", this.schemaName);
            }
            if ((val = this.getStringProperty("datanucleus.identifier.case")) != null) {
                props.put("RequiredCase", val);
            } else {
                props.put("RequiredCase", this.getDefaultIdentifierCase());
            }
            val = this.getStringProperty("datanucleus.identifier.wordSeparator");
            if (val != null) {
                props.put("WordSeparator", val);
            }
            if ((val = this.getStringProperty("datanucleus.identifier.tablePrefix")) != null) {
                props.put("TablePrefix", val);
            }
            if ((val = this.getStringProperty("datanucleus.identifier.tableSuffix")) != null) {
                props.put("TableSuffix", val);
            }
            Class[] argTypes = new Class[]{DatastoreAdapter.class, ClassConstants.CLASS_LOADER_RESOLVER, Map.class};
            Object[] args = new Object[]{this.dba, nucleusContext.getClassLoaderResolver(null), props};
            this.identifierFactory = (IdentifierFactory)nucleusContext.getPluginManager().createExecutableExtension("org.datanucleus.store_identifierfactory", "name", idFactoryName, "class-name", argTypes, args);
        }
        catch (ClassNotFoundException cnfe) {
            throw new NucleusUserException(LOCALISER.msg("039004", (Object)idFactoryName, (Object)idFactoryClassName), cnfe).setFatal();
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error("Exception creating IdentifierFactory", e);
            throw new NucleusException(LOCALISER.msg("039005", (Object)idFactoryClassName), e).setFatal();
        }
    }

    @Override
    public boolean supportsValueStrategy(String strategy) {
        if (strategy.equalsIgnoreCase("IDENTITY") || super.supportsValueStrategy(strategy)) {
            if (strategy.equalsIgnoreCase("IDENTITY") && !this.dba.supportsOption("IdentityColumns")) {
                return false;
            }
            return !strategy.equalsIgnoreCase("SEQUENCE") || this.dba.supportsOption("Sequences");
        }
        return false;
    }

    public MappedTypeManager getMappedTypeManager() {
        return this.mappedTypeMgr;
    }

    public IdentifierFactory getIdentifierFactory() {
        return this.identifierFactory;
    }

    public DatastoreAdapter getDatastoreAdapter() {
        return this.dba;
    }

    public MappingManager getMappingManager() {
        if (this.mappingManager == null) {
            this.mappingManager = this.dba.getMappingManager(this);
        }
        return this.mappingManager;
    }

    public abstract DatastoreContainerObject newJoinDatastoreContainerObject(AbstractMemberMetaData var1, ClassLoaderResolver var2);

    public synchronized StoreData[] getStoreDataForDatastoreContainerObject(DatastoreIdentifier tableIdentifier) {
        return this.storeDataMgr.getStoreDataForProperties("tableId", tableIdentifier, "table-owner", "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastoreContainerObject getDatastoreContainerObject(AbstractMemberMetaData mmd) {
        block3: {
            this.schemaLock.readLock().lock();
            try {
                StoreData sd = this.storeDataMgr.get(mmd);
                if (sd == null || !(sd instanceof MappedStoreData)) break block3;
                DatastoreContainerObject datastoreContainerObject = ((MappedStoreData)sd).getDatastoreContainerObject();
                Object var5_5 = null;
                this.schemaLock.readLock().unlock();
                return datastoreContainerObject;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.schemaLock.readLock().unlock();
                throw throwable;
            }
        }
        DatastoreContainerObject datastoreContainerObject = null;
        Object var5_6 = null;
        this.schemaLock.readLock().unlock();
        return datastoreContainerObject;
    }

    public void addDatastoreContainer(DatastoreContainerObject table) {
        if (table != null && this.datastoreContainerByIdentifier.get(table.getIdentifier()) == null) {
            this.datastoreContainerByIdentifier.put(table.getIdentifier(), table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastoreClass getDatastoreClass(String className, ClassLoaderResolver clr) {
        DatastoreClass ct;
        block12: {
            ct = null;
            if (className == null) {
                NucleusLogger.PERSISTENCE.error(LOCALISER.msg("032015"));
                return null;
            }
            this.schemaLock.readLock().lock();
            try {
                StoreData sd = this.storeDataMgr.get(className);
                if (sd == null || !(sd instanceof MappedStoreData) || (ct = (DatastoreClass)((MappedStoreData)sd).getDatastoreContainerObject()) == null) break block12;
                DatastoreClass datastoreClass = ct;
                Object var7_9 = null;
                this.schemaLock.readLock().unlock();
                return datastoreClass;
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                this.schemaLock.readLock().unlock();
                throw throwable;
            }
        }
        Object var7_10 = null;
        this.schemaLock.readLock().unlock();
        boolean toBeAdded = false;
        if (clr != null) {
            Class cls = clr.classForName(className);
            ApiAdapter api = this.getApiAdapter();
            if (cls != null && !cls.isInterface() && api.isPersistable(cls)) {
                toBeAdded = true;
            }
        } else {
            toBeAdded = true;
        }
        boolean classKnown = false;
        if (toBeAdded) {
            this.addClass(className, clr);
            this.schemaLock.readLock().lock();
            try {
                StoreData sd = this.storeDataMgr.get(className);
                if (sd != null && sd instanceof MappedStoreData) {
                    classKnown = true;
                    ct = (DatastoreClass)((MappedStoreData)sd).getDatastoreContainerObject();
                }
                Object var9_14 = null;
                this.schemaLock.readLock().unlock();
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                this.schemaLock.readLock().unlock();
                throw throwable;
            }
        }
        if (!classKnown && ct == null) {
            throw new NoTableManagedException(className);
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatastoreClass getDatastoreClass(DatastoreIdentifier name) {
        DatastoreClass datastoreClass;
        this.schemaLock.readLock().lock();
        try {
            for (StoreData sd : this.storeDataMgr.getManagedStoreData()) {
                MappedStoreData tsd;
                if (!(sd instanceof MappedStoreData) || !(tsd = (MappedStoreData)sd).hasTable() || !tsd.getDatastoreIdentifier().equals(name)) continue;
                DatastoreClass datastoreClass2 = (DatastoreClass)tsd.getDatastoreContainerObject();
                Object var7_6 = null;
                this.schemaLock.readLock().unlock();
                return datastoreClass2;
            }
            datastoreClass = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.schemaLock.readLock().unlock();
            throw throwable;
        }
        Object var7_7 = null;
        this.schemaLock.readLock().unlock();
        return datastoreClass;
    }

    public AbstractClassMetaData getClassWithPrimaryKeyForClass(AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        if (cmd == null) {
            return null;
        }
        if (cmd.getSuperAbstractClassMetaData() == null) {
            return cmd;
        }
        if (this.getDatastoreClass(cmd.getFullClassName(), clr) != null) {
            return cmd;
        }
        return this.getClassWithPrimaryKeyForClass(cmd.getSuperAbstractClassMetaData(), clr);
    }

    public AbstractClassMetaData[] getClassesManagingTableForClass(AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        if (cmd == null) {
            return null;
        }
        if (cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE || cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.NEW_TABLE) {
            return new AbstractClassMetaData[]{cmd};
        }
        if (cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
            int i;
            String[] subclasses = this.getMetaDataManager().getSubclassesForClass(cmd.getFullClassName(), true);
            if (subclasses != null) {
                for (int i2 = 0; i2 < subclasses.length; ++i2) {
                    if (this.storeDataMgr.managesClass(subclasses[i2])) continue;
                    this.addClass(subclasses[i2], clr);
                }
            }
            HashSet<AbstractClassMetaData> managingClasses = new HashSet<AbstractClassMetaData>();
            for (StoreData data : this.storeDataMgr.getManagedStoreData()) {
                AbstractClassMetaData[] superCmds;
                if (!data.isFCO() || ((AbstractClassMetaData)data.getMetaData()).getSuperAbstractClassMetaData() == null || !((AbstractClassMetaData)data.getMetaData()).getSuperAbstractClassMetaData().getFullClassName().equals(cmd.getFullClassName()) || (superCmds = this.getClassesManagingTableForClass((AbstractClassMetaData)data.getMetaData(), clr)) == null) continue;
                for (i = 0; i < superCmds.length; ++i) {
                    managingClasses.add(superCmds[i]);
                }
            }
            Iterator managingClassesIter = managingClasses.iterator();
            AbstractClassMetaData[] managingCmds = new AbstractClassMetaData[managingClasses.size()];
            i = 0;
            while (managingClassesIter.hasNext()) {
                managingCmds[i++] = (AbstractClassMetaData)managingClassesIter.next();
            }
            return managingCmds;
        }
        if (cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUPERCLASS_TABLE) {
            return this.getClassesManagingTableForClass(cmd.getSuperAbstractClassMetaData(), clr);
        }
        return null;
    }

    public boolean isObjectInserted(ObjectProvider sm, int fieldNumber) {
        if (sm == null) {
            return false;
        }
        if (!sm.isInserting()) {
            return true;
        }
        DatastoreClass latestTable = this.insertedDatastoreClassByStateManager.get(sm);
        if (latestTable == null) {
            return false;
        }
        AbstractMemberMetaData mmd = sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd == null) {
            return false;
        }
        String className = mmd.getClassName();
        if (mmd.isPrimaryKey()) {
            className = sm.getObject().getClass().getName();
        }
        for (DatastoreClass datastoreCls = latestTable; datastoreCls != null; datastoreCls = datastoreCls.getSuperDatastoreClass()) {
            if (!datastoreCls.managesClass(className)) continue;
            return true;
        }
        return false;
    }

    public boolean isObjectInserted(ObjectProvider sm, String className) {
        if (sm == null) {
            return false;
        }
        if (!sm.isInserting()) {
            return false;
        }
        DatastoreClass latestTable = this.insertedDatastoreClassByStateManager.get(sm);
        if (latestTable != null) {
            for (DatastoreClass datastoreCls = latestTable; datastoreCls != null; datastoreCls = datastoreCls.getSuperDatastoreClass()) {
                if (!datastoreCls.managesClass(className)) continue;
                return true;
            }
        }
        return false;
    }

    public void setObjectIsInsertedToLevel(ObjectProvider sm, DatastoreClass table) {
        this.insertedDatastoreClassByStateManager.put(sm, table);
        if (table.managesClass(sm.getClassMetaData().getFullClassName())) {
            sm.changeActivityState(ActivityState.INSERTING_CALLBACKS);
            this.insertedDatastoreClassByStateManager.remove(sm);
        }
    }

    @Override
    public Store getBackingStoreForField(ClassLoaderResolver clr, AbstractMemberMetaData mmd, Class type) {
        if (mmd == null || mmd != null && mmd.isSerialized()) {
            return null;
        }
        if (mmd.getMap() != null) {
            this.assertCompatibleFieldType(mmd, clr, type, MapMapping.class);
            return this.getBackingStoreForMap(mmd, clr);
        }
        if (mmd.getArray() != null) {
            this.assertCompatibleFieldType(mmd, clr, type, ArrayMapping.class);
            return this.getBackingStoreForArray(mmd, clr);
        }
        if (mmd.getCollection() != null) {
            this.assertCompatibleFieldType(mmd, clr, type, CollectionMapping.class);
            return this.getBackingStoreForCollection(mmd, clr, type);
        }
        this.assertCompatibleFieldType(mmd, clr, type, PersistableMapping.class);
        return this.getBackingStoreForPersistableRelation(mmd, clr, type);
    }

    private void assertCompatibleFieldType(AbstractMemberMetaData mmd, ClassLoaderResolver clr, Class type, Class expectedMappingType) {
        JavaTypeMapping m;
        AbstractClassMetaData fieldTypeCmd;
        AbstractClassMetaData[] tableOwnerCmds;
        DatastoreClass ownerTable = this.getDatastoreClass(mmd.getClassName(), clr);
        if (ownerTable == null && (tableOwnerCmds = this.getClassesManagingTableForClass(fieldTypeCmd = this.getMetaDataManager().getMetaDataForClass(mmd.getClassName(), clr), clr)) != null && tableOwnerCmds.length == 1) {
            ownerTable = this.getDatastoreClass(tableOwnerCmds[0].getFullClassName(), clr);
        }
        if (ownerTable != null && !expectedMappingType.isAssignableFrom((m = ownerTable.getMemberMapping(mmd)).getClass())) {
            throw new IncompatibleFieldTypeException(mmd.getFullFieldName(), type.getName(), mmd.getTypeName());
        }
    }

    private CollectionStore getBackingStoreForCollection(AbstractMemberMetaData mmd, ClassLoaderResolver clr, Class type) {
        CollectionStore store = null;
        DatastoreContainerObject datastoreTable = this.getDatastoreContainerObject(mmd);
        store = type == null ? (datastoreTable == null ? (List.class.isAssignableFrom(mmd.getType()) ? this.newFKListStore(mmd, clr) : this.newFKSetStore(mmd, clr)) : (List.class.isAssignableFrom(mmd.getType()) ? this.newJoinListStore(mmd, clr, datastoreTable) : this.newJoinSetStore(mmd, clr, datastoreTable))) : (datastoreTable == null ? (SCOUtils.isListBased(type) ? this.newFKListStore(mmd, clr) : this.newFKSetStore(mmd, clr)) : (SCOUtils.isListBased(type) ? this.newJoinListStore(mmd, clr, datastoreTable) : this.newJoinSetStore(mmd, clr, datastoreTable)));
        return store;
    }

    private MapStore getBackingStoreForMap(AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        MapStore store = null;
        DatastoreContainerObject datastoreTable = this.getDatastoreContainerObject(mmd);
        store = datastoreTable == null ? this.newFKMapStore(mmd, clr) : this.newJoinMapStore(mmd, clr, datastoreTable);
        return store;
    }

    private ArrayStore getBackingStoreForArray(AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        DatastoreContainerObject datastoreTable = this.getDatastoreContainerObject(mmd);
        ArrayStore store = datastoreTable != null ? this.newJoinArrayStore(mmd, clr, datastoreTable) : this.newFKArrayStore(mmd, clr);
        return store;
    }

    private PersistableRelationStore getBackingStoreForPersistableRelation(AbstractMemberMetaData mmd, ClassLoaderResolver clr, Class type) {
        PersistableRelationStore store = null;
        DatastoreContainerObject datastoreTable = this.getDatastoreContainerObject(mmd);
        store = this.newPersistableRelationStore(mmd, clr, datastoreTable);
        return store;
    }

    public abstract FieldManager getFieldManagerForResultProcessing(ObjectProvider var1, Object var2, StatementClassMapping var3);

    public abstract FieldManager getFieldManagerForResultProcessing(ExecutionContext var1, Object var2, StatementClassMapping var3, AbstractClassMetaData var4);

    public abstract FieldManager getFieldManagerForStatementGeneration(ObjectProvider var1, Object var2, StatementClassMapping var3, boolean var4);

    public abstract Object getResultValueAtPosition(Object var1, JavaTypeMapping var2, int var3);

    public abstract boolean insertValuesOnInsert(DatastoreMapping var1);

    public abstract boolean allowsBatching();

    public abstract ResultObjectFactory newResultObjectFactory(AbstractClassMetaData var1, StatementClassMapping var2, boolean var3, FetchPlan var4, Class var5);

    protected ArrayStore newFKArrayStore(AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        throw new UnsupportedOperationException("FK Arrays not supported.");
    }

    protected ListStore newFKListStore(AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        throw new UnsupportedOperationException("FK Lists not supported.");
    }

    protected SetStore newFKSetStore(AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        throw new UnsupportedOperationException("FK Sets not supported.");
    }

    protected MapStore newFKMapStore(AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        throw new UnsupportedOperationException("FK Maps not supported.");
    }

    protected ArrayStore newJoinArrayStore(AbstractMemberMetaData mmd, ClassLoaderResolver clr, DatastoreContainerObject joinTable) {
        throw new UnsupportedOperationException("Join Arrays not supported.");
    }

    protected MapStore newJoinMapStore(AbstractMemberMetaData mmd, ClassLoaderResolver clr, DatastoreContainerObject joinTable) {
        throw new UnsupportedOperationException("Join Maps not supported.");
    }

    protected ListStore newJoinListStore(AbstractMemberMetaData mmd, ClassLoaderResolver clr, DatastoreContainerObject joinTable) {
        throw new UnsupportedOperationException("Join Lists not supported.");
    }

    protected SetStore newJoinSetStore(AbstractMemberMetaData mmd, ClassLoaderResolver clr, DatastoreContainerObject joinTable) {
        throw new UnsupportedOperationException("Join Sets not supported.");
    }

    protected PersistableRelationStore newPersistableRelationStore(AbstractMemberMetaData mmd, ClassLoaderResolver clr, DatastoreContainerObject joinTable) {
        throw new UnsupportedOperationException("Join N-1 relations not supported.");
    }

    public String getDefaultIdentifierCase() {
        return "UPPERCASE";
    }
}

