/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.ObjectStringConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateStringConverter
implements ObjectStringConverter<Date> {
    static SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");

    @Override
    public Date toObject(String str) {
        if (str == null) {
            return null;
        }
        try {
            return format.parse(str);
        }
        catch (ParseException pe) {
            throw new NucleusDataStoreException(LOCALISER.msg("016002", (Object)str, (Object)Date.class.getName()), pe);
        }
    }

    @Override
    public String toString(Date date) {
        return date != null ? format.format(date) : null;
    }
}

