/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.datanucleus.NucleusContext;
import org.datanucleus.ObjectManagerImpl;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.WeakValueMap;

public class WeakLevel2Cache
implements Level2Cache {
    private static Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerImpl.class.getClassLoader());
    protected Collection pinnedClasses;
    protected Collection pinnedIds;
    protected Map pinnedCache;
    protected transient Map unpinnedCache;
    protected ApiAdapter apiAdapter;
    private int maxSize = -1;

    protected WeakLevel2Cache() {
    }

    public WeakLevel2Cache(NucleusContext nucleusCtx) {
        this.apiAdapter = nucleusCtx.getApiAdapter();
        this.pinnedCache = new HashMap();
        this.unpinnedCache = new WeakValueMap();
        this.maxSize = nucleusCtx.getPersistenceConfiguration().getIntProperty("datanucleus.cache.level2.maxSize");
    }

    public void close() {
        this.evictAll();
        this.pinnedCache = null;
        this.unpinnedCache = null;
    }

    public synchronized void evict(Object oid) {
        if (oid == null) {
            return;
        }
        this.unpinnedCache.remove(oid);
        this.pinnedCache.remove(oid);
    }

    public synchronized void evictAll() {
        this.unpinnedCache.clear();
        this.pinnedCache.clear();
    }

    public synchronized void evictAll(Class pcClass, boolean subclasses) {
        if (pcClass == null) {
            return;
        }
        HashSet oidsToEvict = new HashSet();
        Set pinnedObjects = this.pinnedCache.entrySet();
        for (Map.Entry entry : pinnedObjects) {
            CachedPC pc = (CachedPC)entry.getValue();
            if (!pcClass.getName().equals(pc.getPCClass().getName()) && (!subclasses || !pcClass.isAssignableFrom(pc.getPCClass()))) continue;
            oidsToEvict.add(entry.getKey());
        }
        Set set = this.unpinnedCache.entrySet();
        for (Map.Entry entry : set) {
            CachedPC pc = (CachedPC)entry.getValue();
            if ((pc == null || !pcClass.getName().equals(pc.getPCClass().getName())) && (!subclasses || !pcClass.isAssignableFrom(pc.getPCClass()))) continue;
            oidsToEvict.add(entry.getKey());
        }
        if (!oidsToEvict.isEmpty()) {
            this.evictAll(oidsToEvict);
        }
    }

    public synchronized void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    public synchronized void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.evict(oids[i]);
        }
    }

    public synchronized void pin(Object oid) {
        if (oid == null) {
            return;
        }
        if (this.pinnedIds == null) {
            this.pinnedIds = new HashSet();
        } else if (!this.pinnedIds.contains(oid)) {
            this.pinnedIds.add(oid);
        }
        Object pc = this.unpinnedCache.get(oid);
        if (pc != null) {
            this.pinnedCache.put(oid, pc);
            this.unpinnedCache.remove(oid);
        }
    }

    public synchronized void pinAll(Class cls, boolean subs) {
        Level2Cache.PinnedClass pinnedCls;
        if (cls == null) {
            return;
        }
        if (this.pinnedClasses == null) {
            this.pinnedClasses = new HashSet();
        }
        if (this.pinnedClasses.contains(pinnedCls = new Level2Cache.PinnedClass(cls, subs))) {
            return;
        }
        this.pinnedClasses.add(pinnedCls);
        Collection unpinnedObjects = this.unpinnedCache.values();
        for (CachedPC obj : unpinnedObjects) {
            if ((!subs || !cls.isInstance(obj.getPCClass())) && !cls.getName().equals(obj.getPCClass().getName())) continue;
            this.pin(obj);
        }
    }

    public synchronized void pinAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.pin(iter.next());
        }
    }

    public synchronized void pinAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.pin(oids[i]);
        }
    }

    public synchronized void unpin(Object oid) {
        if (oid == null) {
            return;
        }
        Object pc = this.pinnedCache.get(oid);
        if (pc != null) {
            this.unpinnedCache.put(oid, pc);
            this.pinnedCache.remove(oid);
        }
        if (this.pinnedIds != null && this.pinnedIds.contains(oid)) {
            this.pinnedIds.remove(oid);
        }
    }

    public synchronized void unpinAll(Class cls, boolean subs) {
        if (cls == null) {
            return;
        }
        if (this.pinnedClasses != null) {
            Level2Cache.PinnedClass pinnedCls = new Level2Cache.PinnedClass(cls, subs);
            this.pinnedClasses.remove(pinnedCls);
        }
        Collection pinnedObjects = this.pinnedCache.values();
        for (CachedPC obj : pinnedObjects) {
            if ((!subs || !cls.isInstance(obj.getPCClass())) && !cls.getName().equals(obj.getPCClass().getName())) continue;
            this.unpin(obj);
        }
    }

    public synchronized void unpinAll(Collection oids) {
        if (oids == null) {
            return;
        }
        Iterator iter = oids.iterator();
        while (iter.hasNext()) {
            this.unpin(iter.next());
        }
    }

    public synchronized void unpinAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        for (int i = 0; i < oids.length; ++i) {
            this.unpin(oids[i]);
        }
    }

    public synchronized CachedPC get(Object oid) {
        if (oid == null) {
            return null;
        }
        CachedPC pc = (CachedPC)this.pinnedCache.get(oid);
        if (pc != null) {
            return pc;
        }
        pc = (CachedPC)this.unpinnedCache.get(oid);
        return pc;
    }

    public int getNumberOfPinnedObjects() {
        return this.pinnedCache.size();
    }

    public int getNumberOfUnpinnedObjects() {
        return this.unpinnedCache.size();
    }

    public int getSize() {
        return this.getNumberOfPinnedObjects() + this.getNumberOfUnpinnedObjects();
    }

    public synchronized CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            NucleusLogger.CACHE.warn(LOCALISER.msg("004011"));
            return null;
        }
        if (this.maxSize >= 0 && this.getSize() == this.maxSize) {
            return null;
        }
        if (this.apiAdapter.isManaged(pc.getPersistableObject())) {
            NucleusLogger.CACHE.error(LOCALISER.msg("004012", oid));
            return null;
        }
        boolean toBePinned = false;
        if (this.pinnedClasses != null) {
            for (Level2Cache.PinnedClass pinCls : this.pinnedClasses) {
                if (!pinCls.cls.getName().equals(pc.getPCClass().getName()) && (!pinCls.subclasses || !pinCls.cls.isAssignableFrom(pc.getPCClass()))) continue;
                toBePinned = true;
                break;
            }
        }
        if (this.pinnedIds != null && this.pinnedIds.contains(oid)) {
            toBePinned = true;
        }
        CachedPC obj = null;
        if (this.pinnedCache.get(oid) != null) {
            obj = this.pinnedCache.put(oid, pc);
            if (obj != null) {
                return obj;
            }
        } else if (toBePinned) {
            this.pinnedCache.put(oid, pc);
            this.unpinnedCache.remove(oid);
        } else {
            obj = this.unpinnedCache.put(oid, pc);
            if (obj != null) {
                return obj;
            }
        }
        return null;
    }

    public boolean containsOid(Object oid) {
        return this.pinnedCache.containsKey(oid) || this.unpinnedCache.containsKey(oid);
    }

    public boolean isEmpty() {
        return this.pinnedCache.isEmpty() && this.unpinnedCache.isEmpty();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.unpinnedCache = new WeakValueMap();
    }
}

