/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.transaction.Synchronization;
import org.datanucleus.ClassConstants;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.TransactionActiveOnBeginException;
import org.datanucleus.exceptions.TransactionNotActiveException;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.transaction.HeuristicMixedException;
import org.datanucleus.transaction.HeuristicRollbackException;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.transaction.RollbackException;
import org.datanucleus.transaction.Transaction;
import org.datanucleus.transaction.TransactionManager;
import org.datanucleus.transaction.TransactionUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionImpl
implements org.datanucleus.Transaction {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    ExecutionContext ec;
    TransactionManager txnMgr;
    boolean active = false;
    boolean committing;
    Synchronization sync;
    protected boolean retainValues;
    protected boolean restoreValues;
    protected boolean optimistic;
    protected boolean nontransactionalRead;
    protected boolean nontransactionalWrite;
    protected boolean rollbackOnly = false;
    protected Boolean serializeRead = null;
    private Set<TransactionEventListener> listenersPerTransaction = new HashSet<TransactionEventListener>();
    private Set<TransactionEventListener> listeners = new HashSet<TransactionEventListener>();
    private Map<String, Object> options = new HashMap<String, Object>();
    long beginTime;

    public TransactionImpl(ExecutionContext ec) {
        this.ec = ec;
        this.txnMgr = ec.getNucleusContext().getTransactionManager();
        PersistenceConfiguration config = ec.getNucleusContext().getPersistenceConfiguration();
        this.optimistic = config.getBooleanProperty("datanucleus.Optimistic");
        this.retainValues = config.getBooleanProperty("datanucleus.RetainValues");
        this.restoreValues = config.getBooleanProperty("datanucleus.RestoreValues");
        this.nontransactionalRead = config.getBooleanProperty("datanucleus.NontransactionalRead");
        this.nontransactionalWrite = config.getBooleanProperty("datanucleus.NontransactionalWrite");
        int isolationLevel = TransactionUtils.getTransactionIsolationLevelForName(config.getStringProperty("datanucleus.transactionIsolation"));
        this.setOption("transaction.isolation", isolationLevel);
        Boolean serialiseReadProp = config.getBooleanObjectProperty("datanucleus.SerializeRead");
        if (serialiseReadProp != null) {
            this.serializeRead = serialiseReadProp;
        } else {
            Boolean rdbmsProp = config.getBooleanObjectProperty("datanucleus.rdbms.useUpdateLock");
            if (rdbmsProp != null) {
                this.serializeRead = rdbmsProp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin() {
        if (this.ec.getMultithreaded()) {
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                this.txnMgr.begin(this.ec);
            }
        } else {
            this.txnMgr.begin(this.ec);
        }
        this.internalBegin();
    }

    protected void internalBegin() {
        TransactionEventListener[] ls;
        if (this.active) {
            throw new TransactionActiveOnBeginException(this.ec);
        }
        this.active = true;
        this.beginTime = System.currentTimeMillis();
        if (this.txnMgr.getTransactionRuntime() != null) {
            this.txnMgr.getTransactionRuntime().transactionStarted();
        }
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015000", this.ec, (Object)("" + this.optimistic)));
        }
        for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
            tel.transactionStarted();
        }
    }

    @Override
    public void flush() {
        try {
            TransactionEventListener[] ls;
            for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
                tel.transactionFlushed();
            }
        }
        catch (Throwable ex) {
            if (ex instanceof NucleusException) {
                throw (NucleusException)ex;
            }
            throw new NucleusTransactionException(LOCALISER.msg("015005"), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() {
        try {
            this.flush();
        }
        finally {
            TransactionEventListener[] ls;
            for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
                tel.transactionEnded();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        if (!this.isActive()) {
            throw new TransactionNotActiveException();
        }
        if (this.rollbackOnly) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015020"));
            }
            throw new NucleusDataStoreException(LOCALISER.msg("015020")).setFatal();
        }
        long startTime = System.currentTimeMillis();
        boolean success = false;
        boolean canComplete = true;
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            this.flush();
            this.internalPreCommit();
            this.internalCommit();
            success = true;
        }
        catch (RollbackException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            errors.add(e);
        }
        catch (HeuristicRollbackException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            errors.add(e);
        }
        catch (HeuristicMixedException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            errors.add(e);
        }
        catch (NucleusUserException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            canComplete = false;
            throw e;
        }
        catch (NucleusException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            errors.add(e);
        }
        finally {
            if (canComplete) {
                try {
                    if (!success) {
                        this.rollback();
                    } else {
                        this.internalPostCommit();
                    }
                }
                catch (Throwable e) {
                    errors.add(e);
                }
            }
        }
        if (errors.size() > 0) {
            throw new NucleusTransactionException(LOCALISER.msg("015007"), errors.toArray(new Throwable[errors.size()]));
        }
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015022", System.currentTimeMillis() - startTime));
        }
    }

    protected void internalPreCommit() {
        TransactionEventListener[] ls;
        this.committing = true;
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015001", this.ec));
        }
        if (this.sync != null) {
            this.sync.beforeCompletion();
        }
        for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
            tel.transactionPreCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalCommit() {
        if (this.ec.getMultithreaded()) {
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                this.txnMgr.commit(this.ec);
            }
        } else {
            this.txnMgr.commit(this.ec);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void rollback() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void internalPreRollback() {
        TransactionEventListener[] ls;
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015002", this.ec));
        }
        for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
            tel.transactionPreRollBack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalRollback() {
        TransactionEventListener[] ls;
        Transaction tx = this.txnMgr.getTransaction(this.ec);
        if (tx != null) {
            if (this.ec.getMultithreaded()) {
                TransactionImpl transactionImpl = this;
                synchronized (transactionImpl) {
                    this.txnMgr.rollback(this.ec);
                }
            } else {
                this.txnMgr.rollback(this.ec);
            }
        }
        for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
            tel.transactionRolledBack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void internalPostCommit() {
        block11: {
            Object v0;
            this.active = false;
            if (this.txnMgr.getTransactionRuntime() != null) {
                this.txnMgr.getTransactionRuntime().transactionCommitted(System.currentTimeMillis() - this.beginTime);
            }
            Object var2_1 = null;
            try {
                TransactionEventListener[] ls;
                for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
                    tel.transactionCommitted();
                }
                v0 = null;
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            Object var9_15 = v0;
            this.committing = false;
            this.listenersPerTransaction.clear();
            if (this.sync != null) {
                this.sync.afterCompletion(3);
            }
            break block11;
            catch (Throwable throwable) {
                Object v1;
                Object var2_2 = null;
                try {
                    TransactionEventListener[] ls;
                    for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
                        tel.transactionCommitted();
                    }
                    v1 = null;
                }
                catch (Throwable throwable2) {
                    v1 = null;
                }
                Object var9_16 = v1;
                this.committing = false;
                this.listenersPerTransaction.clear();
                if (this.sync != null) {
                    this.sync.afterCompletion(3);
                }
                throw throwable;
            }
        }
    }

    private TransactionEventListener[] getListenersForEvent() {
        TransactionEventListener[] ls = new TransactionEventListener[this.listeners.size() + this.listenersPerTransaction.size()];
        System.arraycopy(this.listenersPerTransaction.toArray(), 0, ls, 0, this.listenersPerTransaction.size());
        System.arraycopy(this.listeners.toArray(), 0, ls, this.listenersPerTransaction.size(), this.listeners.size());
        return ls;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isCommitting() {
        return this.committing;
    }

    @Override
    public boolean getNontransactionalRead() {
        return this.nontransactionalRead;
    }

    @Override
    public boolean getNontransactionalWrite() {
        return this.nontransactionalWrite;
    }

    @Override
    public boolean getOptimistic() {
        return this.optimistic;
    }

    @Override
    public boolean getRestoreValues() {
        return this.restoreValues;
    }

    @Override
    public boolean getRetainValues() {
        return this.retainValues;
    }

    @Override
    public boolean getRollbackOnly() {
        return this.rollbackOnly;
    }

    @Override
    public Synchronization getSynchronization() {
        return this.sync;
    }

    @Override
    public void setNontransactionalRead(boolean nontransactionalRead) {
        this.nontransactionalRead = nontransactionalRead;
    }

    @Override
    public void setNontransactionalWrite(boolean nontransactionalWrite) {
        this.nontransactionalWrite = nontransactionalWrite;
    }

    @Override
    public void setOptimistic(boolean optimistic) {
        this.optimistic = optimistic;
    }

    @Override
    public void setRestoreValues(boolean restoreValues) {
        this.restoreValues = restoreValues;
    }

    @Override
    public void setRetainValues(boolean retainValues) {
        this.retainValues = retainValues;
        if (retainValues) {
            this.nontransactionalRead = true;
        }
    }

    @Override
    public void setRollbackOnly() {
        if (this.active) {
            this.rollbackOnly = true;
        }
    }

    @Override
    public void setSynchronization(Synchronization sync) {
        this.sync = sync;
    }

    @Override
    public void addTransactionEventListener(TransactionEventListener listener) {
        this.listenersPerTransaction.add(listener);
    }

    @Override
    public void removeTransactionEventListener(TransactionEventListener listener) {
        this.listenersPerTransaction.remove(listener);
        this.listeners.remove(listener);
    }

    @Override
    public void bindTransactionEventListener(TransactionEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Override
    public Boolean getSerializeRead() {
        return this.serializeRead;
    }

    @Override
    public void setSerializeRead(Boolean serializeRead) {
        this.serializeRead = serializeRead;
    }

    @Override
    public boolean lockReadObjects() {
        return this.serializeRead != null ? this.serializeRead : false;
    }

    @Override
    public void setOption(String option, int value) {
        this.options.put(option, value);
    }

    @Override
    public void setOption(String option, boolean value) {
        this.options.put(option, value);
    }

    @Override
    public void setOption(String option, String value) {
        this.options.put(option, value);
    }
}

