/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.api.ApiAdapter;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.exceptions.NotYetFlushedException;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;
import org.datanucleus.util.NucleusLogger;

public class OIDMapping
extends SingleFieldMapping {
    public void setObject(ExecutionContext ec, Object ps, int[] param, Object value) {
        if (value == null) {
            this.getDatastoreMapping(0).setObject(ps, param[0], null);
        } else {
            OID oid;
            ApiAdapter api = ec.getApiAdapter();
            if (api.isPersistable(value)) {
                oid = (OID)api.getIdForObject(value);
                if (oid == null) {
                    if (ec.isInserting(value)) {
                        this.getDatastoreMapping(0).setObject(ps, param[0], null);
                        throw new NotYetFlushedException(value);
                    }
                    ec.persistObjectInternal(value, null, -1, 0);
                    ec.flushInternal(false);
                }
                oid = (OID)api.getIdForObject(value);
            } else {
                oid = (OID)value;
            }
            try {
                this.getDatastoreMapping(0).setObject(ps, param[0], oid.getKeyValue());
            }
            catch (Exception e) {
                this.getDatastoreMapping(0).setObject(ps, param[0], oid.getKeyValue().toString());
            }
        }
    }

    public Object getObject(ExecutionContext ec, Object rs, int[] param) {
        Object value;
        if (this.getNumberOfDatastoreMappings() > 0) {
            value = this.getDatastoreMapping(0).getObject(rs, param[0]);
        } else {
            if (this.referenceMapping != null) {
                return this.referenceMapping.getObject(ec, rs, param);
            }
            MappedStoreManager storeMgr = (MappedStoreManager)ec.getStoreManager();
            Class fieldType = this.mmd.getType();
            JavaTypeMapping referenceMapping = storeMgr.getDatastoreClass(fieldType.getName(), ec.getClassLoaderResolver()).getIdMapping();
            value = referenceMapping.getDatastoreMapping(0).getObject(rs, param[0]);
        }
        if (value != null) {
            value = OIDFactory.getInstance(ec.getNucleusContext(), this.getType(), value);
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("041034", value));
            }
        }
        return value;
    }

    public Class getJavaType() {
        return OID.class;
    }
}

