/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.util.Map;
import java.util.Set;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.AbstractContainerMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.store.types.sco.SCO;
import org.datanucleus.store.types.sco.SCOContainer;
import org.datanucleus.store.types.sco.SCOMap;
import org.datanucleus.store.types.sco.SCOUtils;
import org.datanucleus.util.NucleusLogger;

public class MapMapping
extends AbstractContainerMapping
implements MappingCallbacks {
    public Class getJavaType() {
        return Map.class;
    }

    public void insertPostProcessing(ObjectProvider op) {
    }

    public void postInsert(ObjectProvider sm) {
        Map value = (Map)sm.provideField(this.mmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            if (value != null) {
                SCOUtils.validateObjectsForWriting(sm.getExecutionContext(), value.keySet());
                SCOUtils.validateObjectsForWriting(sm.getExecutionContext(), value.values());
            }
            return;
        }
        if (value == null) {
            this.replaceFieldWithWrapper(sm, null, false, false);
            return;
        }
        if (!this.mmd.isCascadePersist()) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("007006", (Object)this.mmd.getFullFieldName()));
            }
            ApiAdapter api = sm.getExecutionContext().getApiAdapter();
            Set entries = value.entrySet();
            for (Map.Entry entry : entries) {
                if (api.isPersistable(entry.getKey()) && !api.isPersistent(entry.getKey()) && !api.isDetached(entry.getKey())) {
                    throw new ReachableObjectNotCascadedException(this.mmd.getFullFieldName(), entry.getKey());
                }
                if (!api.isPersistable(entry.getValue()) || api.isPersistent(entry.getValue()) || api.isDetached(entry.getValue())) continue;
                throw new ReachableObjectNotCascadedException(this.mmd.getFullFieldName(), entry.getValue());
            }
            this.replaceFieldWithWrapper(sm, value, false, false);
        } else {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("007007", (Object)this.mmd.getFullFieldName()));
            }
            if (value.size() > 0) {
                MappedStoreManager storeMgr = this.datastoreContainer.getStoreManager();
                ((MapStore)storeMgr.getBackingStoreForField(sm.getExecutionContext().getClassLoaderResolver(), this.mmd, value.getClass())).putAll(sm, value);
                this.replaceFieldWithWrapper(sm, value, false, false);
            } else {
                this.replaceFieldWithWrapper(sm, null, false, false);
            }
        }
    }

    public void postUpdate(ObjectProvider sm) {
        ExecutionContext ec = sm.getExecutionContext();
        MappedStoreManager storeMgr = this.datastoreContainer.getStoreManager();
        Map value = (Map)sm.provideField(this.mmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            if (value != null) {
                SCOUtils.validateObjectsForWriting(ec, value.keySet());
                SCOUtils.validateObjectsForWriting(ec, value.values());
            }
            return;
        }
        if (value == null) {
            this.replaceFieldWithWrapper(sm, null, false, false);
            return;
        }
        if (value instanceof SCOContainer) {
            SCOContainer sco = (SCOContainer)((Object)value);
            if (sm.getObject() == sco.getOwner() && this.mmd.getName().equals(sco.getFieldName())) {
                sco.flush();
                return;
            }
            if (sco.getOwner() != null) {
                throw new NucleusException("Owned second-class object was somehow assigned to a field other than its owner's").setFatal();
            }
        }
        if (!this.mmd.isCascadeUpdate()) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("007008", (Object)this.mmd.getFullFieldName()));
            }
            return;
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("007009", (Object)this.mmd.getFullFieldName()));
        }
        MapStore store = (MapStore)storeMgr.getBackingStoreForField(ec.getClassLoaderResolver(), this.mmd, value.getClass());
        store.clear(sm);
        store.putAll(sm, value);
        this.replaceFieldWithWrapper(sm, value, false, false);
    }

    public void preDelete(ObjectProvider sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        sm.getExecutionContext().getApiAdapter().isLoaded(sm, this.mmd.getAbsoluteFieldNumber());
        Map value = (Map)sm.provideField(this.mmd.getAbsoluteFieldNumber());
        if (value == null || value.isEmpty()) {
            return;
        }
        if (!(value instanceof SCO)) {
            value = (Map)sm.wrapSCOField(this.mmd.getAbsoluteFieldNumber(), value, false, false, true);
        }
        value.clear();
        ((SCOMap)((Object)value)).flush();
    }
}

