/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.transaction.Synchronization;
import org.datanucleus.ClassConstants;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.TransactionActiveOnBeginException;
import org.datanucleus.exceptions.TransactionNotActiveException;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.transaction.HeuristicMixedException;
import org.datanucleus.transaction.HeuristicRollbackException;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.transaction.RollbackException;
import org.datanucleus.transaction.Transaction;
import org.datanucleus.transaction.TransactionManager;
import org.datanucleus.transaction.TransactionUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionImpl
implements org.datanucleus.Transaction {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    ExecutionContext ec;
    TransactionManager txnMgr;
    boolean active = false;
    boolean committing;
    Synchronization sync;
    protected boolean retainValues;
    protected boolean restoreValues;
    protected boolean optimistic;
    protected boolean nontransactionalRead;
    protected boolean nontransactionalWrite;
    protected boolean rollbackOnly = false;
    protected Boolean serializeRead = null;
    private Set<TransactionEventListener> listenersPerTransaction = new HashSet<TransactionEventListener>();
    private Set<TransactionEventListener> listeners = new HashSet<TransactionEventListener>();
    private Map<String, Object> options = new HashMap<String, Object>();
    long beginTime;

    public TransactionImpl(ExecutionContext ec) {
        this.ec = ec;
        this.txnMgr = ec.getNucleusContext().getTransactionManager();
        PersistenceConfiguration config = ec.getNucleusContext().getPersistenceConfiguration();
        this.optimistic = config.getBooleanProperty("datanucleus.Optimistic");
        this.retainValues = config.getBooleanProperty("datanucleus.RetainValues");
        this.restoreValues = config.getBooleanProperty("datanucleus.RestoreValues");
        this.nontransactionalRead = config.getBooleanProperty("datanucleus.NontransactionalRead");
        this.nontransactionalWrite = config.getBooleanProperty("datanucleus.NontransactionalWrite");
        int isolationLevel = TransactionUtils.getTransactionIsolationLevelForName(config.getStringProperty("datanucleus.transactionIsolation"));
        this.setOption("transaction.isolation", isolationLevel);
        Boolean serialiseReadProp = config.getBooleanObjectProperty("datanucleus.SerializeRead");
        if (serialiseReadProp != null) {
            this.serializeRead = serialiseReadProp;
        } else {
            Boolean rdbmsProp = config.getBooleanObjectProperty("datanucleus.rdbms.useUpdateLock");
            if (rdbmsProp != null) {
                this.serializeRead = rdbmsProp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin() {
        if (this.ec.getBooleanProperty("datanucleus.Multithreaded").booleanValue()) {
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                this.txnMgr.begin(this.ec);
            }
        } else {
            this.txnMgr.begin(this.ec);
        }
        this.internalBegin();
    }

    protected void internalBegin() {
        TransactionEventListener[] ls;
        if (this.active) {
            throw new TransactionActiveOnBeginException(this.ec);
        }
        this.active = true;
        this.beginTime = System.currentTimeMillis();
        if (this.txnMgr.getTransactionRuntime() != null) {
            this.txnMgr.getTransactionRuntime().transactionStarted();
        }
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015000", this.ec, (Object)("" + this.optimistic)));
        }
        for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
            tel.transactionStarted();
        }
    }

    @Override
    public void flush() {
        try {
            TransactionEventListener[] ls;
            for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
                tel.transactionFlushed();
            }
        }
        catch (Throwable ex) {
            if (ex instanceof NucleusException) {
                throw (NucleusException)ex;
            }
            throw new NucleusTransactionException(LOCALISER.msg("015005"), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() {
        try {
            this.flush();
        }
        finally {
            TransactionEventListener[] ls;
            for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
                tel.transactionEnded();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        if (!this.isActive()) {
            throw new TransactionNotActiveException();
        }
        if (this.rollbackOnly) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015020"));
            }
            throw new NucleusDataStoreException(LOCALISER.msg("015020")).setFatal();
        }
        long startTime = System.currentTimeMillis();
        boolean success = false;
        boolean canComplete = true;
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            this.flush();
            this.internalPreCommit();
            this.internalCommit();
            success = true;
        }
        catch (RollbackException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            errors.add(e);
        }
        catch (HeuristicRollbackException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            errors.add(e);
        }
        catch (HeuristicMixedException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            errors.add(e);
        }
        catch (NucleusUserException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            canComplete = false;
            throw e;
        }
        catch (NucleusException e) {
            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
            }
            errors.add(e);
        }
        finally {
            if (canComplete) {
                try {
                    if (!success) {
                        this.rollback();
                    } else {
                        this.internalPostCommit();
                    }
                }
                catch (Throwable e) {
                    errors.add(e);
                }
            }
        }
        if (errors.size() > 0) {
            throw new NucleusTransactionException(LOCALISER.msg("015007"), errors.toArray(new Throwable[errors.size()]));
        }
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015022", System.currentTimeMillis() - startTime));
        }
    }

    protected void internalPreCommit() {
        TransactionEventListener[] ls;
        this.committing = true;
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015001", this.ec));
        }
        if (this.sync != null) {
            this.sync.beforeCompletion();
        }
        for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
            tel.transactionPreCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalCommit() {
        if (this.ec.getBooleanProperty("datanucleus.Multithreaded").booleanValue()) {
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                this.txnMgr.commit(this.ec);
            }
        } else {
            this.txnMgr.commit(this.ec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    public void rollback() {
        if (!this.isActive()) {
            throw new TransactionNotActiveException();
        }
        startTime = System.currentTimeMillis();
        try {
            try {
                canComplete = true;
                this.committing = true;
                try {
                    this.flush();
                    var5_5 = null;
                }
                catch (Throwable var4_43) {
                    block43: {
                        var5_6 = null;
                        try {}
                        catch (Throwable var7_42) {
                            block41: {
                                var8_10 = null;
                                if (canComplete == false) throw var7_42;
                                try {}
                                catch (Throwable var9_38) {
                                    block40: {
                                        var10_18 = null;
                                        ** try [egrp 6[TRYBLOCK] [7 : 117->156)] { 
lbl25:
                                        // 1 sources

                                        this.active = false;
                                        if (this.txnMgr.getTransactionRuntime() != null) {
                                            this.txnMgr.getTransactionRuntime().transactionRolledBack(System.currentTimeMillis() - this.beginTime);
                                        }
                                        v0 = null;
                                        break block40;
lbl30:
                                        // 1 sources

                                        catch (Throwable var11_26) {
                                            v0 = null;
                                        }
                                    }
                                    var12_34 = v0;
                                    this.listenersPerTransaction.clear();
                                    this.rollbackOnly = false;
                                    if (this.sync == null) throw var9_38;
                                    this.sync.afterCompletion(4);
                                    throw var9_38;
                                }
                                this.internalRollback();
                                var10_17 = null;
                                ** try [egrp 6[TRYBLOCK] [7 : 117->156)] { 
lbl43:
                                // 1 sources

                                this.active = false;
                                if (this.txnMgr.getTransactionRuntime() != null) {
                                    this.txnMgr.getTransactionRuntime().transactionRolledBack(System.currentTimeMillis() - this.beginTime);
                                }
                                v1 = null;
                                break block41;
lbl48:
                                // 1 sources

                                catch (Throwable var11_25) {
                                    v1 = null;
                                }
                            }
                            var12_33 = v1;
                            this.listenersPerTransaction.clear();
                            this.rollbackOnly = false;
                            if (this.sync == null) throw var7_42;
                            this.sync.afterCompletion(4);
                            throw var7_42;
                        }
                        try {}
                        catch (NucleusUserException e) {
                            if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                                NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
                            }
                            canComplete = false;
                            throw e;
                        }
                        this.internalPreRollback();
                        var8_9 = null;
                        if (canComplete == false) throw var4_43;
                        try {}
                        catch (Throwable var9_37) {
                            block42: {
                                var10_16 = null;
                                ** try [egrp 6[TRYBLOCK] [7 : 117->156)] { 
lbl72:
                                // 1 sources

                                this.active = false;
                                if (this.txnMgr.getTransactionRuntime() != null) {
                                    this.txnMgr.getTransactionRuntime().transactionRolledBack(System.currentTimeMillis() - this.beginTime);
                                }
                                v2 = null;
                                break block42;
lbl77:
                                // 1 sources

                                catch (Throwable var11_24) {
                                    v2 = null;
                                }
                            }
                            var12_32 = v2;
                            this.listenersPerTransaction.clear();
                            this.rollbackOnly = false;
                            if (this.sync == null) throw var9_37;
                            this.sync.afterCompletion(4);
                            throw var9_37;
                        }
                        this.internalRollback();
                        var10_15 = null;
                        ** try [egrp 6[TRYBLOCK] [7 : 117->156)] { 
lbl90:
                        // 1 sources

                        this.active = false;
                        if (this.txnMgr.getTransactionRuntime() != null) {
                            this.txnMgr.getTransactionRuntime().transactionRolledBack(System.currentTimeMillis() - this.beginTime);
                        }
                        v3 = null;
                        break block43;
lbl95:
                        // 1 sources

                        catch (Throwable var11_23) {
                            v3 = null;
                        }
                    }
                    var12_31 = v3;
                    this.listenersPerTransaction.clear();
                    this.rollbackOnly = false;
                    if (this.sync == null) throw var4_43;
                    this.sync.afterCompletion(4);
                    throw var4_43;
                }
                try {
                    try {
                        this.internalPreRollback();
                    }
                    catch (NucleusUserException e) {
                        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
                            NucleusLogger.TRANSACTION.debug(StringUtils.getStringFromStackTrace(e));
                        }
                        canComplete = false;
                        throw e;
                    }
                    var8_7 = null;
                    if (!canComplete) ** GOTO lbl193
                    try {
                        this.internalRollback();
                        var10_11 = null;
                        try {
                            this.active = false;
                            if (this.txnMgr.getTransactionRuntime() != null) {
                                this.txnMgr.getTransactionRuntime().transactionRolledBack(System.currentTimeMillis() - this.beginTime);
                            }
                            v4 = null;
                        }
                        catch (Throwable var11_19) {
                            v4 = null;
                        }
                        var12_27 = v4;
                        this.listenersPerTransaction.clear();
                        this.rollbackOnly = false;
                        if (this.sync == null) ** GOTO lbl193
                        this.sync.afterCompletion(4);
                    }
                    catch (Throwable var9_35) {
                        block44: {
                            var10_12 = null;
                            ** try [egrp 6[TRYBLOCK] [7 : 117->156)] { 
lbl138:
                            // 1 sources

                            this.active = false;
                            if (this.txnMgr.getTransactionRuntime() != null) {
                                this.txnMgr.getTransactionRuntime().transactionRolledBack(System.currentTimeMillis() - this.beginTime);
                            }
                            v5 = null;
                            break block44;
lbl143:
                            // 1 sources

                            catch (Throwable var11_20) {
                                v5 = null;
                            }
                        }
                        var12_28 = v5;
                        this.listenersPerTransaction.clear();
                        this.rollbackOnly = false;
                        if (this.sync == null) throw var9_35;
                        this.sync.afterCompletion(4);
                        throw var9_35;
                    }
                }
                catch (Throwable var7_41) {
                    block46: {
                        var8_8 = null;
                        if (canComplete == false) throw var7_41;
                        try {}
                        catch (Throwable var9_36) {
                            block45: {
                                var10_14 = null;
                                ** try [egrp 6[TRYBLOCK] [7 : 117->156)] { 
lbl161:
                                // 1 sources

                                this.active = false;
                                if (this.txnMgr.getTransactionRuntime() != null) {
                                    this.txnMgr.getTransactionRuntime().transactionRolledBack(System.currentTimeMillis() - this.beginTime);
                                }
                                v6 = null;
                                break block45;
lbl166:
                                // 1 sources

                                catch (Throwable var11_22) {
                                    v6 = null;
                                }
                            }
                            var12_30 = v6;
                            this.listenersPerTransaction.clear();
                            this.rollbackOnly = false;
                            if (this.sync == null) throw var9_36;
                            this.sync.afterCompletion(4);
                            throw var9_36;
                        }
                        this.internalRollback();
                        var10_13 = null;
                        ** try [egrp 6[TRYBLOCK] [7 : 117->156)] { 
lbl179:
                        // 1 sources

                        this.active = false;
                        if (this.txnMgr.getTransactionRuntime() != null) {
                            this.txnMgr.getTransactionRuntime().transactionRolledBack(System.currentTimeMillis() - this.beginTime);
                        }
                        v7 = null;
                        break block46;
lbl184:
                        // 1 sources

                        catch (Throwable var11_21) {
                            v7 = null;
                        }
                    }
                    var12_29 = v7;
                    this.listenersPerTransaction.clear();
                    this.rollbackOnly = false;
                    if (this.sync == null) throw var7_41;
                    this.sync.afterCompletion(4);
                    throw var7_41;
                }
lbl193:
                // 3 sources

                var14_44 = null;
                this.committing = false;
            }
            catch (NucleusUserException e) {
                throw e;
            }
            catch (NucleusException e) {
                throw new NucleusDataStoreException(TransactionImpl.LOCALISER.msg("015009"), e);
            }
        }
        catch (Throwable var13_46) {
            var14_45 = null;
            this.committing = false;
            throw var13_46;
        }
        if (NucleusLogger.TRANSACTION.isDebugEnabled() == false) return;
        NucleusLogger.TRANSACTION.debug(TransactionImpl.LOCALISER.msg("015023", System.currentTimeMillis() - startTime));
    }

    protected void internalPreRollback() {
        TransactionEventListener[] ls;
        if (NucleusLogger.TRANSACTION.isDebugEnabled()) {
            NucleusLogger.TRANSACTION.debug(LOCALISER.msg("015002", this.ec));
        }
        for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
            tel.transactionPreRollBack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalRollback() {
        TransactionEventListener[] ls;
        Transaction tx = this.txnMgr.getTransaction(this.ec);
        if (tx != null) {
            if (this.ec.getBooleanProperty("datanucleus.Multithreaded").booleanValue()) {
                TransactionImpl transactionImpl = this;
                synchronized (transactionImpl) {
                    this.txnMgr.rollback(this.ec);
                }
            } else {
                this.txnMgr.rollback(this.ec);
            }
        }
        for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
            tel.transactionRolledBack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void internalPostCommit() {
        block11: {
            Object v0;
            this.active = false;
            if (this.txnMgr.getTransactionRuntime() != null) {
                this.txnMgr.getTransactionRuntime().transactionCommitted(System.currentTimeMillis() - this.beginTime);
            }
            Object var2_1 = null;
            try {
                TransactionEventListener[] ls;
                for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
                    tel.transactionCommitted();
                }
                v0 = null;
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            Object var9_15 = v0;
            this.committing = false;
            this.listenersPerTransaction.clear();
            if (this.sync != null) {
                this.sync.afterCompletion(3);
            }
            break block11;
            catch (Throwable throwable) {
                Object v1;
                Object var2_2 = null;
                try {
                    TransactionEventListener[] ls;
                    for (TransactionEventListener tel : ls = this.getListenersForEvent()) {
                        tel.transactionCommitted();
                    }
                    v1 = null;
                }
                catch (Throwable throwable2) {
                    v1 = null;
                }
                Object var9_16 = v1;
                this.committing = false;
                this.listenersPerTransaction.clear();
                if (this.sync != null) {
                    this.sync.afterCompletion(3);
                }
                throw throwable;
            }
        }
    }

    private TransactionEventListener[] getListenersForEvent() {
        TransactionEventListener[] ls = new TransactionEventListener[this.listeners.size() + this.listenersPerTransaction.size()];
        System.arraycopy(this.listenersPerTransaction.toArray(), 0, ls, 0, this.listenersPerTransaction.size());
        System.arraycopy(this.listeners.toArray(), 0, ls, this.listenersPerTransaction.size(), this.listeners.size());
        return ls;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isCommitting() {
        return this.committing;
    }

    @Override
    public boolean getNontransactionalRead() {
        return this.nontransactionalRead;
    }

    @Override
    public boolean getNontransactionalWrite() {
        return this.nontransactionalWrite;
    }

    @Override
    public boolean getOptimistic() {
        return this.optimistic;
    }

    @Override
    public boolean getRestoreValues() {
        return this.restoreValues;
    }

    @Override
    public boolean getRetainValues() {
        return this.retainValues;
    }

    @Override
    public boolean getRollbackOnly() {
        return this.rollbackOnly;
    }

    @Override
    public Synchronization getSynchronization() {
        return this.sync;
    }

    @Override
    public void setNontransactionalRead(boolean nontransactionalRead) {
        this.nontransactionalRead = nontransactionalRead;
    }

    @Override
    public void setNontransactionalWrite(boolean nontransactionalWrite) {
        this.nontransactionalWrite = nontransactionalWrite;
    }

    @Override
    public void setOptimistic(boolean optimistic) {
        this.optimistic = optimistic;
    }

    @Override
    public void setRestoreValues(boolean restoreValues) {
        this.restoreValues = restoreValues;
    }

    @Override
    public void setRetainValues(boolean retainValues) {
        this.retainValues = retainValues;
        if (retainValues) {
            this.nontransactionalRead = true;
        }
    }

    @Override
    public void setRollbackOnly() {
        if (this.active) {
            this.rollbackOnly = true;
        }
    }

    @Override
    public void setSynchronization(Synchronization sync) {
        this.sync = sync;
    }

    @Override
    public void addTransactionEventListener(TransactionEventListener listener) {
        this.listenersPerTransaction.add(listener);
    }

    @Override
    public void removeTransactionEventListener(TransactionEventListener listener) {
        this.listenersPerTransaction.remove(listener);
    }

    @Override
    public void bindTransactionEventListener(TransactionEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Override
    public Boolean getSerializeRead() {
        return this.serializeRead;
    }

    @Override
    public void setSerializeRead(Boolean serializeRead) {
        this.serializeRead = serializeRead;
    }

    @Override
    public boolean lockReadObjects() {
        return this.serializeRead != null ? this.serializeRead : false;
    }

    @Override
    public void setOption(String option, int value) {
        this.options.put(option, value);
    }

    @Override
    public void setOption(String option, boolean value) {
        this.options.put(option, value);
    }

    @Override
    public void setOption(String option, String value) {
        this.options.put(option, value);
    }
}

