/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUnsupportedOptionException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.TransactionNotActiveException;
import org.datanucleus.exceptions.TransactionNotReadableException;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.query.JDOQLQueryHelper;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.Extent;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.query.QueryInvalidParametersException;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.util.Imports;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Query
implements Serializable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected final transient ExecutionContext ec;
    protected final transient ClassLoaderResolver clr;
    public static final short SELECT = 0;
    public static final short BULK_UPDATE = 1;
    public static final short BULK_DELETE = 2;
    public static final short OTHER = 3;
    protected short type = 0;
    protected Class candidateClass;
    protected String candidateClassName;
    protected boolean subclasses = true;
    protected boolean unique = false;
    protected transient String from = null;
    protected transient String update = null;
    protected String result = null;
    protected boolean resultDistinct = false;
    protected Class resultClass = null;
    protected String resultClassName = null;
    protected String filter;
    protected String imports;
    protected String explicitVariables;
    protected String explicitParameters;
    protected String ordering;
    protected String grouping;
    protected String having;
    protected String range;
    protected long fromInclNo = 0L;
    protected long toExclNo = Long.MAX_VALUE;
    protected String fromInclParam = null;
    protected String toExclParam = null;
    protected boolean unmodifiable = false;
    protected boolean ignoreCache = false;
    private FetchPlan fetchPlan;
    private Boolean serializeRead = null;
    private Integer readTimeoutMillis = null;
    private Integer writeTimeoutMillis = null;
    protected Map<String, Object> extensions = null;
    protected Map<String, SubqueryDefinition> subqueries = null;
    protected transient HashMap implicitParameters = null;
    protected transient Imports parsedImports = null;
    protected transient String[] parameterNames = null;
    protected transient QueryCompilation compilation = null;
    protected transient HashSet<QueryResult> queryResults = new HashSet(1);
    protected transient Map<Thread, Object> tasks = new ConcurrentHashMap<Thread, Object>(1);
    Map inputParameters;

    public Query(ExecutionContext ec) {
        this.ec = ec;
        if (ec == null) {
            throw new NucleusUserException(LOCALISER.msg("021012"));
        }
        this.clr = ec.getClassLoaderResolver();
        this.ignoreCache = ec.getIgnoreCache();
        this.readTimeoutMillis = ec.getDatastoreReadTimeoutMillis();
        this.writeTimeoutMillis = ec.getDatastoreWriteTimeoutMillis();
    }

    public void setCacheResults(boolean cache) {
        if (cache && this.queryResults == null) {
            this.queryResults = new HashSet();
        } else if (!cache) {
            this.queryResults = null;
        }
    }

    public String getLanguage() {
        throw new UnsupportedOperationException("Query Language accessor not supported in this query");
    }

    protected void discardCompiled() {
        this.parsedImports = null;
        this.parameterNames = null;
        this.compilation = null;
    }

    public void setCompilation(QueryCompilation compilation) {
        this.compilation = compilation;
        if (compilation != null && NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug(compilation.toString());
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Query)) {
            return false;
        }
        Query q = (Query)obj;
        if (this.candidateClass == null ? q.candidateClass != null : !this.candidateClass.equals(q.candidateClass)) {
            return false;
        }
        if (this.filter == null ? q.filter != null : !this.filter.equals(q.filter)) {
            return false;
        }
        if (this.imports == null ? q.imports != null : !this.imports.equals(q.imports)) {
            return false;
        }
        if (this.explicitParameters == null ? q.explicitParameters != null : !this.explicitParameters.equals(q.explicitParameters)) {
            return false;
        }
        if (this.explicitVariables == null ? q.explicitVariables != null : !this.explicitVariables.equals(q.explicitVariables)) {
            return false;
        }
        if (this.unique != q.unique) {
            return false;
        }
        if (this.unmodifiable != q.unmodifiable) {
            return false;
        }
        if (this.resultClass != q.resultClass) {
            return false;
        }
        if (this.grouping == null ? q.grouping != null : !this.grouping.equals(q.grouping)) {
            return false;
        }
        return !(this.ordering == null ? q.ordering != null : !this.ordering.equals(q.ordering));
    }

    public int hashCode() {
        return (this.candidateClass == null ? 0 : this.candidateClass.hashCode()) ^ (this.result == null ? 0 : this.result.hashCode()) ^ (this.filter == null ? 0 : this.filter.hashCode()) ^ (this.imports == null ? 0 : this.imports.hashCode()) ^ (this.explicitParameters == null ? 0 : this.explicitParameters.hashCode()) ^ (this.explicitVariables == null ? 0 : this.explicitVariables.hashCode()) ^ (this.resultClass == null ? 0 : this.resultClass.hashCode()) ^ (this.grouping == null ? 0 : this.grouping.hashCode()) ^ (this.having == null ? 0 : this.having.hashCode()) ^ (this.ordering == null ? 0 : this.ordering.hashCode()) ^ (this.range == null ? 0 : this.range.hashCode());
    }

    public short getType() {
        return this.type;
    }

    public void setType(short type) {
        if (type != 0 && type != 1 && type != 2) {
            throw new NucleusUserException("Query only supports types of SELECT, BULK_UPDATE, BULK_DELETE : unknown value " + type);
        }
        this.type = type;
    }

    public StoreManager getStoreManager() {
        return this.ec.getStoreManager();
    }

    public ExecutionContext getExecutionContext() {
        return this.ec;
    }

    public void addExtension(String key, Object value) {
        if (this.extensions == null) {
            this.extensions = new HashMap<String, Object>();
        }
        this.extensions.put(key, value);
    }

    public void setExtensions(Map extensions) {
        this.extensions = extensions != null ? new HashMap(extensions) : null;
    }

    public Object getExtension(String key) {
        return this.extensions != null ? this.extensions.get(key) : null;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public boolean getBooleanExtensionProperty(String name, boolean resultIfNotSet) {
        if (this.extensions != null && this.extensions.containsKey(name)) {
            return Boolean.valueOf((String)this.extensions.get(name));
        }
        return this.ec.getNucleusContext().getPersistenceConfiguration().getBooleanProperty(name, resultIfNotSet);
    }

    public String getStringExtensionProperty(String name, String resultIfNotSet) {
        if (this.extensions != null && this.extensions.containsKey(name)) {
            return (String)this.extensions.get(name);
        }
        String value = this.ec.getNucleusContext().getPersistenceConfiguration().getStringProperty(name);
        return value != null ? value : resultIfNotSet;
    }

    public Set<String> getSupportedExtensions() {
        HashSet<String> supported = new HashSet<String>();
        supported.add("datanucleus.query.flushBeforeExecution");
        supported.add("datanucleus.query.useFetchPlan");
        supported.add("datanucleus.query.resultSizeMethod");
        supported.add("datanucleus.query.loadResultsAtCommit");
        supported.add("datanucleus.query.resultCacheType");
        supported.add("datanucleus.query.compilation.cached");
        supported.add("datanucleus.query.results.cached");
        supported.add("datanucleus.query.multithread");
        return supported;
    }

    public FetchPlan getFetchPlan() {
        if (this.fetchPlan == null) {
            this.fetchPlan = this.ec.getFetchPlan().getCopy();
        }
        return this.fetchPlan;
    }

    public void setFetchPlan(FetchPlan fp) {
        this.fetchPlan = fp;
    }

    public void setUpdate(String update) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.update = update;
    }

    public String getUpdate() {
        return this.update;
    }

    public Class getCandidateClass() {
        return this.candidateClass;
    }

    public void setCandidateClass(Class candidateClass) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.candidateClassName = candidateClass != null ? candidateClass.getName() : null;
        this.candidateClass = candidateClass;
    }

    public void setCandidateClassName(String candidateClassName) {
        this.candidateClassName = candidateClassName != null ? candidateClassName.trim() : null;
    }

    public String getCandidateClassName() {
        return this.candidateClassName;
    }

    public void setFrom(String from) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    public abstract void setCandidates(Extent var1);

    public abstract void setCandidates(Collection var1);

    public void setFilter(String filter) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.filter = StringUtils.isWhitespace(filter) ? null : StringUtils.removeSpecialTagsFromString(filter).trim();
    }

    public String getFilter() {
        return this.filter;
    }

    public void declareImports(String imports) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.imports = StringUtils.isWhitespace(imports) ? null : StringUtils.removeSpecialTagsFromString(imports).trim();
    }

    public String getImports() {
        return this.imports;
    }

    public void declareExplicitParameters(String parameters) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.explicitParameters = StringUtils.isWhitespace(parameters) ? null : StringUtils.removeSpecialTagsFromString(parameters).trim();
    }

    public String getExplicitParameters() {
        return this.explicitParameters;
    }

    public void setImplicitParameter(String name, Object value) {
        if (this.implicitParameters == null) {
            this.implicitParameters = new HashMap();
        }
        this.implicitParameters.put(name, value);
        if (this.compilation == null) {
            this.discardCompiled();
            this.compileInternal(this.implicitParameters);
        }
        this.applyImplicitParameterValueToCompilation(name, value);
    }

    public void setImplicitParameter(int position, Object value) {
        if (this.implicitParameters == null) {
            this.implicitParameters = new HashMap();
        }
        this.implicitParameters.put(position, value);
        if (this.compilation == null) {
            this.discardCompiled();
            this.compileInternal(this.implicitParameters);
        }
        this.applyImplicitParameterValueToCompilation("" + position, value);
    }

    protected void applyImplicitParameterValueToCompilation(String name, Object value) {
        boolean subSymbolFound;
        if (this.compilation == null) {
            return;
        }
        boolean symbolFound = false;
        Symbol sym = this.compilation.getSymbolTable().getSymbol(name);
        if (sym != null) {
            symbolFound = true;
            if (sym.getValueType() == null && value != null) {
                sym.setValueType(value.getClass());
            } else if (sym.getValueType() != null && value != null && !QueryUtils.queryParameterTypesAreCompatible(sym.getValueType(), value.getClass())) {
                throw new QueryInvalidParametersException("Parameter " + name + " needs to be assignable from " + sym.getValueType().getName() + " yet the value is of type " + value.getClass().getName());
            }
        }
        if (subSymbolFound = this.applyImplicitParameterValueToSubqueries(name, value, this.compilation)) {
            symbolFound = true;
        }
        if (!symbolFound) {
            throw new QueryInvalidParametersException(LOCALISER.msg("021116", (Object)name));
        }
    }

    protected boolean applyImplicitParameterValueToSubqueries(String name, Object value, QueryCompilation comp) {
        boolean symbolFound = false;
        Symbol sym = null;
        String[] subqueryNames = comp.getSubqueryAliases();
        if (subqueryNames != null) {
            for (int i = 0; i < subqueryNames.length; ++i) {
                boolean subSymbolFound;
                QueryCompilation subCompilation = comp.getCompilationForSubquery(subqueryNames[i]);
                sym = subCompilation.getSymbolTable().getSymbol(name);
                if (sym != null) {
                    symbolFound = true;
                    if (sym.getValueType() == null && value != null) {
                        sym.setValueType(value.getClass());
                    } else if (sym.getValueType() != null && value != null && !QueryUtils.queryParameterTypesAreCompatible(sym.getValueType(), value.getClass())) {
                        throw new QueryInvalidParametersException("Parameter " + name + " needs to be assignable from " + sym.getValueType().getName() + " yet the value is of type " + value.getClass().getName());
                    }
                }
                if (!(subSymbolFound = this.applyImplicitParameterValueToSubqueries(name, value, subCompilation))) continue;
                symbolFound = true;
            }
        }
        return symbolFound;
    }

    public Map getImplicitParameters() {
        return this.implicitParameters;
    }

    public void declareExplicitVariables(String variables) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.explicitVariables = StringUtils.isWhitespace(variables) ? null : StringUtils.removeSpecialTagsFromString(variables).trim();
    }

    public String getExplicitVariables() {
        return this.explicitVariables;
    }

    public void setOrdering(String ordering) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.ordering = ordering != null ? ordering.trim() : null;
    }

    public String getOrdering() {
        return this.ordering;
    }

    public void setGrouping(String grouping) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.grouping = grouping != null ? grouping.trim() : null;
    }

    public String getGrouping() {
        return this.grouping;
    }

    public void setHaving(String having) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.having = having != null ? having.trim() : null;
    }

    public String getHaving() {
        return this.having;
    }

    public void setUnique(boolean unique) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.unique = unique;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setRange(long fromIncl, long toExcl) {
        this.discardCompiled();
        this.fromInclNo = fromIncl;
        this.toExclNo = toExcl;
        this.fromInclParam = null;
        this.toExclParam = null;
        this.range = "" + this.fromInclNo + "," + this.toExclNo;
    }

    public void setRange(String range) {
        block8: {
            StringTokenizer tok;
            block7: {
                this.discardCompiled();
                this.range = range;
                if (range == null) {
                    this.fromInclNo = 0L;
                    this.fromInclParam = null;
                    this.toExclNo = Long.MAX_VALUE;
                    this.toExclParam = null;
                    return;
                }
                tok = new StringTokenizer(range, ",");
                if (!tok.hasMoreTokens()) {
                    throw new NucleusUserException("Invalid range. Expected 'lower, upper'");
                }
                String first = tok.nextToken().trim();
                try {
                    this.fromInclNo = Long.valueOf(first);
                }
                catch (NumberFormatException nfe) {
                    this.fromInclNo = 0L;
                    this.fromInclParam = first.trim();
                    if (!this.fromInclParam.startsWith(":")) break block7;
                    this.fromInclParam = this.fromInclParam.substring(1);
                }
            }
            if (!tok.hasMoreTokens()) {
                throw new NucleusUserException("Invalid range. Expected 'lower, upper'");
            }
            String second = tok.nextToken().trim();
            try {
                this.toExclNo = Long.valueOf(second);
            }
            catch (NumberFormatException nfe) {
                this.toExclNo = Long.MAX_VALUE;
                this.toExclParam = second.trim();
                if (!this.toExclParam.startsWith(":")) break block8;
                this.toExclParam = this.toExclParam.substring(1);
            }
        }
    }

    public String getRange() {
        return this.range;
    }

    public long getRangeFromIncl() {
        return this.fromInclNo;
    }

    public long getRangeToExcl() {
        return this.toExclNo;
    }

    public String getRangeFromInclParam() {
        return this.fromInclParam;
    }

    public String getRangeToExclParam() {
        return this.toExclParam;
    }

    public void setResult(String result) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.result = result != null ? result.trim() : null;
    }

    public String getResult() {
        return this.result;
    }

    public void setResultDistinct(boolean distinct) {
        this.resultDistinct = distinct;
    }

    public boolean getResultDistinct() {
        return this.resultDistinct;
    }

    public String getResultClassName() {
        return this.resultClassName;
    }

    public void setResultClassName(String resultClassName) {
        this.discardCompiled();
        try {
            this.resultClass = this.clr.classForName(resultClassName);
            this.resultClassName = null;
        }
        catch (ClassNotResolvedException cnre) {
            this.resultClassName = resultClassName;
            this.resultClass = null;
        }
    }

    public void setResultClass(Class result_cls) {
        this.discardCompiled();
        this.resultClass = result_cls;
        this.resultClassName = null;
    }

    public Class getResultClass() {
        return this.resultClass;
    }

    public void setResultMetaData(QueryResultMetaData qrmd) {
        throw new NucleusException("This query doesn't support the use of setResultMetaData()");
    }

    public void setIgnoreCache(boolean ignoreCache) {
        this.discardCompiled();
        this.ignoreCache = ignoreCache;
    }

    public boolean getIgnoreCache() {
        return this.ignoreCache;
    }

    public boolean isSubclasses() {
        return this.subclasses;
    }

    public void setSubclasses(boolean subclasses) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.subclasses = subclasses;
    }

    public Boolean getSerializeRead() {
        return this.serializeRead;
    }

    public void setSerializeRead(Boolean serialize) {
        this.serializeRead = serialize;
    }

    public boolean isUnmodifiable() {
        return this.unmodifiable;
    }

    protected void assertIsModifiable() {
        if (this.unmodifiable) {
            throw new NucleusUserException(LOCALISER.msg("021014"));
        }
    }

    public void setUnmodifiable() {
        this.unmodifiable = true;
    }

    public void setDatastoreReadTimeoutMillis(Integer timeout) {
        if (!this.supportsTimeout()) {
            throw new NucleusUnsupportedOptionException("Timeout not supported on this query");
        }
        this.readTimeoutMillis = timeout;
    }

    public Integer getDatastoreReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public void setDatastoreWriteTimeoutMillis(Integer timeout) {
        if (!this.supportsTimeout()) {
            throw new NucleusUnsupportedOptionException("Timeout not supported on this query");
        }
        this.writeTimeoutMillis = timeout;
    }

    public Integer getDatastoreWriteTimeoutMillis() {
        return this.writeTimeoutMillis;
    }

    public QueryManager getQueryManager() {
        if (this.ec != null) {
            return this.ec.getStoreManager().getQueryManager();
        }
        return null;
    }

    public void addSubquery(Query sub, String variableDecl, String candidateExpr, Map paramMap) {
        if (StringUtils.isWhitespace(variableDecl)) {
            throw new NucleusUserException(LOCALISER.msg("021115"));
        }
        if (sub == null) {
            this.explicitVariables = this.explicitVariables == null ? variableDecl : this.explicitVariables + ";" + variableDecl;
        } else {
            if (this.subqueries == null) {
                this.subqueries = new HashMap<String, SubqueryDefinition>();
            }
            String subqueryVariableName = variableDecl.trim();
            int sepPos = subqueryVariableName.indexOf(32);
            subqueryVariableName = subqueryVariableName.substring(sepPos + 1);
            if (!StringUtils.isWhitespace(candidateExpr)) {
                sub.setFrom(candidateExpr);
            }
            this.subqueries.put(subqueryVariableName, new SubqueryDefinition(sub, StringUtils.isWhitespace(candidateExpr) ? null : candidateExpr, variableDecl, paramMap));
        }
    }

    public SubqueryDefinition getSubqueryForVariable(String variableName) {
        if (this.subqueries == null) {
            return null;
        }
        return this.subqueries.get(variableName);
    }

    public boolean hasSubqueryForVariable(String variableName) {
        return this.subqueries == null ? false : this.subqueries.containsKey(variableName);
    }

    protected void prepareDatastore() {
        boolean flush = false;
        flush = !this.ignoreCache && !this.ec.isDelayDatastoreOperationsEnabled() ? true : this.getBooleanExtensionProperty("datanucleus.query.flushBeforeExecution", false);
        if (flush) {
            this.ec.flushInternal(false);
        }
    }

    public QueryCompilation getCompilation() {
        return this.compilation;
    }

    protected boolean isCompiled() {
        return this.compilation != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile() {
        try {
            if (this.candidateClass != null) {
                this.clr.setPrimary(this.candidateClass.getClassLoader());
            }
            this.compileInternal(null);
            Object var2_1 = null;
            this.clr.setPrimary(null);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.clr.setPrimary(null);
            throw throwable;
        }
    }

    protected abstract void compileInternal(Map var1);

    public Imports getParsedImports() {
        if (this.parsedImports == null) {
            this.parsedImports = new Imports();
            if (this.candidateClassName != null) {
                this.parsedImports.importPackage(this.candidateClassName);
            }
            if (this.imports != null) {
                this.parsedImports.parseImports(this.imports);
            }
        }
        return this.parsedImports;
    }

    public Object execute() {
        return this.executeWithArray(new Object[0]);
    }

    public Object executeWithArray(Object[] parameterValues) {
        if (this.ec == null) {
            throw new NucleusUserException(LOCALISER.msg("021017"));
        }
        if (this.ec.isClosed()) {
            throw new NucleusUserException(LOCALISER.msg("021013")).setFatal();
        }
        if (!this.ec.getTransaction().isActive() && !this.ec.getTransaction().getNontransactionalRead()) {
            throw new TransactionNotReadableException();
        }
        return this.executeQuery(this.getParameterMapForValues(parameterValues));
    }

    public Object executeWithMap(Map parameters) {
        if (this.ec == null) {
            throw new NucleusUserException(LOCALISER.msg("021017"));
        }
        if (this.ec.isClosed()) {
            throw new NucleusUserException(LOCALISER.msg("021013")).setFatal();
        }
        if (!this.ec.getTransaction().isActive() && !this.ec.getTransaction().getNontransactionalRead()) {
            throw new TransactionNotReadableException();
        }
        return this.executeQuery(parameters);
    }

    public Map getInputParameters() {
        return this.inputParameters;
    }

    protected boolean supportsTimeout() {
        return false;
    }

    /*
     * Exception decompiling
     */
    protected Object executeQuery(Map parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void assertSupportsCancel() {
        throw new UnsupportedOperationException("This query implementation doesn't support the cancel of executing queries");
    }

    public void cancel() {
        this.assertSupportsCancel();
        for (Map.Entry<Thread, Object> entry : this.tasks.entrySet()) {
            boolean success = this.cancelTaskObject(entry.getValue());
            NucleusLogger.QUERY.debug("Query cancelled for thread=" + entry.getKey().getId() + " with success=" + success);
        }
        this.tasks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(Thread thread) {
        this.assertSupportsCancel();
        Map<Thread, Object> map = this.tasks;
        synchronized (map) {
            Object threadObject = this.tasks.get(thread);
            if (threadObject != null) {
                boolean success = this.cancelTaskObject(threadObject);
                NucleusLogger.QUERY.debug("Query (in thread=" + thread.getId() + ") cancelled with success=" + success);
            }
            this.tasks.remove(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerTask(Object taskObject) {
        Map<Thread, Object> map = this.tasks;
        synchronized (map) {
            this.tasks.put(Thread.currentThread(), taskObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregisterTask() {
        Map<Thread, Object> map = this.tasks;
        synchronized (map) {
            this.tasks.remove(Thread.currentThread());
        }
    }

    protected boolean cancelTaskObject(Object obj) {
        return true;
    }

    protected abstract Object performExecute(Map var1);

    protected boolean applyRangeChecks() {
        return false;
    }

    public long deletePersistentAll() {
        return this.deletePersistentAll(new Object[0]);
    }

    public long deletePersistentAll(Object[] parameterValues) {
        return this.deletePersistentAll(this.getParameterMapForValues(parameterValues));
    }

    public long deletePersistentAll(Map parameters) {
        if (this.ec.isClosed()) {
            throw new NucleusUserException(LOCALISER.msg("021013")).setFatal();
        }
        if (!this.ec.getTransaction().isActive() && !this.ec.getTransaction().getNontransactionalWrite()) {
            throw new TransactionNotActiveException();
        }
        if (this.result != null) {
            throw new NucleusUserException(LOCALISER.msg("021029"));
        }
        if (this.resultClass != null) {
            throw new NucleusUserException(LOCALISER.msg("021030"));
        }
        if (this.ordering != null) {
            throw new NucleusUserException(LOCALISER.msg("021027"));
        }
        if (this.grouping != null) {
            throw new NucleusUserException(LOCALISER.msg("021028"));
        }
        if (this.range != null) {
            throw new NucleusUserException(LOCALISER.msg("021031"));
        }
        if (this.fromInclNo >= 0L && this.toExclNo >= 0L && (this.fromInclNo != 0L || this.toExclNo != Long.MAX_VALUE)) {
            throw new NucleusUserException(LOCALISER.msg("021031"));
        }
        return this.performDeletePersistentAll(parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long performDeletePersistentAll(Map parameters) {
        Collection results;
        boolean requiresUnique;
        block9: {
            requiresUnique = this.unique;
            if (this.unique) {
                this.unique = false;
                this.discardCompiled();
            }
            this.compileInternal(parameters);
            results = (Collection)this.performExecute(parameters);
            if (results != null) break block9;
            long l = 0L;
            Object var9_6 = null;
            if (requiresUnique != this.unique) {
                this.unique = requiresUnique;
                this.discardCompiled();
            }
            return l;
        }
        try {
            int number = results.size();
            if (requiresUnique && number > 1) {
                throw new NucleusUserException(LOCALISER.msg("021032"));
            }
            Iterator resultsIter = results.iterator();
            while (resultsIter.hasNext()) {
                this.ec.findObjectProvider(resultsIter.next()).flush();
            }
            this.ec.deleteObjects(results.toArray());
            if (results instanceof QueryResult) {
                ((QueryResult)results).close();
            }
            long l = number;
            Object var9_7 = null;
            if (requiresUnique != this.unique) {
                this.unique = requiresUnique;
                this.discardCompiled();
            }
            return l;
        }
        catch (Throwable throwable) {
            block10: {
                Object var9_8 = null;
                if (requiresUnique == this.unique) break block10;
                this.unique = requiresUnique;
                this.discardCompiled();
            }
            throw throwable;
        }
    }

    public void close(Object queryResult) {
        if (queryResult != null && queryResult instanceof QueryResult) {
            if (this.queryResults != null) {
                this.queryResults.remove(queryResult);
            }
            ((QueryResult)queryResult).close();
        }
    }

    public void closeAll() {
        if (this.queryResults != null) {
            QueryResult[] qrs = this.queryResults.toArray(new QueryResult[this.queryResults.size()]);
            for (int i = 0; i < qrs.length; ++i) {
                this.close(qrs[i]);
            }
        }
        if (this.fetchPlan != null) {
            this.fetchPlan.clearGroups().addGroup("default");
        }
    }

    protected boolean shouldReturnSingleRow() {
        return QueryUtils.queryReturnsSingleRow(this);
    }

    protected Map getParameterMapForValues(Object[] parameterValues) {
        HashMap<Object, Object> parameterMap = new HashMap<Object, Object>();
        int position = 0;
        if (this.explicitParameters != null) {
            StringTokenizer t1 = new StringTokenizer(this.explicitParameters, ",");
            while (t1.hasMoreTokens()) {
                StringTokenizer t2 = new StringTokenizer(t1.nextToken(), " ");
                if (t2.countTokens() != 2) {
                    throw new NucleusUserException(LOCALISER.msg("021101", (Object)this.explicitParameters));
                }
                t2.nextToken();
                String parameterName = t2.nextToken();
                if (!JDOQLQueryHelper.isValidJavaIdentifierForJDOQL(parameterName)) {
                    throw new NucleusUserException(LOCALISER.msg("021102", (Object)parameterName));
                }
                if (parameterMap.containsKey(parameterName)) {
                    throw new NucleusUserException(LOCALISER.msg("021103", (Object)parameterName));
                }
                if (parameterValues.length < position + 1) {
                    throw new NucleusUserException(LOCALISER.msg("021108", (Object)("" + position), (Object)("" + parameterValues.length)));
                }
                parameterMap.put(parameterName, parameterValues[position++]);
            }
            if (parameterMap.size() != parameterValues.length) {
                throw new NucleusUserException(LOCALISER.msg("021108", (Object)("" + parameterMap.size()), (Object)("" + parameterValues.length)));
            }
        } else {
            for (int i = 0; i < parameterValues.length; ++i) {
                parameterMap.put(i, parameterValues[i]);
            }
        }
        return parameterMap;
    }

    protected boolean useFetchPlan() {
        boolean useFetchPlan = this.getBooleanExtensionProperty("datanucleus.query.useFetchPlan", true);
        if (this.type == 1 || this.type == 2) {
            useFetchPlan = false;
        }
        return useFetchPlan;
    }

    public boolean useCaching() {
        return this.getBooleanExtensionProperty("datanucleus.query.compilation.cached", true);
    }

    public boolean useResultsCaching() {
        if (!this.useCaching()) {
            return false;
        }
        return this.getBooleanExtensionProperty("datanucleus.query.results.cached", false);
    }

    public boolean checkUnusedParameters() {
        return this.getBooleanExtensionProperty("datanucleus.query.checkUnusedParameters", true);
    }

    protected void checkParameterTypesAgainstCompilation(Map parameterValues) {
        if (this.compilation == null) {
            return;
        }
        if (parameterValues == null || parameterValues.isEmpty()) {
            return;
        }
        boolean checkUnusedParams = this.checkUnusedParameters();
        for (Map.Entry entry : parameterValues.entrySet()) {
            Object paramKey = entry.getKey();
            Symbol sym = null;
            sym = this.deepFindSymbolForParameterInCompilation(this.compilation, paramKey);
            if (sym != null) {
                Class expectedValueType = sym.getValueType();
                if (entry.getValue() == null || expectedValueType == null || QueryUtils.queryParameterTypesAreCompatible(expectedValueType, entry.getValue().getClass())) continue;
                throw new NucleusUserException("Parameter \"" + paramKey + "\" was specified as " + entry.getValue().getClass().getName() + " but should have been " + expectedValueType.getName());
            }
            if (!(paramKey instanceof String) || (this.fromInclParam != null || this.toExclParam != null) && (paramKey.equals(this.fromInclParam) || paramKey.equals(this.toExclParam)) || !checkUnusedParams) continue;
            throw new QueryInvalidParametersException(LOCALISER.msg("021116", paramKey));
        }
    }

    protected Symbol deepFindSymbolForParameterInCompilation(QueryCompilation compilation, Object paramKey) {
        String[] subqueryNames;
        Symbol sym = null;
        sym = this.getSymbolForParameterInCompilation(compilation, paramKey);
        if (sym == null && (subqueryNames = compilation.getSubqueryAliases()) != null) {
            for (int i = 0; i < subqueryNames.length && (sym = this.deepFindSymbolForParameterInCompilation(compilation.getCompilationForSubquery(subqueryNames[i]), paramKey)) == null; ++i) {
            }
        }
        return sym;
    }

    private Symbol getSymbolForParameterInCompilation(QueryCompilation compilation, Object paramKey) {
        Symbol sym = null;
        if (paramKey instanceof Integer) {
            ParameterExpression expr = compilation.getParameterExpressionForPosition((Integer)paramKey);
            if (expr != null) {
                sym = expr.getSymbol();
            }
        } else {
            String paramName = (String)paramKey;
            sym = compilation.getSymbolTable().getSymbol(paramName);
        }
        return sym;
    }

    public Class resolveClassDeclaration(String classDecl) {
        try {
            return this.getParsedImports().resolveClassDeclaration(classDecl, this.ec.getClassLoaderResolver(), this.candidateClass == null ? null : this.candidateClass.getClassLoader());
        }
        catch (ClassNotResolvedException e) {
            throw new NucleusUserException(LOCALISER.msg("021015", (Object)classDecl));
        }
    }

    public static class SubqueryDefinition {
        Query query;
        String candidateExpression;
        String variableDecl;
        Map parameterMap;

        public SubqueryDefinition(Query q, String candidates, String variables, Map params) {
            this.query = q;
            this.candidateExpression = candidates;
            this.variableDecl = variables;
            this.parameterMap = params;
        }

        public Query getQuery() {
            return this.query;
        }

        public String getCandidateExpression() {
            return this.candidateExpression;
        }

        public String getVariableDeclaration() {
            return this.variableDecl;
        }

        public Map getParameterMap() {
            return this.parameterMap;
        }
    }
}

