/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Collection;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.NucleusContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.Type;
import org.datanucleus.store.exceptions.NotYetFlushedException;
import org.datanucleus.store.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.mapping.AppIDObjectIdFieldConsumer;
import org.datanucleus.store.mapped.mapping.CorrespondentColumnsMapper;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.mapped.mapping.MappingManager;
import org.datanucleus.store.mapped.mapping.OIDMapping;
import org.datanucleus.store.scostore.PersistableRelationStore;
import org.datanucleus.store.types.sco.SCOCollection;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class PersistableMapping
extends OIDMapping
implements MappingCallbacks {
    protected JavaTypeMapping[] javaTypeMappings = new JavaTypeMapping[0];
    protected AbstractClassMetaData cmd;
    private int numberOfDatastoreFields = 0;

    public void initialize(AbstractMemberMetaData mmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(mmd, container, clr);
        this.prepareDatastoreMapping(clr);
    }

    public void addJavaTypeMapping(JavaTypeMapping mapping) {
        if (mapping == null) {
            throw new NucleusException("mapping argument in PersistenceCapableMapping.addJavaTypeMapping is null").setFatal();
        }
        JavaTypeMapping[] jtm = this.javaTypeMappings;
        this.javaTypeMappings = new JavaTypeMapping[jtm.length + 1];
        System.arraycopy(jtm, 0, this.javaTypeMappings, 0, jtm.length);
        this.javaTypeMappings[jtm.length] = mapping;
    }

    protected void prepareDatastoreMapping() {
    }

    protected void prepareDatastoreMapping(ClassLoaderResolver clr) {
        if (this.roleForMember != 3 && this.roleForMember != 4 && this.roleForMember != 5 && this.roleForMember != 6) {
            AbstractClassMetaData refCmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(this.mmd.getType(), clr);
            JavaTypeMapping referenceMapping = null;
            if (refCmd.getInheritanceMetaData() != null && refCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
                AbstractClassMetaData[] cmds = this.storeMgr.getClassesManagingTableForClass(refCmd, clr);
                if (cmds != null && cmds.length > 0) {
                    if (cmds.length > 1) {
                        NucleusLogger.PERSISTENCE.warn("Field " + this.mmd.getFullFieldName() + " represents either a 1-1 relation, " + "or a N-1 relation where the other end uses \"subclass-table\" inheritance strategy and more " + "than 1 subclasses with a table. This is not fully supported");
                    }
                } else {
                    return;
                }
                referenceMapping = this.storeMgr.getDatastoreClass(cmds[0].getFullClassName(), clr).getIdMapping();
            } else {
                referenceMapping = this.storeMgr.getDatastoreClass(this.mmd.getType().getName(), clr).getIdMapping();
            }
            CorrespondentColumnsMapper correspondentColumnsMapping = new CorrespondentColumnsMapper(this.mmd, referenceMapping, true);
            int relationType = this.mmd.getRelationType(clr);
            boolean createDatastoreMappings = true;
            if (relationType == 6) {
                AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(clr);
                createDatastoreMappings = relatedMmds[0].getJoinMetaData() == null;
            } else if (relationType == 2) {
                boolean bl = createDatastoreMappings = this.mmd.getMappedBy() == null;
            }
            if (relationType == 7) {
                this.storeMgr.newJoinDatastoreContainerObject(this.mmd, clr);
            } else {
                for (int i = 0; i < referenceMapping.getNumberOfDatastoreMappings(); ++i) {
                    DatastoreMapping refDatastoreMapping = referenceMapping.getDatastoreMapping(i);
                    JavaTypeMapping mapping = this.storeMgr.getMappingManager().getMapping(refDatastoreMapping.getJavaTypeMapping().getJavaType());
                    this.addJavaTypeMapping(mapping);
                    if (createDatastoreMappings) {
                        ColumnMetaData colmd = correspondentColumnsMapping.getColumnMetaDataByIdentifier(refDatastoreMapping.getDatastoreField().getIdentifier());
                        if (colmd == null) {
                            throw new NucleusUserException(LOCALISER.msg("041038", refDatastoreMapping.getDatastoreField().getIdentifier(), (Object)this.toString())).setFatal();
                        }
                        MappingManager mmgr = this.storeMgr.getMappingManager();
                        DatastoreField col = mmgr.createDatastoreField(this.mmd, this.datastoreContainer, mapping, colmd, refDatastoreMapping.getDatastoreField(), clr);
                        DatastoreMapping datastoreMapping = mmgr.createDatastoreMapping(mapping, col, refDatastoreMapping.getJavaTypeMapping().getJavaTypeForDatastoreMapping(i));
                        this.addDatastoreMapping(datastoreMapping);
                        continue;
                    }
                    mapping.setReferenceMapping(referenceMapping);
                }
            }
        }
    }

    public JavaTypeMapping[] getJavaTypeMapping() {
        return this.javaTypeMappings;
    }

    public int getNumberOfDatastoreMappings() {
        if (this.numberOfDatastoreFields == 0) {
            for (int i = 0; i < this.javaTypeMappings.length; ++i) {
                this.numberOfDatastoreFields += this.javaTypeMappings[i].getNumberOfDatastoreMappings();
            }
        }
        return this.numberOfDatastoreFields;
    }

    public DatastoreMapping getDatastoreMapping(int index) {
        int currentIndex = 0;
        int numberJavaMappings = this.javaTypeMappings.length;
        for (int i = 0; i < numberJavaMappings; ++i) {
            int numberDatastoreMappings = this.javaTypeMappings[i].getNumberOfDatastoreMappings();
            for (int j = 0; j < numberDatastoreMappings; ++j) {
                if (currentIndex == index) {
                    return this.javaTypeMappings[i].getDatastoreMapping(j);
                }
                ++currentIndex;
            }
        }
        throw new NucleusException("Invalid index " + index + " for DataStoreMapping.").setFatal();
    }

    public DatastoreMapping[] getDatastoreMappings() {
        if (this.datastoreMappings.length == 0) {
            this.datastoreMappings = new DatastoreMapping[this.getNumberOfDatastoreMappings()];
            int currentIndex = 0;
            int numberJavaMappings = this.javaTypeMappings.length;
            for (int i = 0; i < numberJavaMappings; ++i) {
                int numberDatastoreMappings = this.javaTypeMappings[i].getNumberOfDatastoreMappings();
                for (int j = 0; j < numberDatastoreMappings; ++j) {
                    this.datastoreMappings[currentIndex++] = this.javaTypeMappings[i].getDatastoreMapping(j);
                }
            }
        }
        return super.getDatastoreMappings();
    }

    public Object getValueForDatastoreMapping(NucleusContext nucleusCtx, int index, Object value) {
        ExecutionContext ec = nucleusCtx.getApiAdapter().getExecutionContext(value);
        if (this.cmd == null) {
            this.cmd = nucleusCtx.getMetaDataManager().getMetaDataForClass(this.getType(), ec != null ? ec.getClassLoaderResolver() : nucleusCtx.getClassLoaderResolver(null));
        }
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(this.cmd.getPKMemberPositions()[index]);
            ObjectProvider sm = null;
            if (ec != null) {
                sm = ec.findObjectProvider(value);
            }
            if (sm == null) {
                if (mmd instanceof FieldMetaData) {
                    return ClassUtils.getValueOfFieldByReflection(value, mmd.getName());
                }
                return ClassUtils.getValueOfMethodByReflection(value, ClassUtils.getJavaBeanGetterName(mmd.getName(), false), null);
            }
            if (!mmd.isPrimaryKey()) {
                nucleusCtx.getApiAdapter().isLoaded(sm, mmd.getAbsoluteFieldNumber());
            }
            SingleValueFieldManager fm = new SingleValueFieldManager();
            sm.provideFields(new int[]{mmd.getAbsoluteFieldNumber()}, fm);
            return fm.fetchObjectField(mmd.getAbsoluteFieldNumber());
        }
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
            OID oid = (OID)nucleusCtx.getApiAdapter().getIdForObject(value);
            return oid != null ? oid.getKeyValue() : null;
        }
        return null;
    }

    public void setObject(ExecutionContext ec, Object ps, int[] param, Object value) {
        this.setObject(ec, ps, param, value, null, -1);
    }

    public void setObject(ExecutionContext ec, Object ps, int[] param, Object value, ObjectProvider ownerSM, int ownerFieldNumber) {
        if (value == null) {
            this.setObjectAsNull(ec, ps, param);
        } else {
            this.setObjectAsValue(ec, ps, param, value, ownerSM, ownerFieldNumber);
        }
    }

    private void setObjectAsNull(ExecutionContext ec, Object ps, int[] param) {
        int n = 0;
        for (int i = 0; i < this.javaTypeMappings.length; ++i) {
            JavaTypeMapping mapping = this.javaTypeMappings[i];
            if (mapping.getNumberOfDatastoreMappings() <= 0) continue;
            int[] posMapping = new int[mapping.getNumberOfDatastoreMappings()];
            for (int j = 0; j < posMapping.length; ++j) {
                posMapping[j] = param[n++];
            }
            mapping.setObject(ec, ps, posMapping, null);
        }
    }

    private boolean hasDatastoreAttributedPrimaryKeyValues(MetaDataManager mdm, StoreManager srm, ClassLoaderResolver clr) {
        AbstractClassMetaData acmd;
        boolean hasDatastoreAttributedPrimaryKeyValues = false;
        if (this.mmd != null && this.roleForMember != 4 && this.roleForMember != 3 && this.roleForMember != 5 && this.roleForMember != 6 && (acmd = mdm.getMetaDataForClass(this.mmd.getType(), clr)).getIdentityType() == IdentityType.APPLICATION) {
            for (int i = 0; i < acmd.getPKMemberPositions().length; ++i) {
                IdentityStrategy strategy = acmd.getMetaDataForManagedMemberAtAbsolutePosition(acmd.getPKMemberPositions()[i]).getValueStrategy();
                if (strategy == null) continue;
                hasDatastoreAttributedPrimaryKeyValues |= srm.isStrategyDatastoreAttributed(strategy, false);
            }
        }
        return hasDatastoreAttributedPrimaryKeyValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setObjectAsValue(ExecutionContext ec, Object ps, int[] param, Object value, ObjectProvider ownerSM, int ownerFieldNumber) {
        ApiAdapter api = ec.getApiAdapter();
        if (!api.isPersistable(value)) {
            throw new NucleusException(LOCALISER.msg("041016", value.getClass(), value)).setFatal();
        }
        ObjectProvider valueSM = ec.findObjectProvider(value);
        try {
            Object attachedValue;
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            MappedStoreManager storeMgr = (MappedStoreManager)ec.getStoreManager();
            boolean hasDatastoreAttributedPrimaryKeyValues = this.hasDatastoreAttributedPrimaryKeyValues(ec.getMetaDataManager(), storeMgr, clr);
            boolean inserted = false;
            if (ownerFieldNumber >= 0) {
                inserted = storeMgr.isObjectInserted(valueSM, ownerFieldNumber);
            } else if (this.mmd == null) {
                inserted = storeMgr.isObjectInserted(valueSM, this.type);
            }
            if (valueSM != null) {
                if (ec.getApiAdapter().isDetached(value) && valueSM.getReferencedPC() != null && ownerSM != null && this.mmd != null) {
                    ownerSM.replaceFieldMakeDirty(ownerFieldNumber, valueSM.getReferencedPC());
                }
                if (valueSM.isWaitingToBeFlushedToDatastore()) {
                    valueSM.flush();
                }
            } else if (ec.getApiAdapter().isDetached(value) && (attachedValue = ec.persistObjectInternal(value, null, -1, 0)) != value && ownerSM != null) {
                ownerSM.replaceFieldMakeDirty(ownerFieldNumber, attachedValue);
            }
            if (inserted || !ec.isInserting(value) || !hasDatastoreAttributedPrimaryKeyValues && this.mmd != null && this.mmd.isPrimaryKey() || !hasDatastoreAttributedPrimaryKeyValues && ownerSM == valueSM && api.getIdForObject(value) != null) {
                Object id = api.getIdForObject(value);
                boolean requiresPersisting = false;
                if (ec.getApiAdapter().isDetached(value) && ownerSM != null) {
                    if (ownerSM.isInserting()) {
                        if (!ec.getNucleusContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.attachSameDatastore") && ec.getObjectFromCache(api.getIdForObject(value)) == null) {
                            try {
                                Object obj = ec.findObject(api.getIdForObject(value), true, false, value.getClass().getName());
                                if (obj != null) {
                                    ObjectProvider objSM = ec.findObjectProvider(obj);
                                    if (objSM != null) {
                                        ec.evictFromTransaction(objSM);
                                    }
                                    ec.removeObjectFromCache(api.getIdForObject(value));
                                }
                            }
                            catch (NucleusObjectNotFoundException onfe) {
                                requiresPersisting = true;
                            }
                        }
                    } else {
                        requiresPersisting = true;
                    }
                } else if (id == null) {
                    requiresPersisting = true;
                } else {
                    ExecutionContext pcEC = ec.getApiAdapter().getExecutionContext(value);
                    if (pcEC != null && ec != pcEC) {
                        throw new NucleusUserException(LOCALISER.msg("041015"), id);
                    }
                }
                if (requiresPersisting) {
                    if (this.mmd != null && !this.mmd.isCascadePersist() && !ec.getApiAdapter().isDetached(value)) {
                        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("007006", (Object)this.mmd.getFullFieldName()));
                        }
                        throw new ReachableObjectNotCascadedException(this.mmd.getFullFieldName(), value);
                    }
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("007007", this.mmd != null ? this.mmd.getFullFieldName() : null));
                    }
                    try {
                        Object pcNew = ec.persistObjectInternal(value, null, -1, 0);
                        if (hasDatastoreAttributedPrimaryKeyValues) {
                            ec.flushInternal(false);
                        }
                        id = api.getIdForObject(pcNew);
                        if (ec.getApiAdapter().isDetached(value) && ownerSM != null) {
                            ownerSM.replaceFieldMakeDirty(ownerFieldNumber, pcNew);
                            int relationType = this.mmd.getRelationType(clr);
                            if (relationType == 6) {
                                if (NucleusLogger.PERSISTENCE.isInfoEnabled()) {
                                    NucleusLogger.PERSISTENCE.info("PCMapping.setObject : object " + ownerSM.getInternalObjectId() + " has field " + ownerFieldNumber + " that is 1-N bidirectional." + " Have just attached the N side so should really update the reference in the 1 side collection" + " to refer to this attached object. Not yet implemented");
                                }
                            } else if (relationType == 2) {
                                AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(clr);
                                ObjectProvider relatedSM = ec.findObjectProvider(pcNew);
                                relatedSM.replaceFieldMakeDirty(relatedMmds[0].getAbsoluteFieldNumber(), ownerSM.getObject());
                            }
                        }
                    }
                    catch (NotYetFlushedException e) {
                        this.setObjectAsNull(ec, ps, param);
                        throw new NotYetFlushedException(value);
                    }
                }
                if (valueSM != null) {
                    valueSM.setStoringPC();
                }
                if (this.getNumberOfDatastoreMappings() > 0) {
                    if (id instanceof OID) {
                        super.setObject(ec, ps, param, id);
                    } else {
                        ((PersistenceCapable)value).jdoCopyKeyFieldsFromObjectId((PersistenceCapable.ObjectIdFieldConsumer)new AppIDObjectIdFieldConsumer(param, ec, ps, this.javaTypeMappings), id);
                    }
                }
            } else {
                if (valueSM != null) {
                    valueSM.setStoringPC();
                }
                if (this.getNumberOfDatastoreMappings() > 0) {
                    this.setObjectAsNull(ec, ps, param);
                    throw new NotYetFlushedException(value);
                }
            }
            Object var20_23 = null;
            if (valueSM != null) {
                valueSM.unsetStoringPC();
            }
        }
        catch (Throwable throwable) {
            Object var20_24 = null;
            if (valueSM != null) {
                valueSM.unsetStoringPC();
            }
            throw throwable;
        }
    }

    public Object getObject(ExecutionContext ec, Object rs, int[] param) {
        MappedStoreManager storeMgr = (MappedStoreManager)ec.getStoreManager();
        if (storeMgr.getResultValueAtPosition(rs, this, param[0]) == null) {
            return null;
        }
        if (this.cmd == null) {
            this.cmd = ec.getMetaDataManager().getMetaDataForClass(this.getType(), ec.getClassLoaderResolver());
        }
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
            return this.getObjectForDatastoreIdentity(ec, rs, param, this.cmd);
        }
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            return this.getObjectForApplicationIdentity(ec, rs, param, this.cmd);
        }
        return null;
    }

    private Object getObjectForDatastoreIdentity(ExecutionContext ec, Object rs, int[] param, AbstractClassMetaData cmd) {
        Object oid = super.getObject(ec, rs, param);
        ApiAdapter api = ec.getApiAdapter();
        if (api.isPersistable(oid)) {
            return oid;
        }
        return oid == null ? null : ec.findObject(oid, false, true, null);
    }

    private Object createSingleFieldIdentity(ExecutionContext ec, Object rs, int[] param, AbstractClassMetaData cmd, Class objectIdClass, Class pcClass) {
        int paramNumber = param[0];
        try {
            MappedStoreManager storeMgr = (MappedStoreManager)ec.getStoreManager();
            Object idObj = storeMgr.getResultValueAtPosition(rs, this, paramNumber);
            if (idObj == null) {
                throw new NucleusException(LOCALISER.msg("041039")).setFatal();
            }
            Class keyType = ec.getApiAdapter().getKeyTypeForSingleFieldIdentityType(objectIdClass);
            idObj = ClassUtils.convertValue(idObj, keyType);
            return ec.getApiAdapter().getNewSingleFieldIdentity(objectIdClass, pcClass, idObj);
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error(LOCALISER.msg("041036", (Object)cmd.getObjectidClass(), (Object)e));
            return null;
        }
    }

    private Object createObjectIdInstanceReflection(ExecutionContext ec, Object rs, int[] param, AbstractClassMetaData cmd, Class objectIdClass) {
        Object fieldValue = null;
        try {
            Object id = objectIdClass.newInstance();
            int paramIndex = 0;
            int[] pkFieldNums = cmd.getPKMemberPositions();
            for (int i = 0; i < pkFieldNums.length; ++i) {
                AbstractMemberMetaData fmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNums[i]);
                Field field = objectIdClass.getField(fmd.getName());
                MappedStoreManager storeMgr = (MappedStoreManager)ec.getStoreManager();
                JavaTypeMapping m = storeMgr.getDatastoreClass(cmd.getFullClassName(), ec.getClassLoaderResolver()).getMemberMapping(fmd);
                for (int j = 0; j < m.getNumberOfDatastoreMappings(); ++j) {
                    Object obj;
                    if ((obj = storeMgr.getResultValueAtPosition(rs, this, param[paramIndex++])) instanceof BigDecimal) {
                        BigDecimal bigDecimal = (BigDecimal)obj;
                        Class keyType = ec.getApiAdapter().getKeyTypeForSingleFieldIdentityType(field.getType());
                        obj = ClassUtils.convertValue(bigDecimal, keyType);
                        if (!bigDecimal.subtract(new BigDecimal("" + obj)).equals(new BigDecimal("0"))) {
                            throw new NucleusException("Cannot convert retrieved BigInteger value to field of object id class!").setFatal();
                        }
                    }
                    fieldValue = obj;
                }
                field.set(id, fieldValue);
            }
            return id;
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error(LOCALISER.msg("041037", (Object)cmd.getObjectidClass(), (Object)(this.mmd == null ? null : this.mmd.getName()), fieldValue, (Object)e));
            return null;
        }
    }

    private Object getObjectForAbstractClass(ExecutionContext ec, Object rs, int[] param, AbstractClassMetaData cmd) {
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        Class objectIdClass = clr.classForName(cmd.getObjectidClass());
        Class pcClass = clr.classForName(cmd.getFullClassName());
        Object id = cmd.usesSingleFieldIdentityClass() ? this.createSingleFieldIdentity(ec, rs, param, cmd, objectIdClass, pcClass) : this.createObjectIdInstanceReflection(ec, rs, param, cmd, objectIdClass);
        return ec.findObject(id, false, true, null);
    }

    private Object getObjectForApplicationIdentity(ExecutionContext ec, final Object rs, int[] param, AbstractClassMetaData cmd) {
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        if (((ClassMetaData)cmd).isAbstract() && cmd.getObjectidClass() != null) {
            return this.getObjectForAbstractClass(ec, rs, param, cmd);
        }
        int totalFieldCount = cmd.getNoOfManagedMembers() + cmd.getNoOfInheritedManagedMembers();
        StatementMappingIndex[] statementExpressionIndex = new StatementMappingIndex[totalFieldCount];
        int paramIndex = 0;
        final MappedStoreManager storeMgr = (MappedStoreManager)ec.getStoreManager();
        DatastoreClass datastoreClass = storeMgr.getDatastoreClass(cmd.getFullClassName(), clr);
        final int[] pkFieldNumbers = cmd.getPKMemberPositions();
        for (int i = 0; i < pkFieldNumbers.length; ++i) {
            AbstractMemberMetaData fmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNumbers[i]);
            JavaTypeMapping m = datastoreClass.getMemberMapping(fmd);
            statementExpressionIndex[fmd.getAbsoluteFieldNumber()] = new StatementMappingIndex(m);
            int[] expressionsIndex = new int[m.getNumberOfDatastoreMappings()];
            for (int j = 0; j < expressionsIndex.length; ++j) {
                expressionsIndex[j] = param[paramIndex++];
            }
            statementExpressionIndex[fmd.getAbsoluteFieldNumber()].setColumnPositions(expressionsIndex);
        }
        final StatementClassMapping resultMappings = new StatementClassMapping();
        for (int i = 0; i < pkFieldNumbers.length; ++i) {
            resultMappings.addMappingForMember(pkFieldNumbers[i], statementExpressionIndex[pkFieldNumbers[i]]);
        }
        return ec.findObjectUsingAID(new Type(clr.classForName(cmd.getFullClassName())), new FieldValues(){

            public void fetchFields(ObjectProvider sm) {
                sm.replaceFields(pkFieldNumbers, storeMgr.getFieldManagerForResultProcessing(sm, rs, resultMappings));
            }

            public void fetchNonLoadedFields(ObjectProvider sm) {
                sm.replaceNonLoadedFields(pkFieldNumbers, storeMgr.getFieldManagerForResultProcessing(sm, rs, resultMappings));
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, false, true);
    }

    public void postFetch(ObjectProvider sm) {
    }

    public void insertPostProcessing(ObjectProvider op) {
    }

    public void postInsert(ObjectProvider sm) {
        Object pc = sm.provideField(this.mmd.getAbsoluteFieldNumber());
        if (pc == null) {
            return;
        }
        ClassLoaderResolver clr = sm.getExecutionContext().getClassLoaderResolver();
        AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(clr);
        int relationType = this.mmd.getRelationType(clr);
        if (pc != null) {
            if (relationType == 2) {
                AbstractMemberMetaData relatedMmd;
                ObjectProvider otherSM = sm.getExecutionContext().findObjectProvider(pc);
                Object relatedValue = otherSM.provideField((relatedMmd = this.mmd.getRelatedMemberMetaDataForObject(clr, sm.getObject(), pc)).getAbsoluteFieldNumber());
                if (relatedValue == null) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("041018", (Object)sm.toPrintableID(), (Object)this.mmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(pc), (Object)relatedMmd.getFullFieldName()));
                    }
                    otherSM.replaceField(relatedMmd.getAbsoluteFieldNumber(), sm.getObject());
                } else if (relatedValue != sm.getObject()) {
                    throw new NucleusUserException(LOCALISER.msg("041020", (Object)sm.toPrintableID(), (Object)this.mmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(pc), (Object)StringUtils.toJVMIDString(relatedValue)));
                }
            } else if (relationType == 6 && relatedMmds[0].hasCollection()) {
                boolean contained;
                Collection relatedColl;
                ObjectProvider otherSM = sm.getExecutionContext().findObjectProvider(pc);
                if (otherSM != null && (relatedColl = (Collection)otherSM.provideField(relatedMmds[0].getAbsoluteFieldNumber())) != null && !(relatedColl instanceof SCOCollection) && !(contained = relatedColl.contains(sm.getObject()))) {
                    NucleusLogger.PERSISTENCE.info(LOCALISER.msg("041022", (Object)sm.toPrintableID(), (Object)this.mmd.getFullFieldName(), (Object)StringUtils.toJVMIDString(pc), (Object)relatedMmds[0].getFullFieldName()));
                }
            } else if (relationType == 7) {
                ObjectProvider otherSM = sm.getExecutionContext().findObjectProvider(pc);
                if (otherSM == null) {
                    Object other = sm.getExecutionContext().persistObjectInternal(pc, null, -1, 0);
                    otherSM = sm.getExecutionContext().findObjectProvider(other);
                }
                PersistableRelationStore store = (PersistableRelationStore)this.storeMgr.getBackingStoreForField(sm.getExecutionContext().getClassLoaderResolver(), this.mmd, this.mmd.getType());
                store.add(sm, otherSM);
            }
        }
    }

    public void postUpdate(ObjectProvider sm) {
        Object pc = sm.provideField(this.mmd.getAbsoluteFieldNumber());
        ClassLoaderResolver clr = sm.getExecutionContext().getClassLoaderResolver();
        int relationType = this.mmd.getRelationType(clr);
        if (pc == null) {
            if (relationType == 7) {
                PersistableRelationStore store = (PersistableRelationStore)this.storeMgr.getBackingStoreForField(sm.getExecutionContext().getClassLoaderResolver(), this.mmd, this.mmd.getType());
                store.remove(sm);
            }
            return;
        }
        ObjectProvider otherSM = sm.getExecutionContext().findObjectProvider(pc);
        if (otherSM == null && (relationType == 2 || relationType == 6 || relationType == 7)) {
            Object other = sm.getExecutionContext().persistObjectInternal(pc, null, -1, 0);
            otherSM = sm.getExecutionContext().findObjectProvider(other);
        }
        if (relationType == 7) {
            PersistableRelationStore store = (PersistableRelationStore)this.storeMgr.getBackingStoreForField(sm.getExecutionContext().getClassLoaderResolver(), this.mmd, this.mmd.getType());
            store.update(sm, otherSM);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void preDelete(ObjectProvider sm) {
        ExecutionContext ec = sm.getExecutionContext();
        int fieldNumber = this.mmd.getAbsoluteFieldNumber();
        try {
            ec.getApiAdapter().isLoaded(sm, fieldNumber);
        }
        catch (JDOObjectNotFoundException onfe) {
            return;
        }
        Object pc = sm.provideField(fieldNumber);
        if (pc == null) {
            return;
        }
        ClassLoaderResolver clr = sm.getExecutionContext().getClassLoaderResolver();
        int relationType = this.mmd.getRelationType(clr);
        if (relationType == 7) {
            PersistableRelationStore store = (PersistableRelationStore)this.storeMgr.getBackingStoreForField(sm.getExecutionContext().getClassLoaderResolver(), this.mmd, this.mmd.getType());
            store.remove(sm);
        }
        boolean dependent = this.mmd.isDependent();
        if (this.mmd.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        MappedStoreManager storeMgr = (MappedStoreManager)ec.getStoreManager();
        AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(clr);
        boolean hasFK = false;
        if (!dependent) {
            if (this.mmd.getForeignKeyMetaData() != null) {
                hasFK = true;
            }
            if (relatedMmds != null && relatedMmds[0].getForeignKeyMetaData() != null) {
                hasFK = true;
            }
            if (ec.getNucleusContext().getPersistenceConfiguration().getStringProperty("datanucleus.deletionPolicy").equals("JDO2")) {
                hasFK = false;
            }
        }
        if (relationType == 1 || relationType == 2 && this.mmd.getMappedBy() == null) {
            if (dependent) {
                boolean relatedObjectDeleted = ec.getApiAdapter().isDeleted(pc);
                if (this.isNullable() && !relatedObjectDeleted) {
                    sm.replaceFieldMakeDirty(fieldNumber, null);
                    sm.getExecutionContext().getStoreManager().getPersistenceHandler().updateObject(sm, new int[]{fieldNumber});
                    if (relatedObjectDeleted) return;
                    ec.deleteObjectInternal(pc);
                    return;
                }
                NucleusLogger.DATASTORE_PERSIST.warn("Delete of " + StringUtils.toJVMIDString(sm.getObject()) + " needs delete of related object at " + this.mmd.getFullFieldName() + " but cannot delete it direct since FK is here");
                return;
            }
            AbstractMemberMetaData relatedMmd = this.mmd.getRelatedMemberMetaDataForObject(clr, sm.getObject(), pc);
            if (relatedMmd == null) return;
            ObjectProvider otherSM = ec.findObjectProvider(pc);
            if (otherSM == null) return;
            Object currentValue = otherSM.provideField(relatedMmd.getAbsoluteFieldNumber());
            if (currentValue == null) return;
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("041019", (Object)StringUtils.toJVMIDString(pc), (Object)relatedMmd.getFullFieldName(), (Object)sm.toPrintableID()));
            }
            otherSM.replaceFieldMakeDirty(relatedMmd.getAbsoluteFieldNumber(), null);
            if (!ec.getManageRelations()) return;
            otherSM.getExecutionContext().getRelationshipManager(otherSM).relationChange(relatedMmd.getAbsoluteFieldNumber(), sm.getObject(), null);
            return;
        }
        if (relationType == 2 && this.mmd.getMappedBy() != null) {
            DatastoreClass relatedTable = storeMgr.getDatastoreClass(relatedMmds[0].getClassName(), clr);
            JavaTypeMapping relatedMapping = relatedTable.getMemberMapping(relatedMmds[0]);
            boolean isNullable = relatedMapping.isNullable();
            ObjectProvider otherSM = ec.findObjectProvider(pc);
            if (!dependent) {
                if (hasFK) return;
                if (!this.isNullable()) return;
                Object currentRelatedValue = otherSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
                if (currentRelatedValue == null) return;
                otherSM.replaceFieldMakeDirty(relatedMmds[0].getAbsoluteFieldNumber(), null);
                ec.getStoreManager().getPersistenceHandler().updateObject(otherSM, new int[]{relatedMmds[0].getAbsoluteFieldNumber()});
                if (!ec.getManageRelations()) return;
                otherSM.getExecutionContext().getRelationshipManager(otherSM).relationChange(relatedMmds[0].getAbsoluteFieldNumber(), sm.getObject(), null);
                return;
            }
            if (isNullable) {
                otherSM.replaceFieldMakeDirty(relatedMmds[0].getAbsoluteFieldNumber(), null);
                otherSM.getExecutionContext().getStoreManager().getPersistenceHandler().updateObject(otherSM, new int[]{relatedMmds[0].getAbsoluteFieldNumber()});
            }
            ec.deleteObjectInternal(pc);
            return;
        }
        if (relationType == 6) {
            ObjectProvider otherSM = ec.findObjectProvider(pc);
            if (relatedMmds[0].getJoinMetaData() == null) {
                if (otherSM.isDeleting()) {
                    return;
                }
                if (dependent) {
                    if (this.isNullable()) {
                        sm.replaceFieldMakeDirty(fieldNumber, null);
                        sm.getExecutionContext().getStoreManager().getPersistenceHandler().updateObject(sm, new int[]{fieldNumber});
                    }
                    if (ec.getApiAdapter().isDeleted(pc)) {
                        return;
                    }
                    ec.deleteObjectInternal(pc);
                    return;
                }
                if (!relatedMmds[0].hasCollection()) {
                    if (!relatedMmds[0].hasMap()) return;
                    return;
                }
                if (ec.getApiAdapter().isDeleted(otherSM.getObject())) return;
                if (otherSM.isDeleting()) return;
                ec.markDirty(otherSM, false);
                Collection otherColl = (Collection)otherSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
                if (otherColl == null) return;
                if (ec.getManageRelations()) {
                    otherSM.getExecutionContext().getRelationshipManager(otherSM).relationRemove(relatedMmds[0].getAbsoluteFieldNumber(), sm.getObject());
                }
                NucleusLogger.PERSISTENCE.debug("ManagedRelationships : delete of object causes removal from collection at " + relatedMmds[0].getFullFieldName());
                otherColl.remove(sm.getObject());
                return;
            }
            if (dependent) {
                ec.deleteObjectInternal(pc);
                return;
            }
            if (relatedMmds[0].hasCollection()) {
                if (ec.getApiAdapter().isDeleted(otherSM.getObject())) return;
                if (otherSM.isDeleting()) return;
                ec.markDirty(otherSM, false);
                otherSM.isLoaded(relatedMmds[0].getAbsoluteFieldNumber());
                Collection otherColl = (Collection)otherSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
                if (otherColl == null) return;
                NucleusLogger.PERSISTENCE.debug("ManagedRelationships : delete of object causes removal from collection at " + relatedMmds[0].getFullFieldName());
                otherColl.remove(sm.getObject());
                return;
            }
            if (!relatedMmds[0].hasMap()) return;
            return;
        } else {
            if (relationType != 7) return;
            if (!dependent) return;
            ec.deleteObjectInternal(pc);
        }
    }
}

