/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import java.util.Collection;
import org.datanucleus.ClassConstants;
import org.datanucleus.NucleusContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public abstract class AbstractLevel2Cache
implements Level2Cache {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected int maxSize = -1;
    protected boolean clearAtClose = true;
    protected String cacheName;

    public AbstractLevel2Cache(NucleusContext nucleusCtx) {
        PersistenceConfiguration conf = nucleusCtx.getPersistenceConfiguration();
        this.maxSize = conf.getIntProperty("datanucleus.cache.level2.maxSize");
        this.clearAtClose = conf.getBooleanProperty("datanucleus.cache.level2.clearAtClose", true);
        this.cacheName = conf.getStringProperty("datanucleus.cache.level2.cacheName");
        if (this.cacheName == null) {
            NucleusLogger.CACHE.warn("No 'datanucleus.cache.level2.cacheName' specified so using name of 'dataNucleus'");
            this.cacheName = "dataNucleus";
        }
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public int getNumberOfPinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfPinnedObjects() method not supported by this plugin");
    }

    public int getNumberOfUnpinnedObjects() {
        throw new UnsupportedOperationException("getNumberOfUnpinnedObjects() method not supported by this plugin");
    }

    public void pin(Object arg0) {
        throw new UnsupportedOperationException("pin(Object) method not supported by this plugin");
    }

    public void pinAll(Collection arg0) {
        throw new UnsupportedOperationException("pinAll(Collection) method not supported by this plugin");
    }

    public void pinAll(Object[] arg0) {
        throw new UnsupportedOperationException("pinAll(Object[]) method not supported by this plugin");
    }

    public void pinAll(Class arg0, boolean arg1) {
        throw new UnsupportedOperationException("pinAll(Class,boolean) method not supported by this plugin");
    }

    public void unpin(Object arg0) {
        throw new UnsupportedOperationException("unpin(Object) method not supported by this plugin");
    }

    public void unpinAll(Collection arg0) {
        throw new UnsupportedOperationException("unpinAll(Collection) method not supported by this plugin");
    }

    public void unpinAll(Object[] arg0) {
        throw new UnsupportedOperationException("unpinAll(Object[]) method not supported by this plugin");
    }

    public void unpinAll(Class arg0, boolean arg1) {
        throw new UnsupportedOperationException("unpinAll(Class,boolean) method not supported by this plugin");
    }
}

