/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.sco.backed;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.state.ObjectProviderFactory;
import org.datanucleus.store.BackedSCOStoreManager;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.store.types.sco.SCOUtils;
import org.datanucleus.store.types.sco.backed.Set;
import org.datanucleus.store.types.sco.queued.ClearMapOperation;
import org.datanucleus.store.types.sco.queued.OperationQueue;
import org.datanucleus.store.types.sco.queued.PutOperation;
import org.datanucleus.store.types.sco.queued.QueuedOperation;
import org.datanucleus.store.types.sco.queued.RemoveMapOperation;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedMap
extends org.datanucleus.store.types.sco.simple.SortedMap {
    protected transient boolean allowNulls = false;
    protected transient MapStore backingStore;
    protected transient boolean useCache = true;
    protected transient boolean isCacheLoaded = false;
    protected transient boolean queued = false;
    protected transient OperationQueue<MapStore> operationQueue = null;

    public SortedMap(ObjectProvider ownerSM, String fieldName) {
        super(ownerSM, fieldName);
        Comparator comparator;
        ExecutionContext ec = ownerSM.getExecutionContext();
        AbstractMemberMetaData fmd = ownerSM.getClassMetaData().getMetaDataForMember(fieldName);
        this.fieldNumber = fmd.getAbsoluteFieldNumber();
        this.allowNulls = SCOUtils.allowNullsInContainer(this.allowNulls, fmd);
        this.queued = ec.isDelayDatastoreOperationsEnabled();
        this.useCache = SCOUtils.useContainerCache(ownerSM, fieldName);
        if (!SCOUtils.mapHasSerialisedKeysAndValues(fmd) && fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            this.backingStore = (MapStore)((BackedSCOStoreManager)((Object)ec.getStoreManager())).getBackingStoreForField(clr, fmd, java.util.SortedMap.class);
        }
        this.delegate = (comparator = SCOUtils.getComparator(fmd, ownerSM.getExecutionContext().getClassLoaderResolver())) != null ? new TreeMap(comparator) : new TreeMap();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(SCOUtils.getContainerInfoMessage(ownerSM, fieldName, this, this.useCache, this.queued, this.allowNulls, SCOUtils.useCachedLazyLoading(ownerSM, fieldName)));
        }
    }

    @Override
    public void initialise(Object o, boolean forInsert, boolean forUpdate) {
        Map m = (Map)o;
        if (m != null) {
            AbstractMemberMetaData fmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName);
            if (SCOUtils.mapHasSerialisedKeysAndValues(fmd) && (fmd.getMap().keyIsPersistent() || fmd.getMap().valueIsPersistent())) {
                ExecutionContext ec = this.ownerSM.getExecutionContext();
                for (Map.Entry entry : m.entrySet()) {
                    ObjectProvider objSM;
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (fmd.getMap().keyIsPersistent() && (objSM = ec.findObjectProvider(key)) == null) {
                        objSM = ObjectProviderFactory.newForEmbedded(ec, key, false, this.ownerSM, this.fieldNumber);
                    }
                    if (!fmd.getMap().valueIsPersistent() || (objSM = ec.findObjectProvider(value)) != null) continue;
                    objSM = ObjectProviderFactory.newForEmbedded(ec, value, false, this.ownerSM, this.fieldNumber);
                }
            }
            if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
                this.isCacheLoaded = true;
            }
            if (forInsert) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023007", (Object)this.ownerSM.toPrintableID(), (Object)this.fieldName, (Object)("" + m.size())));
                }
                this.putAll(m);
            } else if (forUpdate) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023008", (Object)this.ownerSM.toPrintableID(), (Object)this.fieldName, (Object)("" + m.size())));
                }
                this.clear();
                this.putAll(m);
            } else {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023007", (Object)this.ownerSM.toPrintableID(), (Object)this.fieldName, (Object)("" + m.size())));
                }
                this.delegate.clear();
                this.delegate.putAll(m);
            }
        }
    }

    @Override
    public void initialise() {
        if (this.useCache && !SCOUtils.useCachedLazyLoading(this.ownerSM, this.fieldName)) {
            this.loadFromStore();
        }
    }

    @Override
    public Object getValue() {
        this.loadFromStore();
        return super.getValue();
    }

    @Override
    public void load() {
        if (this.useCache) {
            this.loadFromStore();
        }
    }

    @Override
    public boolean isLoaded() {
        return this.useCache ? this.isCacheLoaded : false;
    }

    protected void loadFromStore() {
        if (this.backingStore != null && !this.isCacheLoaded) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023006", (Object)this.ownerSM.toPrintableID(), (Object)this.fieldName));
            }
            this.delegate.clear();
            SCOUtils.populateMapDelegateWithStoreData(this.delegate, this.backingStore, this.ownerSM);
            this.isCacheLoaded = true;
        }
    }

    @Override
    public void flush() {
        if (this.queued && this.operationQueue != null) {
            this.operationQueue.performAll(this.backingStore, this.ownerSM, this.fieldName);
        }
    }

    protected void addQueuedOperation(QueuedOperation<? super MapStore> op) {
        if (this.operationQueue == null) {
            this.operationQueue = new OperationQueue();
        }
        this.operationQueue.enqueue(op);
    }

    @Override
    public void updateEmbeddedKey(Object key, int fieldNumber, Object newValue) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedKey(this.ownerSM, key, fieldNumber, newValue);
        }
    }

    @Override
    public void updateEmbeddedValue(Object value, int fieldNumber, Object newValue) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedValue(this.ownerSM, value, fieldNumber, newValue);
        }
    }

    @Override
    public synchronized void unsetOwner() {
        super.unsetOwner();
        if (this.backingStore != null) {
            this.backingStore = null;
        }
    }

    @Override
    public Object clone() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return this.delegate.clone();
    }

    @Override
    public Comparator comparator() {
        return this.delegate.comparator();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.containsKey(key);
        }
        if (this.backingStore != null) {
            return this.backingStore.containsKey(this.ownerSM, key);
        }
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.containsValue(value);
        }
        if (this.backingStore != null) {
            return this.backingStore.containsValue(this.ownerSM, value);
        }
        return this.delegate.containsValue(value);
    }

    @Override
    public java.util.Set entrySet() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Set(this.ownerSM, this.fieldName, false, this.backingStore.entrySetStore());
        }
        return this.delegate.entrySet();
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        return ((Object)this.entrySet()).equals(m.entrySet());
    }

    @Override
    public Object firstKey() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.firstKey();
        }
        if (!this.useCache) {
            java.util.Set keys = this.keySet();
            Iterator keysIter = keys.iterator();
            return keysIter.next();
        }
        this.loadFromStore();
        return this.delegate.firstKey();
    }

    @Override
    public Object lastKey() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.lastKey();
        }
        if (!this.useCache) {
            java.util.Set keys = this.keySet();
            Iterator keysIter = keys.iterator();
            Object last = null;
            while (keysIter.hasNext()) {
                last = keysIter.next();
            }
            return last;
        }
        this.loadFromStore();
        return this.delegate.lastKey();
    }

    @Override
    public java.util.SortedMap headMap(Object toKey) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.headMap(toKey);
        }
        if (!this.useCache) {
            throw new NucleusUserException("Don't currently support SortedMap.headMap() when not using cached containers");
        }
        this.loadFromStore();
        return this.delegate.headMap(toKey);
    }

    @Override
    public java.util.SortedMap subMap(Object fromKey, Object toKey) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.subMap(fromKey, toKey);
        }
        if (!this.useCache) {
            throw new NucleusUserException("Don't currently support SortedMap.subMap() when not using cached container");
        }
        this.loadFromStore();
        return this.delegate.subMap(fromKey, toKey);
    }

    @Override
    public java.util.SortedMap tailMap(Object fromKey) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.headMap(fromKey);
        }
        if (!this.useCache) {
            throw new NucleusUserException("Don't currently support SortedMap.tailMap() when not using cached containers");
        }
        this.loadFromStore();
        return this.delegate.headMap(fromKey);
    }

    @Override
    public Object get(Object key) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.get(this.ownerSM, key);
        }
        return this.delegate.get(key);
    }

    @Override
    public synchronized int hashCode() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            int h = 0;
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                h += i.next().hashCode();
            }
            return h;
        }
        return this.delegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public java.util.Set keySet() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Set(this.ownerSM, this.fieldName, false, this.backingStore.keySetStore());
        }
        return this.delegate.keySet();
    }

    @Override
    public int size() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.size();
        }
        if (this.backingStore != null) {
            return this.backingStore.entrySetStore().size(this.ownerSM);
        }
        return this.delegate.size();
    }

    @Override
    public Collection values() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return new Set(this.ownerSM, this.fieldName, true, this.backingStore.valueSetStore());
        }
        return this.delegate.values();
    }

    @Override
    public void clear() {
        this.makeDirty();
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
                this.addQueuedOperation(new ClearMapOperation());
            } else {
                this.backingStore.clear(this.ownerSM);
            }
        }
        this.delegate.clear();
    }

    @Override
    public Object put(Object key, Object value) {
        if (!this.allowNulls) {
            if (value == null) {
                throw new NullPointerException("Nulls not allowed for map at field " + this.fieldName + " but value is null");
            }
            if (key == null) {
                throw new NullPointerException("Nulls not allowed for map at field " + this.fieldName + " but key is null");
            }
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        this.makeDirty();
        Object oldValue = null;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
                this.addQueuedOperation(new PutOperation(key, value));
            } else {
                oldValue = this.backingStore.put(this.ownerSM, key, value);
            }
        }
        Object delegateOldValue = this.delegate.put(key, value);
        if (this.backingStore == null) {
            oldValue = delegateOldValue;
        } else if (SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
            oldValue = delegateOldValue;
        }
        return oldValue;
    }

    @Override
    public void putAll(Map m) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
                for (Map.Entry entry : m.entrySet()) {
                    this.addQueuedOperation(new PutOperation(entry.getKey(), entry.getValue()));
                }
            } else {
                this.backingStore.putAll(this.ownerSM, m);
            }
        }
        this.delegate.putAll(m);
    }

    @Override
    public Object remove(Object key) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        Object removed = null;
        Object delegateRemoved = this.delegate.remove(key);
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
                this.addQueuedOperation(new RemoveMapOperation(key));
                removed = delegateRemoved;
            } else {
                removed = this.backingStore.remove(this.ownerSM, key);
            }
        } else {
            removed = delegateRemoved;
        }
        return removed;
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        if (this.useCache) {
            this.loadFromStore();
            return new TreeMap(this.delegate);
        }
        return new TreeMap(this.delegate);
    }
}

