/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import java.util.Collection;
import java.util.Map;
import org.datanucleus.ClassConstants;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.store.types.sco.SCO;
import org.datanucleus.store.types.sco.SCOContainer;
import org.datanucleus.store.types.sco.SCOUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class AttachFieldManager
extends AbstractFieldManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    private final ObjectProvider smAttached;
    private final boolean[] secondClassMutableFields;
    private final boolean[] dirtyFields;
    private final boolean persistent;
    private final boolean cascadeAttach;
    boolean copy = true;

    public AttachFieldManager(ObjectProvider smAttached, boolean[] secondClassMutableFields, boolean[] dirtyFields, boolean persistent, boolean cascadeAttach, boolean copy) {
        this.smAttached = smAttached;
        this.secondClassMutableFields = secondClassMutableFields;
        this.dirtyFields = dirtyFields;
        this.persistent = persistent;
        this.cascadeAttach = cascadeAttach;
        this.copy = copy;
    }

    public void storeObjectField(int fieldNumber, Object value) {
        AbstractClassMetaData cmd = this.smAttached.getClassMetaData();
        AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.hasExtension("attach") && mmd.getValueForExtension("attach").equalsIgnoreCase("never")) {
            this.smAttached.replaceFieldMakeDirty(fieldNumber, null);
            return;
        }
        ExecutionContext ec = this.smAttached.getExecutionContext();
        ApiAdapter api = ec.getApiAdapter();
        if (value == null) {
            Object oldValue = null;
            if (mmd.isDependent() && this.persistent) {
                try {
                    this.smAttached.loadFieldFromDatastore(fieldNumber);
                }
                catch (Exception e) {
                    // empty catch block
                }
                oldValue = this.smAttached.provideField(fieldNumber);
            }
            this.smAttached.replaceField(fieldNumber, null);
            if (this.dirtyFields[fieldNumber] || !this.persistent) {
                this.smAttached.makeDirty(fieldNumber);
            }
            if (mmd.isDependent() && !mmd.isEmbedded() && oldValue != null && value == null && api.isPersistable(oldValue)) {
                this.smAttached.flush();
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026026", oldValue, (Object)mmd.getFullFieldName()));
                ec.deleteObjectInternal(oldValue);
            }
        } else if (this.secondClassMutableFields[fieldNumber]) {
            if (mmd.isSerialized()) {
                this.smAttached.replaceFieldMakeDirty(fieldNumber, value);
                this.smAttached.makeDirty(fieldNumber);
            } else {
                SCO sco;
                Object oldValue = this.smAttached.provideField(fieldNumber);
                if (oldValue == null && !this.smAttached.getLoadedFields()[fieldNumber] && this.persistent) {
                    this.smAttached.loadField(fieldNumber);
                    oldValue = this.smAttached.provideField(fieldNumber);
                }
                if (oldValue == null || oldValue != null && !(oldValue instanceof SCO)) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026029", (Object)StringUtils.toJVMIDString(this.smAttached.getObject()), this.smAttached.getInternalObjectId(), (Object)mmd.getName()));
                    }
                    if ((sco = SCOUtils.newSCOInstance(this.smAttached, mmd, mmd.getType(), null, null, false, false, false)) instanceof SCOContainer) {
                        ((SCOContainer)sco).load();
                    }
                    this.smAttached.replaceFieldMakeDirty(fieldNumber, sco);
                } else {
                    sco = (SCO)oldValue;
                }
                if (this.cascadeAttach) {
                    if (this.copy) {
                        sco.attachCopy(value);
                    } else if (sco instanceof Collection) {
                        SCOUtils.attachForCollection(this.smAttached, ((Collection)value).toArray(), SCOUtils.collectionHasElementsWithoutIdentity(mmd));
                    } else if (sco instanceof Map) {
                        SCOUtils.attachForMap(this.smAttached, ((Map)value).entrySet(), SCOUtils.mapHasKeysWithoutIdentity(mmd), SCOUtils.mapHasValuesWithoutIdentity(mmd));
                    } else {
                        sco.initialise(value, false, false);
                    }
                }
                if (this.dirtyFields[fieldNumber] || !this.persistent) {
                    this.smAttached.makeDirty(fieldNumber);
                }
            }
        } else if (api.isPersistable(value)) {
            ObjectProvider valueSM = ec.findObjectProvider(value);
            if (valueSM != null && valueSM.getReferencedPC() != null && !api.isPersistent(value)) {
                this.smAttached.replaceFieldMakeDirty(fieldNumber, valueSM.getReferencedPC());
            }
            if (this.cascadeAttach) {
                boolean sco;
                boolean bl = sco = mmd.getEmbeddedMetaData() != null || mmd.isSerialized() || mmd.isEmbedded();
                if (this.copy) {
                    value = ec.attachObjectCopy(value, sco);
                    this.smAttached.replaceFieldMakeDirty(fieldNumber, value);
                } else {
                    ec.attachObject(value, sco);
                }
                if (this.dirtyFields[fieldNumber] || !this.persistent) {
                    this.smAttached.makeDirty(fieldNumber);
                } else if (sco && value != null && api.isDirty(value)) {
                    this.smAttached.makeDirty(fieldNumber);
                }
            } else if (this.dirtyFields[fieldNumber] || !this.persistent) {
                this.smAttached.makeDirty(fieldNumber);
            }
        } else {
            this.smAttached.replaceField(fieldNumber, value);
            if (this.dirtyFields[fieldNumber] || !this.persistent) {
                this.smAttached.makeDirty(fieldNumber);
            }
        }
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        sfv.storeBooleanField(fieldNumber, value);
        this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeByteField(int fieldNumber, byte value) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        sfv.storeByteField(fieldNumber, value);
        this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeCharField(int fieldNumber, char value) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        sfv.storeCharField(fieldNumber, value);
        this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeDoubleField(int fieldNumber, double value) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        sfv.storeDoubleField(fieldNumber, value);
        this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeFloatField(int fieldNumber, float value) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        sfv.storeFloatField(fieldNumber, value);
        this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeIntField(int fieldNumber, int value) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        sfv.storeIntField(fieldNumber, value);
        this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeLongField(int fieldNumber, long value) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        sfv.storeLongField(fieldNumber, value);
        this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeShortField(int fieldNumber, short value) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        sfv.storeShortField(fieldNumber, value);
        this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeStringField(int fieldNumber, String value) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        sfv.storeStringField(fieldNumber, value);
        this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.smAttached.makeDirty(fieldNumber);
        }
    }
}

