/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.plugin;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.plugin.Bundle;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.Extension;
import org.datanucleus.plugin.ExtensionPoint;
import org.datanucleus.plugin.PluginRegistry;
import org.datanucleus.plugin.PluginRegistryFactory;

public class PluginManager {
    private PluginRegistry registry;

    public PluginManager(String registryClassName, ClassLoaderResolver clr, Properties props) {
        String validateStr;
        String allowUserBundles;
        String bundleCheckAction = "EXCEPTION";
        if (props.containsKey("bundle-check-action")) {
            bundleCheckAction = props.getProperty("bundle-check-action");
        }
        boolean userBundles = (allowUserBundles = props.getProperty("allow-user-bundles")) != null ? Boolean.valueOf(allowUserBundles) : false;
        this.registry = PluginRegistryFactory.newPluginRegistry(registryClassName, bundleCheckAction, userBundles, clr);
        this.registry.registerExtensionPoints();
        this.registry.registerExtensions();
        String string = validateStr = props.containsKey("validate-plugins") ? props.getProperty("validate-plugins") : "false";
        if (validateStr.equalsIgnoreCase("true")) {
            this.registry.resolveConstraints();
        }
    }

    public String getRegistryClassName() {
        return this.registry.getClass().getName();
    }

    public ExtensionPoint getExtensionPoint(String id) {
        return this.registry.getExtensionPoint(id);
    }

    public ExtensionPoint[] getExtensionPoints() {
        return this.registry.getExtensionPoints();
    }

    public ConfigurationElement getConfigurationElementForExtension(String extensionPointName, String discrimAttrName, String discrimAttrValue) {
        ExtensionPoint extensionPoint = this.getExtensionPoint(extensionPointName);
        if (extensionPoint != null) {
            Extension[] ex = extensionPoint.getExtensions();
            for (int i = 0; i < ex.length; ++i) {
                ConfigurationElement[] confElm = ex[i].getConfigurationElements();
                for (int j = 0; j < confElm.length; ++j) {
                    if (confElm[j].getAttribute(discrimAttrName) == null || !confElm[j].getAttribute(discrimAttrName).equalsIgnoreCase(discrimAttrValue)) continue;
                    return confElm[j];
                }
            }
        }
        return null;
    }

    public ConfigurationElement[] getConfigurationElementsForExtension(String extensionPointName, String discrimAttrName, String discrimAttrValue) {
        ExtensionPoint extensionPoint = this.getExtensionPoint(extensionPointName);
        HashSet<ConfigurationElement> elems = new HashSet<ConfigurationElement>();
        if (extensionPoint != null) {
            Extension[] ex = extensionPoint.getExtensions();
            for (int i = 0; i < ex.length; ++i) {
                ConfigurationElement[] confElm = ex[i].getConfigurationElements();
                for (int j = 0; j < confElm.length; ++j) {
                    if (discrimAttrName == null) {
                        elems.add(confElm[j]);
                        continue;
                    }
                    if (confElm[j].getAttribute(discrimAttrName) == null || !confElm[j].getAttribute(discrimAttrName).equalsIgnoreCase(discrimAttrValue)) continue;
                    elems.add(confElm[j]);
                }
            }
        }
        if (elems.size() > 0) {
            return elems.toArray(new ConfigurationElement[elems.size()]);
        }
        return null;
    }

    public ConfigurationElement getConfigurationElementForExtension(String extensionPointName, String[] discrimAttrName, String[] discrimAttrValue) {
        ExtensionPoint extensionPoint = this.getExtensionPoint(extensionPointName);
        if (extensionPoint != null) {
            Extension[] ex = extensionPoint.getExtensions();
            for (int i = 0; i < ex.length; ++i) {
                ConfigurationElement[] confElm = ex[i].getConfigurationElements();
                for (int j = 0; j < confElm.length; ++j) {
                    boolean equals = true;
                    for (int k = 0; k < discrimAttrName.length; ++k) {
                        if (confElm[j].getAttribute(discrimAttrName[k]) == null && discrimAttrValue[k] != null) {
                            equals = false;
                            break;
                        }
                        if (confElm[j].getAttribute(discrimAttrName[k]).equalsIgnoreCase(discrimAttrValue[k])) continue;
                        equals = false;
                        break;
                    }
                    if (!equals) continue;
                    return confElm[j];
                }
            }
        }
        return null;
    }

    public String getAttributeValueForExtension(String extensionPoint, String discrimAttrName, String discrimAttrValue, String attributeName) {
        ConfigurationElement elem = this.getConfigurationElementForExtension(extensionPoint, discrimAttrName, discrimAttrValue);
        if (elem != null) {
            return elem.getAttribute(attributeName);
        }
        return null;
    }

    public String[] getAttributeValuesForExtension(String extensionPoint, String discrimAttrName, String discrimAttrValue, String attributeName) {
        ConfigurationElement[] elems = this.getConfigurationElementsForExtension(extensionPoint, discrimAttrName, discrimAttrValue);
        if (elems != null) {
            String[] attrValues = new String[elems.length];
            for (int i = 0; i < elems.length; ++i) {
                attrValues[i] = elems[i].getAttribute(attributeName);
            }
            return attrValues;
        }
        return null;
    }

    public String getAttributeValueForExtension(String extensionPoint, String[] discrimAttrName, String[] discrimAttrValue, String attributeName) {
        ConfigurationElement elem = this.getConfigurationElementForExtension(extensionPoint, discrimAttrName, discrimAttrValue);
        if (elem != null) {
            return elem.getAttribute(attributeName);
        }
        return null;
    }

    public Object createExecutableExtension(String extensionPoint, String discrimAttrName, String discrimAttrValue, String attributeName, Class[] argsClass, Object[] args) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ConfigurationElement elem = this.getConfigurationElementForExtension(extensionPoint, discrimAttrName, discrimAttrValue);
        if (elem != null) {
            return this.registry.createExecutableExtension(elem, attributeName, argsClass, args);
        }
        return null;
    }

    public Object createExecutableExtension(String extensionPoint, String[] discrimAttrName, String[] discrimAttrValue, String attributeName, Class[] argsClass, Object[] args) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ConfigurationElement elem = this.getConfigurationElementForExtension(extensionPoint, discrimAttrName, discrimAttrValue);
        if (elem != null) {
            return this.registry.createExecutableExtension(elem, attributeName, argsClass, args);
        }
        return null;
    }

    public Class loadClass(String pluginId, String className) throws ClassNotResolvedException {
        try {
            return this.registry.loadClass(pluginId, className);
        }
        catch (ClassNotFoundException ex) {
            throw new ClassNotResolvedException(ex.getMessage(), ex);
        }
    }

    public URL resolveURLAsFileURL(URL url) throws IOException {
        return this.registry.resolveURLAsFileURL(url);
    }

    public String getVersionForBundle(String bundleName) {
        Bundle[] bundles = this.registry.getBundles();
        if (bundles != null) {
            for (int i = 0; i < bundles.length; ++i) {
                Bundle bundle = bundles[i];
                if (!bundle.getSymbolicName().equals(bundleName)) continue;
                return bundle.getVersion();
            }
        }
        return null;
    }
}

