/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.sco.backed;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.state.ObjectProviderFactory;
import org.datanucleus.store.BackedSCOStoreManager;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.scostore.ListStore;
import org.datanucleus.store.types.sco.SCOListIterator;
import org.datanucleus.store.types.sco.SCOUtils;
import org.datanucleus.store.types.sco.queued.AddAtOperation;
import org.datanucleus.store.types.sco.queued.AddOperation;
import org.datanucleus.store.types.sco.queued.ClearCollectionOperation;
import org.datanucleus.store.types.sco.queued.OperationQueue;
import org.datanucleus.store.types.sco.queued.QueuedOperation;
import org.datanucleus.store.types.sco.queued.RemoveAtOperation;
import org.datanucleus.store.types.sco.queued.RemoveCollectionOperation;
import org.datanucleus.store.types.sco.queued.SetOperation;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vector
extends org.datanucleus.store.types.sco.simple.Vector {
    protected transient ListStore backingStore;
    protected transient boolean allowNulls = false;
    protected transient boolean useCache = true;
    protected transient boolean isCacheLoaded = false;
    protected transient boolean queued = false;
    protected transient OperationQueue<ListStore> operationQueue = null;

    public Vector(ObjectProvider ownerSM, String fieldName) {
        super(ownerSM, fieldName);
        this.delegate = new java.util.Vector();
        if (ownerSM != null) {
            ExecutionContext ec = ownerSM.getExecutionContext();
            AbstractMemberMetaData fmd = ownerSM.getClassMetaData().getMetaDataForMember(fieldName);
            this.allowNulls = SCOUtils.allowNullsInContainer(this.allowNulls, fmd);
            this.queued = ec.isDelayDatastoreOperationsEnabled();
            this.useCache = SCOUtils.useContainerCache(ownerSM, fieldName);
            if (!SCOUtils.collectionHasSerialisedElements(fmd) && fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                ClassLoaderResolver clr = ec.getClassLoaderResolver();
                this.backingStore = (ListStore)((BackedSCOStoreManager)((Object)ec.getStoreManager())).getBackingStoreForField(clr, fmd, java.util.Vector.class);
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(SCOUtils.getContainerInfoMessage(ownerSM, fieldName, this, this.useCache, this.queued, this.allowNulls, SCOUtils.useCachedLazyLoading(ownerSM, fieldName)));
            }
        }
    }

    @Override
    public void initialise(Object o, boolean forInsert, boolean forUpdate) {
        Collection c = (Collection)o;
        if (c != null) {
            AbstractMemberMetaData fmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName);
            if (SCOUtils.collectionHasSerialisedElements(fmd) && fmd.getCollection().elementIsPersistent()) {
                ExecutionContext ec = this.ownerSM.getExecutionContext();
                for (Object pc : c) {
                    ObjectProvider objSM = ec.findObjectProvider(pc);
                    if (objSM != null) continue;
                    objSM = ObjectProviderFactory.newForEmbedded(ec, pc, false);
                    objSM.addEmbeddedOwner(this.ownerSM, this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName).getAbsoluteFieldNumber());
                }
            }
            if (this.backingStore != null && this.useCache && !this.isCacheLoaded) {
                this.isCacheLoaded = true;
            }
            if (forInsert) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023007", (Object)this.ownerSM.toPrintableID(), (Object)this.fieldName, (Object)("" + c.size())));
                }
                this.addAll(c);
            } else if (forUpdate) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023008", (Object)this.ownerSM.toPrintableID(), (Object)this.fieldName, (Object)("" + c.size())));
                }
                this.clear();
                this.addAll(c);
            } else {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023007", (Object)this.ownerSM.toPrintableID(), (Object)this.fieldName, (Object)("" + c.size())));
                }
                this.delegate.clear();
                this.delegate.addAll(c);
            }
        }
    }

    @Override
    public void initialise() {
        if (this.useCache && !SCOUtils.useCachedLazyLoading(this.ownerSM, this.fieldName)) {
            this.loadFromStore();
        }
    }

    @Override
    public Object getValue() {
        this.loadFromStore();
        return super.getValue();
    }

    @Override
    public void load() {
        if (this.useCache) {
            this.loadFromStore();
        }
    }

    @Override
    public boolean isLoaded() {
        return this.useCache ? this.isCacheLoaded : false;
    }

    protected void loadFromStore() {
        if (this.backingStore != null && !this.isCacheLoaded) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023006", (Object)this.ownerSM.toPrintableID(), (Object)this.fieldName));
            }
            this.delegate.clear();
            Iterator iter = this.backingStore.iterator(this.ownerSM);
            while (iter.hasNext()) {
                this.delegate.add(iter.next());
            }
            this.isCacheLoaded = true;
        }
    }

    @Override
    public void flush() {
        if (this.queued && this.operationQueue != null) {
            this.operationQueue.performAll(this.backingStore, this.ownerSM, this.fieldName);
        }
    }

    protected void addQueuedOperation(QueuedOperation<? super ListStore> op) {
        if (this.operationQueue == null) {
            this.operationQueue = new OperationQueue();
        }
        this.operationQueue.enqueue(op);
    }

    @Override
    public void updateEmbeddedElement(Object element, int fieldNumber, Object value) {
        if (this.backingStore != null) {
            this.backingStore.updateEmbeddedElement(this.ownerSM, element, fieldNumber, value);
        }
    }

    @Override
    public synchronized void unsetOwner() {
        super.unsetOwner();
        if (this.backingStore != null) {
            this.backingStore = null;
        }
    }

    @Override
    public Object clone() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return this.delegate.clone();
    }

    @Override
    public boolean contains(Object element) {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.contains(element);
        }
        if (this.backingStore != null) {
            return this.backingStore.contains(this.ownerSM, element);
        }
        return this.delegate.contains(element);
    }

    @Override
    public synchronized boolean containsAll(Collection c) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            HashSet h = new HashSet(c);
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                h.remove(iter.next());
            }
            return h.isEmpty();
        }
        return this.delegate.containsAll(c);
    }

    @Override
    public Object elementAt(int index) {
        return this.get(index);
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (this.useCache) {
            this.loadFromStore();
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l = (List)o;
        if (l.size() != this.size()) {
            return false;
        }
        Object[] elements = this.toArray();
        Object[] otherElements = l.toArray();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i].equals(otherElements[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Enumeration elements() {
        if (this.useCache) {
            this.loadFromStore();
            return this.delegate.elements();
        }
        final SCOListIterator iter = new SCOListIterator(this, this.ownerSM, this.delegate, this.backingStore, this.useCache, -1);
        return new Enumeration(){

            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            public Object nextElement() {
                return iter.next();
            }
        };
    }

    @Override
    public Object firstElement() {
        return this.get(0);
    }

    @Override
    public Object get(int index) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.get(this.ownerSM, index);
        }
        return this.delegate.get(index);
    }

    @Override
    public synchronized int hashCode() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return this.delegate.hashCode();
    }

    @Override
    public int indexOf(Object element) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.indexOf(this.ownerSM, element);
        }
        return this.delegate.indexOf(element);
    }

    @Override
    public int indexOf(Object element, int startIndex) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.indexOf(this.ownerSM, element);
        }
        return this.delegate.indexOf(element, startIndex);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator iterator() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return new SCOListIterator(this, this.ownerSM, this.delegate, this.backingStore, this.useCache, -1);
    }

    @Override
    public Object lastElement() {
        return this.get(this.size() - 1);
    }

    @Override
    public int lastIndexOf(Object element) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.lastIndexOf(this.ownerSM, element);
        }
        return this.delegate.lastIndexOf(element);
    }

    @Override
    public int lastIndexOf(Object element, int startIndex) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.lastIndexOf(this.ownerSM, element);
        }
        return this.delegate.lastIndexOf(element, startIndex);
    }

    @Override
    public ListIterator listIterator() {
        if (this.useCache) {
            this.loadFromStore();
        }
        return new SCOListIterator(this, this.ownerSM, this.delegate, this.backingStore, this.useCache, -1);
    }

    @Override
    public ListIterator listIterator(int index) {
        if (this.useCache) {
            this.loadFromStore();
        }
        return new SCOListIterator(this, this.ownerSM, this.delegate, this.backingStore, this.useCache, index);
    }

    @Override
    public int size() {
        if (this.useCache && this.isCacheLoaded) {
            return this.delegate.size();
        }
        if (this.backingStore != null) {
            return this.backingStore.size(this.ownerSM);
        }
        return this.delegate.size();
    }

    @Override
    public synchronized List subList(int from, int to) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return this.backingStore.subList(this.ownerSM, from, to);
        }
        return this.delegate.subList(from, to);
    }

    @Override
    public synchronized Object[] toArray() {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerSM);
        }
        return this.delegate.toArray();
    }

    @Override
    public synchronized Object[] toArray(Object[] a) {
        if (this.useCache) {
            this.loadFromStore();
        } else if (this.backingStore != null) {
            return SCOUtils.toArray(this.backingStore, this.ownerSM, a);
        }
        return this.delegate.toArray(a);
    }

    @Override
    public void add(int index, Object element) {
        if (!this.allowNulls && element == null) {
            throw new NullPointerException("Nulls not allowed for collection at field " + this.fieldName + " but element is null");
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
                this.addQueuedOperation(new AddAtOperation(index, element));
            } else {
                try {
                    this.backingStore.add(this.ownerSM, element, index, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"add", (Object)this.fieldName, (Object)dse));
                }
            }
        }
        this.makeDirty();
        this.delegate.add(index, element);
    }

    @Override
    public boolean add(Object element) {
        if (!this.allowNulls && element == null) {
            throw new NullPointerException("Nulls not allowed for collection at field " + this.fieldName + " but element is null");
        }
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
                this.addQueuedOperation(new AddOperation(element));
            } else {
                try {
                    this.backingStore.add(this.ownerSM, element, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"add", (Object)this.fieldName, (Object)dse));
                    backingSuccess = false;
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.add(element);
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    @Override
    public boolean addAll(Collection elements) {
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
                for (Object element : elements) {
                    this.addQueuedOperation(new AddOperation(element));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.addAll(this.ownerSM, elements, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"addAll", (Object)this.fieldName, (Object)dse));
                    backingSuccess = false;
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.addAll(elements);
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    @Override
    public boolean addAll(int index, Collection elements) {
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
                int pos = index;
                for (Object element : elements) {
                    this.addQueuedOperation(new AddAtOperation(pos++, element));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.addAll(this.ownerSM, elements, index, this.useCache ? this.delegate.size() : -1);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"addAll", (Object)this.fieldName, (Object)dse));
                    backingSuccess = false;
                }
            }
        }
        this.makeDirty();
        boolean delegateSuccess = this.delegate.addAll(index, elements);
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    @Override
    public void addElement(Object element) {
        this.add(element);
    }

    @Override
    public synchronized void clear() {
        this.makeDirty();
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
                this.addQueuedOperation(new ClearCollectionOperation());
            } else {
                this.backingStore.clear(this.ownerSM);
            }
        }
        this.delegate.clear();
    }

    @Override
    public boolean remove(Object element) {
        return this.remove(element, true);
    }

    @Override
    public boolean remove(Object element, boolean allowCascadeDelete) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int size = this.useCache ? this.delegate.size() : -1;
        boolean contained = this.delegate.contains(element);
        boolean delegateSuccess = this.delegate.remove(element);
        boolean backingSuccess = true;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
                backingSuccess = contained;
                if (backingSuccess) {
                    this.addQueuedOperation(new RemoveCollectionOperation(element, allowCascadeDelete));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.remove(this.ownerSM, element, size, allowCascadeDelete);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"remove", (Object)this.fieldName, (Object)dse));
                    backingSuccess = false;
                }
            }
        }
        return this.backingStore != null ? backingSuccess : delegateSuccess;
    }

    @Override
    public Object remove(int index) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        int size = this.useCache ? this.delegate.size() : -1;
        Object delegateObject = this.useCache ? (Object)this.delegate.remove(index) : null;
        Object backingObject = null;
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
                backingObject = delegateObject;
                this.addQueuedOperation(new RemoveAtOperation(index));
            } else {
                try {
                    backingObject = this.backingStore.remove(this.ownerSM, index, size);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"remove", (Object)this.fieldName, (Object)dse));
                    backingObject = null;
                }
            }
        }
        return this.backingStore != null ? backingObject : delegateObject;
    }

    @Override
    public boolean removeAll(Collection elements) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        if (this.backingStore != null) {
            int size;
            boolean backingSuccess = true;
            int n = size = this.useCache ? this.delegate.size() : -1;
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
                backingSuccess = false;
                for (Object element : elements) {
                    if (!this.contains(element)) continue;
                    backingSuccess = true;
                    this.addQueuedOperation(new RemoveCollectionOperation(element, true));
                }
            } else {
                try {
                    backingSuccess = this.backingStore.removeAll(this.ownerSM, elements, size);
                }
                catch (NucleusDataStoreException dse) {
                    NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023013", (Object)"removeAll", (Object)this.fieldName, (Object)dse));
                    backingSuccess = false;
                }
            }
            this.delegate.removeAll(elements);
            return backingSuccess;
        }
        return this.delegate.removeAll(elements);
    }

    @Override
    public boolean removeElement(Object element) {
        return this.remove(element);
    }

    @Override
    public void removeElementAt(int index) {
        this.remove(index);
    }

    @Override
    public void removeAllElements() {
        this.clear();
    }

    @Override
    public synchronized boolean retainAll(Collection c) {
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (c.contains(element)) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public Object set(int index, Object element, boolean allowDependentField) {
        if (!this.allowNulls && element == null) {
            throw new NullPointerException("Nulls not allowed for collection at field " + this.fieldName + " but element is null");
        }
        this.makeDirty();
        if (this.useCache) {
            this.loadFromStore();
        }
        Object delegateReturn = this.delegate.set(index, element);
        if (this.backingStore != null) {
            if (SCOUtils.useQueuedUpdate(this.queued, this.ownerSM)) {
                this.addQueuedOperation(new SetOperation(index, element, allowDependentField));
            } else {
                this.backingStore.set(this.ownerSM, index, element, allowDependentField);
            }
        }
        return delegateReturn;
    }

    @Override
    public Object set(int index, Object element) {
        return this.set(index, element, true);
    }

    @Override
    public void setElementAt(Object element, int index) {
        this.set(index, element);
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        if (this.useCache) {
            this.loadFromStore();
            return new java.util.Vector(this.delegate);
        }
        return new java.util.Vector(this.delegate);
    }
}

