/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.annotations.AnnotatedMember;
import org.datanucleus.metadata.annotations.AnnotationObject;
import org.datanucleus.metadata.annotations.AnnotationReader;
import org.datanucleus.metadata.annotations.Member;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationReader
implements AnnotationReader {
    protected static Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected MetaDataManager mgr;
    protected String[] supportedPackages;

    public AbstractAnnotationReader(MetaDataManager mgr) {
        this.mgr = mgr;
    }

    @Override
    public String[] getSupportedAnnotationPackages() {
        return this.supportedPackages;
    }

    protected void setSupportedAnnotationPackages(String[] packages) {
        this.supportedPackages = packages;
    }

    protected boolean isSupportedAnnotation(String annotationClassName) {
        if (this.supportedPackages == null) {
            return false;
        }
        boolean supported = false;
        for (int j = 0; j < this.supportedPackages.length; ++j) {
            if (!annotationClassName.startsWith(this.supportedPackages[j])) continue;
            supported = true;
            break;
        }
        return supported;
    }

    @Override
    public AbstractClassMetaData getMetaDataForClass(Class cls, PackageMetaData pmd, ClassLoaderResolver clr) {
        AnnotationObject[] classAnnotations = this.getClassAnnotationsForClass(cls);
        AbstractClassMetaData cmd = this.processClassAnnotations(pmd, cls, classAnnotations, clr);
        if (cmd != null) {
            AnnotationObject[] annotations;
            boolean propertyAccessor = false;
            Collection<AnnotatedMember> annotatedMethods = this.getJavaBeanAccessorAnnotationsForClass(cls);
            HashMap<String, AnnotatedMember> m = new HashMap<String, AnnotatedMember>();
            for (AnnotatedMember method : annotatedMethods) {
                m.put(method.getName(), method);
                if (method.getAnnotations().length <= 0) continue;
                propertyAccessor = true;
            }
            Collection<AnnotatedMember> annotatedFields = this.getFieldAnnotationsForClass(cls);
            HashMap<String, AnnotatedMember> f = new HashMap<String, AnnotatedMember>();
            for (AnnotatedMember field : annotatedFields) {
                f.put(field.getName(), field);
            }
            for (AnnotatedMember method : m.values()) {
                annotations = method.getAnnotations();
                this.processMemberAnnotations(cmd, method.getMember(), annotations, propertyAccessor);
            }
            for (AnnotatedMember field : f.values()) {
                annotations = field.getAnnotations();
                this.processMemberAnnotations(cmd, field.getMember(), annotations, propertyAccessor);
            }
            Method[] methods = cls.getDeclaredMethods();
            int numberOfMethods = methods.length;
            for (int i = 0; i < numberOfMethods; ++i) {
                this.processMethodAnnotations(cmd, methods[i]);
            }
        }
        return cmd;
    }

    protected abstract AbstractClassMetaData processClassAnnotations(PackageMetaData var1, Class var2, AnnotationObject[] var3, ClassLoaderResolver var4);

    protected abstract AbstractMemberMetaData processMemberAnnotations(AbstractClassMetaData var1, Member var2, AnnotationObject[] var3, boolean var4);

    protected abstract void processMethodAnnotations(AbstractClassMetaData var1, Method var2);

    protected AnnotationObject[] getClassAnnotationsForClass(Class cls) {
        Annotation[] annotations = cls.getAnnotations();
        ArrayList<Annotation> supportedAnnots = new ArrayList<Annotation>();
        if (annotations != null && annotations.length > 0) {
            for (int j = 0; j < annotations.length; ++j) {
                if (!this.isSupportedAnnotation(annotations[j].annotationType().getName())) continue;
                supportedAnnots.add(annotations[j]);
            }
        }
        return this.getAnnotationObjectsForAnnotations(cls.getName(), supportedAnnots.toArray(new Annotation[supportedAnnots.size()]));
    }

    protected Collection<AnnotatedMember> getJavaBeanAccessorAnnotationsForClass(Class cls) {
        HashSet<AnnotatedMember> annotatedMethods = new HashSet<AnnotatedMember>();
        Method[] methods = cls.getDeclaredMethods();
        int numberOfMethods = methods.length;
        for (int i = 0; i < numberOfMethods; ++i) {
            String methodName = methods[i].getName();
            if ((!methodName.startsWith("get") || methodName.length() <= 3) && (!methodName.startsWith("is") || methodName.length() <= 2)) continue;
            Annotation[] annotations = methods[i].getAnnotations();
            ArrayList<Annotation> supportedAnnots = new ArrayList<Annotation>();
            if (annotations != null && annotations.length > 0) {
                for (int j = 0; j < annotations.length; ++j) {
                    if (!this.isSupportedAnnotation(annotations[j].annotationType().getName())) continue;
                    supportedAnnots.add(annotations[j]);
                }
            }
            AnnotationObject[] objects = this.getAnnotationObjectsForAnnotations(cls.getName(), supportedAnnots.toArray(new Annotation[supportedAnnots.size()]));
            AnnotatedMember annMember = new AnnotatedMember(new Member(methods[i]), objects);
            annotatedMethods.add(annMember);
        }
        return annotatedMethods;
    }

    protected Collection<Annotation[]> getMethodAnnotationsForClass(Class cls) {
        HashSet<Annotation[]> annotatedMethods = new HashSet<Annotation[]>();
        Method[] methods = cls.getDeclaredMethods();
        int numberOfMethods = methods.length;
        for (int i = 0; i < numberOfMethods; ++i) {
            Annotation[] annotations = methods[i].getAnnotations();
            if (annotations == null || annotations.length <= 0) continue;
            ArrayList<Annotation> supportedAnnots = new ArrayList<Annotation>();
            for (int j = 0; j < annotations.length; ++j) {
                if (!this.isSupportedAnnotation(annotations[j].annotationType().getName())) continue;
                supportedAnnots.add(annotations[j]);
            }
            annotatedMethods.add(supportedAnnots.toArray(new Annotation[supportedAnnots.size()]));
        }
        return annotatedMethods;
    }

    protected Collection<AnnotatedMember> getFieldAnnotationsForClass(Class cls) {
        HashSet<AnnotatedMember> annotatedFields = new HashSet<AnnotatedMember>();
        Field[] fields = cls.getDeclaredFields();
        int numberOfFields = fields.length;
        for (int i = 0; i < numberOfFields; ++i) {
            Annotation[] annotations = fields[i].getAnnotations();
            ArrayList<Annotation> supportedAnnots = new ArrayList<Annotation>();
            if (annotations != null && annotations.length > 0) {
                for (int j = 0; j < annotations.length; ++j) {
                    if (!this.isSupportedAnnotation(annotations[j].annotationType().getName())) continue;
                    supportedAnnots.add(annotations[j]);
                }
            }
            AnnotationObject[] objects = this.getAnnotationObjectsForAnnotations(cls.getName(), supportedAnnots.toArray(new Annotation[supportedAnnots.size()]));
            AnnotatedMember annField = new AnnotatedMember(new Member(fields[i]), objects);
            annotatedFields.add(annField);
        }
        return annotatedFields;
    }

    protected AnnotationObject[] getAnnotationObjectsForAnnotations(String clsName, Annotation[] annotations) {
        if (annotations == null) {
            return null;
        }
        AnnotationObject[] objects = new AnnotationObject[annotations.length];
        int numberOfAnns = annotations.length;
        for (int i = 0; i < numberOfAnns; ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Method[] annMethods = annotations[i].annotationType().getDeclaredMethods();
            int numberOfAnnotateMethods = annMethods.length;
            for (int j = 0; j < numberOfAnnotateMethods; ++j) {
                try {
                    map.put(annMethods[j].getName(), annMethods[j].invoke((Object)annotations[i], new Object[0]));
                    continue;
                }
                catch (Exception ex) {
                    NucleusLogger.METADATA.warn(LOCALISER.msg("044201", (Object)clsName, (Object)annotations[i].annotationType().getName(), (Object)annMethods[j].getName()));
                }
            }
            objects[i] = new AnnotationObject(annotations[i].annotationType().getName(), map);
        }
        return objects;
    }
}

