/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ContainerComponent;
import org.datanucleus.metadata.ContainerMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class CollectionMetaData
extends ContainerMetaData {
    protected ContainerComponent element = new ContainerComponent();

    public CollectionMetaData(CollectionMetaData collmd) {
        super(collmd);
        this.element.embedded = collmd.element.embedded;
        this.element.serialized = collmd.element.serialized;
        this.element.dependent = collmd.element.dependent;
        this.element.type = collmd.element.type;
        this.element.classMetaData = collmd.element.classMetaData;
    }

    public CollectionMetaData() {
    }

    public void populate(ClassLoaderResolver clr, ClassLoader primary, MetaDataManager mmgr) {
        ElementMetaData elemmd;
        AbstractMemberMetaData mmd = (AbstractMemberMetaData)this.parent;
        if (!StringUtils.isWhitespace(this.element.type) && this.element.type.indexOf(44) > 0) {
            throw new InvalidMetaDataException(LOCALISER, "044131", (Object)mmd.getName(), mmd.getClassName());
        }
        this.element.populate(((AbstractMemberMetaData)this.parent).getAbstractClassMetaData().getPackageName(), clr, primary, mmgr);
        Class field_type = this.getMemberMetaData().getType();
        if (!Collection.class.isAssignableFrom(field_type)) {
            throw new InvalidMetaDataException(LOCALISER, "044132", (Object)this.getFieldName(), this.getMemberMetaData().getClassName(false));
        }
        if (this.element.type == null) {
            throw new InvalidMetaDataException(LOCALISER, "044133", (Object)this.getFieldName(), this.getMemberMetaData().getClassName(false));
        }
        Class elementTypeClass = null;
        try {
            elementTypeClass = clr.classForName(this.element.type, primary);
        }
        catch (ClassNotResolvedException cnre) {
            throw new InvalidMetaDataException(LOCALISER, "044134", (Object)this.getFieldName(), (Object)this.getMemberMetaData().getClassName(false), this.element.type);
        }
        if (!elementTypeClass.getName().equals(this.element.type)) {
            NucleusLogger.METADATA.info(LOCALISER.msg("044135", (Object)this.getFieldName(), (Object)this.getMemberMetaData().getClassName(false), (Object)this.element.type, (Object)elementTypeClass.getName()));
            this.element.type = elementTypeClass.getName();
        }
        ApiAdapter api = mmgr.getApiAdapter();
        if (this.element.embedded == null) {
            this.element.embedded = mmgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(elementTypeClass) ? Boolean.TRUE : (api.isPersistable(elementTypeClass) || Object.class.isAssignableFrom(elementTypeClass) || elementTypeClass.isInterface() ? Boolean.FALSE : Boolean.TRUE);
        }
        if (this.element.embedded == Boolean.FALSE && !api.isPersistable(elementTypeClass) && !elementTypeClass.isInterface() && elementTypeClass != Object.class) {
            this.element.embedded = Boolean.TRUE;
        }
        if ((elemmd = ((AbstractMemberMetaData)this.parent).getElementMetaData()) != null && elemmd.getEmbeddedMetaData() != null) {
            this.element.embedded = Boolean.TRUE;
        }
        if (this.element.dependent == Boolean.TRUE && !api.isPersistable(elementTypeClass) && !elementTypeClass.isInterface() && elementTypeClass != Object.class) {
            this.element.dependent = Boolean.FALSE;
        }
        this.element.classMetaData = mmgr.getMetaDataForClassInternal(elementTypeClass, clr);
        super.populate(clr, primary, mmgr);
        this.setPopulated();
    }

    public String getElementType() {
        return this.element.type;
    }

    public boolean elementIsPersistent() {
        return this.element.classMetaData != null;
    }

    public AbstractClassMetaData getElementClassMetaData(final ClassLoaderResolver clr, final MetaDataManager mmgr) {
        if (this.element.classMetaData != null && !this.element.classMetaData.isInitialised()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    CollectionMetaData.this.element.classMetaData.initialise(clr, mmgr);
                    return null;
                }
            });
        }
        return this.element.classMetaData;
    }

    public boolean isEmbeddedElement() {
        if (this.element.embedded == null) {
            return false;
        }
        return this.element.embedded;
    }

    public boolean isDependentElement() {
        if (this.element.dependent == null) {
            return false;
        }
        if (this.element.classMetaData == null) {
            return false;
        }
        return this.element.dependent;
    }

    public boolean isSerializedElement() {
        if (this.element.serialized == null) {
            return false;
        }
        return this.element.serialized;
    }

    public CollectionMetaData setElementType(String type) {
        this.element.setType(type);
        return this;
    }

    public CollectionMetaData setEmbeddedElement(String embedded) {
        this.element.setEmbedded(embedded);
        return this;
    }

    public CollectionMetaData setEmbeddedElement(boolean embedded) {
        this.element.setEmbedded(embedded);
        return this;
    }

    public CollectionMetaData setSerializedElement(String serialized) {
        this.element.setSerialized(serialized);
        return this;
    }

    public CollectionMetaData setSerializedElement(boolean serialized) {
        this.element.setSerialized(serialized);
        return this;
    }

    public CollectionMetaData setDependentElement(String dependent) {
        this.element.setDependent(dependent);
        return this;
    }

    public CollectionMetaData setDependentElement(boolean dependent) {
        this.element.setDependent(dependent);
        return this;
    }

    void getReferencedClassMetaData(List orderedCMDs, Set referencedCMDs, ClassLoaderResolver clr, MetaDataManager mmgr) {
        AbstractClassMetaData element_cmd = mmgr.getMetaDataForClass(this.element.type, clr);
        if (element_cmd != null) {
            element_cmd.getReferencedClassMetaData(orderedCMDs, referencedCMDs, clr, mmgr);
        }
    }

    public String toString(String prefix, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("<collection element-type=\"").append(this.element.type).append("\"");
        if (this.element.embedded != null) {
            sb.append(" embedded-element=\"").append(this.element.embedded).append("\"");
        }
        if (this.element.dependent != null) {
            sb.append(" dependent-element=\"").append(this.element.dependent).append("\"");
        }
        if (this.element.serialized != null) {
            sb.append(" serialized-element=\"").append(this.element.serialized).append("\"");
        }
        sb.append(">\n");
        sb.append(super.toString(prefix + indent, indent));
        sb.append(prefix).append("</collection>\n");
        return sb.toString();
    }
}

