/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.datanucleus.ClassConstants;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.properties.PersistencePropertyValidator;
import org.datanucleus.properties.PropertyStore;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.PersistenceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceConfiguration
extends PropertyStore {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    private Map<String, Object> defaultProperties = new HashMap<String, Object>();
    private Map<String, PropertyMapping> propertyMappings = new HashMap<String, PropertyMapping>();

    public Set<String> getSupportedProperties() {
        return this.propertyMappings.keySet();
    }

    public Map<String, Object> getDatastoreProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String name : this.properties.keySet()) {
            if (!this.isPropertyForDatastore(name)) continue;
            props.put(name, this.properties.get(name));
        }
        return props;
    }

    public void removeDatastoreProperties() {
        Iterator propKeyIter = this.properties.keySet().iterator();
        while (propKeyIter.hasNext()) {
            String name = (String)propKeyIter.next();
            if (!this.isPropertyForDatastore(name)) continue;
            propKeyIter.remove();
        }
    }

    public boolean isPropertyForDatastore(String name) {
        PropertyMapping mapping = this.propertyMappings.get(name.toLowerCase());
        return mapping != null ? mapping.datastore : false;
    }

    public void setDefaultProperties(Map props) {
        if (props != null && props.size() > 0) {
            for (Map.Entry entry : props.entrySet()) {
                this.defaultProperties.put((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public void setDefaultProperties(PluginManager pluginMgr) {
        ConfigurationElement[] propElements = pluginMgr.getConfigurationElementsForExtension("org.datanucleus.persistence_properties", null, null);
        if (propElements != null) {
            for (int i = 0; i < propElements.length; ++i) {
                String name = propElements[i].getAttribute("name");
                String intName = propElements[i].getAttribute("internal-name");
                String value = propElements[i].getAttribute("value");
                String datastoreString = propElements[i].getAttribute("datastore");
                boolean datastore = datastoreString != null && datastoreString.equalsIgnoreCase("true");
                this.propertyMappings.put(name.toLowerCase(), new PropertyMapping(name, intName, value, propElements[i].getAttribute("validator"), datastore));
                String systemValue = System.getProperty(name);
                if (systemValue != null) {
                    this.defaultProperties.put(intName != null ? intName.toLowerCase() : name.toLowerCase(), systemValue);
                    continue;
                }
                if (this.defaultProperties.containsKey(name) || value == null) continue;
                this.defaultProperties.put(intName != null ? intName.toLowerCase() : name.toLowerCase(), value);
            }
        }
    }

    @Override
    public Object getProperty(String name) {
        if (this.properties.containsKey(name.toLowerCase())) {
            return super.getProperty(name);
        }
        return this.defaultProperties.get(name.toLowerCase());
    }

    public synchronized void setPropertiesUsingFile(String filename) {
        if (filename == null) {
            return;
        }
        Properties props = null;
        try {
            props = PersistenceUtils.setPropertiesUsingFile(filename);
            this.setPropertyInternal("datanucleus.propertiesFile", filename);
        }
        catch (NucleusUserException nue) {
            this.properties.remove("datanucleus.propertiesFile");
            throw nue;
        }
        if (props != null && !props.isEmpty()) {
            this.setPersistenceProperties(props);
        }
    }

    public Map<String, Object> getPersistencePropertiesDefaults() {
        return Collections.unmodifiableMap(this.defaultProperties);
    }

    public Map<String, Object> getPersistenceProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Set<String> getPropertyNamesWithPrefix(String prefix) {
        HashSet<String> propNames = null;
        for (String name : this.properties.keySet()) {
            if (!name.startsWith(prefix.toLowerCase())) continue;
            if (propNames == null) {
                propNames = new HashSet<String>();
            }
            propNames.add(name);
        }
        return propNames;
    }

    public void setPersistenceProperties(Map props) {
        Set keys = props.keySet();
        for (Object keyObj : keys) {
            if (!(keyObj instanceof String)) continue;
            String key = (String)keyObj;
            Object valueObj = props.get(keyObj);
            this.setProperty(key, valueObj);
        }
    }

    public void setProperty(String name, Object value) {
        if (name != null) {
            String propertyName = name.trim();
            PropertyMapping mapping = this.propertyMappings.get(propertyName.toLowerCase());
            if (mapping != null) {
                if (mapping.validatorName != null) {
                    PersistencePropertyValidator validator = null;
                    try {
                        Class<?> validatorCls = Class.forName(mapping.validatorName);
                        validator = (PersistencePropertyValidator)validatorCls.newInstance();
                    }
                    catch (Exception e) {
                        NucleusLogger.PERSISTENCE.warn("Error creating validator of type " + mapping.validatorName, e);
                    }
                    if (validator != null) {
                        boolean validated;
                        boolean bl = validated = mapping.internalName != null ? validator.validate(mapping.internalName, value) : validator.validate(propertyName, value);
                        if (!validated) {
                            throw new IllegalArgumentException(LOCALISER.msg("008012", (Object)propertyName, value));
                        }
                    }
                }
                if (mapping.internalName != null) {
                    this.setPropertyInternal(mapping.internalName, value);
                } else {
                    this.setPropertyInternal(mapping.name, value);
                }
                if (propertyName.equals("datanucleus.propertiesFile")) {
                    this.setPropertiesUsingFile((String)value);
                } else if (propertyName.equals("datanucleus.localisation.messageCodes")) {
                    boolean included = this.getBooleanProperty("datanucleus.localisation.messageCodes");
                    Localiser.setDisplayCodesInMessages(included);
                } else if (propertyName.equals("datanucleus.localisation.language")) {
                    String language = this.getStringProperty("datanucleus.localisation.language");
                    Localiser.setLanguage(language);
                }
            } else {
                this.setPropertyInternal(propertyName, value);
                if (this.propertyMappings.size() > 0) {
                    NucleusLogger.PERSISTENCE.info(LOCALISER.msg("008015", (Object)propertyName));
                }
            }
        }
    }

    public synchronized boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PersistenceConfiguration)) {
            return false;
        }
        PersistenceConfiguration config = (PersistenceConfiguration)obj;
        if (this.properties == null ? config.properties != null : !((Object)this.properties).equals(config.properties)) {
            return false;
        }
        return !(this.defaultProperties == null ? config.defaultProperties != null : !((Object)this.defaultProperties).equals(config.defaultProperties));
    }

    class PropertyMapping {
        String name;
        String internalName;
        String value;
        String validatorName;
        boolean datastore;

        public PropertyMapping(String name, String intName, String val, String validator, boolean datastore) {
            this.name = name;
            this.internalName = intName;
            this.value = val;
            this.validatorName = validator;
            this.datastore = datastore;
        }
    }
}

