/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchGroup;
import org.datanucleus.FetchGroupManager;
import org.datanucleus.OMFContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.TransactionIsolationNotSupportedException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.Extension;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.StoreManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectManagerFactoryImpl {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ExecutionContext.class.getClassLoader());
    private static String versionNumber = null;
    protected OMFContext omfContext;
    private FetchGroupManager fetchGrpMgr;
    private PersistenceConfiguration conf = new PersistenceConfiguration();
    private transient boolean configurable = true;

    protected void logConfiguration() {
        NucleusLogger.PERSISTENCE.info("================= Persistence Configuration ===============");
        NucleusLogger.PERSISTENCE.info(LOCALISER.msg("008000", (Object)"DataNucleus", (Object)ObjectManagerFactoryImpl.getVersionNumber()));
        NucleusLogger.PERSISTENCE.info(LOCALISER.msg("008001", (Object)this.conf.getStringProperty("datanucleus.ConnectionURL"), (Object)this.conf.getStringProperty("datanucleus.ConnectionDriverName"), (Object)this.conf.getStringProperty("datanucleus.ConnectionUserName")));
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            String timeZoneID;
            NucleusLogger.PERSISTENCE.debug("JDK : " + System.getProperty("java.version") + " on " + System.getProperty("os.name"));
            NucleusLogger.PERSISTENCE.debug("Persistence API : " + this.getOMFContext().getApi());
            NucleusLogger.PERSISTENCE.debug("Plugin Registry : " + this.getOMFContext().getPluginManager().getRegistryClassName());
            if (this.conf.hasProperty("datanucleus.PersistenceUnitName")) {
                NucleusLogger.PERSISTENCE.debug("Persistence-Unit : " + this.conf.getStringProperty("datanucleus.PersistenceUnitName"));
            }
            if ((timeZoneID = this.conf.getStringProperty("datanucleus.ServerTimeZoneID")) == null) {
                timeZoneID = TimeZone.getDefault().getID();
            }
            NucleusLogger.PERSISTENCE.debug("Standard Options : " + (this.conf.getBooleanProperty("datanucleus.Multithreaded") ? "multithreaded" : "singlethreaded") + (this.conf.getBooleanProperty("datanucleus.RetainValues") ? ", retain-values" : "") + (this.conf.getBooleanProperty("datanucleus.RestoreValues") ? ", restore-values" : "") + (this.conf.getBooleanProperty("datanucleus.NontransactionalRead") ? ", nontransactional-read" : "") + (this.conf.getBooleanProperty("datanucleus.NontransactionalWrite") ? ", nontransactional-write" : "") + (this.conf.getBooleanProperty("datanucleus.IgnoreCache") ? ", ignoreCache" : "") + ", serverTimeZone=" + timeZoneID);
            NucleusLogger.PERSISTENCE.debug("Persistence Options :" + (this.conf.getBooleanProperty("datanucleus.persistenceByReachabilityAtCommit") ? " reachability-at-commit" : "") + (this.conf.getBooleanProperty("datanucleus.DetachAllOnCommit") ? " detach-all-on-commit" : "") + (this.conf.getBooleanProperty("datanucleus.DetachAllOnRollback") ? " detach-all-on-rollback" : "") + (this.conf.getBooleanProperty("datanucleus.DetachOnClose") ? " detach-on-close" : "") + (this.conf.getBooleanProperty("datanucleus.manageRelationships") ? (this.conf.getBooleanProperty("datanucleus.manageRelationshipsChecks") ? " managed-relations(checked)" : "managed-relations(unchecked)") : "") + " deletion-policy=" + this.conf.getStringProperty("datanucleus.deletionPolicy"));
            NucleusLogger.PERSISTENCE.debug("Transactions : type=" + this.conf.getStringProperty("datanucleus.TransactionType") + " mode=" + (this.conf.getBooleanProperty("datanucleus.Optimistic") ? "optimistic" : "datastore") + " isolation=" + this.conf.getStringProperty("datanucleus.transactionIsolation"));
            NucleusLogger.PERSISTENCE.debug("Value Generation : txn-isolation=" + this.conf.getStringProperty("datanucleus.valuegeneration.transactionIsolation") + " connection=" + (this.conf.getStringProperty("datanucleus.valuegeneration.transactionAttribute").equalsIgnoreCase("New") ? "New" : "Existing"));
            Object primCL = this.conf.getProperty("datanucleus.primaryClassLoader");
            NucleusLogger.PERSISTENCE.debug("ClassLoading : " + this.conf.getStringProperty("datanucleus.classLoaderResolverName") + (primCL != null ? "primary=" + primCL : ""));
            NucleusLogger.PERSISTENCE.debug("Cache : Level1 (" + this.conf.getStringProperty("datanucleus.cache.level1.type") + ")" + ", Level2 (" + this.conf.getStringProperty("datanucleus.cache.level2.type") + ")" + ", QueryResults (" + this.conf.getStringProperty("datanucleus.cache.queryResults.type") + ")" + (this.conf.getBooleanProperty("datanucleus.cache.collections") ? ", Collections/Maps " : ""));
        }
        NucleusLogger.PERSISTENCE.info("===========================================================");
    }

    protected void initialiseOMFContext() {
        this.omfContext = new OMFContext(this.conf);
    }

    protected void initialiseStoreManager(ClassLoaderResolver clr) {
        boolean loadClasses;
        String puName;
        Collection srmOptions;
        String transactionIsolation;
        StoreManager srm = null;
        String storeManagerType = this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.storeManagerType");
        Extension[] exts = this.omfContext.getPluginManager().getExtensionPoint("org.datanucleus.store_manager").getExtensions();
        if (storeManagerType != null) {
            for (int e = 0; srm == null && e < exts.length; ++e) {
                ConfigurationElement[] confElm = exts[e].getConfigurationElements();
                for (int c = 0; srm == null && c < confElm.length; ++c) {
                    String key = confElm[c].getAttribute("key");
                    if (!key.equalsIgnoreCase(storeManagerType)) continue;
                    Class[] ctrArgTypes = new Class[]{ClassLoaderResolver.class, OMFContext.class};
                    Object[] ctrArgs = new Object[]{clr, this.omfContext};
                    try {
                        srm = (StoreManager)this.omfContext.getPluginManager().createExecutableExtension("org.datanucleus.store_manager", "key", storeManagerType, "class-name", ctrArgTypes, ctrArgs);
                        continue;
                    }
                    catch (InvocationTargetException ex) {
                        Throwable t = ex.getTargetException();
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        if (t instanceof Error) {
                            throw (Error)t;
                        }
                        throw new NucleusException(t.getMessage(), t).setFatal();
                    }
                    catch (Exception ex) {
                        throw new NucleusException(ex.getMessage(), ex).setFatal();
                    }
                }
            }
            if (srm == null) {
                throw new NucleusUserException(LOCALISER.msg("008004", (Object)storeManagerType)).setFatal();
            }
        }
        if (srm == null) {
            int idx;
            String url = this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.ConnectionURL");
            if (url != null && (idx = url.indexOf(58)) > -1) {
                url = url.substring(0, idx);
            }
            for (int e = 0; srm == null && e < exts.length; ++e) {
                ConfigurationElement[] confElm = exts[e].getConfigurationElements();
                for (int c = 0; srm == null && c < confElm.length; ++c) {
                    String urlKey = confElm[c].getAttribute("url-key");
                    if (url != null && !urlKey.equalsIgnoreCase(url)) continue;
                    Class[] ctrArgTypes = new Class[]{ClassLoaderResolver.class, OMFContext.class};
                    Object[] ctrArgs = new Object[]{clr, this.omfContext};
                    try {
                        srm = (StoreManager)this.omfContext.getPluginManager().createExecutableExtension("org.datanucleus.store_manager", "url-key", url, "class-name", ctrArgTypes, ctrArgs);
                        continue;
                    }
                    catch (InvocationTargetException ex) {
                        Throwable t = ex.getTargetException();
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        if (t instanceof Error) {
                            throw (Error)t;
                        }
                        throw new NucleusException(t.getMessage(), t).setFatal();
                    }
                    catch (Exception ex) {
                        throw new NucleusException(ex.getMessage(), ex).setFatal();
                    }
                }
            }
            if (srm == null) {
                throw new NucleusUserException(LOCALISER.msg("008004", (Object)url)).setFatal();
            }
        }
        if ((transactionIsolation = this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.transactionIsolation")) != null && !(srmOptions = srm.getSupportedOptions()).contains("TransactionIsolationLevel." + transactionIsolation)) {
            if (transactionIsolation.equals("read-uncommitted")) {
                if (srmOptions.contains("TransactionIsolationLevel.read-committed")) {
                    transactionIsolation = "read-committed";
                } else if (srmOptions.contains("TransactionIsolationLevel.repeatable-read")) {
                    transactionIsolation = "serializable";
                } else if (srmOptions.contains("TransactionIsolationLevel.serializable")) {
                    transactionIsolation = "repeatable-read";
                }
            } else if (transactionIsolation.equals("read-committed")) {
                if (srmOptions.contains("TransactionIsolationLevel.repeatable-read")) {
                    transactionIsolation = "repeatable-read";
                } else if (srmOptions.contains("TransactionIsolationLevel.serializable")) {
                    transactionIsolation = "serializable";
                }
            } else if (transactionIsolation.equals("repeatable-read")) {
                if (srmOptions.contains("TransactionIsolationLevel.serializable")) {
                    transactionIsolation = "serializable";
                }
            } else {
                throw new TransactionIsolationNotSupportedException(transactionIsolation);
            }
        }
        if ((puName = this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.PersistenceUnitName")) != null && (loadClasses = this.conf.getBooleanProperty("datanucleus.persistenceUnitLoadClasses"))) {
            Collection loadedClasses = this.omfContext.getMetaDataManager().getClassesWithMetaData();
            srm.addClasses(loadedClasses.toArray(new String[loadedClasses.size()]), clr);
        }
    }

    public StoreManager getStoreManager() {
        return this.getOMFContext().getStoreManager();
    }

    public synchronized void close() {
        if (this.fetchGrpMgr != null) {
            this.getFetchGroupManager().clearFetchGroups();
        }
        if (this.omfContext != null) {
            this.omfContext.close();
            this.omfContext = null;
        }
    }

    public OMFContext getOMFContext() {
        if (this.omfContext == null) {
            this.initialiseOMFContext();
        }
        return this.omfContext;
    }

    public PersistenceConfiguration getConfiguration() {
        return this.conf;
    }

    public boolean hasLevel2Cache() {
        return this.omfContext.hasLevel2Cache();
    }

    public Level2Cache getLevel2Cache() {
        return this.omfContext.getLevel2Cache();
    }

    public static String getVersionNumber() {
        if (versionNumber != null) {
            return versionNumber;
        }
        String version = "Unknown";
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("org.datanucleus.DataNucleusVersion");
            try {
                version = bundle.getString("datanucleus.version");
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        versionNumber = version;
        return versionNumber;
    }

    protected synchronized FetchGroupManager getFetchGroupManager() {
        if (this.fetchGrpMgr == null) {
            this.fetchGrpMgr = new FetchGroupManager(this.getOMFContext());
        }
        return this.fetchGrpMgr;
    }

    protected void addInternalFetchGroup(FetchGroup grp) {
        this.getFetchGroupManager().addFetchGroup(grp);
    }

    protected void removeInternalFetchGroup(FetchGroup grp) {
        this.getFetchGroupManager().removeFetchGroup(grp);
    }

    protected FetchGroup createInternalFetchGroup(Class cls, String name) {
        if (!cls.isInterface() && !this.getOMFContext().getApiAdapter().isPersistable(cls)) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        if (cls.isInterface() && !this.getOMFContext().getMetaDataManager().isPersistentInterface(cls.getName())) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        return this.getFetchGroupManager().createFetchGroup(cls, name);
    }

    protected FetchGroup getInternalFetchGroup(Class cls, String name) {
        if (!cls.isInterface() && !this.getOMFContext().getApiAdapter().isPersistable(cls)) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        if (cls.isInterface() && !this.getOMFContext().getMetaDataManager().isPersistentInterface(cls.getName())) {
            throw new NucleusUserException("Cannot create FetchGroup for " + cls + " since it is not persistable");
        }
        return this.getFetchGroupManager().getFetchGroup(cls, name);
    }

    public Set<FetchGroup> getFetchGroupsWithName(String name) {
        return this.getFetchGroupManager().getFetchGroupsWithName(name);
    }

    protected boolean isConfigurable() {
        return this.configurable;
    }

    protected void setIsNotConfigurable() {
        this.configurable = false;
    }

    protected void assertConfigurable() {
        if (!this.configurable) {
            throw new NucleusUserException(LOCALISER.msg("008016"));
        }
    }
}

