/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.sco.simple;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.types.sco.SCOCollection;
import org.datanucleus.store.types.sco.SCOCollectionIterator;
import org.datanucleus.store.types.sco.SCOMtoN;
import org.datanucleus.store.types.sco.SCOUtils;
import org.datanucleus.store.types.sco.simple.PriorityQueue;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class Queue
extends AbstractQueue
implements SCOCollection,
SCOMtoN,
Cloneable,
Serializable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", PriorityQueue.class.getClassLoader());
    protected Object owner;
    protected ObjectProvider ownerSM;
    protected String fieldName;
    protected int fieldNumber;
    protected java.util.Queue delegate;

    public Queue(ObjectProvider ownerSM, String fieldName) {
        this.ownerSM = ownerSM;
        this.owner = ownerSM.getObject();
        this.fieldName = fieldName;
        if (ownerSM != null) {
            this.fieldNumber = ownerSM.getClassMetaData().getMetaDataForMember(fieldName).getAbsoluteFieldNumber();
        }
    }

    public void initialise(Object o, boolean forInsert, boolean forUpdate) {
        Collection c = (Collection)o;
        if (c != null) {
            this.initialiseDelegate();
            this.delegate.addAll(c);
        } else {
            this.initialiseDelegate();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023003", (Object)this.ownerSM.toPrintableID(), (Object)this.fieldName, (Object)("" + this.size()), (Object)SCOUtils.getSCOWrapperOptionsMessage(true, false, false, false)));
        }
    }

    public void initialise() {
        this.initialiseDelegate();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023003", (Object)this.ownerSM.toPrintableID(), (Object)this.fieldName, (Object)("" + this.size()), (Object)SCOUtils.getSCOWrapperOptionsMessage(true, false, false, false)));
        }
    }

    protected void initialiseDelegate() {
        AbstractMemberMetaData fmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName);
        Comparator comparator = SCOUtils.getComparator(fmd, this.ownerSM.getExecutionContext().getClassLoaderResolver());
        this.delegate = comparator != null ? new java.util.PriorityQueue(5, comparator) : new java.util.PriorityQueue();
    }

    public Object getValue() {
        return this.delegate;
    }

    public void load() {
    }

    public boolean isLoaded() {
        return true;
    }

    public void flush() {
    }

    public void updateEmbeddedElement(Object element, int fieldNumber, Object value) {
        this.makeDirty();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getOwner() {
        return this.ownerSM != null ? this.ownerSM.getObject() : null;
    }

    public synchronized void unsetOwner() {
        if (this.ownerSM != null) {
            this.ownerSM = null;
        }
    }

    public void makeDirty() {
        if (this.owner != null) {
            ((PersistenceCapable)this.owner).jdoMakeDirty(this.fieldName);
        }
    }

    public Object detachCopy(FetchPlanState state) {
        java.util.PriorityQueue detached = new java.util.PriorityQueue();
        SCOUtils.detachCopyForCollection(this.ownerSM, this.toArray(), state, detached);
        return detached;
    }

    public void attachCopy(Object value) {
        Collection c = (Collection)value;
        AbstractMemberMetaData fmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName);
        boolean elementsWithoutIdentity = SCOUtils.collectionHasElementsWithoutIdentity(fmd);
        HashSet attachedElements = new HashSet(c.size());
        SCOUtils.attachRemoveDeletedElements(this.ownerSM.getExecutionContext().getApiAdapter(), this, c, elementsWithoutIdentity);
        SCOUtils.attachCopyForCollection(this.ownerSM, c.toArray(), attachedElements, elementsWithoutIdentity);
        SCOUtils.attachAddNewElements(this.ownerSM.getExecutionContext().getApiAdapter(), this, attachedElements, elementsWithoutIdentity);
    }

    public Object clone() {
        return null;
    }

    public synchronized boolean contains(Object element) {
        return this.delegate.contains(element);
    }

    public synchronized boolean containsAll(Collection c) {
        return this.delegate.containsAll(c);
    }

    public synchronized boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public synchronized int hashCode() {
        return this.delegate.hashCode();
    }

    public synchronized boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public synchronized Iterator iterator() {
        return new SCOCollectionIterator(this, this.ownerSM, this.delegate, null, true);
    }

    public synchronized Object peek() {
        return this.delegate.peek();
    }

    public synchronized int size() {
        return this.delegate.size();
    }

    public synchronized Object[] toArray() {
        return this.delegate.toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        return this.delegate.toArray(a);
    }

    public synchronized boolean add(Object element) {
        boolean success = this.delegate.add(element);
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    public synchronized boolean addAll(Collection elements) {
        boolean success = this.delegate.addAll(elements);
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    public synchronized void clear() {
        AbstractMemberMetaData mmd;
        if (this.ownerSM != null && !this.delegate.isEmpty() && SCOUtils.hasDependentElement(mmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName))) {
            Iterator iter = this.delegate.iterator();
            while (iter.hasNext()) {
                this.ownerSM.getExecutionContext().deleteObjectInternal(iter.next());
            }
        }
        this.delegate.clear();
        this.makeDirty();
    }

    public synchronized boolean offer(Object element) {
        boolean success = this.delegate.offer(element);
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    public synchronized Object poll() {
        Object obj = this.delegate.poll();
        this.makeDirty();
        return obj;
    }

    public synchronized boolean remove(Object element) {
        return this.remove(element, true);
    }

    public synchronized boolean remove(Object element, boolean allowCascadeDelete) {
        AbstractMemberMetaData mmd;
        boolean success = this.delegate.remove(element);
        if (this.ownerSM != null && allowCascadeDelete && SCOUtils.hasDependentElement(mmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName))) {
            this.ownerSM.getExecutionContext().deleteObjectInternal(element);
        }
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    public synchronized boolean removeAll(Collection elements) {
        AbstractMemberMetaData mmd;
        boolean success = this.delegate.removeAll(elements);
        if (this.ownerSM != null && elements != null && !elements.isEmpty() && SCOUtils.hasDependentElement(mmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName))) {
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                this.ownerSM.getExecutionContext().deleteObjectInternal(iter.next());
            }
        }
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    public synchronized boolean retainAll(Collection c) {
        boolean success = this.delegate.retainAll(c);
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new java.util.PriorityQueue(this.delegate);
    }
}

