/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.scostore.AbstractSetStore;
import org.datanucleus.store.mapped.scostore.AbstractSetStoreSpecialization;
import org.datanucleus.store.mapped.scostore.ElementContainerStore;
import org.datanucleus.store.types.sco.SCOMtoN;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class JoinSetStore
extends AbstractSetStore {
    public JoinSetStore(AbstractMemberMetaData mmd, DatastoreContainerObject joinTable, ClassLoaderResolver clr, JavaTypeMapping ownerMapping, JavaTypeMapping elementMapping, JavaTypeMapping orderMapping, JavaTypeMapping relationDiscriminatorMapping, String relationDiscriminatorValue, boolean isEmbeddedElement, boolean isSerialisedElement, AbstractSetStoreSpecialization specialization) {
        super((StoreManager)joinTable.getStoreManager(), clr, specialization);
        this.containerTable = joinTable;
        this.setOwner(mmd, clr);
        this.ownerMapping = ownerMapping;
        this.elementMapping = elementMapping;
        this.orderMapping = orderMapping;
        this.relationDiscriminatorMapping = relationDiscriminatorMapping;
        this.relationDiscriminatorValue = relationDiscriminatorValue;
        this.elementType = mmd.getCollection().getElementType();
        this.elementsAreEmbedded = isEmbeddedElement;
        this.elementsAreSerialised = isSerialisedElement;
        if (this.elementsAreSerialised) {
            this.elementInfo = null;
        } else {
            Class element_class = clr.classForName(this.elementType);
            if (ClassUtils.isReferenceType(element_class)) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(this.ownerMemberMetaData, 3, clr, this.storeMgr.getMetaDataManager());
                this.elementInfo = new ElementContainerStore.ElementInfo[implNames.length];
                for (int i = 0; i < implNames.length; ++i) {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(implNames[i], clr);
                    AbstractClassMetaData cmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(implNames[i], clr);
                    this.elementInfo[i] = new ElementContainerStore.ElementInfo(cmd, table);
                }
            } else {
                this.emd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
                this.elementInfo = this.emd != null && !this.elementsAreEmbedded ? this.getElementInformationForClass() : null;
            }
        }
    }

    public void update(ObjectProvider sm, Collection coll) {
        if (coll == null || coll.isEmpty()) {
            this.clear(sm);
            return;
        }
        if (this.ownerMemberMetaData.getCollection().isSerializedElement() || this.ownerMemberMetaData.getCollection().isEmbeddedElement()) {
            this.clear(sm);
            this.addAll(sm, coll, 0);
            return;
        }
        Iterator elemIter = this.iterator(sm);
        HashSet existing = new HashSet();
        while (elemIter.hasNext()) {
            Object elem = elemIter.next();
            if (!coll.contains(elem)) {
                this.remove(sm, elem, -1, true);
                continue;
            }
            existing.add(elem);
        }
        if (existing.size() != coll.size()) {
            for (Object elem : coll) {
                if (existing.contains(elem)) continue;
                this.add(sm, elem, 0);
            }
        }
    }

    public boolean removeAll(ObjectProvider sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = this.removeAllInternal(sm, elements, size);
        boolean dependent = this.ownerMemberMetaData.getCollection().isDependentElement();
        if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (dependent) {
            sm.getExecutionContext().deleteObjects(elements.toArray());
        }
        return modified;
    }

    protected abstract boolean removeAllInternal(ObjectProvider var1, Collection var2, int var3);

    private boolean elementAlreadyContainsOwnerInMtoN(ObjectProvider ownerSM, Object element) {
        AbstractMemberMetaData[] relatedMmds;
        ExecutionContext ec = ownerSM.getExecutionContext();
        ObjectProvider elementSM = ec.findObjectProvider(element);
        Object elementSCO = elementSM.provideField((relatedMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(ec.getClassLoaderResolver()))[0].getAbsoluteFieldNumber());
        if (elementSCO instanceof SCOMtoN) {
            if (this.contains(ownerSM, element)) {
                NucleusLogger.DATASTORE.info(LOCALISER.msg("056040", (Object)this.ownerMemberMetaData.getFullFieldName(), element));
                return true;
            }
        } else if (this.locate(ownerSM, element)) {
            NucleusLogger.DATASTORE.info(LOCALISER.msg("056040", (Object)this.ownerMemberMetaData.getFullFieldName(), element));
            return true;
        }
        return false;
    }

    public abstract boolean locate(ObjectProvider var1, Object var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(ObjectProvider sm, Object element, int size) {
        ObjectProvider elementSM;
        this.validateElementForWriting(sm, element, null);
        if (this.relationType == 4 && sm.getExecutionContext().getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships") && (elementSM = sm.getExecutionContext().findObjectProvider(element)) != null) {
            AbstractMemberMetaData[] relatedMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr);
            Object elementOwner = elementSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
            if (elementOwner == null) {
                NucleusLogger.PERSISTENCE.info(LOCALISER.msg("056037", (Object)sm.toPrintableID(), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString(elementSM.getObject())));
                elementSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), sm.getObject());
            } else if (elementOwner != sm.getObject() && sm.getReferencedPC() == null) {
                throw new NucleusUserException(LOCALISER.msg("056038", (Object)sm.toPrintableID(), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString(elementSM.getObject()), (Object)StringUtils.toJVMIDString(elementOwner)));
            }
        }
        boolean modified = false;
        boolean toBeInserted = true;
        if (this.relationType == 5) {
            boolean bl = toBeInserted = !this.elementAlreadyContainsOwnerInMtoN(sm, element);
        }
        if (toBeInserted) {
            try {
                ExecutionContext ec = sm.getExecutionContext();
                ManagedConnection mconn = this.storeMgr.getConnection(ec);
                try {
                    int[] returnCode;
                    int orderID = -1;
                    if (this.orderMapping != null) {
                        orderID = this.getNextIDForOrderColumn(sm);
                    }
                    if ((returnCode = this.internalAdd(sm, element, mconn, false, orderID, true))[0] > 0) {
                        modified = true;
                    }
                    Object var11_14 = null;
                    mconn.release();
                }
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    mconn.release();
                    throw throwable;
                }
            }
            catch (MappedDatastoreException e) {
                NucleusLogger.DATASTORE.error(e);
                String msg = LOCALISER.msg("056009", (Object)e.getMessage());
                NucleusLogger.DATASTORE.error(msg);
                throw new NucleusDataStoreException(msg, e);
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(ObjectProvider sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        ArrayList<MappedDatastoreException> exceptions = new ArrayList<MappedDatastoreException>();
        boolean batched = elements.size() > 1;
        for (Object element : elements) {
            ObjectProvider elementSM;
            this.validateElementForWriting(sm, element, null);
            if (this.relationType != 4 || !sm.getExecutionContext().getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships") || (elementSM = sm.getExecutionContext().findObjectProvider(element)) == null) continue;
            AbstractMemberMetaData[] relatedMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr);
            Object elementOwner = elementSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
            if (elementOwner == null) {
                NucleusLogger.PERSISTENCE.info(LOCALISER.msg("056037", (Object)sm.toPrintableID(), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString(elementSM.getObject())));
                elementSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), sm.getObject());
                continue;
            }
            if (elementOwner == sm.getObject() || sm.getReferencedPC() != null) continue;
            throw new NucleusUserException(LOCALISER.msg("056038", (Object)sm.toPrintableID(), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString(elementSM.getObject()), (Object)StringUtils.toJVMIDString(elementOwner)));
        }
        try {
            ExecutionContext ec = sm.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            try {
                this.preGetNextIDForOrderColumn(mconn);
                int nextOrderID = 0;
                if (this.orderMapping != null) {
                    nextOrderID = this.getNextIDForOrderColumn(sm);
                }
                Iterator iter = elements.iterator();
                Object element = null;
                while (iter.hasNext()) {
                    element = iter.next();
                    try {
                        int[] rc = this.internalAdd(sm, element, mconn, batched, nextOrderID, !batched || batched && !iter.hasNext());
                        if (rc != null) {
                            for (int i = 0; i < rc.length; ++i) {
                                if (rc[i] <= 0) continue;
                                modified = true;
                            }
                        }
                        ++nextOrderID;
                    }
                    catch (MappedDatastoreException mde) {
                        exceptions.add(mde);
                        NucleusLogger.DATASTORE.error("Exception thrown", mde);
                    }
                }
                Object var15_17 = null;
                mconn.release();
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                mconn.release();
                throw throwable;
            }
        }
        catch (MappedDatastoreException e) {
            exceptions.add(e);
            NucleusLogger.DATASTORE.error("Exception thrown", e);
        }
        if (!exceptions.isEmpty()) {
            String msg = LOCALISER.msg("056009", (Object)((Exception)exceptions.get(0)).getMessage());
            NucleusLogger.DATASTORE.error(msg);
            throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]), sm.getObject());
        }
        return modified;
    }

    protected abstract void preGetNextIDForOrderColumn(ManagedConnection var1) throws MappedDatastoreException;

    private int[] internalAdd(ObjectProvider sm, Object element, ManagedConnection conn, boolean batched, int orderId, boolean executeNow) throws MappedDatastoreException {
        boolean toBeInserted = true;
        if (this.relationType == 5) {
            boolean bl = toBeInserted = !this.elementAlreadyContainsOwnerInMtoN(sm, element);
        }
        if (toBeInserted) {
            return this.doInternalAdd(sm, element, conn, batched, orderId, executeNow);
        }
        return null;
    }

    protected abstract int[] doInternalAdd(ObjectProvider var1, Object var2, ManagedConnection var3, boolean var4, int var5, boolean var6) throws MappedDatastoreException;

    protected abstract int getNextIDForOrderColumn(ObjectProvider var1) throws MappedDatastoreException;
}

