/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.util.NucleusLogger;

public class CacheRetrieveFieldManager
extends AbstractFieldManager {
    ObjectProvider sm;
    CachedPC cachedPC;

    public CacheRetrieveFieldManager(ObjectProvider sm, CachedPC cachedPC) {
        this.sm = sm;
        this.cachedPC = cachedPC;
    }

    public Object fetchObjectField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        Object value = sfv.fetchObjectField(fieldNumber);
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        Object relationFieldValue = this.cachedPC.getRelationField(mmd.getName());
        if (relationFieldValue != null) {
            if (Collection.class.isAssignableFrom(relationFieldValue.getClass())) {
                Collection coll = (Collection)relationFieldValue;
                try {
                    Collection fieldColl = (Collection)coll.getClass().newInstance();
                    for (Object elementOid : coll) {
                        Object element = this.sm.getExecutionContext().findObject(elementOid, null, null, false);
                        fieldColl.add(element);
                    }
                    return fieldColl;
                }
                catch (Exception e) {
                    NucleusLogger.CACHE.error("Exception thrown creating value for field " + mmd.getFullFieldName() + " of type " + relationFieldValue.getClass().getName(), e);
                    return null;
                }
            }
            if (Map.class.isAssignableFrom(relationFieldValue.getClass())) {
                Map map = (Map)relationFieldValue;
                try {
                    Map fieldMap = (Map)map.getClass().newInstance();
                    for (Map.Entry entry : map.entrySet()) {
                        Object mapKey = null;
                        mapKey = mmd.getMap().keyIsPersistent() ? this.sm.getExecutionContext().findObject(entry.getKey(), null, null, false) : (Object)entry.getKey();
                        Object mapValue = null;
                        mapValue = mmd.getMap().valueIsPersistent() ? this.sm.getExecutionContext().findObject(entry.getValue(), null, null, false) : (Object)entry.getValue();
                        fieldMap.put(mapKey, mapValue);
                    }
                    return fieldMap;
                }
                catch (Exception e) {
                    NucleusLogger.CACHE.error("Exception thrown creating value for field " + mmd.getFullFieldName() + " of type " + relationFieldValue.getClass().getName(), e);
                    return null;
                }
            }
            if (relationFieldValue.getClass().isArray()) {
                try {
                    Object[] elementOIDs = (Object[])relationFieldValue;
                    Object fieldArr = Array.newInstance(mmd.getType().getComponentType(), elementOIDs.length);
                    for (int i = 0; i < elementOIDs.length; ++i) {
                        Object element = this.sm.getExecutionContext().findObject(elementOIDs[i], null, null, false);
                        Array.set(fieldArr, i, element);
                    }
                    return fieldArr;
                }
                catch (NucleusException ne) {
                    NucleusLogger.CACHE.error("Exception thrown trying to find element of array while getting object with id " + this.sm.getInternalObjectId() + " from the L2 cache", ne);
                    return null;
                }
            }
            try {
                return this.sm.getExecutionContext().findObject(relationFieldValue, null, null, false);
            }
            catch (NucleusObjectNotFoundException nonfe) {
                return null;
            }
        }
        if (value == null) {
            return null;
        }
        if (value.getClass() == StringBuffer.class) {
            return new StringBuffer(((StringBuffer)value).toString());
        }
        return value;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchBooleanField(fieldNumber);
    }

    public byte fetchByteField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchByteField(fieldNumber);
    }

    public char fetchCharField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchCharField(fieldNumber);
    }

    public double fetchDoubleField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchDoubleField(fieldNumber);
    }

    public float fetchFloatField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchFloatField(fieldNumber);
    }

    public int fetchIntField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchIntField(fieldNumber);
    }

    public long fetchLongField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchLongField(fieldNumber);
    }

    public short fetchShortField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchShortField(fieldNumber);
    }

    public String fetchStringField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchStringField(fieldNumber);
    }
}

