/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.plugin;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.plugin.NonManagedPluginRegistry;
import org.datanucleus.plugin.PluginRegistry;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class PluginRegistryFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ExecutionContext.class.getClassLoader());

    public static PluginRegistry newPluginRegistry(String registryClassName, String registryBundleCheck, ClassLoaderResolver clr) {
        PluginRegistry registry = null;
        if (registryClassName != null && (registry = PluginRegistryFactory.newInstance(registryClassName, registryClassName, clr)) != null) {
            if (NucleusLogger.PLUGIN.isDebugEnabled()) {
                NucleusLogger.PLUGIN.debug("Using PluginRegistry " + registry.getClass().getName());
            }
            return registry;
        }
        registry = PluginRegistryFactory.newInstance("org.eclipse.core.runtime.RegistryFactory", "org.datanucleus.plugin.EclipsePluginRegistry", clr);
        if (registry != null) {
            if (NucleusLogger.PLUGIN.isDebugEnabled()) {
                NucleusLogger.PLUGIN.debug("Using PluginRegistry " + registry.getClass().getName());
            }
            return registry;
        }
        if (NucleusLogger.PLUGIN.isDebugEnabled()) {
            NucleusLogger.PLUGIN.debug("Using PluginRegistry " + NonManagedPluginRegistry.class.getName());
        }
        return new NonManagedPluginRegistry(clr, registryBundleCheck);
    }

    private static PluginRegistry newInstance(String testClass, String registryClassName, ClassLoaderResolver clr) {
        try {
            if (clr.classForName(testClass, ObjectManagerFactoryImpl.class.getClassLoader()) == null && NucleusLogger.PLUGIN.isDebugEnabled()) {
                NucleusLogger.PLUGIN.debug(LOCALISER.msg("024005", (Object)registryClassName));
            }
            return (PluginRegistry)clr.classForName(registryClassName, ObjectManagerFactoryImpl.class.getClassLoader()).getConstructor(ClassLoaderResolver.class).newInstance(clr);
        }
        catch (Exception e) {
            if (NucleusLogger.PLUGIN.isDebugEnabled()) {
                NucleusLogger.PLUGIN.debug(LOCALISER.msg("024006", (Object)registryClassName, (Object)(e.getCause() != null ? e.getCause().getMessage() : e.getMessage())));
            }
            return null;
        }
    }
}

