/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jdo.query;

import java.util.ArrayList;
import javax.jdo.JDOException;
import org.datanucleus.jdo.query.BooleanExpressionImpl;
import org.datanucleus.jdo.query.ExpressionType;
import org.datanucleus.jdo.query.NumericExpressionImpl;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.query.typesafe.BooleanExpression;
import org.datanucleus.query.typesafe.NumericExpression;
import org.datanucleus.query.typesafe.PersistableExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionImpl<T>
implements org.datanucleus.query.typesafe.Expression<T> {
    Expression queryExpr;
    ExpressionType exprType = ExpressionType.PATH;

    public ExpressionImpl(PersistableExpression parent, String name) {
        ArrayList<String> tuples = new ArrayList<String>();
        if (parent != null) {
            Expression parentQueryExpr = ((ExpressionImpl)((Object)parent)).getQueryExpression();
            if (parentQueryExpr instanceof PrimaryExpression) {
                tuples.addAll(((PrimaryExpression)parentQueryExpr).getTuples());
                tuples.add(name);
                this.queryExpr = new PrimaryExpression(tuples);
            } else {
                tuples.add(name);
                this.queryExpr = new PrimaryExpression(parentQueryExpr, tuples);
            }
        } else {
            tuples.add(name);
            this.queryExpr = new PrimaryExpression(tuples);
        }
    }

    public ExpressionImpl(Class<T> cls, String name, ExpressionType type) {
        if (type != ExpressionType.PARAMETER && type != ExpressionType.VARIABLE) {
            throw new JDOException("Should not have called this constructor of ExpressionImpl!");
        }
        this.exprType = type;
        if (this.exprType == ExpressionType.PARAMETER) {
            this.queryExpr = new ParameterExpression(name, cls);
        } else if (this.exprType == ExpressionType.VARIABLE) {
            this.queryExpr = new VariableExpression(name);
        }
    }

    public ExpressionImpl(Expression queryExpr) {
        this.queryExpr = queryExpr;
    }

    public Expression getQueryExpression() {
        return this.queryExpr;
    }

    @Override
    public boolean isParameter() {
        return this.exprType == ExpressionType.PARAMETER;
    }

    @Override
    public boolean isVariable() {
        return this.exprType == ExpressionType.VARIABLE;
    }

    @Override
    public BooleanExpression eq(org.datanucleus.query.typesafe.Expression expr) {
        Expression leftQueryExpr = this.queryExpr;
        Expression rightQueryExpr = ((ExpressionImpl)expr).getQueryExpression();
        DyadicExpression queryExpr = new DyadicExpression(leftQueryExpr, Expression.OP_EQ, rightQueryExpr);
        return new BooleanExpressionImpl(queryExpr);
    }

    @Override
    public BooleanExpression eq(T t) {
        Expression leftQueryExpr = this.queryExpr;
        Literal rightQueryExpr = new Literal(t);
        DyadicExpression queryExpr = new DyadicExpression(leftQueryExpr, Expression.OP_EQ, rightQueryExpr);
        return new BooleanExpressionImpl(queryExpr);
    }

    @Override
    public BooleanExpression ne(org.datanucleus.query.typesafe.Expression expr) {
        Expression leftQueryExpr = this.queryExpr;
        Expression rightQueryExpr = ((ExpressionImpl)expr).getQueryExpression();
        DyadicExpression queryExpr = new DyadicExpression(leftQueryExpr, Expression.OP_NOTEQ, rightQueryExpr);
        return new BooleanExpressionImpl(queryExpr);
    }

    @Override
    public BooleanExpression ne(T t) {
        Expression leftQueryExpr = this.queryExpr;
        Literal rightQueryExpr = new Literal(t);
        DyadicExpression queryExpr = new DyadicExpression(leftQueryExpr, Expression.OP_NOTEQ, rightQueryExpr);
        return new BooleanExpressionImpl(queryExpr);
    }

    @Override
    public BooleanExpression instanceOf(Class cls) {
        throw new UnsupportedOperationException("instanceOf not yet supported");
    }

    @Override
    public NumericExpression<Long> count() {
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(this.queryExpr);
        InvokeExpression invokeExpr = new InvokeExpression(null, "count", args);
        return new NumericExpressionImpl<Long>(invokeExpr);
    }

    @Override
    public NumericExpression<Long> countDistinct() {
        ArrayList<DyadicExpression> args = new ArrayList<DyadicExpression>();
        args.add(new DyadicExpression(Expression.OP_DISTINCT, this.queryExpr));
        InvokeExpression invokeExpr = new InvokeExpression(null, "count", args);
        return new NumericExpressionImpl<Long>(invokeExpr);
    }
}

