/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jdo;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jdo.JDOException;
import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.datastore.DataStoreCache;
import javax.jdo.datastore.Sequence;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.metadata.JDOMetadata;
import javax.jdo.metadata.TypeMetadata;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.JDOPermission;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchGroup;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.TransactionActiveOnCloseException;
import org.datanucleus.exceptions.TransactionIsolationNotSupportedException;
import org.datanucleus.jdo.JDOClassNameConstants;
import org.datanucleus.jdo.JDODataStoreCache;
import org.datanucleus.jdo.JDOFetchGroup;
import org.datanucleus.jdo.JDOPersistenceManager;
import org.datanucleus.jdo.JDOPersistenceManagerProxy;
import org.datanucleus.jdo.JDOQueryCache;
import org.datanucleus.jdo.JDOTransaction;
import org.datanucleus.jdo.LifecycleListenerForClass;
import org.datanucleus.jdo.NucleusJDOHelper;
import org.datanucleus.jdo.metadata.ClassMetadataImpl;
import org.datanucleus.jdo.metadata.InterfaceMetadataImpl;
import org.datanucleus.jdo.metadata.JDOMetadataImpl;
import org.datanucleus.jdo.state.JDOStateManagerImpl;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PersistenceUnitMetaData;
import org.datanucleus.metadata.TransactionType;
import org.datanucleus.properties.CorePropertyValidator;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ConnectionResourceType;
import org.datanucleus.store.query.cache.QueryResultsCache;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDOPersistenceManagerFactory
extends ObjectManagerFactoryImpl
implements PersistenceManagerFactory,
ObjectFactory,
Referenceable {
    protected static final Localiser LOCALISER_JDO = Localiser.getInstance("org.datanucleus.jdo.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    private Set<JDOPersistenceManager> pmCache = null;
    protected Map<InstanceLifecycleListener, LifecycleListenerForClass> lifecycleListeners;
    private Map<String, Sequence> sequenceByFactoryClass;
    private DataStoreCache datastoreCache = null;
    private JDOQueryCache queryCache = null;
    private Set<JDOFetchGroup> jdoFetchGroups = null;
    private static Map<String, JDOPersistenceManagerFactory> pmfByName;
    private boolean closed;
    private transient ThreadLocal<PersistenceManager> pmProxyThreadLocal = new InheritableThreadLocal<PersistenceManager>(){

        @Override
        protected PersistenceManager initialValue() {
            return null;
        }
    };
    private static final String[] OPTION_ARRAY;

    public static synchronized PersistenceManagerFactory getPersistenceManagerFactory(Properties overridingProps) {
        HashMap<String, String> overridingMap = new HashMap<String, String>();
        Enumeration<?> e = overridingProps.propertyNames();
        while (e.hasMoreElements()) {
            String param = (String)e.nextElement();
            overridingMap.put(param, overridingProps.getProperty(param));
        }
        JDOPersistenceManagerFactory pmf = new JDOPersistenceManagerFactory(overridingMap);
        pmf.freezeConfiguration();
        return pmf;
    }

    public static synchronized PersistenceManagerFactory getPersistenceManagerFactory(Map overridingProps) {
        HashMap<String, String> overridingMap = null;
        if (overridingProps instanceof Properties) {
            overridingMap = new HashMap<String, String>();
            Enumeration<?> e = ((Properties)((Object)overridingProps)).propertyNames();
            while (e.hasMoreElements()) {
                String param = (String)e.nextElement();
                overridingMap.put(param, ((Properties)((Object)overridingProps)).getProperty(param));
            }
        } else {
            overridingMap = overridingProps;
        }
        return JDOPersistenceManagerFactory.createPersistenceManagerFactory(overridingMap);
    }

    public static synchronized PersistenceManagerFactory getPersistenceManagerFactory(Map overrides, Map props) {
        HashMap<String, String> propsMap = null;
        if (props instanceof Properties) {
            propsMap = new HashMap<String, String>();
            Enumeration<?> e = ((Properties)((Object)props)).propertyNames();
            while (e.hasMoreElements()) {
                String param = (String)e.nextElement();
                propsMap.put(param, ((Properties)((Object)props)).getProperty(param));
            }
        } else {
            propsMap = props;
        }
        HashMap<String, String> overridesMap = null;
        if (overrides instanceof Properties) {
            overridesMap = new HashMap<String, String>();
            Enumeration<?> e = ((Properties)((Object)overrides)).propertyNames();
            while (e.hasMoreElements()) {
                String param = (String)e.nextElement();
                overridesMap.put(param, ((Properties)((Object)overrides)).getProperty(param));
            }
        } else {
            overridesMap = overrides;
        }
        HashMap<String, String> overallMap = null;
        overallMap = propsMap != null ? new HashMap(propsMap) : new HashMap<String, String>();
        if (overridesMap != null) {
            overallMap.putAll(overridesMap);
        }
        return JDOPersistenceManagerFactory.createPersistenceManagerFactory(overallMap);
    }

    protected static JDOPersistenceManagerFactory createPersistenceManagerFactory(Map props) {
        JDOPersistenceManagerFactory pmf = new JDOPersistenceManagerFactory(props);
        Boolean singleton = pmf.getConfiguration().getBooleanObjectProperty("datanucleus.singletonPMFForName");
        if (singleton != null && singleton.booleanValue()) {
            String name;
            if (pmfByName == null) {
                pmfByName = new HashMap<String, JDOPersistenceManagerFactory>();
            }
            if ((name = pmf.getName()) == null) {
                name = pmf.getPersistenceUnitName();
            }
            if (name != null && pmfByName.containsKey(name)) {
                pmf.close();
                NucleusLogger.PERSISTENCE.warn("Requested PMF of name \"" + name + "\" but already exists and using singleton pattern, so returning existing PMF");
                return pmfByName.get(name);
            }
            pmfByName.put(name, pmf);
        }
        pmf.freezeConfiguration();
        return pmf;
    }

    public JDOPersistenceManagerFactory() {
        this(null);
    }

    public JDOPersistenceManagerFactory(Map props) {
        this.initialiseProperties(props);
    }

    protected void initialiseProperties(Map props) {
        if (props != null) {
            String[] startupPropNames = new String[]{"datanucleus.plugin.pluginRegistryClassName", "datanucleus.plugin.pluginRegistryBundleCheck", "datanucleus.classLoaderResolverName", "datanucleus.persistenceXmlFilename", "datanucleus.primaryClassLoader"};
            HashMap startupProps = null;
            for (int i = 0; i < startupPropNames.length; ++i) {
                if (!props.containsKey(startupPropNames[i])) continue;
                if (startupProps == null) {
                    startupProps = new HashMap();
                }
                startupProps.put(startupPropNames[i], props.get(startupPropNames[i]));
            }
            if (startupProps != null) {
                try {
                    this.getConfiguration().setPersistenceProperties(startupProps);
                }
                catch (NucleusException jpe) {
                    throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
                }
            }
        }
        this.initialiseOMFContext();
        String api = "JDO";
        if (props != null && props.get("datanucleus.persistenceApiName") != null) {
            api = (String)props.get("datanucleus.persistenceApiName");
        }
        this.omfContext.setApi(api);
        this.getConfiguration().setPersistenceProperties(this.omfContext.getApiAdapter().getDefaultFactoryProperties());
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                JDOImplHelper.registerAuthorizedStateManagerClass(JDOStateManagerImpl.class);
                return null;
            }
        });
        HashMap<Object, Object> pmfProps = new HashMap<Object, Object>();
        PersistenceUnitMetaData pumd = null;
        if (props != null) {
            String persistenceUnitName = (String)props.get("datanucleus.PersistenceUnitName");
            if (persistenceUnitName == null) {
                persistenceUnitName = (String)props.get("javax.jdo.option.PersistenceUnitName");
            }
            if (persistenceUnitName != null) {
                this.getConfiguration().setProperty("datanucleus.PersistenceUnitName", persistenceUnitName);
                try {
                    pumd = this.omfContext.getMetaDataManager().getMetaDataForPersistenceUnit(persistenceUnitName);
                    if (pumd != null) {
                        if (pumd.getProperties() != null) {
                            pmfProps.putAll(pumd.getProperties());
                        }
                    } else {
                        throw new JDOUserException(LOCALISER_JDO.msg("012004", (Object)persistenceUnitName));
                    }
                    if (this.omfContext.getApi().equalsIgnoreCase("JPA")) {
                        pumd.clearJarFiles();
                    }
                }
                catch (NucleusException jpe) {
                    throw new JDOUserException(LOCALISER_JDO.msg("012005", (Object)persistenceUnitName));
                }
            }
        }
        if (props != null) {
            pmfProps.putAll(props);
            if (!pmfProps.containsKey("datanucleus.TransactionType") && !pmfProps.containsKey("javax.jdo.option.TransactionType")) {
                pmfProps.put("datanucleus.TransactionType", TransactionType.RESOURCE_LOCAL.toString());
            } else {
                String transactionType;
                String string = transactionType = pmfProps.get("datanucleus.TransactionType") != null ? (String)pmfProps.get("datanucleus.TransactionType") : (String)pmfProps.get("javax.jdo.option.TransactionType");
                if (TransactionType.JTA.toString().equalsIgnoreCase(transactionType)) {
                    pmfProps.put("datanucleus.connection.resourceType", ConnectionResourceType.JTA.toString());
                    pmfProps.put("datanucleus.connection2.resourceType", ConnectionResourceType.JTA.toString());
                }
            }
        } else {
            pmfProps.put("datanucleus.TransactionType", TransactionType.RESOURCE_LOCAL.toString());
        }
        try {
            String propsFileProp = "datanucleus.propertiesFile";
            if (pmfProps.containsKey(propsFileProp)) {
                this.getConfiguration().setPropertiesUsingFile((String)pmfProps.get(propsFileProp));
                pmfProps.remove(propsFileProp);
            }
            this.getConfiguration().setPersistenceProperties(pmfProps);
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
        if (pumd != null) {
            try {
                this.omfContext.getMetaDataManager().loadPersistenceUnit(pumd, null);
            }
            catch (NucleusException jpe) {
                throw new JDOException(jpe.getMessage(), (Throwable)jpe);
            }
        }
        if (props != null) {
            for (String key : props.keySet()) {
                if (!key.startsWith("javax.jdo.listener.InstanceLifecycleListener")) continue;
                String listenerClsName = key.substring(45);
                String listenerClasses = (String)props.get(key);
                ClassLoaderResolver clr = this.omfContext.getClassLoaderResolver(null);
                Class listenerCls = null;
                try {
                    listenerCls = clr.classForName(listenerClsName);
                }
                catch (ClassNotResolvedException cnre) {
                    throw new JDOUserException(LOCALISER_JDO.msg("012022", (Object)listenerClsName));
                }
                InstanceLifecycleListener listener = null;
                Method method = ClassUtils.getMethodForClass(listenerCls, "getInstance", null);
                if (method != null) {
                    try {
                        listener = (InstanceLifecycleListener)method.invoke(null, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new JDOUserException(LOCALISER_JDO.msg("012021", (Object)listenerClsName), (Throwable)e);
                    }
                }
                try {
                    listener = (InstanceLifecycleListener)listenerCls.newInstance();
                }
                catch (Exception e) {
                    throw new JDOUserException(LOCALISER_JDO.msg("012020", (Object)listenerClsName), (Throwable)e);
                }
                Class[] classes = null;
                if (!StringUtils.isWhitespace(listenerClasses)) {
                    String[] classNames = StringUtils.split(listenerClasses, ",");
                    classes = new Class[classNames.length];
                    for (int i = 0; i < classNames.length; ++i) {
                        classes[i] = clr.classForName(classNames[i]);
                    }
                }
                this.addInstanceLifecycleListener(listener, classes);
            }
        }
    }

    protected void freezeConfiguration() {
        if (this.isConfigurable()) {
            if (this.omfContext == null) {
                this.initialiseOMFContext();
            }
            try {
                this.logConfiguration();
                ClassLoaderResolver clr = this.getOMFContext().getClassLoaderResolver(null);
                clr.registerUserClassLoader((ClassLoader)this.getConfiguration().getProperty("datanucleus.primaryClassLoader"));
                this.initialiseStoreManager(clr);
                this.initialiseLevel2Cache();
                if (this.cache != null) {
                    this.datastoreCache = new JDODataStoreCache(this.cache);
                }
                this.setIsNotConfigurable();
            }
            catch (TransactionIsolationNotSupportedException inse) {
                throw new JDOUnsupportedOptionException(inse.getMessage());
            }
            catch (NucleusException jpe) {
                throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
            }
        }
    }

    public synchronized PersistenceManager getPersistenceManager() {
        return this.getPersistenceManager(this.getConfiguration().getStringProperty("datanucleus.ConnectionUserName"), this.getConfiguration().getStringProperty("datanucleus.ConnectionPassword"));
    }

    public synchronized PersistenceManager getPersistenceManager(String userName, String password) {
        this.assertIsOpen();
        this.freezeConfiguration();
        JDOPersistenceManager pm = this.newPM(this, userName, password);
        if (this.lifecycleListeners != null) {
            for (LifecycleListenerForClass listener : this.lifecycleListeners.values()) {
                pm.addInstanceLifecycleListener(listener.getListener(), listener.getClasses());
            }
        }
        if (this.pmCache == null) {
            this.pmCache = new HashSet<JDOPersistenceManager>();
        }
        this.pmCache.add(pm);
        return pm;
    }

    protected JDOPersistenceManager newPM(JDOPersistenceManagerFactory jdoPmf, String userName, String password) {
        return new JDOPersistenceManager(jdoPmf, userName, password);
    }

    public synchronized boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JDOPersistenceManagerFactory)) {
            return false;
        }
        return super.equals(obj);
    }

    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
        JDOPersistenceManagerFactory pmf = null;
        if (NucleusLogger.NAMING.isDebugEnabled()) {
            NucleusLogger.NAMING.debug("Creating PersistenceManagerFactory instance via JNDI with values [object] " + (obj == null ? "" : obj.toString()) + " " + "[name] " + (name == null ? "" : name.toString()) + " " + "[context] " + (ctx == null ? "" : ctx.toString()) + " " + "[env] " + (env == null ? "" : env.toString()) + " ");
        }
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            if (ref.getClassName().equals(JDOClassNameConstants.JDOPersistenceManagerFactory) || ref.getClassName().equals(JDOClassNameConstants.JAVAX_JDO_PersistenceManagerFactory)) {
                Properties p = new Properties();
                Enumeration<RefAddr> e = ref.getAll();
                while (e.hasMoreElements()) {
                    StringRefAddr sra = (StringRefAddr)e.nextElement();
                    p.setProperty(sra.getType(), (String)sra.getContent());
                }
                pmf = new JDOPersistenceManagerFactory(p);
                pmf.freezeConfiguration();
                if (NucleusLogger.NAMING.isDebugEnabled()) {
                    NucleusLogger.NAMING.debug(LOCALISER_JDO.msg("012006", (Object)name.toString()));
                }
            } else {
                NucleusLogger.NAMING.warn(LOCALISER_JDO.msg("012007", (Object)ref.getClassName(), (Object)JDOClassNameConstants.JDOPersistenceManagerFactory));
            }
        } else {
            NucleusLogger.NAMING.warn(LOCALISER_JDO.msg("012008", (Object)obj.getClass().getName()));
        }
        return pmf;
    }

    @Override
    public Reference getReference() {
        Reference rc = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            rc = new Reference(JDOClassNameConstants.JAVAX_JDO_PersistenceManagerFactory, JDOClassNameConstants.JDOPersistenceManagerFactory, null);
            Map<String, Object> p = this.getConfiguration().getPersistenceProperties();
            for (String key : p.keySet()) {
                String value;
                if (p.get(key) instanceof String) {
                    value = (String)p.get(key);
                    rc.add(new StringRefAddr(key, value));
                    if (!NucleusLogger.NAMING.isDebugEnabled()) continue;
                    NucleusLogger.NAMING.debug(LOCALISER_JDO.msg("012009", (Object)key, (Object)value));
                    continue;
                }
                if (p.get(key) instanceof Long) {
                    value = "" + p.get(key);
                    rc.add(new StringRefAddr(key, value));
                    if (!NucleusLogger.NAMING.isDebugEnabled()) continue;
                    NucleusLogger.NAMING.debug(LOCALISER_JDO.msg("012009", (Object)key, (Object)value));
                    continue;
                }
                if (p.get(key) instanceof Integer) {
                    value = "" + p.get(key);
                    rc.add(new StringRefAddr(key, value));
                    if (!NucleusLogger.NAMING.isDebugEnabled()) continue;
                    NucleusLogger.NAMING.debug(LOCALISER_JDO.msg("012009", (Object)key, (Object)value));
                    continue;
                }
                if (p.get(key) instanceof Boolean) {
                    value = (Boolean)p.get(key) != false ? "true" : "false";
                    rc.add(new StringRefAddr(key, value));
                    if (!NucleusLogger.NAMING.isDebugEnabled()) continue;
                    NucleusLogger.NAMING.debug(LOCALISER_JDO.msg("012009", (Object)key, (Object)value));
                    continue;
                }
                NucleusLogger.NAMING.warn(LOCALISER_JDO.msg("012010", (Object)key));
            }
            if (NucleusLogger.NAMING.isDebugEnabled() && p.isEmpty()) {
                NucleusLogger.NAMING.debug(LOCALISER_JDO.msg("012011"));
            }
        }
        catch (IOException ex) {
            NucleusLogger.NAMING.error(ex.getMessage());
            throw new NucleusException(ex.getMessage(), ex);
        }
        return rc;
    }

    public PersistenceManager getPersistenceManagerProxy() {
        return new JDOPersistenceManagerProxy(this);
    }

    PersistenceManager getPMProxyDelegate() {
        PersistenceManager pm = this.pmProxyThreadLocal.get();
        if (pm == null) {
            pm = this.getPersistenceManager();
            this.pmProxyThreadLocal.set(pm);
        }
        return pm;
    }

    void clearPMProxyDelegate() {
        PersistenceManagerFactory pmf = this.getPMProxyDelegate().getPersistenceManagerFactory();
        String txnType = pmf.getTransactionType();
        if (TransactionType.RESOURCE_LOCAL.toString().equalsIgnoreCase(txnType)) {
            this.getPMProxyDelegate().close();
            this.pmProxyThreadLocal.remove();
        } else if (TransactionType.JTA.toString().equalsIgnoreCase(txnType)) {
            // empty if block
        }
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.setProperty("VendorName", JDOPersistenceManagerFactory.getVendorName());
        props.setProperty("VersionNumber", JDOPersistenceManagerFactory.getVersionNumber());
        return props;
    }

    public Collection<String> supportedOptions() {
        ArrayList<String> options = new ArrayList<String>(Arrays.asList(OPTION_ARRAY));
        StoreManager storeMgr = this.getOMFContext().getStoreManager();
        if (storeMgr != null) {
            Collection storeMgrOptions = storeMgr.getSupportedOptions();
            if (!storeMgrOptions.contains("DatastoreIdentity")) {
                options.remove("javax.jdo.option.DatastoreIdentity");
            }
            if (!storeMgrOptions.contains("ApplicationIdentity")) {
                options.remove("javax.jdo.option.ApplicationIdentity");
            }
            if (!storeMgrOptions.contains("OptimisticTransaction")) {
                options.remove("javax.jdo.option.Optimistic");
            }
            if (!storeMgr.supportsQueryLanguage("JDOQL")) {
                options.remove("javax.jdo.query.JDOQL");
            }
            if (!storeMgr.supportsQueryLanguage("SQL")) {
                options.remove("javax.jdo.query.SQL");
            }
            if (storeMgrOptions.contains("TransactionIsolationLevel.read-committed")) {
                options.add("javax.jdo.option.TransactionIsolationLevel.read-committed");
            }
            if (storeMgrOptions.contains("TransactionIsolationLevel.read-uncommitted")) {
                options.add("javax.jdo.option.TransactionIsolationLevel.read-uncommitted");
            }
            if (storeMgrOptions.contains("TransactionIsolationLevel.repeatable-read")) {
                options.add("javax.jdo.option.TransactionIsolationLevel.repeatable-read");
            }
            if (storeMgrOptions.contains("TransactionIsolationLevel.serializable")) {
                options.add("javax.jdo.option.TransactionIsolationLevel.serializable");
            }
            if (storeMgrOptions.contains("TransactionIsolationLevel.snapshot")) {
                options.add("javax.jdo.option.TransactionIsolationLevel.snapshot");
            }
            if (storeMgrOptions.contains("Query.Cancel")) {
                options.add("javax.jdo.option.QueryCancel");
            }
            if (storeMgrOptions.contains("Datastore.Timeout")) {
                options.add("javax.jdo.option.DatastoreTimeout");
            }
        }
        return Collections.unmodifiableList(options);
    }

    public synchronized void releasePersistenceManager(JDOPersistenceManager pm) {
        if (this.pmCache != null && this.pmCache.contains(pm)) {
            pm.internalClose();
            this.pmCache.remove(pm);
        }
    }

    protected synchronized void beginTransactionForPersistenceManager(PersistenceManager pm, JDOTransaction jdotx) {
        if (pm.isClosed()) {
            // empty if block
        }
        jdotx.internalBegin();
    }

    protected void assertIsOpen() {
        if (this.isClosed()) {
            throw new JDOUserException(LOCALISER.msg("008002"));
        }
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void close() {
        this.checkJDOPermission(JDOPermission.CLOSE_PERSISTENCE_MANAGER_FACTORY);
        if (this.isClosed()) {
            return;
        }
        this.setIsNotConfigurable();
        if (this.pmCache != null) {
            HashSet<JDOUserException> exceptions = new HashSet<JDOUserException>();
            for (JDOPersistenceManager pm : this.pmCache) {
                ObjectManager om = pm.getObjectManager();
                if (!om.getTransaction().isActive()) continue;
                TransactionActiveOnCloseException tae = new TransactionActiveOnCloseException(om);
                exceptions.add(new JDOUserException(tae.getMessage(), (Object)pm));
            }
            if (!exceptions.isEmpty()) {
                throw new JDOUserException(LOCALISER_JDO.msg("012002"), exceptions.toArray(new Throwable[exceptions.size()]));
            }
            for (JDOPersistenceManager pm : this.pmCache) {
                pm.internalClose();
            }
            this.pmCache.clear();
        }
        if (pmfByName != null) {
            pmfByName.values().remove(this);
        }
        super.close();
        this.closed = true;
    }

    public DataStoreCache getDataStoreCache() {
        this.freezeConfiguration();
        return this.datastoreCache;
    }

    public JDOQueryCache getQueryCache() {
        if (this.queryCache != null) {
            return this.queryCache;
        }
        QueryResultsCache cache = this.getOMFContext().getQueryManager().getQueryResultsCache();
        this.queryCache = new JDOQueryCache(cache);
        return this.queryCache;
    }

    public synchronized void setConnectionUserName(String userName) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.ConnectionUserName", userName);
    }

    public synchronized void setConnectionPassword(String password) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.ConnectionPassword", password);
    }

    public synchronized void setConnectionURL(String url) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.ConnectionURL", url);
    }

    public synchronized void setConnectionDriverName(String driverName) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.ConnectionDriverName", driverName);
    }

    public synchronized void setConnectionFactoryName(String connectionFactoryName) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.ConnectionFactoryName", connectionFactoryName);
    }

    public synchronized void setConnectionFactory(Object connectionFactory) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.ConnectionFactory", connectionFactory);
    }

    public synchronized void setConnectionFactory2Name(String connectionFactoryName) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.ConnectionFactory2Name", connectionFactoryName);
    }

    public synchronized void setConnectionFactory2(Object connectionFactory) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.ConnectionFactory2", connectionFactory);
    }

    public synchronized void setMultithreaded(boolean flag) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.Multithreaded", flag ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized void setOptimistic(boolean flag) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.Optimistic", flag ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized void setRetainValues(boolean flag) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.RetainValues", flag ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized void setRestoreValues(boolean flag) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.RestoreValues", flag ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized void setNontransactionalRead(boolean flag) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.NontransactionalRead", flag ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized void setNontransactionalWrite(boolean flag) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.NontransactionalWrite", flag ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized void setIgnoreCache(boolean flag) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.IgnoreCache", flag ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized void setDetachAllOnCommit(boolean flag) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.DetachAllOnCommit", flag ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized void setCopyOnAttach(boolean flag) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.CopyOnAttach", flag ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized void setMapping(String mapping) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.Mapping", mapping);
    }

    public synchronized void setCatalog(String catalog) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.mapping.Catalog", catalog);
    }

    public synchronized void setSchema(String schema) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.mapping.Schema", schema);
    }

    public synchronized void setDatastoreReadTimeoutMillis(Integer timeout) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.datastoreReadTimeout", timeout);
    }

    public synchronized void setDatastoreWriteTimeoutMillis(Integer timeout) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.datastoreWriteTimeout", timeout);
    }

    public synchronized void setTransactionType(String type) {
        this.assertConfigurable();
        boolean validated = new CorePropertyValidator().validate("datanucleus.TransactionType", type);
        if (!validated) {
            throw new JDOUserException(LOCALISER.msg("008012", (Object)"javax.jdo.option.TransactionType", (Object)type));
        }
        this.getConfiguration().setProperty("datanucleus.TransactionType", type);
    }

    public synchronized void setPersistenceUnitName(String name) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.PersistenceUnitName", name);
    }

    public synchronized void setPersistenceXmlFilename(String name) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.persistenceXmlFilename", name);
    }

    public synchronized void setName(String name) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.Name", name);
    }

    public synchronized void setServerTimeZoneID(String id) {
        this.assertConfigurable();
        boolean validated = new CorePropertyValidator().validate("datanucleus.ServerTimeZoneID", id);
        if (!validated) {
            throw new JDOUserException("Invalid TimeZone ID specified");
        }
        this.getConfiguration().setProperty("datanucleus.ServerTimeZoneID", id);
    }

    public synchronized void setReadOnly(boolean flag) {
        this.assertConfigurable();
        this.getConfiguration().setProperty("datanucleus.ReadOnly", flag ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized void setTransactionIsolationLevel(String level) {
        this.assertConfigurable();
        if (this.omfContext != null && this.omfContext.getStoreManager() != null && !this.omfContext.getStoreManager().getSupportedOptions().contains("TransactionIsolationLevel." + level)) {
            throw new JDOUnsupportedOptionException("Isolation level \"" + level + "\" is not supported for this datastore");
        }
        this.getConfiguration().setProperty("datanucleus.transactionIsolation", level != null ? level : "read-committed");
    }

    public String getConnectionUserName() {
        return this.getConfiguration().getStringProperty("datanucleus.ConnectionUserName");
    }

    public String getConnectionPassword() {
        return this.getConfiguration().getStringProperty("datanucleus.ConnectionPassword");
    }

    public String getConnectionURL() {
        return this.getConfiguration().getStringProperty("datanucleus.ConnectionURL");
    }

    public String getConnectionDriverName() {
        return this.getConfiguration().getStringProperty("datanucleus.ConnectionDriverName");
    }

    public String getConnectionFactoryName() {
        return this.getConfiguration().getStringProperty("datanucleus.ConnectionFactoryName");
    }

    public String getConnectionFactory2Name() {
        return this.getConfiguration().getStringProperty("datanucleus.ConnectionFactory2Name");
    }

    public Object getConnectionFactory() {
        return this.getConfiguration().getProperty("datanucleus.ConnectionFactory");
    }

    public Object getConnectionFactory2() {
        return this.getConfiguration().getProperty("datanucleus.ConnectionFactory2");
    }

    public boolean getMultithreaded() {
        return this.getConfiguration().getBooleanProperty("datanucleus.Multithreaded");
    }

    public boolean getOptimistic() {
        return this.getConfiguration().getBooleanProperty("datanucleus.Optimistic");
    }

    public boolean getRetainValues() {
        return this.getConfiguration().getBooleanProperty("datanucleus.RetainValues");
    }

    public boolean getRestoreValues() {
        return this.getConfiguration().getBooleanProperty("datanucleus.RestoreValues");
    }

    public boolean getNontransactionalRead() {
        return this.getConfiguration().getBooleanProperty("datanucleus.NontransactionalRead");
    }

    public boolean getNontransactionalWrite() {
        return this.getConfiguration().getBooleanProperty("datanucleus.NontransactionalWrite");
    }

    public boolean getIgnoreCache() {
        return this.getConfiguration().getBooleanProperty("datanucleus.IgnoreCache");
    }

    public boolean getDetachAllOnCommit() {
        return this.getConfiguration().getBooleanProperty("datanucleus.DetachAllOnCommit");
    }

    public boolean getCopyOnAttach() {
        return this.getConfiguration().getBooleanProperty("datanucleus.CopyOnAttach");
    }

    public String getMapping() {
        return this.getConfiguration().getStringProperty("datanucleus.Mapping");
    }

    public String getCatalog() {
        return this.getConfiguration().getStringProperty("datanucleus.mapping.Catalog");
    }

    public String getSchema() {
        return this.getConfiguration().getStringProperty("datanucleus.mapping.Schema");
    }

    public String getName() {
        return this.getConfiguration().getStringProperty("datanucleus.Name");
    }

    public String getPersistenceUnitName() {
        return this.getConfiguration().getStringProperty("datanucleus.PersistenceUnitName");
    }

    public String getPersistenceXmlFilename() {
        return this.getConfiguration().getStringProperty("datanucleus.persistenceXmlFilename");
    }

    public Integer getDatastoreReadTimeoutMillis() {
        return this.getConfiguration().getIntProperty("datanucleus.datastoreReadTimeout");
    }

    public Integer getDatastoreWriteTimeoutMillis() {
        return this.getConfiguration().getIntProperty("datanucleus.datastoreWriteTimeout");
    }

    public String getServerTimeZoneID() {
        return this.getConfiguration().getStringProperty("datanucleus.ServerTimeZoneID");
    }

    public boolean getReadOnly() {
        return this.getConfiguration().getBooleanProperty("datanucleus.ReadOnly");
    }

    public String getTransactionType() {
        return this.getConfiguration().getStringProperty("datanucleus.TransactionType");
    }

    public String getTransactionIsolationLevel() {
        return this.getConfiguration().getStringProperty("datanucleus.transactionIsolation");
    }

    public void setPrimaryClassLoader(ClassLoader loader) {
        this.getConfiguration().setProperty("datanucleus.primaryClassLoader", loader);
    }

    public ClassLoader getPrimaryClassLoader() {
        return (ClassLoader)this.getConfiguration().getProperty("datanucleus.primaryClassLoader");
    }

    public void setPersistenceProperties(Map<String, Object> props) {
        this.assertConfigurable();
        this.getConfiguration().setPersistenceProperties(props);
    }

    public Map<String, Object> getPersistenceProperties() {
        return this.getConfiguration().getPersistenceProperties();
    }

    @Override
    protected void assertConfigurable() {
        if (!this.isConfigurable()) {
            throw new JDOUserException(LOCALISER.msg("008016"));
        }
    }

    protected void assertLifecycleListenersConfigurable() {
        if (this.pmCache != null) {
            throw new JDOUserException(LOCALISER.msg("008017"));
        }
    }

    public List<LifecycleListenerForClass> getLifecycleListenerSpecifications() {
        return new ArrayList<LifecycleListenerForClass>(this.lifecycleListeners.values());
    }

    public synchronized void addInstanceLifecycleListener(InstanceLifecycleListener listener, Class[] classes) {
        this.assertLifecycleListenersConfigurable();
        if (listener == null) {
            return;
        }
        if ((classes = LifecycleListenerForClass.canonicaliseClasses(classes)) != null && classes.length == 0) {
            return;
        }
        if (this.lifecycleListeners == null) {
            this.lifecycleListeners = new IdentityHashMap<InstanceLifecycleListener, LifecycleListenerForClass>(1);
        }
        LifecycleListenerForClass entry = this.lifecycleListeners.containsKey(listener) ? this.lifecycleListeners.get(listener).mergeClasses(classes) : new LifecycleListenerForClass(listener, classes);
        this.lifecycleListeners.put(listener, entry);
    }

    public synchronized void removeInstanceLifecycleListener(InstanceLifecycleListener listener) {
        this.assertLifecycleListenersConfigurable();
        if (listener == null || this.lifecycleListeners == null) {
            return;
        }
        this.lifecycleListeners.remove(listener);
    }

    public void addSequenceForFactoryClass(String factoryClassName, Sequence sequence) {
        if (this.sequenceByFactoryClass == null) {
            this.sequenceByFactoryClass = new HashMap<String, Sequence>();
        }
        this.sequenceByFactoryClass.put(factoryClassName, sequence);
    }

    public Sequence getSequenceForFactoryClass(String factoryClassName) {
        if (this.sequenceByFactoryClass == null) {
            return null;
        }
        return this.sequenceByFactoryClass.get(factoryClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<javax.jdo.FetchGroup> getFetchGroups() {
        Set<JDOFetchGroup> jdoGroups = this.getJDOFetchGroups(false);
        if (jdoGroups != null) {
            Set<JDOFetchGroup> set = jdoGroups;
            synchronized (set) {
                if (!jdoGroups.isEmpty()) {
                    return new HashSet<javax.jdo.FetchGroup>(jdoGroups);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.jdo.FetchGroup getFetchGroup(Class cls, String name) {
        Set<JDOFetchGroup> jdoGroups = this.getJDOFetchGroups(false);
        if (jdoGroups != null) {
            Set<JDOFetchGroup> set = jdoGroups;
            synchronized (set) {
                for (JDOFetchGroup jdoFetchGroup : jdoGroups) {
                    if (jdoFetchGroup.getType() != cls || !jdoFetchGroup.getName().equals(name)) continue;
                    return jdoFetchGroup;
                }
            }
        }
        try {
            FetchGroup internalGrp = this.getInternalFetchGroup(cls, name);
            if (!internalGrp.isUnmodifiable()) {
                return new JDOFetchGroup(internalGrp);
            }
            internalGrp = this.createInternalFetchGroup(cls, name);
            this.addInternalFetchGroup(internalGrp);
            JDOFetchGroup jdoGrp = new JDOFetchGroup(internalGrp);
            return jdoGrp;
        }
        catch (NucleusException ne) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFetchGroups(javax.jdo.FetchGroup ... groups) {
        Set<JDOFetchGroup> jdoGroups;
        if (groups == null || groups.length == 0) {
            return;
        }
        Set<JDOFetchGroup> set = jdoGroups = this.getJDOFetchGroups(true);
        synchronized (set) {
            for (int i = 0; i < groups.length; ++i) {
                JDOFetchGroup jdoFetchGroup = (JDOFetchGroup)groups[i];
                this.addInternalFetchGroup(jdoFetchGroup.getInternalFetchGroup());
                jdoGroups.add(jdoFetchGroup);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFetchGroups(javax.jdo.FetchGroup ... groups) {
        if (groups == null || groups.length == 0) {
            return;
        }
        Set<JDOFetchGroup> jdoGroups = this.getJDOFetchGroups(false);
        if (jdoGroups != null) {
            Set<JDOFetchGroup> set = jdoGroups;
            synchronized (set) {
                if (!jdoGroups.isEmpty()) {
                    for (int i = 0; i < groups.length; ++i) {
                        JDOFetchGroup jdoFetchGroup = (JDOFetchGroup)groups[i];
                        this.removeInternalFetchGroup(jdoFetchGroup.getInternalFetchGroup());
                        jdoGroups.remove(jdoFetchGroup);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllFetchGroups() {
        Set<JDOFetchGroup> jdoGroups = this.getJDOFetchGroups(false);
        if (jdoGroups != null) {
            Set<JDOFetchGroup> set = jdoGroups;
            synchronized (set) {
                for (JDOFetchGroup jdoGrp : jdoGroups) {
                    this.removeInternalFetchGroup(jdoGrp.getInternalFetchGroup());
                }
                jdoGroups.clear();
            }
        }
    }

    public JDOMetadata newMetadata() {
        return new JDOMetadataImpl();
    }

    public void registerMetadata(JDOMetadata metadata) {
        MetaDataManager mmgr = this.omfContext.getMetaDataManager();
        FileMetaData filemd = ((JDOMetadataImpl)metadata).getInternal();
        for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
            int j;
            PackageMetaData pmd = filemd.getPackage(i);
            for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                ClassMetaData cmd = pmd.getClass(j);
                if (!mmgr.hasMetaDataForClass(cmd.getFullClassName())) continue;
                throw new JDOUserException("Cannot redefine metadata for " + cmd.getFullClassName());
            }
            for (j = 0; j < pmd.getNoOfInterfaces(); ++j) {
                InterfaceMetaData imd = pmd.getInterface(j);
                if (!mmgr.hasMetaDataForClass(imd.getFullClassName())) continue;
                throw new JDOUserException("Cannot redefine metadata for " + imd.getFullClassName());
            }
        }
        mmgr.loadUserMetaData(filemd, null);
    }

    public TypeMetadata getMetadata(String className) {
        MetaDataManager mmgr = this.omfContext.getMetaDataManager();
        AbstractClassMetaData acmd = mmgr.getMetaDataForClass(className, this.omfContext.getClassLoaderResolver(null));
        if (acmd == null) {
            return null;
        }
        if (acmd instanceof ClassMetaData) {
            return new ClassMetadataImpl((ClassMetaData)acmd);
        }
        return new InterfaceMetadataImpl((InterfaceMetaData)acmd);
    }

    public Collection<Class> getManagedClasses() {
        MetaDataManager mmgr = this.omfContext.getMetaDataManager();
        Collection classNames = mmgr.getClassesWithMetaData();
        HashSet<Class> classes = new HashSet<Class>();
        if (classNames != null) {
            ClassLoaderResolver clr = this.omfContext.getClassLoaderResolver(null);
            Iterator iter = classNames.iterator();
            while (iter.hasNext()) {
                try {
                    Class cls = clr.classForName((String)iter.next());
                    classes.add(cls);
                }
                catch (ClassNotResolvedException cnre) {}
            }
        }
        return classes;
    }

    private void checkJDOPermission(JDOPermission jdoPermission) {
        SecurityManager secmgr = System.getSecurityManager();
        if (secmgr != null) {
            secmgr.checkPermission((Permission)jdoPermission);
        }
    }

    private synchronized Set<JDOFetchGroup> getJDOFetchGroups(boolean createIfNull) {
        if (this.jdoFetchGroups == null && createIfNull) {
            this.jdoFetchGroups = new HashSet<JDOFetchGroup>();
        }
        return this.jdoFetchGroups;
    }

    static {
        OPTION_ARRAY = new String[]{"javax.jdo.option.TransientTransactional", "javax.jdo.option.NontransactionalWrite", "javax.jdo.option.NontransactionalRead", "javax.jdo.option.RetainValues", "javax.jdo.option.Optimistic", "javax.jdo.option.ApplicationIdentity", "javax.jdo.option.DatastoreIdentity", "javax.jdo.option.NonDurableIdentity", "javax.jdo.option.BinaryCompatibility", "javax.jdo.option.GetDataStoreConnection", "javax.jdo.option.GetJDBCConnection", "javax.jdo.option.version.DateTime", "javax.jdo.option.PreDirtyEvent", "javax.jdo.option.ArrayList", "javax.jdo.option.LinkedList", "javax.jdo.option.TreeSet", "javax.jdo.option.TreeMap", "javax.jdo.option.Vector", "javax.jdo.option.List", "javax.jdo.option.Stack", "javax.jdo.option.Map", "javax.jdo.option.HashMap", "javax.jdo.option.Hashtable", "javax.jdo.option.SortedSet", "javax.jdo.option.SortedMap", "javax.jdo.option.Array", "javax.jdo.option.NullCollection", "javax.jdo.option.mapping.HeterogeneousObjectType", "javax.jdo.option.mapping.HeterogeneousInterfaceType", "javax.jdo.option.mapping.JoinedTablePerClass", "javax.jdo.option.mapping.JoinedTablePerConcreteClass", "javax.jdo.option.mapping.NonJoinedTablePerConcreteClass", "javax.jdo.query.SQL", "javax.jdo.query.JDOQL", "javax.jdo.option.UnconstrainedQueryVariables"};
    }
}

