/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.sco.queued;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.scostore.Store;
import org.datanucleus.store.types.sco.queued.AddOperation;
import org.datanucleus.store.types.sco.queued.QueuedOperation;
import org.datanucleus.store.types.sco.queued.RemoveOperation;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class OperationQueue {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    private List<QueuedOperation> queuedOperations = new ArrayList<QueuedOperation>();

    public void enqueue(QueuedOperation oper) {
        this.queuedOperations.add(oper);
    }

    public void performAll(Store store, ObjectProvider op, String fieldName) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023005", (Object)op.toPrintableID(), (Object)fieldName));
        }
        List<QueuedOperation> flushOperations = this.queuedOperations;
        this.queuedOperations = new ArrayList<QueuedOperation>();
        ListIterator<QueuedOperation> operIter = flushOperations.listIterator();
        while (operIter.hasNext()) {
            QueuedOperation oper = operIter.next();
            if (oper instanceof AddOperation) {
                if (operIter.hasNext()) {
                    QueuedOperation operNext = operIter.next();
                    boolean addThenRemove = false;
                    if (operNext instanceof RemoveOperation && ((AddOperation)oper).getValue() == ((RemoveOperation)operNext).getValue()) {
                        addThenRemove = true;
                        NucleusLogger.PERSISTENCE.info("Field " + fieldName + " of " + StringUtils.toJVMIDString(op.getObject()) + " had an add then a remove of element " + StringUtils.toJVMIDString(((AddOperation)oper).getValue()) + " - operations ignored");
                    }
                    if (addThenRemove) continue;
                    operIter.previous();
                    oper.perform(store, op);
                    continue;
                }
                oper.perform(store, op);
                continue;
            }
            if (oper instanceof RemoveOperation) {
                if (operIter.hasNext()) {
                    QueuedOperation opNext = operIter.next();
                    boolean removeThenAdd = false;
                    if (opNext instanceof AddOperation && ((RemoveOperation)oper).getValue() == ((AddOperation)opNext).getValue()) {
                        removeThenAdd = true;
                        NucleusLogger.PERSISTENCE.info("Field " + fieldName + " of " + StringUtils.toJVMIDString(op.getObject()) + " had a remove then add of element " + StringUtils.toJVMIDString(((RemoveOperation)oper).getValue()) + " - operations ignored");
                    }
                    if (removeThenAdd) continue;
                    operIter.previous();
                    oper.perform(store, op);
                    continue;
                }
                oper.perform(store, op);
                continue;
            }
            oper.perform(store, op);
        }
        if (!this.queuedOperations.isEmpty()) {
            this.queuedOperations.clear();
        }
    }
}

