/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.util.Collection;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.scostore.AbstractSetStore;
import org.datanucleus.store.mapped.scostore.AbstractSetStoreSpecialization;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.util.ClassUtils;

public abstract class MapKeySetStore
extends AbstractSetStore {
    protected final MapStore mapStore;

    public MapKeySetStore(DatastoreContainerObject mapTable, AbstractMemberMetaData ownerMmd, JavaTypeMapping ownerMapping, JavaTypeMapping keyMapping, MapStore mapStore, ClassLoaderResolver clr, AbstractSetStoreSpecialization specialization) {
        super((StoreManager)mapTable.getStoreManager(), clr, specialization);
        this.mapStore = mapStore;
        this.containerTable = mapTable;
        this.ownerMemberMetaData = ownerMmd;
        this.ownerMapping = ownerMapping;
        this.elementMapping = keyMapping;
        this.initialize(clr);
    }

    private void initialize(ClassLoaderResolver clr) {
        this.elementType = this.elementMapping.getType();
        this.elementsAreEmbedded = this.isEmbeddedMapping(this.elementMapping);
        this.elementsAreSerialised = this.isEmbeddedMapping(this.elementMapping);
        Class element_class = clr.classForName(this.elementType);
        this.emd = ClassUtils.isReferenceType(element_class) ? this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr) : this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
        if (this.emd != null) {
            this.elementType = this.emd.getFullClassName();
            this.elementInfo = this.getElementInformationForClass();
        }
    }

    public boolean add(ObjectProvider sm, Object element, int size) {
        throw new UnsupportedOperationException("Cannot add to a map through its key set");
    }

    public boolean addAll(ObjectProvider sm, Collection elements, int size) {
        throw new UnsupportedOperationException("Cannot add to a map through its key set");
    }

    public boolean remove(ObjectProvider sm, Object element, int size, boolean allowDependentField) {
        if (!this.canRemove()) {
            throw new UnsupportedOperationException("Cannot remove from an inverse map through its key set");
        }
        return super.remove(sm, element, size, allowDependentField);
    }

    public boolean removeAll(ObjectProvider sm, Collection elements, int size) {
        if (!this.canRemove()) {
            throw new UnsupportedOperationException("Cannot remove from an inverse map through its key set");
        }
        return super.removeAll(sm, elements, size);
    }

    public void clear(ObjectProvider sm) {
        if (!this.canClear()) {
            throw new UnsupportedOperationException("Cannot clear an inverse map through its key set");
        }
        super.clear(sm);
    }

    protected abstract boolean canRemove();

    protected abstract boolean canClear();

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression qs, JavaTypeMapping ownerMapping, LogicSetExpression te, DatastoreIdentifier setTableAlias, Class filteredElementType, ScalarExpression elmExpr, DatastoreIdentifier elementTableAlias, boolean existsQuery) {
        throw new NucleusUserException("Cannot query sets obtained by Map.keySet()");
    }
}

