/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.OMFContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.SingleFieldMultiMapping;

public class RectangleMapping
extends SingleFieldMultiMapping {
    private static final Rectangle sampleValue = new Rectangle(0, 0, 1, 1);

    public void initialize(AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(fmd, container, clr);
        this.addDatastoreFields();
    }

    public void initialize(MappedStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addDatastoreFields();
    }

    protected void addDatastoreFields() {
        this.addDatastoreField(ClassNameConstants.INT);
        this.addDatastoreField(ClassNameConstants.INT);
        this.addDatastoreField(ClassNameConstants.INT);
        this.addDatastoreField(ClassNameConstants.INT);
    }

    public Class getJavaType() {
        return Rectangle.class;
    }

    public Object getValueForDatastoreMapping(OMFContext omfCtx, int index, Object value) {
        Rectangle2D.Double rect = (Rectangle2D.Double)value;
        if (index == 0) {
            return rect.getX();
        }
        if (index == 1) {
            return rect.getY();
        }
        if (index == 2) {
            return rect.getWidth();
        }
        if (index == 3) {
            return rect.getHeight();
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ExecutionContext ec, Object preparedStatement, int[] exprIndex, Object value) {
        Rectangle rectangle = (Rectangle)value;
        if (rectangle == null) {
            for (int i = 0; i < exprIndex.length; ++i) {
                this.getDatastoreMapping(i).setObject(preparedStatement, exprIndex[i], null);
            }
        } else {
            this.getDatastoreMapping(0).setInt(preparedStatement, exprIndex[0], rectangle.x);
            this.getDatastoreMapping(1).setInt(preparedStatement, exprIndex[1], rectangle.y);
            this.getDatastoreMapping(2).setInt(preparedStatement, exprIndex[2], rectangle.width);
            this.getDatastoreMapping(3).setInt(preparedStatement, exprIndex[3], rectangle.height);
        }
    }

    public Object getObject(ExecutionContext ec, Object resultSet, int[] exprIndex) {
        if (this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        int x = this.getDatastoreMapping(0).getInt(resultSet, exprIndex[0]);
        int y = this.getDatastoreMapping(1).getInt(resultSet, exprIndex[1]);
        int width = this.getDatastoreMapping(2).getInt(resultSet, exprIndex[2]);
        int height = this.getDatastoreMapping(3).getInt(resultSet, exprIndex[3]);
        return new Rectangle(x, y, width, height);
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return sampleValue;
    }
}

