/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.store.scostore.SetStore;

public abstract class MapEntrySetStore
extends BaseContainerStore
implements SetStore {
    protected DatastoreContainerObject mapTable;
    protected MapStore mapStore;
    protected JavaTypeMapping keyMapping;
    protected JavaTypeMapping valueMapping;
    protected ClassLoaderResolver clr;

    public MapEntrySetStore(DatastoreContainerObject mapTable, AbstractMemberMetaData ownerMemberMetaData, JavaTypeMapping ownerMapping, JavaTypeMapping keyMapping, JavaTypeMapping valueMapping, MapStore mapStore, ClassLoaderResolver clr) {
        super(mapTable.getStoreManager());
        this.mapTable = mapTable;
        this.mapStore = mapStore;
        this.ownerMapping = ownerMapping;
        this.keyMapping = keyMapping;
        this.valueMapping = valueMapping;
        this.ownerMemberMetaData = ownerMemberMetaData;
        this.clr = clr;
    }

    public boolean hasOrderMapping() {
        return false;
    }

    public boolean updateEmbeddedElement(ObjectProvider sm, Object element, int fieldNumber, Object value) {
        return false;
    }

    public JavaTypeMapping getOwnerMapping() {
        return this.ownerMapping;
    }

    protected boolean validateElementType(Object element) {
        return element instanceof Map.Entry;
    }

    public abstract Iterator iterator(ObjectProvider var1);

    public abstract int size(ObjectProvider var1);

    public void update(ObjectProvider sm, Collection coll) {
        this.clear(sm);
        this.addAll(sm, coll, 0);
    }

    public boolean contains(ObjectProvider sm, Object element) {
        if (!this.validateElementType(element)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)element;
        return this.mapStore.containsKey(sm, entry.getKey());
    }

    public boolean add(ObjectProvider sm, Object element, int size) {
        throw new UnsupportedOperationException("Cannot add to a map through its entry set");
    }

    public boolean addAll(ObjectProvider sm, Collection elements, int size) {
        throw new UnsupportedOperationException("Cannot add to a map through its entry set");
    }

    public boolean remove(ObjectProvider sm, Object element, int size, boolean allowDependentField) {
        if (!this.validateElementType(element)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)element;
        Object removed = this.mapStore.remove(sm, entry.getKey());
        return removed == null ? entry.getValue() == null : removed.equals(entry.getValue());
    }

    public boolean removeAll(ObjectProvider sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        Iterator iter = elements.iterator();
        boolean modified = false;
        while (iter.hasNext()) {
            Object element = iter.next();
            Map.Entry entry = (Map.Entry)element;
            Object removed = this.mapStore.remove(sm, entry.getKey());
            modified = removed == null ? entry.getValue() == null : removed.equals(entry.getValue());
        }
        return modified;
    }

    public void clear(ObjectProvider sm) {
        this.mapStore.clear(sm);
    }

    public MapStore getMapStore() {
        return this.mapStore;
    }

    public JavaTypeMapping getKeyMapping() {
        return this.keyMapping;
    }

    public JavaTypeMapping getValueMapping() {
        return this.valueMapping;
    }

    public QueryExpression getExistsSubquery(QueryExpression stmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier collectionTableAlias) {
        throw new NucleusUserException("Cannot query sets obtained by Map.entrySet()");
    }

    public QueryExpression getSizeSubquery(QueryExpression stmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier collectionTableAlias) {
        throw new NucleusUserException("Cannot query sets obtained by Map.entrySet()");
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression qs, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier collectionTableAlias, Class filteredElementType, ScalarExpression elmExpr, DatastoreIdentifier elementTableAlias, boolean existsQuery) {
        throw new NucleusUserException("Cannot query sets obtained by Map.entrySet()");
    }
}

