/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StringLiteral;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.StringMapping;
import org.datanucleus.store.types.StringBufferStringConverter;

public class StringBufferMapping
extends StringMapping {
    protected static StringBufferStringConverter converter = new StringBufferStringConverter();
    protected static StringBuffer mappingSampleValue = new StringBuffer();

    public String getJavaTypeForDatastoreMapping(int index) {
        return ClassNameConstants.JAVA_LANG_STRING;
    }

    public void setObject(ExecutionContext ec, Object preparedStatement, int[] exprIndex, Object value) {
        String v = converter.toString(value);
        super.setObject(ec, preparedStatement, exprIndex, v);
    }

    public Object getObject(ExecutionContext ec, Object resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return null;
        }
        Object value = this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]);
        if (value != null) {
            return converter.toObject((String)value);
        }
        return null;
    }

    public Class getJavaType() {
        return StringBuffer.class;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return mappingSampleValue;
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        return new StringLiteral(qs, (JavaTypeMapping)this, ((StringBuffer)value).toString());
    }
}

