/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.OMFContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.SqlTemporalExpression;
import org.datanucleus.store.mapped.expression.SqlTimestampLiteral;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SingleFieldMultiMapping;

public class GregorianCalendarMapping
extends SingleFieldMultiMapping {
    boolean singleColumn = false;

    public void initialize(AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(fmd, container, clr);
        this.addDatastoreFields();
    }

    public void initialize(MappedStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addDatastoreFields();
    }

    protected void addDatastoreFields() {
        if (this.mmd != null && this.mmd.hasExtension("calendar-one-column") && this.mmd.getValueForExtension("calendar-one-column").equals("true")) {
            this.singleColumn = true;
        }
        if (this.singleColumn) {
            this.addDatastoreField(ClassNameConstants.JAVA_SQL_TIMESTAMP);
        } else {
            this.addDatastoreField(ClassNameConstants.LONG);
            this.addDatastoreField(ClassNameConstants.JAVA_LANG_STRING);
        }
    }

    public Class getJavaType() {
        return GregorianCalendar.class;
    }

    public String getJavaTypeForDatastoreMapping(int index) {
        if (this.singleColumn) {
            return ClassNameConstants.JAVA_SQL_TIMESTAMP;
        }
        if (index == 0) {
            return ClassNameConstants.LONG;
        }
        if (index == 1) {
            return ClassNameConstants.JAVA_LANG_STRING;
        }
        return null;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return new GregorianCalendar();
    }

    public Object getValueForDatastoreMapping(OMFContext omfCtx, int index, Object value) {
        if (this.singleColumn) {
            return value;
        }
        if (index == 0) {
            return ((Calendar)value).getTime().getTime();
        }
        if (index == 1) {
            return ((Calendar)value).getTimeZone().getID();
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ExecutionContext ec, Object preparedStatement, int[] exprIndex, Object value) {
        GregorianCalendar cal = (GregorianCalendar)value;
        if (this.singleColumn) {
            Timestamp ts = null;
            if (cal != null) {
                ts = new Timestamp(cal.getTimeInMillis());
            }
            this.getDatastoreMapping(0).setObject(preparedStatement, exprIndex[0], ts);
        } else if (cal == null) {
            this.getDatastoreMapping(0).setObject(preparedStatement, exprIndex[0], null);
            this.getDatastoreMapping(1).setObject(preparedStatement, exprIndex[1], null);
        } else {
            this.getDatastoreMapping(0).setLong(preparedStatement, exprIndex[0], cal.getTime().getTime());
            this.getDatastoreMapping(1).setString(preparedStatement, exprIndex[1], cal.getTimeZone().getID());
        }
    }

    public Object getObject(ExecutionContext ec, Object resultSet, int[] exprIndex) {
        try {
            if (this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]) == null) {
                return null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.singleColumn) {
            Timestamp ts = (Timestamp)this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(ts.getTime());
            String timezoneID = ec.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.ServerTimeZoneID");
            if (timezoneID != null) {
                cal.setTimeZone(TimeZone.getTimeZone(timezoneID));
            }
            return cal;
        }
        long millisecs = this.getDatastoreMapping(0).getLong(resultSet, exprIndex[0]);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(millisecs));
        String timezoneId = this.getDatastoreMapping(1).getString(resultSet, exprIndex[1]);
        if (timezoneId != null) {
            cal.setTimeZone(TimeZone.getTimeZone(timezoneId));
        }
        return cal;
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        if (this.singleColumn) {
            return new SqlTimestampLiteral(qs, (JavaTypeMapping)this, (Timestamp)value);
        }
        throw new NucleusUserException("We dont support querying of Calendar fields when stored as 2 columns");
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        if (this.singleColumn) {
            return new SqlTemporalExpression(qs, this, te);
        }
        throw new NucleusUserException("We dont support querying of Calendar fields when stored as 2 columns");
    }
}

