/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.fieldmanager;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.store.types.sco.SCO;
import org.datanucleus.store.types.sco.SCOContainer;
import org.datanucleus.util.NucleusLogger;

public class CachePopulateFieldManager
extends AbstractFieldManager {
    CachedPC cachedPC;
    protected final ObjectProvider sm;

    public CachePopulateFieldManager(ObjectProvider sm, CachedPC cachedPC) {
        this.sm = sm;
        this.cachedPC = cachedPC;
    }

    public Object fetchObjectField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        Object value = sfv.fetchObjectField(fieldNumber);
        ApiAdapter api = this.sm.getExecutionContext().getApiAdapter();
        this.cachedPC.getLoadedFields()[fieldNumber] = true;
        if (value == null) {
            return null;
        }
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (!mmd.isCacheable()) {
            this.cachedPC.getLoadedFields()[fieldNumber] = false;
            return null;
        }
        if (api.isPersistable(value)) {
            if (mmd.isSerialized() || mmd.isEmbedded()) {
                this.cachedPC.getLoadedFields()[fieldNumber] = false;
                return null;
            }
            this.cachedPC.setRelationField(mmd.getName(), api.getIdForObject(value));
            return null;
        }
        if (value instanceof Collection) {
            if (MetaDataUtils.getInstance().storesPersistable(mmd, this.sm.getExecutionContext())) {
                if (value instanceof List && mmd.getOrderMetaData() != null && !mmd.getOrderMetaData().isIndexedList()) {
                    this.cachedPC.getLoadedFields()[fieldNumber] = false;
                    return null;
                }
                if (mmd.isSerialized() || mmd.isEmbedded() || mmd.getCollection().isSerializedElement() || mmd.getCollection().isEmbeddedElement()) {
                    this.cachedPC.getLoadedFields()[fieldNumber] = false;
                    return null;
                }
                Collection collValue = (Collection)value;
                if (collValue instanceof SCO && !((SCOContainer)value).isLoaded()) {
                    this.cachedPC.getLoadedFields()[fieldNumber] = false;
                    return null;
                }
                Iterator collIter = collValue.iterator();
                Collection returnColl = null;
                try {
                    returnColl = value.getClass().isInterface() ? (List.class.isAssignableFrom(value.getClass()) || mmd.getOrderMetaData() != null ? new ArrayList() : new HashSet()) : (value instanceof SCO ? (Collection)((SCO)value).getValue().getClass().newInstance() : (ArrayList)value.getClass().newInstance());
                    while (collIter.hasNext()) {
                        Object elem = collIter.next();
                        returnColl.add(api.getIdForObject(elem));
                    }
                    this.cachedPC.setRelationField(mmd.getName(), returnColl);
                    return null;
                }
                catch (Exception e) {
                    NucleusLogger.CACHE.warn("Unable to create object of type " + value.getClass().getName() + " for L2 caching : " + e.getMessage());
                    this.cachedPC.getLoadedFields()[fieldNumber] = false;
                    return null;
                }
            }
            if (value instanceof SCOContainer) {
                if (((SCOContainer)value).isLoaded()) {
                    return ((SCO)value).getValue();
                }
                this.cachedPC.getLoadedFields()[fieldNumber] = false;
                return null;
            }
            return value;
        }
        if (value instanceof Map) {
            if (MetaDataUtils.getInstance().storesPersistable(mmd, this.sm.getExecutionContext())) {
                if (mmd.isSerialized() || mmd.isEmbedded() || mmd.getMap().isSerializedKey() || mmd.getMap().isEmbeddedKey() || mmd.getMap().isSerializedValue() || mmd.getMap().isEmbeddedValue()) {
                    this.cachedPC.getLoadedFields()[fieldNumber] = false;
                    return null;
                }
                if (value instanceof SCO && !((SCOContainer)value).isLoaded()) {
                    this.cachedPC.getLoadedFields()[fieldNumber] = false;
                    return null;
                }
                try {
                    Map returnMap = null;
                    returnMap = value.getClass().isInterface() ? new HashMap() : (value instanceof SCO ? (Map)((SCO)value).getValue().getClass().newInstance() : (Map)value.getClass().newInstance());
                    for (Map.Entry entry : ((Map)value).entrySet()) {
                        Object mapKey = null;
                        Object mapValue = null;
                        mapKey = mmd.getMap().keyIsPersistent() ? api.getIdForObject(entry.getKey()) : (Object)entry.getKey();
                        mapValue = mmd.getMap().valueIsPersistent() ? api.getIdForObject(entry.getValue()) : (Object)entry.getValue();
                        returnMap.put(mapKey, mapValue);
                    }
                    this.cachedPC.setRelationField(mmd.getName(), returnMap);
                    return null;
                }
                catch (Exception e) {
                    NucleusLogger.CACHE.warn("Unable to create object of type " + value.getClass().getName() + " for L2 caching : " + e.getMessage());
                    this.cachedPC.getLoadedFields()[fieldNumber] = false;
                    return null;
                }
            }
            if (value instanceof SCOContainer) {
                if (((SCOContainer)value).isLoaded()) {
                    return ((SCO)value).getValue();
                }
                this.cachedPC.getLoadedFields()[fieldNumber] = false;
                return null;
            }
            return value;
        }
        if (value instanceof Object[]) {
            if (MetaDataUtils.getInstance().storesPersistable(mmd, this.sm.getExecutionContext())) {
                if (mmd.isSerialized() || mmd.isEmbedded() || mmd.getArray().isSerializedElement() || mmd.getArray().isEmbeddedElement()) {
                    this.cachedPC.getLoadedFields()[fieldNumber] = false;
                    return null;
                }
                Object[] returnArr = new Object[Array.getLength(value)];
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object element = Array.get(value, i);
                    returnArr[i] = api.getIdForObject(element);
                }
                this.cachedPC.setRelationField(mmd.getName(), returnArr);
                return null;
            }
            return value;
        }
        if (value instanceof StringBuffer) {
            return new StringBuffer(((StringBuffer)value).toString());
        }
        if (value instanceof SCO) {
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug("CachePopulateFM.fetchObjectField this=" + this.sm.toPrintableID() + " field=" + fieldNumber + " is having its SCO wrapper replaced prior to L2 caching.");
            }
            return ((SCO)value).getValue();
        }
        return value;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        this.cachedPC.getLoadedFields()[fieldNumber] = true;
        return sfv.fetchBooleanField(fieldNumber);
    }

    public byte fetchByteField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        this.cachedPC.getLoadedFields()[fieldNumber] = true;
        return sfv.fetchByteField(fieldNumber);
    }

    public char fetchCharField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        this.cachedPC.getLoadedFields()[fieldNumber] = true;
        return sfv.fetchCharField(fieldNumber);
    }

    public double fetchDoubleField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        this.cachedPC.getLoadedFields()[fieldNumber] = true;
        return sfv.fetchDoubleField(fieldNumber);
    }

    public float fetchFloatField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        this.cachedPC.getLoadedFields()[fieldNumber] = true;
        return sfv.fetchFloatField(fieldNumber);
    }

    public int fetchIntField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        this.cachedPC.getLoadedFields()[fieldNumber] = true;
        return sfv.fetchIntField(fieldNumber);
    }

    public long fetchLongField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        this.cachedPC.getLoadedFields()[fieldNumber] = true;
        return sfv.fetchLongField(fieldNumber);
    }

    public short fetchShortField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        this.cachedPC.getLoadedFields()[fieldNumber] = true;
        return sfv.fetchShortField(fieldNumber);
    }

    public String fetchStringField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        this.cachedPC.getLoadedFields()[fieldNumber] = true;
        return sfv.fetchStringField(fieldNumber);
    }
}

