/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.expression;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.query.expression.ArrayExpression;
import org.datanucleus.query.expression.CaseExpression;
import org.datanucleus.query.expression.ClassExpression;
import org.datanucleus.query.expression.CreatorExpression;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.JoinExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.expression.SubqueryExpression;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.query.node.Node;
import org.datanucleus.query.node.NodeType;
import org.datanucleus.query.node.ParameterNode;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.store.query.QueryCompilerSyntaxException;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionCompiler {
    SymbolTable symtbl;
    Map<String, String> aliasByPrefix = null;

    public void setMethodAliases(Map<String, String> aliasByPrefix) {
        this.aliasByPrefix = aliasByPrefix;
    }

    public void setSymbolTable(SymbolTable symtbl) {
        this.symtbl = symtbl;
    }

    public Expression compileOrderExpression(Node node) {
        if (this.isOperator(node, "order")) {
            if (node.getChildNodes().size() > 1) {
                return new OrderExpression(this.compileExpression(node.getFirstChild()), (String)node.getNextChild().getNodeValue());
            }
            if (node.getChildNodes().size() == 1) {
                return new OrderExpression(this.compileExpression(node.getFirstChild()));
            }
        }
        return this.compileExpression(node.getFirstChild());
    }

    public Expression compileFromExpression(Node node, boolean classIsExpression) {
        if (node.getNodeType() == NodeType.CLASS) {
            Node aliasNode = node.getFirstChild();
            ClassExpression clsExpr = new ClassExpression((String)aliasNode.getNodeValue());
            if (classIsExpression) {
                clsExpr.setCandidateExpression((String)node.getNodeValue());
            }
            JoinExpression currentJoinExpr = null;
            for (Node childNode : node.getChildNodes()) {
                if (childNode.getNodeType() != NodeType.OPERATOR) continue;
                String joinType = (String)childNode.getNodeValue();
                JoinExpression.JoinType joinTypeId = JoinExpression.JoinType.JOIN_INNER;
                if (joinType.equals("JOIN_INNER_FETCH")) {
                    joinTypeId = JoinExpression.JoinType.JOIN_INNER_FETCH;
                } else if (joinType.equals("JOIN_OUTER_FETCH")) {
                    joinTypeId = JoinExpression.JoinType.JOIN_LEFT_OUTER_FETCH;
                } else if (joinType.equals("JOIN_OUTER")) {
                    joinTypeId = JoinExpression.JoinType.JOIN_LEFT_OUTER;
                }
                Node joinedNode = childNode.getFirstChild();
                Node joinedAliasNode = childNode.getNextChild();
                PrimaryExpression primExpr = (PrimaryExpression)this.compilePrimaryExpression(joinedNode);
                JoinExpression joinExpr = new JoinExpression(primExpr, (String)joinedAliasNode.getNodeValue(), joinTypeId);
                if (currentJoinExpr != null) {
                    currentJoinExpr.setJoinExpression(joinExpr);
                } else {
                    clsExpr.setJoinExpression(joinExpr);
                }
                currentJoinExpr = joinExpr;
            }
            return clsExpr;
        }
        return null;
    }

    public Expression compileExpression(Node node) {
        return this.compileOrAndExpression(node);
    }

    private Expression compileOrAndExpression(Node node) {
        if (this.isOperator(node, "||")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_OR, right);
        }
        if (this.isOperator(node, "&&")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_AND, right);
        }
        if (this.isOperator(node, "|")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_OR, right);
        }
        if (this.isOperator(node, "^")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_OR, right);
        }
        if (this.isOperator(node, "&")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_AND, right);
        }
        return this.compileRelationalExpression(node);
    }

    private Expression compileRelationalExpression(Node node) {
        if (this.isOperator(node, "==")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_EQ, right);
        }
        if (this.isOperator(node, "!=")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_NOTEQ, right);
        }
        if (this.isOperator(node, "LIKE")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_LIKE, right);
        }
        if (this.isOperator(node, "<=")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_LTEQ, right);
        }
        if (this.isOperator(node, ">=")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_GTEQ, right);
        }
        if (this.isOperator(node, "<")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_LT, right);
        }
        if (this.isOperator(node, ">")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_GT, right);
        }
        if (this.isOperator(node, "instanceof")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_IS, right);
        }
        if (this.isOperator(node, "IN")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_IN, right);
        }
        return this.compileAdditiveMultiplicativeExpression(node);
    }

    private Expression compileAdditiveMultiplicativeExpression(Node node) {
        if (this.isOperator(node, "+")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_ADD, right);
        }
        if (this.isOperator(node, "-") && node.getChildNodes().size() > 1) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_SUB, right);
        }
        if (this.isOperator(node, "*")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_MUL, right);
        }
        if (this.isOperator(node, "/")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_DIV, right);
        }
        if (this.isOperator(node, "%")) {
            Expression left = this.compileExpression(node.getFirstChild());
            Expression right = this.compileExpression(node.getNextChild());
            return new DyadicExpression(left, Expression.OP_MOD, right);
        }
        return this.compileUnaryExpression(node);
    }

    private Expression compileUnaryExpression(Node node) {
        if (this.isOperator(node, "-") && node.getChildNodes().size() == 1) {
            Expression left = this.compileExpression(node.getFirstChild());
            if (left instanceof Literal) {
                ((Literal)left).negate();
                return left;
            }
            return new DyadicExpression(Expression.OP_NEG, left);
        }
        if (this.isOperator(node, "~")) {
            Expression left = this.compileExpression(node.getFirstChild());
            return new DyadicExpression(Expression.OP_COM, left);
        }
        if (this.isOperator(node, "!")) {
            Expression left = this.compileExpression(node.getFirstChild());
            if (left instanceof DyadicExpression && left.getOperator() == Expression.OP_IS) {
                DyadicExpression leftExpr = (DyadicExpression)left;
                return new DyadicExpression(leftExpr.getLeft(), Expression.OP_ISNOT, leftExpr.getRight());
            }
            return new DyadicExpression(Expression.OP_NOT, left);
        }
        if (this.isOperator(node, "DISTINCT")) {
            Expression left = this.compileExpression(node.getFirstChild());
            return new DyadicExpression(Expression.OP_DISTINCT, left);
        }
        return this.compilePrimaryExpression(node);
    }

    private Expression compilePrimaryExpression(Node node) {
        if (node.getNodeType() == NodeType.IDENTIFIER) {
            Symbol firstSym;
            String first;
            Node currentNode = node;
            ArrayList<Object> tupple = new ArrayList<Object>();
            Expression currentExpr = null;
            while (currentNode != null) {
                tupple.add(currentNode.getNodeValue());
                if (currentNode.getNodeType() == NodeType.INVOKE) {
                    if (currentExpr == null && tupple.size() > 1) {
                        first = (String)tupple.get(0);
                        firstSym = this.symtbl.getSymbol(first);
                        if (firstSym != null) {
                            if (firstSym.getType() == 1) {
                                currentExpr = new ParameterExpression(first, -1);
                                if (tupple.size() > 2) {
                                    currentExpr = new PrimaryExpression(currentExpr, tupple.subList(1, tupple.size() - 1));
                                }
                            } else if (firstSym.getType() == 2) {
                                currentExpr = new VariableExpression(first);
                                if (tupple.size() > 2) {
                                    currentExpr = new PrimaryExpression(currentExpr, tupple.subList(1, tupple.size() - 1));
                                }
                            }
                        }
                        if (currentExpr == null) {
                            currentExpr = new PrimaryExpression(tupple.subList(0, tupple.size() - 1));
                        }
                    }
                    String methodName = (String)tupple.get(tupple.size() - 1);
                    if (currentExpr instanceof PrimaryExpression) {
                        String id = currentExpr.getId();
                        if (this.aliasByPrefix != null && this.aliasByPrefix.containsKey(id)) {
                            String alias = this.aliasByPrefix.get(id);
                            methodName = alias + "." + methodName;
                            currentExpr = null;
                        }
                    }
                    List<Expression> parameterExprs = this.getExpressionsForPropertiesOfNode(currentNode);
                    currentExpr = new InvokeExpression(currentExpr, methodName, parameterExprs);
                    currentNode = currentNode.getFirstChild();
                    tupple = new ArrayList();
                    continue;
                }
                if (currentNode.getNodeType() == NodeType.CAST) {
                    if (currentExpr == null && tupple.size() > 1) {
                        Symbol sym;
                        PrimaryExpression primExpr = currentExpr = new PrimaryExpression(tupple.subList(0, tupple.size() - 1));
                        if (primExpr.tuples.size() == 1 && (sym = this.symtbl.getSymbol(primExpr.getId())) != null) {
                            if (sym.getType() == 1) {
                                currentExpr = new ParameterExpression(primExpr.getId(), -1);
                            } else if (sym.getType() == 2) {
                                currentExpr = new VariableExpression(primExpr.getId());
                            }
                        }
                    }
                    String className = (String)tupple.get(tupple.size() - 1);
                    currentExpr = new DyadicExpression(currentExpr, Expression.OP_CAST, new Literal(className));
                    currentNode = currentNode.getFirstChild();
                    tupple = new ArrayList();
                    continue;
                }
                currentNode = currentNode.getFirstChild();
            }
            if (currentExpr != null && tupple.size() > 0) {
                currentExpr = new PrimaryExpression(currentExpr, tupple);
            }
            if (currentExpr == null) {
                first = (String)tupple.get(0);
                firstSym = this.symtbl.getSymbol(first);
                if (firstSym != null) {
                    if (firstSym.getType() == 1) {
                        ParameterExpression paramExpr = new ParameterExpression(first, -1);
                        currentExpr = tupple.size() > 1 ? new PrimaryExpression(paramExpr, tupple.subList(1, tupple.size())) : paramExpr;
                    } else if (firstSym.getType() == 2) {
                        VariableExpression varExpr = new VariableExpression(first);
                        currentExpr = tupple.size() > 1 ? new PrimaryExpression(varExpr, tupple.subList(1, tupple.size())) : varExpr;
                    } else {
                        currentExpr = new PrimaryExpression(tupple);
                    }
                } else {
                    currentExpr = new PrimaryExpression(tupple);
                }
            }
            return currentExpr;
        }
        if (node.getNodeType() == NodeType.PARAMETER) {
            Object val = node.getNodeValue();
            Expression currentExpr = null;
            currentExpr = val instanceof Integer ? new ParameterExpression("" + node.getNodeValue(), ((ParameterNode)node).getPosition()) : new ParameterExpression((String)node.getNodeValue(), ((ParameterNode)node).getPosition());
            for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getFirstChild()) {
                if (childNode.getNodeType() == NodeType.INVOKE) {
                    String methodName = (String)childNode.getNodeValue();
                    List<Expression> parameterExprs = this.getExpressionsForPropertiesOfNode(childNode);
                    currentExpr = new InvokeExpression(currentExpr, methodName, parameterExprs);
                    continue;
                }
                if (childNode.getNodeType() == NodeType.IDENTIFIER) {
                    String identifier = childNode.getNodeId();
                    ArrayList<String> tuples = new ArrayList<String>();
                    tuples.add(identifier);
                    boolean moreIdentifierNodes = true;
                    while (moreIdentifierNodes) {
                        Node currentNode = childNode;
                        if ((childNode = childNode.getFirstChild()) == null || childNode.getNodeType() != NodeType.IDENTIFIER) {
                            moreIdentifierNodes = false;
                            childNode = currentNode;
                            continue;
                        }
                        tuples.add(childNode.getNodeId());
                    }
                    currentExpr = new PrimaryExpression(currentExpr, tuples);
                    continue;
                }
                throw new QueryCompilerSyntaxException("Dont support compilation of " + node);
            }
            return currentExpr;
        }
        if (node.getNodeType() == NodeType.INVOKE) {
            Node currentNode = node;
            ArrayList<Object> tupple = new ArrayList<Object>();
            InvokeExpression currentExpr = null;
            while (currentNode != null) {
                tupple.add(currentNode.getNodeValue());
                if (currentNode.getNodeType() == NodeType.INVOKE) {
                    String methodName = (String)tupple.get(tupple.size() - 1);
                    List<Expression> parameterExprs = this.getExpressionsForPropertiesOfNode(currentNode);
                    currentExpr = new InvokeExpression(currentExpr, methodName, parameterExprs);
                    if ((currentNode = currentNode.getFirstChild()) == null) continue;
                    tupple = new ArrayList();
                    tupple.add(currentExpr);
                    continue;
                }
                currentNode = currentNode.getFirstChild();
            }
            return currentExpr;
        }
        if (node.getNodeType() == NodeType.CREATOR) {
            Node currentNode;
            ArrayList<Object> tupple = new ArrayList<Object>();
            boolean method = false;
            for (currentNode = node.getFirstChild(); currentNode != null; currentNode = currentNode.getFirstChild()) {
                tupple.add(currentNode.getNodeValue());
                if (currentNode.getNodeType() != NodeType.INVOKE) continue;
                method = true;
                break;
            }
            List<Expression> parameterExprs = null;
            parameterExprs = method ? this.getExpressionsForPropertiesOfNode(currentNode) : new ArrayList<Expression>();
            return new CreatorExpression(tupple, parameterExprs);
        }
        if (node.getNodeType() == NodeType.LITERAL) {
            Node currentNode = node;
            ArrayList<Object> tupple = new ArrayList<Object>();
            Expression currentExpr = null;
            while (currentNode != null) {
                tupple.add(currentNode.getNodeValue());
                if (currentNode.getNodeType() == NodeType.INVOKE) {
                    if (currentExpr == null && tupple.size() > 1) {
                        currentExpr = new Literal(node.getNodeValue());
                    }
                    String methodName = (String)tupple.get(tupple.size() - 1);
                    List<Expression> parameterExprs = this.getExpressionsForPropertiesOfNode(currentNode);
                    currentExpr = new InvokeExpression(currentExpr, methodName, parameterExprs);
                    currentNode = currentNode.getFirstChild();
                    tupple = new ArrayList();
                    continue;
                }
                currentNode = currentNode.getFirstChild();
            }
            if (currentExpr == null) {
                currentExpr = new Literal(node.getNodeValue());
            }
            return currentExpr;
        }
        if (node.getNodeType() == NodeType.ARRAY) {
            Node currentNode = node;
            List arrayElements = (List)node.getNodeValue();
            boolean literal = true;
            Class<?> type = null;
            for (Node element : arrayElements) {
                if (type == null) {
                    type = element.getNodeValue().getClass();
                }
                if (element.getNodeType() != NodeType.IDENTIFIER) continue;
                literal = false;
                break;
            }
            Expression currentExpr = null;
            if (literal) {
                Object array = Array.newInstance(type, arrayElements.size());
                Iterator iter = arrayElements.iterator();
                int index = 0;
                while (iter.hasNext()) {
                    Node element = (Node)iter.next();
                    Array.set(array, index++, element.getNodeValue());
                }
                currentExpr = new Literal(array);
            } else {
                Expression[] arrayElementExprs = new Expression[arrayElements.size()];
                for (int i = 0; i < arrayElementExprs.length; ++i) {
                    arrayElementExprs[i] = this.compilePrimaryExpression((Node)arrayElements.get(i));
                }
                currentExpr = new ArrayExpression(arrayElementExprs);
            }
            currentNode = currentNode.getFirstChild();
            ArrayList<Object> tupple = new ArrayList<Object>();
            while (currentNode != null) {
                tupple.add(currentNode.getNodeValue());
                if (currentNode.getNodeType() == NodeType.INVOKE) {
                    if (currentExpr == null && tupple.size() > 1) {
                        currentExpr = new Literal(node.getNodeValue());
                    }
                    String methodName = (String)tupple.get(tupple.size() - 1);
                    List<Expression> parameterExprs = this.getExpressionsForPropertiesOfNode(currentNode);
                    currentExpr = new InvokeExpression(currentExpr, methodName, parameterExprs);
                    currentNode = currentNode.getFirstChild();
                    tupple = new ArrayList();
                    continue;
                }
                currentNode = currentNode.getFirstChild();
            }
            return currentExpr;
        }
        if (node.getNodeType() == NodeType.SUBQUERY) {
            List children = node.getChildNodes();
            if (children.size() != 1) {
                throw new QueryCompilerSyntaxException("Invalid number of children for SUBQUERY node : " + node);
            }
            Node varNode = (Node)children.get(0);
            VariableExpression subqueryExpr = new VariableExpression(varNode.getNodeId());
            SubqueryExpression currentExpr = new SubqueryExpression((String)node.getNodeValue(), subqueryExpr);
            return currentExpr;
        }
        if (node.getNodeType() == NodeType.CASE) {
            List children = node.getChildNodes();
            if (children.size() % 2 != 1) {
                throw new QueryCompilerSyntaxException("Invalid number of children for CASE node (should be odd) : " + node);
            }
            Node elseNode = (Node)children.get(children.size() - 1);
            CaseExpression caseExpr = new CaseExpression(this.compileExpression(elseNode));
            Iterator childIter = children.iterator();
            while (childIter.hasNext()) {
                Node whenNode = (Node)childIter.next();
                if (!childIter.hasNext()) continue;
                Node actionNode = (Node)childIter.next();
                Expression whenExpr = this.compileExpression(whenNode);
                Expression actionExpr = this.compileExpression(actionNode);
                caseExpr.addCondition(whenExpr, actionExpr);
            }
            return caseExpr;
        }
        NucleusLogger.QUERY.warn("ExpressionCompiler.compilePrimary " + node + " ignored by ExpressionCompiler");
        return null;
    }

    private List<Expression> getExpressionsForPropertiesOfNode(Node node) {
        if (node.hasProperties()) {
            ArrayList<Expression> parameterExprs = new ArrayList<Expression>();
            List<Node> propNodes = node.getProperties();
            for (int i = 0; i < propNodes.size(); ++i) {
                parameterExprs.add(this.compileExpression(propNodes.get(i)));
            }
            return parameterExprs;
        }
        return Collections.EMPTY_LIST;
    }

    private boolean isOperator(Node node, String operator) {
        return node.getNodeType() == NodeType.OPERATOR && node.getNodeValue().equals(operator);
    }
}

