/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.sco.queued;

import java.util.ArrayList;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.scostore.Store;
import org.datanucleus.store.types.sco.queued.QueuedOperation;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class OperationQueue {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    private ArrayList<QueuedOperation> queuedOperations = new ArrayList();

    public void enqueue(QueuedOperation op) {
        this.queuedOperations.add(op);
    }

    public void performAll(Store store, ObjectProvider sm, String fieldName) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023005", (Object)sm.toPrintableID(), (Object)fieldName));
        }
        ArrayList<QueuedOperation> flushOperations = this.queuedOperations;
        this.queuedOperations = new ArrayList();
        for (QueuedOperation op : flushOperations) {
            op.perform(store, sm);
        }
        if (!this.queuedOperations.isEmpty()) {
            this.queuedOperations.clear();
        }
    }
}

