/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.sco;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues2;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.scostore.CollectionStore;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.store.scostore.SetStore;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.sco.SCO;
import org.datanucleus.store.types.sco.SCOContainer;
import org.datanucleus.store.types.sco.SCOList;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class SCOUtils {
    private static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());

    public static SCO newSCOInstance(ObjectProvider ownerSM, AbstractMemberMetaData fmd, Class declaredType, Class instantiatedType, Object value, boolean forInsert, boolean forUpdate, boolean replaceField) {
        if (!fmd.getType().isAssignableFrom(declaredType)) {
            throw new NucleusUserException(LOCALISER.msg("023010", (Object)declaredType.getName(), (Object)fmd.getName(), (Object)fmd.getType()));
        }
        String typeName = declaredType.getName();
        if (instantiatedType != null) {
            typeName = instantiatedType.getName();
        }
        if (value != null) {
            typeName = value.getClass().getName();
        }
        TypeManager typeMgr = ownerSM.getExecutionContext().getOMFContext().getTypeManager();
        boolean fullWrapper = ownerSM.getExecutionContext().getStoreManager().getSupportedOptions().contains("BackedSCO");
        Class wrapperType = null;
        wrapperType = fullWrapper ? typeMgr.getWrappedTypeBackedForType(typeName) : typeMgr.getWrapperTypeForType(typeName);
        if (wrapperType == null) {
            if (value != null && typeMgr.isSecondClassWrapper(typeName)) {
                SCO sco = (SCO)value;
                if (replaceField) {
                    ownerSM.replaceField(fmd.getAbsoluteFieldNumber(), sco);
                }
                return sco;
            }
            if (instantiatedType != null) {
                wrapperType = fullWrapper ? typeMgr.getWrappedTypeBackedForType(instantiatedType.getName()) : typeMgr.getWrapperTypeForType(instantiatedType.getName());
            }
            if (wrapperType == null) {
                wrapperType = fullWrapper ? typeMgr.getWrappedTypeBackedForType(declaredType.getName()) : typeMgr.getWrapperTypeForType(declaredType.getName());
            }
        }
        if (wrapperType == null) {
            throw new NucleusUserException(LOCALISER.msg("023011", (Object)declaredType.getName(), (Object)StringUtils.toJVMIDString(value), (Object)fmd.getFullFieldName()));
        }
        SCO sco = (SCO)ClassUtils.newInstance(wrapperType, new Class[]{ObjectProvider.class, String.class}, new Object[]{ownerSM, fmd.getName()});
        if (replaceField) {
            ownerSM.replaceField(fmd.getAbsoluteFieldNumber(), sco);
        }
        if (value != null) {
            sco.initialise(value, forInsert, forUpdate);
        } else {
            sco.initialise();
        }
        return sco;
    }

    public static String getContainerInfoMessage(ObjectProvider ownerSM, String fieldName, SCOContainer cont, boolean useCache, boolean queued, boolean allowNulls, boolean lazyLoading) {
        String msg = LOCALISER.msg("023004", (Object)ownerSM.toPrintableID(), (Object)fieldName, (Object)cont.getClass().getName(), (Object)("[cache-values=" + useCache + ", lazy-loading=" + SCOUtils.useCachedLazyLoading(ownerSM, fieldName) + ", queued-operations=" + queued + ", allow-nulls=" + allowNulls + "]"));
        return msg;
    }

    public static String getSCOWrapperOptionsMessage(boolean useCache, boolean queued, boolean allowNulls, boolean lazyLoading) {
        StringBuffer str = new StringBuffer();
        if (useCache) {
            str.append("cached");
        }
        if (lazyLoading) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append("lazy-loaded");
        }
        if (queued) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append("queued");
        }
        if (allowNulls) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append("allowNulls");
        }
        return str.toString();
    }

    public static boolean allowNullsInContainer(boolean defaultValue, AbstractMemberMetaData fmd) {
        boolean allow = defaultValue;
        if (fmd.hasExtension("allow-nulls")) {
            String extValue = fmd.getValueForExtension("allow-nulls");
            if (extValue.equalsIgnoreCase("true")) {
                allow = true;
            } else if (extValue.equalsIgnoreCase("false")) {
                allow = false;
            }
        }
        return allow;
    }

    public static boolean useContainerQueueing(ObjectProvider ownerSM) {
        if (ownerSM.getExecutionContext().getTransaction().getOptimistic()) {
            return true;
        }
        return ownerSM.getExecutionContext().getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.datastoreTransactionDelayOperations");
    }

    public static boolean useContainerCache(ObjectProvider ownerSM, String fieldName) {
        if (ownerSM == null) {
            return false;
        }
        boolean useCache = ownerSM.getExecutionContext().getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.cache.collections");
        AbstractMemberMetaData fmd = ownerSM.getExecutionContext().getMetaDataManager().getMetaDataForMember(ownerSM.getObject().getClass(), ownerSM.getExecutionContext().getClassLoaderResolver(), fieldName);
        if (fmd.getOrderMetaData() != null && !fmd.getOrderMetaData().isIndexedList()) {
            useCache = true;
        } else if (fmd.getContainer() != null && fmd.getContainer().hasExtension("cache")) {
            useCache = Boolean.parseBoolean(fmd.getContainer().getValueForExtension("cache"));
        }
        return useCache;
    }

    public static boolean useCachedLazyLoading(ObjectProvider ownerSM, String fieldName) {
        if (ownerSM == null) {
            return false;
        }
        boolean lazy = false;
        AbstractClassMetaData cmd = ownerSM.getClassMetaData();
        AbstractMemberMetaData fmd = cmd.getMetaDataForMember(fieldName);
        Boolean lazyCollections = ownerSM.getExecutionContext().getOMFContext().getPersistenceConfiguration().getBooleanObjectProperty("datanucleus.cache.collections.lazy");
        if (lazyCollections != null) {
            lazy = lazyCollections;
        } else if (fmd.getContainer() != null && fmd.getContainer().hasExtension("cache-lazy-loading")) {
            lazy = Boolean.parseBoolean(fmd.getContainer().getValueForExtension("cache-lazy-loading"));
        } else {
            boolean inFP = false;
            int[] fpFields = ownerSM.getExecutionContext().getFetchPlan().getFetchPlanForClass(cmd).getMemberNumbers();
            int fieldNo = fmd.getAbsoluteFieldNumber();
            if (fpFields != null && fpFields.length > 0) {
                for (int i = 0; i < fpFields.length; ++i) {
                    if (fpFields[i] != fieldNo) continue;
                    inFP = true;
                    break;
                }
            }
            lazy = !inFP;
        }
        return lazy;
    }

    public static boolean collectionHasElementsWithoutIdentity(AbstractMemberMetaData fmd) {
        boolean elementsWithoutIdentity = false;
        if (fmd.isSerialized()) {
            elementsWithoutIdentity = true;
        } else if (fmd.getElementMetaData() != null && fmd.getElementMetaData().getEmbeddedMetaData() != null && fmd.getJoinMetaData() != null) {
            elementsWithoutIdentity = true;
        } else if (fmd.getCollection() != null && fmd.getCollection().isEmbeddedElement()) {
            elementsWithoutIdentity = true;
        }
        return elementsWithoutIdentity;
    }

    public static boolean mapHasKeysWithoutIdentity(AbstractMemberMetaData fmd) {
        boolean keysWithoutIdentity = false;
        if (fmd.isSerialized()) {
            keysWithoutIdentity = true;
        } else if (fmd.getKeyMetaData() != null && fmd.getKeyMetaData().getEmbeddedMetaData() != null && fmd.getJoinMetaData() != null) {
            keysWithoutIdentity = true;
        } else if (fmd.getMap() != null && fmd.getMap().isEmbeddedKey()) {
            keysWithoutIdentity = true;
        }
        return keysWithoutIdentity;
    }

    public static boolean mapHasValuesWithoutIdentity(AbstractMemberMetaData fmd) {
        boolean valuesWithoutIdentity = false;
        if (fmd.isSerialized()) {
            valuesWithoutIdentity = true;
        } else if (fmd.getValueMetaData() != null && fmd.getValueMetaData().getEmbeddedMetaData() != null && fmd.getJoinMetaData() != null) {
            valuesWithoutIdentity = true;
        } else if (fmd.getMap() != null && fmd.getMap().isEmbeddedValue()) {
            valuesWithoutIdentity = true;
        }
        return valuesWithoutIdentity;
    }

    public static boolean collectionHasSerialisedElements(AbstractMemberMetaData fmd) {
        boolean serialised = fmd.isSerialized();
        if (fmd.getCollection() != null && fmd.getCollection().isEmbeddedElement() && fmd.getJoinMetaData() == null) {
            serialised = true;
        }
        return serialised;
    }

    public static boolean arrayIsStoredInSingleColumn(AbstractMemberMetaData fmd, MetaDataManager mmgr) {
        boolean singleColumn = fmd.isSerialized();
        if (!singleColumn && fmd.getArray() != null && fmd.getJoinMetaData() == null) {
            if (fmd.getArray().isEmbeddedElement()) {
                singleColumn = true;
            }
            Class<?> elementClass = fmd.getType().getComponentType();
            ApiAdapter api = mmgr.getApiAdapter();
            if (!elementClass.isInterface() && !api.isPersistable(elementClass)) {
                singleColumn = true;
            }
        }
        return singleColumn;
    }

    public static boolean mapHasSerialisedKeysAndValues(AbstractMemberMetaData fmd) {
        boolean inverseKeyField = false;
        if (fmd.getKeyMetaData() != null && fmd.getKeyMetaData().getMappedBy() != null) {
            inverseKeyField = true;
        }
        boolean inverseValueField = false;
        if (fmd.getValueMetaData() != null && fmd.getValueMetaData().getMappedBy() != null) {
            inverseValueField = true;
        }
        boolean serialised = fmd.isSerialized();
        if (fmd.getMap() != null && fmd.getJoinMetaData() == null && fmd.getMap().isEmbeddedKey() && fmd.getMap().isEmbeddedValue() && !inverseKeyField && !inverseValueField) {
            serialised = true;
        }
        return serialised;
    }

    public static void updateCollectionWithCollection(ApiAdapter api, Collection coll, Collection newColl) {
        if (coll == null) {
            return;
        }
        if (newColl == null) {
            coll.clear();
            return;
        }
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (api.isPersistable(element)) {
                Object id = api.getIdForObject(element);
                if (id != null) {
                    boolean present = false;
                    for (Object newElement : newColl) {
                        Object newId = api.getIdForObject(newElement);
                        if (!id.equals(newId)) continue;
                        present = true;
                        break;
                    }
                    if (present) continue;
                    iter.remove();
                    continue;
                }
                if (newColl.contains(element)) continue;
                iter.remove();
                continue;
            }
            if (newColl.contains(element)) continue;
            iter.remove();
        }
        for (Object newElement : newColl) {
            if (api.isPersistable(newElement)) {
                Object newId = api.getIdForObject(newElement);
                if (newId != null) {
                    boolean present = false;
                    for (Object element : coll) {
                        Object id = api.getIdForObject(element);
                        if (!newId.equals(id)) continue;
                        present = true;
                        break;
                    }
                    if (present) continue;
                    coll.add(newElement);
                    continue;
                }
                if (coll.contains(newElement)) continue;
                coll.add(newElement);
                continue;
            }
            if (coll.contains(newElement)) continue;
            coll.add(newElement);
        }
    }

    public static boolean attachRemoveDeletedElements(ApiAdapter api, Collection coll, Collection elements, boolean elementsWithoutId) {
        boolean updated = false;
        Iterator attachedIter = coll.iterator();
        while (attachedIter.hasNext()) {
            Object currentElem = attachedIter.next();
            Object currentElemId = api.getIdForObject(currentElem);
            Iterator desiredIter = elements.iterator();
            boolean contained = false;
            if (elementsWithoutId) {
                contained = elements.contains(currentElem);
            } else {
                while (desiredIter.hasNext()) {
                    Object desiredElem = desiredIter.next();
                    if (!currentElemId.equals(api.getIdForObject(desiredElem))) continue;
                    contained = true;
                    break;
                }
            }
            if (contained) continue;
            attachedIter.remove();
            updated = true;
        }
        return updated;
    }

    public static boolean attachAddNewElements(ApiAdapter api, Collection coll, Collection elements, boolean elementsWithoutId) {
        boolean updated = false;
        for (Object element : elements) {
            Object elemId = api.getIdForObject(element);
            boolean contained = false;
            if (elementsWithoutId) {
                contained = coll.contains(element);
            } else {
                for (Object currentElem : coll) {
                    if (!api.getIdForObject(currentElem).equals(elemId)) continue;
                    contained = true;
                    break;
                }
            }
            if (contained) continue;
            coll.add(element);
            updated = true;
        }
        return updated;
    }

    public static boolean updateCollectionWithCollectionElements(Collection coll, Collection elements) {
        boolean updated = false;
        Iterator attachedIter = coll.iterator();
        while (attachedIter.hasNext()) {
            Object attachedElement = attachedIter.next();
            if (elements.contains(attachedElement)) continue;
            attachedIter.remove();
            updated = true;
        }
        for (Object element : elements) {
            if (coll.contains(element)) continue;
            coll.add(element);
            updated = true;
        }
        return updated;
    }

    public static boolean updateListWithListElements(List list, List elements) {
        boolean updated = false;
        ArrayList newCopy = new ArrayList(elements);
        Iterator attachedIter = list.iterator();
        while (attachedIter.hasNext()) {
            Object attachedElement = attachedIter.next();
            if (newCopy.remove(attachedElement)) continue;
            attachedIter.remove();
            updated = true;
        }
        ArrayList oldCopy = new ArrayList(list);
        for (Object element : elements) {
            if (oldCopy.remove(element)) continue;
            list.add(element);
            updated = true;
        }
        Iterator elementsIter = elements.iterator();
        int position = 0;
        while (elementsIter.hasNext()) {
            Object element = elementsIter.next();
            Object currentElement = list.get(position);
            boolean updatePosition = false;
            if (element == null && currentElement != null || element != null && currentElement == null) {
                updatePosition = true;
            } else if (element != null && currentElement != null && !currentElement.equals(element)) {
                updatePosition = true;
            }
            if (updatePosition) {
                ((SCOList)((Object)list)).set(position, element, false);
                updated = true;
            }
            ++position;
        }
        return updated;
    }

    public static boolean updateMapWithMapKeysValues(ApiAdapter api, Map map, Map keysValues) {
        boolean updated = false;
        HashMap copy = new HashMap(map);
        for (Map.Entry entry : copy.entrySet()) {
            Object key = entry.getKey();
            if (keysValues.containsKey(key)) continue;
            map.remove(key);
            updated = true;
        }
        for (Map.Entry entry : keysValues.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!map.containsKey(key)) {
                map.put(key, keysValues.get(key));
                updated = true;
                continue;
            }
            Object oldValue = map.get(key);
            if (api.isPersistable(value) && api.getIdForObject(value) != api.getIdForObject(oldValue)) {
                map.put(key, value);
                continue;
            }
            if ((oldValue != null || value == null) && (oldValue == null || oldValue.equals(value))) continue;
            map.put(key, value);
        }
        return updated;
    }

    public static void populateMapDelegateWithStoreData(Map delegate, MapStore store, ObjectProvider ownerSM) {
        HashSet keys = new HashSet();
        if (!store.keysAreEmbedded() && !store.keysAreSerialised()) {
            SetStore keystore = store.keySetStore();
            Iterator keyIter = keystore.iterator(ownerSM);
            while (keyIter.hasNext()) {
                keys.add(keyIter.next());
            }
        }
        HashSet values = new HashSet();
        if (!store.valuesAreEmbedded() && !store.valuesAreSerialised()) {
            SetStore valuestore = store.valueSetStore();
            Iterator valueIter = valuestore.iterator(ownerSM);
            while (valueIter.hasNext()) {
                values.add(valueIter.next());
            }
        }
        SetStore entries = store.entrySetStore();
        Iterator entryIter = entries.iterator(ownerSM);
        while (entryIter.hasNext()) {
            Map.Entry entry = (Map.Entry)entryIter.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            delegate.put(key, value);
        }
        if (!store.keysAreEmbedded() && !store.keysAreSerialised() && delegate.size() != keys.size()) {
            NucleusLogger.DATASTORE_RETRIEVE.warn("The number of Map key objects (" + keys.size() + ")" + " was different to the number of entries (" + delegate.size() + ")." + " Likely there is a bug in your datastore");
        }
        if (!store.valuesAreEmbedded() && !store.valuesAreSerialised() && delegate.size() != values.size()) {
            NucleusLogger.DATASTORE_RETRIEVE.warn("The number of Map value objects (" + values.size() + ")" + " was different to the number of entries (" + delegate.size() + ")." + " Likely there is a bug in your datastore");
        }
        keys.clear();
        values.clear();
    }

    public static Object[] toArray(CollectionStore backingStore, ObjectProvider sm) {
        Object[] result = new Object[backingStore.size(sm)];
        Iterator it = backingStore.iterator(sm);
        int i = 0;
        while (it.hasNext()) {
            result[i] = it.next();
            ++i;
        }
        return result;
    }

    public static Object[] toArray(CollectionStore backingStore, ObjectProvider sm, Object[] a) {
        int size = backingStore.size(sm);
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator it = backingStore.iterator(sm);
        for (int i = 0; i < size; ++i) {
            a[i] = it.next();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public static Comparator getComparator(AbstractMemberMetaData fmd, ClassLoaderResolver clr) {
        Comparator comparator = null;
        String comparatorName = null;
        if (fmd.hasMap() && fmd.getMap().hasExtension("comparator-name")) {
            comparatorName = fmd.getMap().getValueForExtension("comparator-name");
        } else if (fmd.hasCollection() && fmd.getCollection().hasExtension("comparator-name")) {
            comparatorName = fmd.getCollection().getValueForExtension("comparator-name");
        }
        if (comparatorName != null) {
            Class comparatorCls = null;
            try {
                comparatorCls = clr.classForName(comparatorName);
                comparator = (Comparator)ClassUtils.newInstance(comparatorCls, null, null);
            }
            catch (NucleusException jpe) {
                NucleusLogger.PERSISTENCE.warn(LOCALISER.msg("023012", (Object)fmd.getFullFieldName(), (Object)comparatorName));
            }
        }
        return comparator;
    }

    public static void refreshFetchPlanFieldsForCollection(ObjectProvider ownerSM, Object[] elements) {
        ApiAdapter api = ownerSM.getExecutionContext().getApiAdapter();
        for (int i = 0; i < elements.length; ++i) {
            if (!api.isPersistable(elements[i])) continue;
            ownerSM.getExecutionContext().refreshObject(elements[i]);
        }
    }

    public static void refreshFetchPlanFieldsForMap(ObjectProvider ownerSM, Set entries) {
        ApiAdapter api = ownerSM.getExecutionContext().getApiAdapter();
        for (Map.Entry entry : entries) {
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (api.isPersistable(key)) {
                ownerSM.getExecutionContext().refreshObject(key);
            }
            if (!api.isPersistable(val)) continue;
            ownerSM.getExecutionContext().refreshObject(val);
        }
    }

    public static void detachForCollection(ObjectProvider ownerSM, Object[] elements, FetchPlanState state) {
        ApiAdapter api = ownerSM.getExecutionContext().getApiAdapter();
        for (int i = 0; i < elements.length; ++i) {
            if (!api.isPersistable(elements[i])) continue;
            ownerSM.getExecutionContext().detachObject(elements[i], state);
        }
    }

    public static void detachCopyForCollection(ObjectProvider ownerSM, Object[] elements, FetchPlanState state, Collection detached) {
        ApiAdapter api = ownerSM.getExecutionContext().getApiAdapter();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] == null) {
                detached.add(null);
                continue;
            }
            Object object = elements[i];
            if (api.isPersistable(object)) {
                detached.add(ownerSM.getExecutionContext().detachObjectCopy(object, state));
                continue;
            }
            detached.add(object);
        }
    }

    public static void attachForCollection(ObjectProvider ownerSM, Object[] elements, boolean elementsWithoutIdentity) {
        ExecutionContext ec = ownerSM.getExecutionContext();
        ApiAdapter api = ec.getApiAdapter();
        for (int i = 0; i < elements.length; ++i) {
            Object attached;
            if (!api.isPersistable(elements[i]) || (attached = ec.getAttachedObjectForId(api.getIdForObject(elements[i]))) != null) continue;
            ec.attachObject(elements[i], elementsWithoutIdentity);
        }
    }

    public static void attachCopyForCollection(ObjectProvider ownerSM, Object[] detachedElements, Collection attached, boolean elementsWithoutIdentity) {
        ApiAdapter api = ownerSM.getExecutionContext().getApiAdapter();
        for (int i = 0; i < detachedElements.length; ++i) {
            if (api.isPersistable(detachedElements[i]) && api.isDetachable(detachedElements[i])) {
                attached.add(ownerSM.getExecutionContext().attachObjectCopy(detachedElements[i], elementsWithoutIdentity));
                continue;
            }
            attached.add(detachedElements[i]);
        }
    }

    public static void detachForMap(ObjectProvider ownerSM, Set entries, FetchPlanState state) {
        ApiAdapter api = ownerSM.getExecutionContext().getApiAdapter();
        for (Map.Entry entry : entries) {
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (api.isPersistable(key)) {
                ownerSM.getExecutionContext().detachObject(key, state);
            }
            if (!api.isPersistable(val)) continue;
            ownerSM.getExecutionContext().detachObject(val, state);
        }
    }

    public static void detachCopyForMap(ObjectProvider ownerSM, Set entries, FetchPlanState state, Map detached) {
        ApiAdapter api = ownerSM.getExecutionContext().getApiAdapter();
        for (Map.Entry entry : entries) {
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (api.isPersistable(val)) {
                val = ownerSM.getExecutionContext().detachObjectCopy(val, state);
            }
            if (api.isPersistable(key)) {
                key = ownerSM.getExecutionContext().detachObjectCopy(key, state);
            }
            detached.put(key, val);
        }
    }

    public static void attachForMap(ObjectProvider ownerSM, Set entries, boolean keysWithoutIdentity, boolean valuesWithoutIdentity) {
        ExecutionContext ec = ownerSM.getExecutionContext();
        ApiAdapter api = ec.getApiAdapter();
        for (Map.Entry entry : entries) {
            Object attached;
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (api.isPersistable(key) && (attached = ec.getAttachedObjectForId(api.getIdForObject(key))) == null) {
                ownerSM.getExecutionContext().attachObject(key, keysWithoutIdentity);
            }
            if (!api.isPersistable(val) || (attached = ec.getAttachedObjectForId(api.getIdForObject(val))) != null) continue;
            ownerSM.getExecutionContext().attachObject(val, valuesWithoutIdentity);
        }
    }

    public static void attachCopyForMap(ObjectProvider ownerSM, Set detachedEntries, Map attached, boolean keysWithoutIdentity, boolean valuesWithoutIdentity) {
        Iterator iter = detachedEntries.iterator();
        ApiAdapter api = ownerSM.getExecutionContext().getApiAdapter();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Object val = entry.getValue();
            Object key = entry.getKey();
            if (api.isPersistable(val) && api.isDetachable(val)) {
                val = ownerSM.getExecutionContext().attachObjectCopy(val, valuesWithoutIdentity);
            }
            if (api.isPersistable(key) && api.isDetachable(key)) {
                key = ownerSM.getExecutionContext().attachObjectCopy(key, keysWithoutIdentity);
            }
            attached.put(key, val);
        }
    }

    public static boolean validateObjectForWriting(ExecutionContext ec, Object object, FieldValues2 fieldValues) {
        boolean persisted = false;
        ApiAdapter api = ec.getApiAdapter();
        if (api.isPersistable(object)) {
            ExecutionContext objectEC = api.getExecutionContext(object);
            if (objectEC != null && ec != objectEC) {
                throw new NucleusUserException(LOCALISER.msg("023009", (Object)StringUtils.toJVMIDString(object)), api.getIdForObject(object));
            }
            if (!api.isPersistent(object)) {
                boolean exists = false;
                if (api.isDetached(object)) {
                    if (ec.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.attachSameDatastore")) {
                        exists = true;
                    } else {
                        try {
                            ObjectProvider objSM;
                            Object obj = ec.findObject(api.getIdForObject(object), true, false, object.getClass().getName());
                            if (obj != null && (objSM = ec.findObjectProvider(obj)) != null) {
                                ec.evictFromTransaction(objSM);
                            }
                            exists = true;
                        }
                        catch (NucleusObjectNotFoundException onfe) {
                            exists = false;
                        }
                    }
                }
                if (!exists) {
                    ec.persistObjectInternal(object, fieldValues, 0);
                    persisted = true;
                }
            } else {
                ObjectProvider objectSM = ec.findObjectProvider(object);
                if (objectSM.isWaitingToBeFlushedToDatastore()) {
                    if (fieldValues != null) {
                        objectSM.loadFieldValues(fieldValues);
                    }
                    objectSM.flush();
                }
            }
        }
        return persisted;
    }

    public static void validateObjectsForWriting(ExecutionContext ec, Object objects) {
        block3: {
            block4: {
                if (objects == null) break block3;
                if (!objects.getClass().isArray()) break block4;
                if (objects.getClass().getComponentType().isPrimitive()) break block3;
                Object[] obj = (Object[])objects;
                for (int i = 0; i < obj.length; ++i) {
                    SCOUtils.validateObjectForWriting(ec, obj[i], null);
                }
                break block3;
            }
            if (objects instanceof Collection) {
                Collection col = (Collection)objects;
                Iterator it = col.iterator();
                while (it.hasNext()) {
                    SCOUtils.validateObjectForWriting(ec, it.next(), null);
                }
            }
        }
    }

    public static boolean isListBased(Class type) {
        if (type == null) {
            return false;
        }
        if (List.class.isAssignableFrom(type)) {
            return true;
        }
        return Queue.class.isAssignableFrom(type);
    }

    public static Class getContainerInstanceType(Class declaredType, Boolean ordered) {
        if (declaredType.isInterface()) {
            if (List.class.isAssignableFrom(declaredType)) {
                return ArrayList.class;
            }
            if (Set.class.isAssignableFrom(declaredType)) {
                return HashSet.class;
            }
            if (Map.class.isAssignableFrom(declaredType)) {
                return HashMap.class;
            }
            if (ordered.booleanValue()) {
                return ArrayList.class;
            }
            return HashSet.class;
        }
        return declaredType;
    }

    public static boolean detachAsWrapped(ObjectProvider ownerSM) {
        return ownerSM.getExecutionContext().getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.detachAsWrapped");
    }

    public static boolean useQueuedUpdate(boolean queued, ObjectProvider sm) {
        return queued && !sm.getExecutionContext().isFlushing() && sm.getExecutionContext().getTransaction().isActive();
    }
}

