/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jdo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jdo.JDOUserCallbackException;
import javax.jdo.listener.AttachCallback;
import javax.jdo.listener.AttachLifecycleListener;
import javax.jdo.listener.ClearCallback;
import javax.jdo.listener.ClearLifecycleListener;
import javax.jdo.listener.CreateLifecycleListener;
import javax.jdo.listener.DeleteCallback;
import javax.jdo.listener.DeleteLifecycleListener;
import javax.jdo.listener.DetachCallback;
import javax.jdo.listener.DetachLifecycleListener;
import javax.jdo.listener.DirtyLifecycleListener;
import javax.jdo.listener.InstanceLifecycleEvent;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.listener.LoadCallback;
import javax.jdo.listener.LoadLifecycleListener;
import javax.jdo.listener.StoreCallback;
import javax.jdo.listener.StoreLifecycleListener;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.jdo.FieldInstanceLifecycleEvent;
import org.datanucleus.jdo.LifecycleListenerForClass;
import org.datanucleus.state.CallbackHandler;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.util.Localiser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDOCallbackHandler
implements CallbackHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    OMFContext omfCtx;
    List<LifecycleListenerForClass> listeners = new ArrayList<LifecycleListenerForClass>(1);
    private List<LifecycleListenerForClass> listenersWorkingCopy = null;

    public JDOCallbackHandler(OMFContext omfCtx) {
        this.omfCtx = omfCtx;
    }

    @Override
    public void postCreate(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof CreateLifecycleListener)) continue;
            ((CreateLifecycleListener)listener.getListener()).postCreate(new InstanceLifecycleEvent(pc, 0, null));
        }
    }

    @Override
    public void prePersist(Object pc) {
    }

    @Override
    public void preStore(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof StoreLifecycleListener)) continue;
            ExecutionContext ec = this.omfCtx.getApiAdapter().getExecutionContext(pc);
            String[] fieldNames = null;
            ObjectProvider op = ec.findObjectProvider(pc);
            fieldNames = op.getDirtyFieldNames();
            if (fieldNames == null) {
                fieldNames = op.getLoadedFieldNames();
            }
            ((StoreLifecycleListener)listener.getListener()).preStore((InstanceLifecycleEvent)new FieldInstanceLifecycleEvent(pc, 2, null, fieldNames));
        }
        if (pc instanceof StoreCallback) {
            try {
                ((StoreCallback)pc).jdoPreStore();
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(LOCALISER.msg("025001", (Object)"jdoPreStore"), (Throwable)e);
            }
        }
    }

    @Override
    public void postStore(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof StoreLifecycleListener)) continue;
            ((StoreLifecycleListener)listener.getListener()).postStore(new InstanceLifecycleEvent(pc, 2, null));
        }
    }

    @Override
    public void preClear(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof ClearLifecycleListener)) continue;
            ((ClearLifecycleListener)listener.getListener()).preClear(new InstanceLifecycleEvent(pc, 3, null));
        }
        if (pc instanceof ClearCallback) {
            try {
                ((ClearCallback)pc).jdoPreClear();
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(LOCALISER.msg("025001", (Object)"jdoPreClear"), (Throwable)e);
            }
        }
    }

    @Override
    public void postClear(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof ClearLifecycleListener)) continue;
            ((ClearLifecycleListener)listener.getListener()).postClear(new InstanceLifecycleEvent(pc, 3, null));
        }
    }

    @Override
    public void preDelete(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof DeleteLifecycleListener)) continue;
            ((DeleteLifecycleListener)listener.getListener()).preDelete(new InstanceLifecycleEvent(pc, 4, null));
        }
        if (pc instanceof DeleteCallback) {
            try {
                ((DeleteCallback)pc).jdoPreDelete();
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(LOCALISER.msg("025001", (Object)"jdoPreDelete"), (Throwable)e);
            }
        }
    }

    @Override
    public void postDelete(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof DeleteLifecycleListener)) continue;
            ((DeleteLifecycleListener)listener.getListener()).postDelete(new InstanceLifecycleEvent(pc, 4, null));
        }
    }

    @Override
    public void preDirty(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof DirtyLifecycleListener)) continue;
            ((DirtyLifecycleListener)listener.getListener()).preDirty(new InstanceLifecycleEvent(pc, 5, null));
        }
    }

    @Override
    public void postDirty(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof DirtyLifecycleListener)) continue;
            ((DirtyLifecycleListener)listener.getListener()).postDirty(new InstanceLifecycleEvent(pc, 5, null));
        }
    }

    @Override
    public void postLoad(Object pc) {
        if (pc instanceof LoadCallback) {
            try {
                ((LoadCallback)pc).jdoPostLoad();
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(LOCALISER.msg("025001", (Object)"jdoPostLoad"), (Throwable)e);
            }
        }
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof LoadLifecycleListener)) continue;
            ((LoadLifecycleListener)listener.getListener()).postLoad(new InstanceLifecycleEvent(pc, 1, null));
        }
    }

    @Override
    public void postRefresh(Object pc) {
    }

    @Override
    public void preDetach(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof DetachLifecycleListener)) continue;
            ((DetachLifecycleListener)listener.getListener()).preDetach(new InstanceLifecycleEvent(pc, 6, null));
        }
        if (pc instanceof DetachCallback) {
            try {
                ((DetachCallback)pc).jdoPreDetach();
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(LOCALISER.msg("025001", (Object)"jdoPreDetach"), (Throwable)e);
            }
        }
    }

    @Override
    public void postDetach(Object pc, Object detachedPC) {
        if (pc instanceof DetachCallback) {
            try {
                ((DetachCallback)detachedPC).jdoPostDetach(pc);
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(LOCALISER.msg("025001", (Object)"jdoPostDetach"), (Throwable)e);
            }
        }
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof DetachLifecycleListener)) continue;
            ((DetachLifecycleListener)listener.getListener()).postDetach(new InstanceLifecycleEvent(detachedPC, 6, pc));
        }
    }

    @Override
    public void preAttach(Object pc) {
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof AttachLifecycleListener)) continue;
            ((AttachLifecycleListener)listener.getListener()).preAttach(new InstanceLifecycleEvent(pc, 7, null));
        }
        if (pc instanceof AttachCallback) {
            try {
                ((AttachCallback)pc).jdoPreAttach();
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(LOCALISER.msg("025001", (Object)"jdoPreAttach"), (Throwable)e);
            }
        }
    }

    @Override
    public void postAttach(Object pc, Object detachedPC) {
        if (pc instanceof AttachCallback) {
            try {
                ((AttachCallback)pc).jdoPostAttach(detachedPC);
            }
            catch (Exception e) {
                throw new JDOUserCallbackException(LOCALISER.msg("025001", (Object)"jdoPostAttach"), (Throwable)e);
            }
        }
        for (LifecycleListenerForClass listener : this.getListenersWorkingCopy()) {
            if (!listener.forClass(pc.getClass()) || !(listener.getListener() instanceof AttachLifecycleListener)) continue;
            ((AttachLifecycleListener)listener.getListener()).postAttach(new InstanceLifecycleEvent(pc, 7, detachedPC));
        }
    }

    @Override
    public void addListener(Object listener, Class[] classes) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<LifecycleListenerForClass>(1);
        }
        this.listeners.add(new LifecycleListenerForClass((InstanceLifecycleListener)listener, classes));
        this.listenersWorkingCopy = null;
    }

    @Override
    public void removeListener(Object listener) {
        if (listener != null && this.listeners != null) {
            Iterator<LifecycleListenerForClass> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                LifecycleListenerForClass classListener = iter.next();
                if (classListener.getListener() != listener) continue;
                iter.remove();
            }
        }
        this.listenersWorkingCopy = null;
    }

    @Override
    public void close() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
        this.listenersWorkingCopy = null;
    }

    protected List<LifecycleListenerForClass> getListenersWorkingCopy() {
        if (this.listenersWorkingCopy == null) {
            this.listenersWorkingCopy = new ArrayList<LifecycleListenerForClass>(this.listeners);
        }
        return this.listenersWorkingCopy;
    }
}

