/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.AbstractExtent;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryResult;

public class DefaultCandidateExtent
extends AbstractExtent {
    private FetchPlan fetchPlan = null;
    private Query query;
    protected HashMap<Iterator, QueryResult> queryResultsByIterator = new HashMap();

    public DefaultCandidateExtent(ObjectManager om, Class cls, boolean subclasses, AbstractClassMetaData cmd) {
        super(om, cls, subclasses, cmd);
        this.fetchPlan = om.getFetchPlan().getCopy();
        this.query = om.newQuery();
        this.query.setClass(cls);
        this.query.setSubclasses(subclasses);
    }

    public Iterator iterator() {
        Object results = this.query.execute();
        Iterator iter = null;
        if (results instanceof QueryResult) {
            QueryResult qr = (QueryResult)results;
            iter = qr.iterator();
            this.queryResultsByIterator.put(iter, qr);
        } else {
            iter = ((Collection)results).iterator();
        }
        return iter;
    }

    public boolean hasSubclasses() {
        return this.subclasses;
    }

    public ObjectManager getObjectManager() {
        return this.om;
    }

    public FetchPlan getFetchPlan() {
        return this.fetchPlan;
    }

    public void closeAll() {
        Iterator<QueryResult> iter = this.queryResultsByIterator.values().iterator();
        while (iter.hasNext()) {
            QueryResult qr = iter.next();
            qr.close();
            iter.remove();
        }
        this.query.closeAll();
    }

    public void close(Iterator iterator) {
        QueryResult qr = this.queryResultsByIterator.remove(iterator);
        if (qr != null) {
            qr.close();
        }
        this.query.close(qr);
    }
}

