/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;

public class VersionMapping
extends SingleFieldMapping {
    private final JavaTypeMapping delegate;

    public VersionMapping(DatastoreAdapter dba, DatastoreContainerObject datastoreContainer, JavaTypeMapping delegate) {
        ColumnMetaData colmd;
        this.initialize(datastoreContainer.getStoreManager(), delegate.getType());
        this.delegate = delegate;
        this.datastoreContainer = datastoreContainer;
        VersionMetaData vermd = datastoreContainer.getVersionMetaData();
        ColumnMetaData[] versionColumnMetaData = vermd.getColumnMetaData();
        IdentifierFactory idFactory = datastoreContainer.getStoreManager().getIdentifierFactory();
        DatastoreIdentifier id = null;
        if (versionColumnMetaData.length == 0) {
            id = idFactory.newVersionFieldIdentifier();
            colmd = new ColumnMetaData();
            colmd.setName(id.getIdentifierName());
            datastoreContainer.getVersionMetaData().addColumn(colmd);
        } else {
            colmd = versionColumnMetaData[0];
            if (colmd.getName() == null) {
                id = idFactory.newVersionFieldIdentifier();
                colmd.setName(id.getIdentifierName());
            } else {
                id = idFactory.newDatastoreFieldIdentifier(colmd.getName());
            }
        }
        DatastoreField column = datastoreContainer.addDatastoreField(this.getType(), id, this, colmd);
        datastoreContainer.getStoreManager().getMappingManager().createDatastoreMapping(delegate, column, this.getType());
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return this.delegate.getSampleValue(clr);
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        return this.delegate.newLiteral(qs, value);
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        return this.delegate.newScalarExpression(qs, te);
    }

    public boolean includeInFetchStatement() {
        return false;
    }

    public int getNumberOfDatastoreMappings() {
        return this.delegate.getNumberOfDatastoreMappings();
    }

    public DatastoreMapping getDatastoreMapping(int index) {
        return this.delegate.getDatastoreMapping(index);
    }

    public DatastoreMapping[] getDatastoreMappings() {
        return this.delegate.getDatastoreMappings();
    }

    public void addDatastoreMapping(DatastoreMapping datastoreMapping) {
        this.delegate.addDatastoreMapping(datastoreMapping);
    }

    public Class getJavaType() {
        return VersionMapping.class;
    }

    public void setObject(ObjectManager om, Object preparedStatement, int[] exprIndex, Object value) {
        this.delegate.setObject(om, preparedStatement, exprIndex, value);
    }

    public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex) {
        return this.delegate.getObject(om, resultSet, exprIndex);
    }
}

